/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.adapter;

import java.util.Arrays;
import java.util.List;
import org.springframework.batch.item.ItemWriter;
import org.springframework.batch.item.adapter.AbstractMethodInvokingDelegator;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.Assert;

public class PropertyExtractingDelegatingItemWriter<T>
extends AbstractMethodInvokingDelegator<T>
implements ItemWriter<T> {
    private String[] fieldsUsedAsTargetMethodArguments;

    @Override
    public void write(List<? extends T> items) throws Exception {
        for (T item : items) {
            BeanWrapperImpl beanWrapper = new BeanWrapperImpl(item);
            Object[] methodArguments = new Object[this.fieldsUsedAsTargetMethodArguments.length];
            for (int i2 = 0; i2 < this.fieldsUsedAsTargetMethodArguments.length; ++i2) {
                methodArguments[i2] = beanWrapper.getPropertyValue(this.fieldsUsedAsTargetMethodArguments[i2]);
            }
            this.invokeDelegateMethodWithArguments(methodArguments);
        }
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.notEmpty((Object[])this.fieldsUsedAsTargetMethodArguments, "fieldsUsedAsTargetMethodArguments must not be empty");
    }

    public void setFieldsUsedAsTargetMethodArguments(String[] fieldsUsedAsMethodArguments) {
        this.fieldsUsedAsTargetMethodArguments = Arrays.asList(fieldsUsedAsMethodArguments).toArray(new String[fieldsUsedAsMethodArguments.length]);
    }
}

