/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.List;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepListener;
import org.springframework.batch.core.listener.MulticasterBatchListener;
import org.springframework.batch.core.metrics.BatchMetrics;
import org.springframework.batch.core.step.item.Chunk;
import org.springframework.batch.core.step.item.ChunkProcessor;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SimpleChunkProcessor<I, O>
implements ChunkProcessor<I>,
InitializingBean {
    private ItemProcessor<? super I, ? extends O> itemProcessor;
    private ItemWriter<? super O> itemWriter;
    private final MulticasterBatchListener<I, O> listener = new MulticasterBatchListener();

    private SimpleChunkProcessor() {
        this(null, null);
    }

    public SimpleChunkProcessor(@Nullable ItemProcessor<? super I, ? extends O> itemProcessor, ItemWriter<? super O> itemWriter) {
        this.itemProcessor = itemProcessor;
        this.itemWriter = itemWriter;
    }

    public SimpleChunkProcessor(ItemWriter<? super O> itemWriter) {
        this(null, itemWriter);
    }

    public void setItemProcessor(ItemProcessor<? super I, ? extends O> itemProcessor) {
        this.itemProcessor = itemProcessor;
    }

    public void setItemWriter(ItemWriter<? super O> itemWriter) {
        this.itemWriter = itemWriter;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.itemWriter, "ItemWriter must be set");
    }

    public void setListeners(List<? extends StepListener> listeners) {
        for (StepListener stepListener : listeners) {
            this.registerListener(stepListener);
        }
    }

    public void registerListener(StepListener listener) {
        this.listener.register(listener);
    }

    protected MulticasterBatchListener<I, O> getListener() {
        return this.listener;
    }

    protected final O doProcess(I item) throws Exception {
        if (this.itemProcessor == null) {
            I result = item;
            return (O)result;
        }
        try {
            this.listener.beforeProcess(item);
            O result = this.itemProcessor.process(item);
            this.listener.afterProcess(item, result);
            return result;
        }
        catch (Exception e) {
            this.listener.onProcessError(item, e);
            throw e;
        }
    }

    protected final void doWrite(List<O> items) throws Exception {
        if (this.itemWriter == null) {
            return;
        }
        try {
            this.listener.beforeWrite(items);
            this.writeItems(items);
            this.doAfterWrite(items);
        }
        catch (Exception e) {
            this.doOnWriteError(e, items);
            throw e;
        }
    }

    protected final void doAfterWrite(List<O> items) {
        this.listener.afterWrite(items);
    }

    protected final void doOnWriteError(Exception e, List<O> items) {
        this.listener.onWriteError(e, items);
    }

    protected void writeItems(List<O> items) throws Exception {
        if (this.itemWriter != null) {
            this.itemWriter.write(items);
        }
    }

    @Override
    public final void process(StepContribution contribution, Chunk<I> inputs) throws Exception {
        this.initializeUserData(inputs);
        if (this.isComplete(inputs)) {
            return;
        }
        Chunk<O> outputs = this.transform(contribution, inputs);
        contribution.incrementFilterCount(this.getFilterCount(inputs, outputs));
        this.write(contribution, inputs, this.getAdjustedOutputs(inputs, outputs));
    }

    protected void initializeUserData(Chunk<I> inputs) {
        inputs.setUserData(inputs.size());
    }

    protected int getFilterCount(Chunk<I> inputs, Chunk<O> outputs) {
        return (Integer)inputs.getUserData() - outputs.size();
    }

    protected boolean isComplete(Chunk<I> inputs) {
        return inputs.isEmpty();
    }

    protected Chunk<O> getAdjustedOutputs(Chunk<I> inputs, Chunk<O> outputs) {
        return outputs;
    }

    protected void write(StepContribution contribution, Chunk<I> inputs, Chunk<O> outputs) throws Exception {
        Timer.Sample sample = BatchMetrics.createTimerSample();
        String status = "SUCCESS";
        try {
            this.doWrite(outputs.getItems());
        }
        catch (Exception e) {
            inputs.clear();
            status = "FAILURE";
            throw e;
        }
        finally {
            this.stopTimer(sample, contribution.getStepExecution(), "chunk.write", status, "Chunk writing");
        }
        contribution.incrementWriteCount(outputs.size());
    }

    protected Chunk<O> transform(StepContribution contribution, Chunk<I> inputs) throws Exception {
        Chunk<O> outputs = new Chunk<O>();
        Chunk.ChunkIterator iterator2 = inputs.iterator();
        while (iterator2.hasNext()) {
            O output;
            Object item = iterator2.next();
            Timer.Sample sample = BatchMetrics.createTimerSample();
            String status = "SUCCESS";
            try {
                output = this.doProcess(item);
            }
            catch (Exception e) {
                inputs.clear();
                status = "FAILURE";
                throw e;
            }
            finally {
                this.stopTimer(sample, contribution.getStepExecution(), "item.process", status, "Item processing");
            }
            if (output != null) {
                outputs.add(output);
                continue;
            }
            iterator2.remove();
        }
        return outputs;
    }

    protected void stopTimer(Timer.Sample sample, StepExecution stepExecution, String metricName, String status, String description) {
        sample.stop(BatchMetrics.createTimer(metricName, description + " duration", Tag.of("job.name", stepExecution.getJobExecution().getJobInstance().getJobName()), Tag.of("step.name", stepExecution.getStepName()), Tag.of("status", status)));
    }
}

