/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.repository.dao;

import com.fasterxml.jackson.annotation.JacksonAnnotation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.BasicPolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.NamedType;
import com.fasterxml.jackson.databind.jsontype.PolymorphicTypeValidator;
import com.fasterxml.jackson.databind.jsontype.TypeIdResolver;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.batch.core.JobParameter;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.repository.ExecutionContextSerializer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.Assert;

public class Jackson2ExecutionContextStringSerializer
implements ExecutionContextSerializer {
    private ObjectMapper objectMapper = new ObjectMapper();

    public Jackson2ExecutionContextStringSerializer(String ... trustedClassNames) {
        this.objectMapper.configure(MapperFeature.DEFAULT_VIEW_INCLUSION, false);
        this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        this.objectMapper.configure(MapperFeature.BLOCK_UNSAFE_POLYMORPHIC_BASE_TYPES, true);
        this.objectMapper.setDefaultTyping(Jackson2ExecutionContextStringSerializer.createTrustedDefaultTyping(trustedClassNames));
        this.objectMapper.registerModule(new JobParametersModule());
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        Assert.notNull((Object)objectMapper, "ObjectMapper must not be null");
        this.objectMapper = objectMapper.copy();
        this.objectMapper.registerModule(new JobParametersModule());
    }

    @Override
    public Map<String, Object> deserialize(InputStream in) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return this.objectMapper.readValue(in, typeRef);
    }

    @Override
    public void serialize(Map<String, Object> context, OutputStream out) throws IOException {
        Assert.notNull(context, "A context is required");
        Assert.notNull((Object)out, "An OutputStream is required");
        this.objectMapper.writeValue(out, context);
    }

    private static TypeResolverBuilder<? extends TypeResolverBuilder> createTrustedDefaultTyping(String[] trustedClassNames) {
        TrustedTypeResolverBuilder result = new TrustedTypeResolverBuilder(ObjectMapper.DefaultTyping.NON_FINAL, trustedClassNames);
        result = result.init(JsonTypeInfo.Id.CLASS, null);
        result = result.inclusion(JsonTypeInfo.As.PROPERTY);
        return result;
    }

    static class TrustedTypeIdResolver
    implements TypeIdResolver {
        private static final Set<String> TRUSTED_CLASS_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java.util.ArrayList", "java.util.Arrays$ArrayList", "java.util.LinkedList", "java.util.Collections$EmptyList", "java.util.Collections$EmptyMap", "java.util.Collections$EmptySet", "java.util.Collections$UnmodifiableRandomAccessList", "java.util.Collections$UnmodifiableList", "java.util.Collections$UnmodifiableMap", "java.util.Collections$UnmodifiableSet", "java.util.Collections$SingletonList", "java.util.Collections$SingletonMap", "java.util.Collections$SingletonSet", "java.util.Date", "java.time.Instant", "java.time.Duration", "java.time.LocalDate", "java.time.LocalTime", "java.time.LocalDateTime", "java.sql.Timestamp", "java.net.URL", "java.util.TreeMap", "java.util.HashMap", "java.util.LinkedHashMap", "java.util.TreeSet", "java.util.HashSet", "java.util.LinkedHashSet", "java.lang.Boolean", "java.lang.Byte", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.math.BigDecimal", "java.math.BigInteger", "java.lang.String", "java.lang.Character", "java.lang.CharSequence", "java.util.Properties", "[Ljava.util.Properties;", "org.springframework.batch.core.JobParameter", "org.springframework.batch.core.JobParameters", "org.springframework.batch.core.jsr.partition.JsrPartitionHandler$PartitionPlanState")));
        private final Set<String> trustedClassNames = new LinkedHashSet<String>(TRUSTED_CLASS_NAMES);
        private final TypeIdResolver delegate;

        TrustedTypeIdResolver(TypeIdResolver delegate, String[] trustedClassNames) {
            this.delegate = delegate;
            if (trustedClassNames != null) {
                this.trustedClassNames.addAll(Arrays.asList(trustedClassNames));
            }
        }

        @Override
        public void init(JavaType baseType) {
            this.delegate.init(baseType);
        }

        @Override
        public String idFromValue(Object value) {
            return this.delegate.idFromValue(value);
        }

        @Override
        public String idFromValueAndType(Object value, Class<?> suggestedType) {
            return this.delegate.idFromValueAndType(value, suggestedType);
        }

        @Override
        public String idFromBaseType() {
            return this.delegate.idFromBaseType();
        }

        @Override
        public JavaType typeFromId(DatabindContext context, String id) throws IOException {
            boolean isExplicitMixin;
            DeserializationConfig config = (DeserializationConfig)context.getConfig();
            JavaType result = this.delegate.typeFromId(context, id);
            String className = result.getRawClass().getName();
            if (this.isTrusted(className)) {
                return result;
            }
            boolean bl = isExplicitMixin = config.findMixInClassFor(result.getRawClass()) != null;
            if (isExplicitMixin) {
                return result;
            }
            Class<?> rawClass = result.getRawClass();
            JacksonAnnotation jacksonAnnotation = AnnotationUtils.findAnnotation(rawClass, JacksonAnnotation.class);
            if (jacksonAnnotation != null) {
                return result;
            }
            throw new IllegalArgumentException("The class with " + id + " and name of " + className + " is not trusted. If you believe this class is safe to deserialize, you can add it to the base set of trusted classes at construction time or provide an explicit mapping using Jackson annotations or a custom ObjectMapper. If the serialization is only done by a trusted source, you can also enable default typing.");
        }

        private boolean isTrusted(String id) {
            return this.trustedClassNames.contains(id);
        }

        @Override
        public String getDescForKnownTypeIds() {
            return this.delegate.getDescForKnownTypeIds();
        }

        @Override
        public JsonTypeInfo.Id getMechanism() {
            return this.delegate.getMechanism();
        }
    }

    static class TrustedTypeResolverBuilder
    extends ObjectMapper.DefaultTypeResolverBuilder {
        private final String[] trustedClassNames;

        TrustedTypeResolverBuilder(ObjectMapper.DefaultTyping defaultTyping, String[] trustedClassNames) {
            super(defaultTyping, BasicPolymorphicTypeValidator.builder().allowIfSubType(Object.class).build());
            this.trustedClassNames = trustedClassNames != null ? Arrays.copyOf(trustedClassNames, trustedClassNames.length) : null;
        }

        @Override
        protected TypeIdResolver idResolver(MapperConfig<?> config, JavaType baseType, PolymorphicTypeValidator subtypeValidator, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
            TypeIdResolver result = super.idResolver(config, baseType, subtypeValidator, subtypes, forSer, forDeser);
            return new TrustedTypeIdResolver(result, this.trustedClassNames);
        }
    }

    private class JobParametersModule
    extends SimpleModule {
        private static final long serialVersionUID = 1L;

        private JobParametersModule() {
            super("Job parameters module");
            this.setMixInAnnotation(JobParameters.class, JobParametersMixIn.class);
            this.addDeserializer(JobParameter.class, new JobParameterDeserializer());
        }

        private class JobParameterDeserializer
        extends StdDeserializer<JobParameter> {
            private static final long serialVersionUID = 1L;
            private static final String IDENTIFYING_KEY_NAME = "identifying";
            private static final String TYPE_KEY_NAME = "type";
            private static final String VALUE_KEY_NAME = "value";

            JobParameterDeserializer() {
                super(JobParameter.class);
            }

            @Override
            public JobParameter deserialize(JsonParser parser, DeserializationContext context) throws IOException {
                JsonNode node = (JsonNode)parser.readValueAsTree();
                boolean identifying = node.get(IDENTIFYING_KEY_NAME).asBoolean();
                String type = node.get(TYPE_KEY_NAME).asText();
                JsonNode value = node.get(VALUE_KEY_NAME);
                switch (JobParameter.ParameterType.valueOf(type)) {
                    case STRING: {
                        String parameterValue = value.asText();
                        return new JobParameter(parameterValue, identifying);
                    }
                    case DATE: {
                        Date parameterValue = new Date(value.get(1).asLong());
                        return new JobParameter(parameterValue, identifying);
                    }
                    case LONG: {
                        Long parameterValue = value.get(1).asLong();
                        return new JobParameter(parameterValue, identifying);
                    }
                    case DOUBLE: {
                        Double parameterValue = value.asDouble();
                        return new JobParameter(parameterValue, identifying);
                    }
                }
                return null;
            }
        }

        private abstract class JobParametersMixIn {
            private JobParametersMixIn() {
            }

            @JsonIgnore
            abstract boolean isEmpty();
        }
    }
}

