/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.listener.StepExecutionListenerSupport;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.support.PatternMatcher;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class ExecutionContextPromotionListener
extends StepExecutionListenerSupport
implements InitializingBean {
    private String[] keys = null;
    private String[] statuses = new String[]{ExitStatus.COMPLETED.getExitCode()};
    private boolean strict = false;

    @Override
    @Nullable
    public ExitStatus afterStep(StepExecution stepExecution) {
        ExecutionContext stepContext = stepExecution.getExecutionContext();
        ExecutionContext jobContext = stepExecution.getJobExecution().getExecutionContext();
        String exitCode = stepExecution.getExitStatus().getExitCode();
        for (String statusPattern : this.statuses) {
            if (!PatternMatcher.match(statusPattern, exitCode)) continue;
            for (String key : this.keys) {
                if (stepContext.containsKey(key)) {
                    jobContext.put(key, stepContext.get(key));
                    continue;
                }
                if (!this.strict) continue;
                throw new IllegalArgumentException("The key [" + key + "] was not found in the Step's ExecutionContext.");
            }
            break;
        }
        return null;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.keys, "The 'keys' property must be provided");
        Assert.notEmpty((Object[])this.keys, "The 'keys' property must not be empty");
        Assert.notNull((Object)this.statuses, "The 'statuses' property must be provided");
        Assert.notEmpty((Object[])this.statuses, "The 'statuses' property must not be empty");
    }

    public void setKeys(String[] keys2) {
        this.keys = keys2;
    }

    public void setStatuses(String[] statuses) {
        this.statuses = statuses;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

