/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.listener;

import java.util.Iterator;
import java.util.List;
import javax.batch.api.chunk.listener.RetryReadListener;
import org.springframework.batch.core.listener.OrderedComposite;

public class CompositeRetryReadListener
implements RetryReadListener {
    private OrderedComposite<RetryReadListener> listeners = new OrderedComposite();

    public void setListeners(List<? extends RetryReadListener> listeners) {
        this.listeners.setItems(listeners);
    }

    public void register(RetryReadListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void onRetryReadException(Exception ex) throws Exception {
        Iterator<RetryReadListener> iterator2 = this.listeners.reverse();
        while (iterator2.hasNext()) {
            RetryReadListener listener = iterator2.next();
            listener.onRetryReadException(ex);
        }
    }
}

