/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.batch.core.jsr.configuration.support.BatchArtifactType;
import org.springframework.batch.core.jsr.configuration.xml.PropertyParser;
import org.springframework.batch.core.jsr.partition.JsrPartitionHandler;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class PartitionParser {
    private static final String REF = "ref";
    private static final String MAPPER_ELEMENT = "mapper";
    private static final String PLAN_ELEMENT = "plan";
    private static final String PARTITIONS_ATTRIBUTE = "partitions";
    private static final String THREADS_ATTRIBUTE = "threads";
    private static final String PROPERTIES_ELEMENT = "properties";
    private static final String ANALYZER_ELEMENT = "analyzer";
    private static final String COLLECTOR_ELEMENT = "collector";
    private static final String REDUCER_ELEMENT = "reducer";
    private static final String PARTITION_CONTEXT_PROPERTY = "propertyContext";
    private static final String PARTITION_MAPPER_PROPERTY = "partitionMapper";
    private static final String PARTITION_ANALYZER_PROPERTY = "partitionAnalyzer";
    private static final String PARTITION_REDUCER_PROPERTY = "partitionReducer";
    private static final String PARTITION_QUEUE_PROPERTY = "partitionDataQueue";
    private static final String LISTENERS_PROPERTY = "listeners";
    private static final String THREADS_PROPERTY = "threads";
    private static final String PARTITIONS_PROPERTY = "partitions";
    private static final String PARTITION_LOCK_PROPERTY = "partitionLock";
    private final String name;
    private boolean allowStartIfComplete = false;

    public PartitionParser(String stepName, boolean allowStartIfComplete) {
        this.name = stepName;
        this.allowStartIfComplete = allowStartIfComplete;
    }

    public void parse(Element element, AbstractBeanDefinition bd, ParserContext parserContext, String stepName) {
        BeanDefinitionRegistry registry = parserContext.getRegistry();
        MutablePropertyValues factoryBeanProperties = bd.getPropertyValues();
        AbstractBeanDefinition partitionHandlerDefinition = BeanDefinitionBuilder.genericBeanDefinition(JsrPartitionHandler.class).getBeanDefinition();
        MutablePropertyValues properties = partitionHandlerDefinition.getPropertyValues();
        properties.addPropertyValue(PARTITION_CONTEXT_PROPERTY, new RuntimeBeanReference("batchPropertyContext"));
        properties.addPropertyValue("jobRepository", new RuntimeBeanReference("jobRepository"));
        properties.addPropertyValue("allowStartIfComplete", this.allowStartIfComplete);
        this.parseMapperElement(element, parserContext, properties);
        this.parsePartitionPlan(element, parserContext, stepName, properties);
        this.parseAnalyzerElement(element, parserContext, properties);
        this.parseReducerElement(element, parserContext, factoryBeanProperties);
        this.parseCollectorElement(element, parserContext, factoryBeanProperties, properties);
        String partitionHandlerBeanName = this.name + ".partitionHandler";
        registry.registerBeanDefinition(partitionHandlerBeanName, partitionHandlerDefinition);
        factoryBeanProperties.add("partitionHandler", new RuntimeBeanReference(partitionHandlerBeanName));
    }

    private void parseCollectorElement(Element element, ParserContext parserContext, MutablePropertyValues factoryBeanProperties, MutablePropertyValues properties) {
        Element collectorElement = DomUtils.getChildElementByTagName(element, COLLECTOR_ELEMENT);
        if (collectorElement != null) {
            this.registerCollectorAnalyzerQueue(parserContext);
            properties.add(PARTITION_QUEUE_PROPERTY, new RuntimeBeanReference(this.name + "PartitionQueue"));
            properties.add(PARTITION_LOCK_PROPERTY, new RuntimeBeanReference(this.name + "PartitionLock"));
            factoryBeanProperties.add("partitionQueue", new RuntimeBeanReference(this.name + "PartitionQueue"));
            factoryBeanProperties.add(PARTITION_LOCK_PROPERTY, new RuntimeBeanReference(this.name + "PartitionLock"));
            String collectorName = collectorElement.getAttribute(REF);
            factoryBeanProperties.add(LISTENERS_PROPERTY, new RuntimeBeanReference(collectorName));
            new PropertyParser(collectorName, parserContext, BatchArtifactType.STEP_ARTIFACT, this.name).parseProperties(collectorElement);
        }
    }

    private void parseReducerElement(Element element, ParserContext parserContext, MutablePropertyValues factoryBeanProperties) {
        Element reducerElement = DomUtils.getChildElementByTagName(element, REDUCER_ELEMENT);
        if (reducerElement != null) {
            String reducerName = reducerElement.getAttribute(REF);
            factoryBeanProperties.add(PARTITION_REDUCER_PROPERTY, new RuntimeBeanReference(reducerName));
            new PropertyParser(reducerName, parserContext, BatchArtifactType.STEP_ARTIFACT, this.name).parseProperties(reducerElement);
        }
    }

    private void parseAnalyzerElement(Element element, ParserContext parserContext, MutablePropertyValues properties) {
        Element analyzerElement = DomUtils.getChildElementByTagName(element, ANALYZER_ELEMENT);
        if (analyzerElement != null) {
            String analyzerName = analyzerElement.getAttribute(REF);
            properties.add(PARTITION_ANALYZER_PROPERTY, new RuntimeBeanReference(analyzerName));
            new PropertyParser(analyzerName, parserContext, BatchArtifactType.STEP_ARTIFACT, this.name).parseProperties(analyzerElement);
        }
    }

    private void parseMapperElement(Element element, ParserContext parserContext, MutablePropertyValues properties) {
        Element mapperElement = DomUtils.getChildElementByTagName(element, MAPPER_ELEMENT);
        if (mapperElement != null) {
            String mapperName = mapperElement.getAttribute(REF);
            properties.add(PARTITION_MAPPER_PROPERTY, new RuntimeBeanReference(mapperName));
            new PropertyParser(mapperName, parserContext, BatchArtifactType.STEP_ARTIFACT, this.name).parseProperties(mapperElement);
        }
    }

    private void registerCollectorAnalyzerQueue(ParserContext parserContext) {
        AbstractBeanDefinition partitionQueueDefinition = BeanDefinitionBuilder.genericBeanDefinition(ConcurrentLinkedQueue.class).getBeanDefinition();
        AbstractBeanDefinition partitionLockDefinition = BeanDefinitionBuilder.genericBeanDefinition(ReentrantLock.class).getBeanDefinition();
        parserContext.getRegistry().registerBeanDefinition(this.name + "PartitionQueue", partitionQueueDefinition);
        parserContext.getRegistry().registerBeanDefinition(this.name + "PartitionLock", partitionLockDefinition);
    }

    protected void parsePartitionPlan(Element element, ParserContext parserContext, String stepName, MutablePropertyValues properties) {
        Element planElement = DomUtils.getChildElementByTagName(element, PLAN_ELEMENT);
        if (planElement != null) {
            List<Element> partitionProperties;
            String partitions = planElement.getAttribute("partitions");
            String threads = planElement.getAttribute("threads");
            if (!StringUtils.hasText(threads)) {
                threads = partitions;
            }
            if ((partitionProperties = DomUtils.getChildElementsByTagName(planElement, PROPERTIES_ELEMENT)) != null) {
                for (Element partition : partitionProperties) {
                    String partitionStepName = stepName + ":partition" + partition.getAttribute("partition");
                    new PropertyParser(partitionStepName, parserContext, BatchArtifactType.STEP, partitionStepName).parseProperty(partition);
                }
            }
            properties.add("threads", threads);
            properties.add("partitions", partitions);
        }
    }
}

