/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.jsr.configuration.xml;

import java.util.Properties;
import org.springframework.batch.core.jsr.configuration.xml.JsrBeanDefinitionDocumentReader;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

public class JsrXmlApplicationContext
extends GenericApplicationContext {
    private static final String JOB_PARAMETERS_BEAN_DEFINITION_NAME = "jsr_jobParameters";
    private XmlBeanDefinitionReader reader = new XmlBeanDefinitionReader(this);

    public JsrXmlApplicationContext() {
        this.reader.setDocumentReaderClass(JsrBeanDefinitionDocumentReader.class);
        this.reader.setEnvironment(this.getEnvironment());
    }

    public JsrXmlApplicationContext(Properties jobParameters) {
        this.reader.setDocumentReaderClass(JsrBeanDefinitionDocumentReader.class);
        this.reader.setEnvironment(this.getEnvironment());
        this.storeJobParameters(jobParameters);
    }

    private void storeJobParameters(Properties properties) {
        AbstractBeanDefinition jobParameters = BeanDefinitionBuilder.genericBeanDefinition(Properties.class).getBeanDefinition();
        jobParameters.getConstructorArgumentValues().addGenericArgumentValue(properties != null ? properties : new Properties());
        this.reader.getRegistry().registerBeanDefinition(JOB_PARAMETERS_BEAN_DEFINITION_NAME, jobParameters);
    }

    protected XmlBeanDefinitionReader getReader() {
        return this.reader;
    }

    public void setValidating(boolean validating) {
        this.reader.setValidating(validating);
    }

    public void load(Resource ... resources) {
        this.reader.loadBeanDefinitions(resources);
    }
}

