/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import java.util.Collection;
import java.util.List;
import org.springframework.batch.core.configuration.xml.InlineFlowParser;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SplitParser {
    private static final String PARENT_ATTR = "parent";
    private final String jobFactoryRef;

    public SplitParser(String jobFactoryRef) {
        this.jobFactoryRef = jobFactoryRef;
    }

    public Collection<BeanDefinition> parse(Element element, ParserContext parserContext) {
        List<Element> flowElements;
        String idAttribute = element.getAttribute("id");
        BeanDefinitionBuilder stateBuilder = BeanDefinitionBuilder.genericBeanDefinition("org.springframework.batch.core.job.flow.support.state.SplitState");
        String taskExecutorBeanId = element.getAttribute("task-executor");
        if (StringUtils.hasText(taskExecutorBeanId)) {
            RuntimeBeanReference taskExecutorRef = new RuntimeBeanReference(taskExecutorBeanId);
            stateBuilder.addPropertyValue("taskExecutor", taskExecutorRef);
        }
        if ((flowElements = DomUtils.getChildElementsByTagName(element, "flow")).size() < 2) {
            parserContext.getReaderContext().error("A <split/> must contain at least two 'flow' elements.", element);
        }
        ManagedList<BeanDefinition> flows = new ManagedList<BeanDefinition>();
        int i2 = 0;
        String prefix = idAttribute;
        for (Element nextElement : flowElements) {
            String ref = nextElement.getAttribute(PARENT_ATTR);
            if (StringUtils.hasText(ref)) {
                if (nextElement.getElementsByTagName("*").getLength() > 0) {
                    parserContext.getReaderContext().error("A <flow/> in a <split/> must have ref= or nested <flow/>, but not both.", nextElement);
                }
                GenericBeanDefinition flowDefinition = new GenericBeanDefinition();
                flowDefinition.setParentName(ref);
                MutablePropertyValues propertyValues = flowDefinition.getPropertyValues();
                propertyValues.addPropertyValue("name", prefix + "." + i2);
                flows.add(flowDefinition);
            } else {
                InlineFlowParser flowParser = new InlineFlowParser(prefix + "." + i2, this.jobFactoryRef);
                flows.add(flowParser.parse(nextElement, parserContext));
            }
            ++i2;
        }
        stateBuilder.addConstructorArgValue(flows);
        stateBuilder.addConstructorArgValue(prefix);
        return InlineFlowParser.getNextElements(parserContext, stateBuilder.getBeanDefinition(), element);
    }
}

