/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.configuration.xml;

import org.springframework.batch.core.configuration.xml.CoreNamespaceUtils;
import org.springframework.batch.core.configuration.xml.StepListenerParser;
import org.springframework.batch.core.configuration.xml.StepParserStepFactoryBean;
import org.springframework.batch.core.configuration.xml.TaskletParser;
import org.springframework.batch.core.listener.StepListenerMetaData;
import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.config.TypedStringValue;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class AbstractStepParser {
    protected static final String ID_ATTR = "id";
    private static final String PARENT_ATTR = "parent";
    private static final String REF_ATTR = "ref";
    private static final String ALLOW_START_ATTR = "allow-start-if-complete";
    private static final String TASKLET_ELE = "tasklet";
    private static final String PARTITION_ELE = "partition";
    private static final String JOB_ELE = "job";
    private static final String JOB_PARAMS_EXTRACTOR_ATTR = "job-parameters-extractor";
    private static final String JOB_LAUNCHER_ATTR = "job-launcher";
    private static final String STEP_ATTR = "step";
    private static final String STEP_ELE = "step";
    private static final String PARTITIONER_ATTR = "partitioner";
    private static final String AGGREGATOR_ATTR = "aggregator";
    private static final String HANDLER_ATTR = "handler";
    private static final String HANDLER_ELE = "handler";
    private static final String TASK_EXECUTOR_ATTR = "task-executor";
    private static final String GRID_SIZE_ATTR = "grid-size";
    private static final String FLOW_ELE = "flow";
    private static final String JOB_REPO_ATTR = "job-repository";
    private static final StepListenerParser stepListenerParser = new StepListenerParser(StepListenerMetaData.stepExecutionListenerMetaData());

    protected AbstractBeanDefinition parseStep(Element stepElement, ParserContext parserContext, String jobFactoryRef) {
        String isAllowStart;
        String jobRepositoryRef;
        String isAbstract;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition();
        AbstractBeanDefinition bd = builder.getRawBeanDefinition();
        NodeList children = stepElement.getChildNodes();
        for (int i2 = 0; i2 < children.getLength(); ++i2) {
            Node nd = children.item(i2);
            if (!(nd instanceof Element)) continue;
            Element nestedElement = (Element)nd;
            String name = nestedElement.getLocalName();
            if (TASKLET_ELE.equals(name)) {
                boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
                new TaskletParser().parseTasklet(stepElement, nestedElement, bd, parserContext, stepUnderspecified);
                continue;
            }
            if (FLOW_ELE.equals(name)) {
                boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
                this.parseFlow(stepElement, nestedElement, bd, parserContext, stepUnderspecified);
                continue;
            }
            if (PARTITION_ELE.equals(name)) {
                boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
                this.parsePartition(stepElement, nestedElement, bd, parserContext, stepUnderspecified, jobFactoryRef);
                continue;
            }
            if (JOB_ELE.equals(name)) {
                boolean stepUnderspecified = CoreNamespaceUtils.isUnderspecified(stepElement);
                this.parseJob(stepElement, nestedElement, bd, parserContext, stepUnderspecified);
                continue;
            }
            if ("description".equals(name)) {
                bd.setDescription(nestedElement.getTextContent());
                continue;
            }
            String ns = nestedElement.getNamespaceURI();
            BeanMetadataElement value = null;
            boolean skip = false;
            if (ns == null && name.equals("bean") || ns.equals("http://www.springframework.org/schema/beans")) {
                BeanDefinitionHolder holder = parserContext.getDelegate().parseBeanDefinitionElement(nestedElement);
                value = parserContext.getDelegate().decorateBeanDefinitionIfRequired(nestedElement, holder);
            } else if (ns.equals("http://www.springframework.org/schema/batch")) {
                skip = true;
            } else {
                value = parserContext.getDelegate().parseCustomElement(nestedElement);
            }
            if (skip) continue;
            bd.setBeanClass(StepParserStepFactoryBean.class);
            bd.setAttribute("isNamespaceStep", true);
            builder.addPropertyValue(TASKLET_ELE, value);
        }
        String parentRef = stepElement.getAttribute(PARENT_ATTR);
        if (StringUtils.hasText(parentRef)) {
            bd.setParentName(parentRef);
        }
        if (StringUtils.hasText(isAbstract = stepElement.getAttribute("abstract"))) {
            bd.setAbstract(Boolean.valueOf(isAbstract));
        }
        if (StringUtils.hasText(jobRepositoryRef = stepElement.getAttribute(JOB_REPO_ATTR))) {
            builder.addPropertyReference("jobRepository", jobRepositoryRef);
        }
        if (StringUtils.hasText(jobFactoryRef)) {
            bd.setAttribute("jobParserJobFactoryBeanRef", jobFactoryRef);
        }
        if (StringUtils.hasText(isAllowStart = stepElement.getAttribute(ALLOW_START_ATTR)) && !bd.getPropertyValues().contains("allowStartIfComplete")) {
            bd.getPropertyValues().add("allowStartIfComplete", Boolean.valueOf(isAllowStart));
        }
        stepListenerParser.handleListenersElement(stepElement, bd, parserContext);
        return bd;
    }

    private void parsePartition(Element stepElement, Element partitionElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified, String jobFactoryRef) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", true);
        String stepRef = partitionElement.getAttribute("step");
        String partitionerRef = partitionElement.getAttribute(PARTITIONER_ATTR);
        String aggregatorRef = partitionElement.getAttribute(AGGREGATOR_ATTR);
        String handlerRef = partitionElement.getAttribute("handler");
        if (!StringUtils.hasText(partitionerRef)) {
            parserContext.getReaderContext().error("You must specify a partitioner", partitionElement);
            return;
        }
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        propertyValues.addPropertyValue(PARTITIONER_ATTR, new RuntimeBeanReference(partitionerRef));
        if (StringUtils.hasText(aggregatorRef)) {
            propertyValues.addPropertyValue("stepExecutionAggregator", new RuntimeBeanReference(aggregatorRef));
        }
        boolean customHandler = false;
        if (!StringUtils.hasText(handlerRef)) {
            Element handlerElement = DomUtils.getChildElementByTagName(partitionElement, "handler");
            if (handlerElement != null) {
                String gridSize;
                String taskExecutorRef = handlerElement.getAttribute(TASK_EXECUTOR_ATTR);
                if (StringUtils.hasText(taskExecutorRef)) {
                    propertyValues.addPropertyValue("taskExecutor", new RuntimeBeanReference(taskExecutorRef));
                }
                if (StringUtils.hasText(gridSize = handlerElement.getAttribute(GRID_SIZE_ATTR))) {
                    propertyValues.addPropertyValue("gridSize", new TypedStringValue(gridSize));
                }
            }
        } else {
            customHandler = true;
            AbstractBeanDefinition partitionHandler = BeanDefinitionBuilder.genericBeanDefinition().getRawBeanDefinition();
            partitionHandler.setParentName(handlerRef);
            propertyValues.addPropertyValue("partitionHandler", partitionHandler);
        }
        Element inlineStepElement = DomUtils.getChildElementByTagName(partitionElement, "step");
        if (inlineStepElement == null && !StringUtils.hasText(stepRef) && !customHandler) {
            parserContext.getReaderContext().error("You must specify a step", partitionElement);
            return;
        }
        if (StringUtils.hasText(stepRef)) {
            propertyValues.addPropertyValue("step", new RuntimeBeanReference(stepRef));
        } else if (inlineStepElement != null) {
            AbstractBeanDefinition stepDefinition = this.parseStep(inlineStepElement, parserContext, jobFactoryRef);
            stepDefinition.getPropertyValues().addPropertyValue("name", stepElement.getAttribute(ID_ATTR));
            propertyValues.addPropertyValue("step", stepDefinition);
        }
    }

    private void parseJob(Element stepElement, Element jobElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", true);
        String jobRef = jobElement.getAttribute(REF_ATTR);
        if (!StringUtils.hasText(jobRef)) {
            parserContext.getReaderContext().error("You must specify a job", jobElement);
            return;
        }
        MutablePropertyValues propertyValues = bd.getPropertyValues();
        propertyValues.addPropertyValue(JOB_ELE, new RuntimeBeanReference(jobRef));
        String jobParametersExtractor = jobElement.getAttribute(JOB_PARAMS_EXTRACTOR_ATTR);
        String jobLauncher = jobElement.getAttribute(JOB_LAUNCHER_ATTR);
        if (StringUtils.hasText(jobParametersExtractor)) {
            propertyValues.addPropertyValue("jobParametersExtractor", new RuntimeBeanReference(jobParametersExtractor));
        }
        if (StringUtils.hasText(jobLauncher)) {
            propertyValues.addPropertyValue("jobLauncher", new RuntimeBeanReference(jobLauncher));
        }
    }

    private void parseFlow(Element stepElement, Element flowElement, AbstractBeanDefinition bd, ParserContext parserContext, boolean stepUnderspecified) {
        bd.setBeanClass(StepParserStepFactoryBean.class);
        bd.setAttribute("isNamespaceStep", true);
        String flowRef = flowElement.getAttribute(PARENT_ATTR);
        String idAttribute = stepElement.getAttribute(ID_ATTR);
        GenericBeanDefinition flowDefinition = new GenericBeanDefinition();
        flowDefinition.setParentName(flowRef);
        MutablePropertyValues propertyValues = flowDefinition.getPropertyValues();
        if (StringUtils.hasText(idAttribute)) {
            propertyValues.addPropertyValue("name", idAttribute);
        }
        bd.getPropertyValues().addPropertyValue(FLOW_ELE, flowDefinition);
    }
}

