/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.CompositeClientParam;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.MarkdownType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="SearchParameter", profile="http://hl7.org/fhir/StructureDefinition/SearchParameter")
public class SearchParameter
extends CanonicalResource {
    @Child(name="url", type={UriType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Canonical identifier for this search parameter, represented as a URI (globally unique)", formalDefinition="An absolute URI that is used to identify this search parameter when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this search parameter is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the search parameter is stored on different servers.")
    protected UriType url;
    @Child(name="version", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Business version of the search parameter", formalDefinition="The identifier that is used to identify this version of the search parameter when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the search parameter author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.")
    protected StringType version;
    @Child(name="name", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name for this search parameter (computer friendly)", formalDefinition="A natural language name identifying the search parameter. This name should be usable as an identifier for the module by machine processing applications such as code generation.")
    protected StringType name;
    @Child(name="derivedFrom", type={CanonicalType.class}, order=3, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Original definition for the search parameter", formalDefinition="Where this search parameter is originally defined. If a derivedFrom is provided, then the details in the search parameter must be consistent with the definition from which it is defined. i.e. the parameter should have the same meaning, and (usually) the functionality should be a proper subset of the underlying search parameter.")
    protected CanonicalType derivedFrom;
    @Child(name="status", type={CodeType.class}, order=4, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | retired | unknown", formalDefinition="The status of this search parameter. Enables tracking the life-cycle of the content.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/publication-status")
    protected Enumeration<Enumerations.PublicationStatus> status;
    @Child(name="experimental", type={BooleanType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="For testing purposes, not real usage", formalDefinition="A Boolean value to indicate that this search parameter is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.")
    protected BooleanType experimental;
    @Child(name="date", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date last changed", formalDefinition="The date  (and optionally time) when the search parameter was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the search parameter changes.")
    protected DateTimeType date;
    @Child(name="publisher", type={StringType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name of the publisher (organization or individual)", formalDefinition="The name of the organization or individual that published the search parameter.")
    protected StringType publisher;
    @Child(name="contact", type={ContactDetail.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contact details for the publisher", formalDefinition="Contact details to assist a user in finding and communicating with the publisher.")
    protected List<ContactDetail> contact;
    @Child(name="description", type={MarkdownType.class}, order=9, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Natural language description of the search parameter", formalDefinition="And how it used.")
    protected MarkdownType description;
    @Child(name="useContext", type={UsageContext.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The context that the content is intended to support", formalDefinition="The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate search parameter instances.")
    protected List<UsageContext> useContext;
    @Child(name="jurisdiction", type={CodeableConcept.class}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Intended jurisdiction for search parameter (if applicable)", formalDefinition="A legal or geographic region in which the search parameter is intended to be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/jurisdiction")
    protected List<CodeableConcept> jurisdiction;
    @Child(name="purpose", type={MarkdownType.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this search parameter is defined", formalDefinition="Explanation of why this search parameter is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="code", type={CodeType.class}, order=13, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Code used in URL", formalDefinition="The code used in the URL or the parameter name in a parameters resource for this search parameter.")
    protected CodeType code;
    @Child(name="base", type={CodeType.class}, order=14, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The resource type(s) this search parameter applies to", formalDefinition="The base resource type(s) that this search parameter can be used against.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected List<CodeType> base;
    @Child(name="type", type={CodeType.class}, order=15, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="number | date | string | token | reference | composite | quantity | uri | special", formalDefinition="The type of value that a search parameter may contain, and how the content is interpreted.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-param-type")
    protected Enumeration<Enumerations.SearchParamType> type;
    @Child(name="expression", type={StringType.class}, order=16, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="FHIRPath expression that extracts the values", formalDefinition="A FHIRPath expression that returns a set of elements for the search parameter.")
    protected StringType expression;
    @Child(name="xpath", type={StringType.class}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="XPath that extracts the values", formalDefinition="An XPath expression that returns a set of elements for the search parameter.")
    protected StringType xpath;
    @Child(name="xpathUsage", type={CodeType.class}, order=18, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="normal | phonetic | nearby | distance | other", formalDefinition="How the search parameter relates to the set of elements returned by evaluating the xpath query.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-xpath-usage")
    protected Enumeration<XPathUsageType> xpathUsage;
    @Child(name="target", type={CodeType.class}, order=19, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Types of resource (if a resource reference)", formalDefinition="Types of resource (if a resource is referenced).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected List<CodeType> target;
    @Child(name="multipleOr", type={BooleanType.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Allow multiple values per parameter (or)", formalDefinition="Whether multiple values are allowed for each time the parameter exists. Values are separated by commas, and the parameter matches if any of the values match.")
    protected BooleanType multipleOr;
    @Child(name="multipleAnd", type={BooleanType.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Allow multiple parameters (and)", formalDefinition="Whether multiple parameters are allowed - e.g. more than one parameter with the same name. The search matches if all the parameters match.")
    protected BooleanType multipleAnd;
    @Child(name="comparator", type={CodeType.class}, order=22, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="eq | ne | gt | lt | ge | le | sa | eb | ap", formalDefinition="Comparators supported for the search parameter.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-comparator")
    protected List<Enumeration<SearchComparator>> comparator;
    @Child(name="modifier", type={CodeType.class}, order=23, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="missing | exact | contains | not | text | in | not-in | below | above | type | identifier | ofType", formalDefinition="A modifier supported for the search parameter.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/search-modifier-code")
    protected List<Enumeration<SearchModifierCode>> modifier;
    @Child(name="chain", type={StringType.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Chained names supported", formalDefinition="Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from SearchParameter.code for a parameter on the target resource type.")
    protected List<StringType> chain;
    @Child(name="component", type={}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="For Composite resources to define the parts", formalDefinition="Used to define the parts of a composite search parameter.")
    protected List<SearchParameterComponentComponent> component;
    private static final long serialVersionUID = -877703644L;
    @SearchParamDefinition(name="context", path="(CapabilityStatement.useContext.value as CodeableConcept) | (CodeSystem.useContext.value as CodeableConcept) | (CompartmentDefinition.useContext.value as CodeableConcept) | (ConceptMap.useContext.value as CodeableConcept) | (GraphDefinition.useContext.value as CodeableConcept) | (ImplementationGuide.useContext.value as CodeableConcept) | (MessageDefinition.useContext.value as CodeableConcept) | (NamingSystem.useContext.value as CodeableConcept) | (OperationDefinition.useContext.value as CodeableConcept) | (SearchParameter.useContext.value as CodeableConcept) | (StructureDefinition.useContext.value as CodeableConcept) | (StructureMap.useContext.value as CodeableConcept) | (TerminologyCapabilities.useContext.value as CodeableConcept) | (ValueSet.useContext.value as CodeableConcept)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="context-quantity", path="(CapabilityStatement.useContext.value as Quantity) | (CapabilityStatement.useContext.value as Range) | (CodeSystem.useContext.value as Quantity) | (CodeSystem.useContext.value as Range) | (CompartmentDefinition.useContext.value as Quantity) | (CompartmentDefinition.useContext.value as Range) | (ConceptMap.useContext.value as Quantity) | (ConceptMap.useContext.value as Range) | (GraphDefinition.useContext.value as Quantity) | (GraphDefinition.useContext.value as Range) | (ImplementationGuide.useContext.value as Quantity) | (ImplementationGuide.useContext.value as Range) | (MessageDefinition.useContext.value as Quantity) | (MessageDefinition.useContext.value as Range) | (NamingSystem.useContext.value as Quantity) | (NamingSystem.useContext.value as Range) | (OperationDefinition.useContext.value as Quantity) | (OperationDefinition.useContext.value as Range) | (SearchParameter.useContext.value as Quantity) | (SearchParameter.useContext.value as Range) | (StructureDefinition.useContext.value as Quantity) | (StructureDefinition.useContext.value as Range) | (StructureMap.useContext.value as Quantity) | (StructureMap.useContext.value as Range) | (TerminologyCapabilities.useContext.value as Quantity) | (TerminologyCapabilities.useContext.value as Range) | (ValueSet.useContext.value as Quantity) | (ValueSet.useContext.value as Range)", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A quantity- or range-valued use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A quantity- or range-valued use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A quantity- or range-valued use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A quantity- or range-valued use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A quantity- or range-valued use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A quantity- or range-valued use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A quantity- or range-valued use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A quantity- or range-valued use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A quantity- or range-valued use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A quantity- or range-valued use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A quantity- or range-valued use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A quantity- or range-valued use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A quantity- or range-valued use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A quantity- or range-valued use context assigned to the value set\r\n", type="quantity")
    public static final String SP_CONTEXT_QUANTITY = "context-quantity";
    public static final QuantityClientParam CONTEXT_QUANTITY = new QuantityClientParam("context-quantity");
    @SearchParamDefinition(name="context-type", path="CapabilityStatement.useContext.code | CodeSystem.useContext.code | CompartmentDefinition.useContext.code | ConceptMap.useContext.code | GraphDefinition.useContext.code | ImplementationGuide.useContext.code | MessageDefinition.useContext.code | NamingSystem.useContext.code | OperationDefinition.useContext.code | SearchParameter.useContext.code | StructureDefinition.useContext.code | StructureMap.useContext.code | TerminologyCapabilities.useContext.code | ValueSet.useContext.code", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A type of use context assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A type of use context assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A type of use context assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A type of use context assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A type of use context assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A type of use context assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A type of use context assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A type of use context assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A type of use context assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A type of use context assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A type of use context assigned to the structure definition\r\n* [StructureMap](structuremap.html): A type of use context assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A type of use context assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A type of use context assigned to the value set\r\n", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="date", path="CapabilityStatement.date | CodeSystem.date | CompartmentDefinition.date | ConceptMap.date | GraphDefinition.date | ImplementationGuide.date | MessageDefinition.date | NamingSystem.date | OperationDefinition.date | SearchParameter.date | StructureDefinition.date | StructureMap.date | TerminologyCapabilities.date | ValueSet.date", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The capability statement publication date\r\n* [CodeSystem](codesystem.html): The code system publication date\r\n* [CompartmentDefinition](compartmentdefinition.html): The compartment definition publication date\r\n* [ConceptMap](conceptmap.html): The concept map publication date\r\n* [GraphDefinition](graphdefinition.html): The graph definition publication date\r\n* [ImplementationGuide](implementationguide.html): The implementation guide publication date\r\n* [MessageDefinition](messagedefinition.html): The message definition publication date\r\n* [NamingSystem](namingsystem.html): The naming system publication date\r\n* [OperationDefinition](operationdefinition.html): The operation definition publication date\r\n* [SearchParameter](searchparameter.html): The search parameter publication date\r\n* [StructureDefinition](structuredefinition.html): The structure definition publication date\r\n* [StructureMap](structuremap.html): The structure map publication date\r\n* [TerminologyCapabilities](terminologycapabilities.html): The terminology capabilities publication date\r\n* [ValueSet](valueset.html): The value set publication date\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="description", path="CapabilityStatement.description | CodeSystem.description | CompartmentDefinition.description | ConceptMap.description | GraphDefinition.description | ImplementationGuide.description | MessageDefinition.description | NamingSystem.description | OperationDefinition.description | SearchParameter.description | StructureDefinition.description | StructureMap.description | TerminologyCapabilities.description | ValueSet.description", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The description of the capability statement\r\n* [CodeSystem](codesystem.html): The description of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The description of the compartment definition\r\n* [ConceptMap](conceptmap.html): The description of the concept map\r\n* [GraphDefinition](graphdefinition.html): The description of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The description of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The description of the message definition\r\n* [NamingSystem](namingsystem.html): The description of the naming system\r\n* [OperationDefinition](operationdefinition.html): The description of the operation definition\r\n* [SearchParameter](searchparameter.html): The description of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The description of the structure definition\r\n* [StructureMap](structuremap.html): The description of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The description of the terminology capabilities\r\n* [ValueSet](valueset.html): The description of the value set\r\n", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="jurisdiction", path="CapabilityStatement.jurisdiction | CodeSystem.jurisdiction | ConceptMap.jurisdiction | GraphDefinition.jurisdiction | ImplementationGuide.jurisdiction | MessageDefinition.jurisdiction | NamingSystem.jurisdiction | OperationDefinition.jurisdiction | SearchParameter.jurisdiction | StructureDefinition.jurisdiction | StructureMap.jurisdiction | TerminologyCapabilities.jurisdiction | ValueSet.jurisdiction", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Intended jurisdiction for the capability statement\r\n* [CodeSystem](codesystem.html): Intended jurisdiction for the code system\r\n* [ConceptMap](conceptmap.html): Intended jurisdiction for the concept map\r\n* [GraphDefinition](graphdefinition.html): Intended jurisdiction for the graph definition\r\n* [ImplementationGuide](implementationguide.html): Intended jurisdiction for the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Intended jurisdiction for the message definition\r\n* [NamingSystem](namingsystem.html): Intended jurisdiction for the naming system\r\n* [OperationDefinition](operationdefinition.html): Intended jurisdiction for the operation definition\r\n* [SearchParameter](searchparameter.html): Intended jurisdiction for the search parameter\r\n* [StructureDefinition](structuredefinition.html): Intended jurisdiction for the structure definition\r\n* [StructureMap](structuremap.html): Intended jurisdiction for the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Intended jurisdiction for the terminology capabilities\r\n* [ValueSet](valueset.html): Intended jurisdiction for the value set\r\n", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="CapabilityStatement.name | CodeSystem.name | CompartmentDefinition.name | ConceptMap.name | GraphDefinition.name | ImplementationGuide.name | MessageDefinition.name | NamingSystem.name | OperationDefinition.name | SearchParameter.name | StructureDefinition.name | StructureMap.name | TerminologyCapabilities.name | ValueSet.name", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Computationally friendly name of the capability statement\r\n* [CodeSystem](codesystem.html): Computationally friendly name of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Computationally friendly name of the compartment definition\r\n* [ConceptMap](conceptmap.html): Computationally friendly name of the concept map\r\n* [GraphDefinition](graphdefinition.html): Computationally friendly name of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Computationally friendly name of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Computationally friendly name of the message definition\r\n* [NamingSystem](namingsystem.html): Computationally friendly name of the naming system\r\n* [OperationDefinition](operationdefinition.html): Computationally friendly name of the operation definition\r\n* [SearchParameter](searchparameter.html): Computationally friendly name of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Computationally friendly name of the structure definition\r\n* [StructureMap](structuremap.html): Computationally friendly name of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Computationally friendly name of the terminology capabilities\r\n* [ValueSet](valueset.html): Computationally friendly name of the value set\r\n", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="CapabilityStatement.publisher | CodeSystem.publisher | CompartmentDefinition.publisher | ConceptMap.publisher | GraphDefinition.publisher | ImplementationGuide.publisher | MessageDefinition.publisher | NamingSystem.publisher | OperationDefinition.publisher | SearchParameter.publisher | StructureDefinition.publisher | StructureMap.publisher | TerminologyCapabilities.publisher | ValueSet.publisher", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): Name of the publisher of the capability statement\r\n* [CodeSystem](codesystem.html): Name of the publisher of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): Name of the publisher of the compartment definition\r\n* [ConceptMap](conceptmap.html): Name of the publisher of the concept map\r\n* [GraphDefinition](graphdefinition.html): Name of the publisher of the graph definition\r\n* [ImplementationGuide](implementationguide.html): Name of the publisher of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): Name of the publisher of the message definition\r\n* [NamingSystem](namingsystem.html): Name of the publisher of the naming system\r\n* [OperationDefinition](operationdefinition.html): Name of the publisher of the operation definition\r\n* [SearchParameter](searchparameter.html): Name of the publisher of the search parameter\r\n* [StructureDefinition](structuredefinition.html): Name of the publisher of the structure definition\r\n* [StructureMap](structuremap.html): Name of the publisher of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): Name of the publisher of the terminology capabilities\r\n* [ValueSet](valueset.html): Name of the publisher of the value set\r\n", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="status", path="CapabilityStatement.status | CodeSystem.status | CompartmentDefinition.status | ConceptMap.status | GraphDefinition.status | ImplementationGuide.status | MessageDefinition.status | NamingSystem.status | OperationDefinition.status | SearchParameter.status | StructureDefinition.status | StructureMap.status | TerminologyCapabilities.status | ValueSet.status", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The current status of the capability statement\r\n* [CodeSystem](codesystem.html): The current status of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The current status of the compartment definition\r\n* [ConceptMap](conceptmap.html): The current status of the concept map\r\n* [GraphDefinition](graphdefinition.html): The current status of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The current status of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The current status of the message definition\r\n* [NamingSystem](namingsystem.html): The current status of the naming system\r\n* [OperationDefinition](operationdefinition.html): The current status of the operation definition\r\n* [SearchParameter](searchparameter.html): The current status of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The current status of the structure definition\r\n* [StructureMap](structuremap.html): The current status of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The current status of the terminology capabilities\r\n* [ValueSet](valueset.html): The current status of the value set\r\n", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="url", path="CapabilityStatement.url | CodeSystem.url | CompartmentDefinition.url | ConceptMap.url | GraphDefinition.url | ImplementationGuide.url | MessageDefinition.url | NamingSystem.url | OperationDefinition.url | SearchParameter.url | StructureDefinition.url | StructureMap.url | TerminologyCapabilities.url | ValueSet.url", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The uri that identifies the capability statement\r\n* [CodeSystem](codesystem.html): The uri that identifies the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The uri that identifies the compartment definition\r\n* [ConceptMap](conceptmap.html): The uri that identifies the concept map\r\n* [GraphDefinition](graphdefinition.html): The uri that identifies the graph definition\r\n* [ImplementationGuide](implementationguide.html): The uri that identifies the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The uri that identifies the message definition\r\n* [NamingSystem](namingsystem.html): The uri that identifies the naming system\r\n* [OperationDefinition](operationdefinition.html): The uri that identifies the operation definition\r\n* [SearchParameter](searchparameter.html): The uri that identifies the search parameter\r\n* [StructureDefinition](structuredefinition.html): The uri that identifies the structure definition\r\n* [StructureMap](structuremap.html): The uri that identifies the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The uri that identifies the terminology capabilities\r\n* [ValueSet](valueset.html): The uri that identifies the value set\r\n", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="version", path="CapabilityStatement.version | CodeSystem.version | CompartmentDefinition.version | ConceptMap.version | GraphDefinition.version | ImplementationGuide.version | MessageDefinition.version | NamingSystem.version | OperationDefinition.version | SearchParameter.version | StructureDefinition.version | StructureMap.version | TerminologyCapabilities.version | ValueSet.version", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): The business version of the capability statement\r\n* [CodeSystem](codesystem.html): The business version of the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): The business version of the compartment definition\r\n* [ConceptMap](conceptmap.html): The business version of the concept map\r\n* [GraphDefinition](graphdefinition.html): The business version of the graph definition\r\n* [ImplementationGuide](implementationguide.html): The business version of the implementation guide\r\n* [MessageDefinition](messagedefinition.html): The business version of the message definition\r\n* [NamingSystem](namingsystem.html): The business version of the naming system\r\n* [OperationDefinition](operationdefinition.html): The business version of the operation definition\r\n* [SearchParameter](searchparameter.html): The business version of the search parameter\r\n* [StructureDefinition](structuredefinition.html): The business version of the structure definition\r\n* [StructureMap](structuremap.html): The business version of the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): The business version of the terminology capabilities\r\n* [ValueSet](valueset.html): The business version of the value set\r\n", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="context-type-quantity", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and quantity- or range-based value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and quantity- or range-based value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and quantity- or range-based value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and quantity- or range-based value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and quantity- or range-based value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and quantity- or range-based value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and quantity- or range-based value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and quantity- or range-based value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and quantity- or range-based value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and quantity- or range-based value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and quantity- or range-based value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and quantity- or range-based value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and quantity- or range-based value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and quantity- or range-based value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context-quantity"})
    public static final String SP_CONTEXT_TYPE_QUANTITY = "context-type-quantity";
    public static final CompositeClientParam<TokenClientParam, QuantityClientParam> CONTEXT_TYPE_QUANTITY = new CompositeClientParam("context-type-quantity");
    @SearchParamDefinition(name="context-type-value", path="CapabilityStatement.useContext | CodeSystem.useContext | CompartmentDefinition.useContext | ConceptMap.useContext | GraphDefinition.useContext | ImplementationGuide.useContext | MessageDefinition.useContext | NamingSystem.useContext | OperationDefinition.useContext | SearchParameter.useContext | StructureDefinition.useContext | StructureMap.useContext | TerminologyCapabilities.useContext | ValueSet.useContext", description="Multiple Resources: \r\n\r\n* [CapabilityStatement](capabilitystatement.html): A use context type and value assigned to the capability statement\r\n* [CodeSystem](codesystem.html): A use context type and value assigned to the code system\r\n* [CompartmentDefinition](compartmentdefinition.html): A use context type and value assigned to the compartment definition\r\n* [ConceptMap](conceptmap.html): A use context type and value assigned to the concept map\r\n* [GraphDefinition](graphdefinition.html): A use context type and value assigned to the graph definition\r\n* [ImplementationGuide](implementationguide.html): A use context type and value assigned to the implementation guide\r\n* [MessageDefinition](messagedefinition.html): A use context type and value assigned to the message definition\r\n* [NamingSystem](namingsystem.html): A use context type and value assigned to the naming system\r\n* [OperationDefinition](operationdefinition.html): A use context type and value assigned to the operation definition\r\n* [SearchParameter](searchparameter.html): A use context type and value assigned to the search parameter\r\n* [StructureDefinition](structuredefinition.html): A use context type and value assigned to the structure definition\r\n* [StructureMap](structuremap.html): A use context type and value assigned to the structure map\r\n* [TerminologyCapabilities](terminologycapabilities.html): A use context type and value assigned to the terminology capabilities\r\n* [ValueSet](valueset.html): A use context type and value assigned to the value set\r\n", type="composite", compositeOf={"context-type", "context"})
    public static final String SP_CONTEXT_TYPE_VALUE = "context-type-value";
    public static final CompositeClientParam<TokenClientParam, TokenClientParam> CONTEXT_TYPE_VALUE = new CompositeClientParam("context-type-value");
    @SearchParamDefinition(name="base", path="SearchParameter.base", description="The resource type(s) this search parameter applies to", type="token")
    public static final String SP_BASE = "base";
    public static final TokenClientParam BASE = new TokenClientParam("base");
    @SearchParamDefinition(name="code", path="SearchParameter.code", description="Code used in URL", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="component", path="SearchParameter.component.definition", description="Defines how the part works", type="reference", target={SearchParameter.class})
    public static final String SP_COMPONENT = "component";
    public static final ReferenceClientParam COMPONENT = new ReferenceClientParam("component");
    public static final Include INCLUDE_COMPONENT = new Include("SearchParameter:component").toLocked();
    @SearchParamDefinition(name="derived-from", path="SearchParameter.derivedFrom", description="Original definition for the search parameter", type="reference", target={SearchParameter.class})
    public static final String SP_DERIVED_FROM = "derived-from";
    public static final ReferenceClientParam DERIVED_FROM = new ReferenceClientParam("derived-from");
    public static final Include INCLUDE_DERIVED_FROM = new Include("SearchParameter:derived-from").toLocked();
    @SearchParamDefinition(name="target", path="SearchParameter.target", description="Types of resource (if a resource reference)", type="token")
    public static final String SP_TARGET = "target";
    public static final TokenClientParam TARGET = new TokenClientParam("target");
    @SearchParamDefinition(name="type", path="SearchParameter.type", description="number | date | string | token | reference | composite | quantity | uri | special", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");

    public SearchParameter() {
    }

    public SearchParameter(String url, String name, Enumerations.PublicationStatus status, String description, String code, String base, Enumerations.SearchParamType type) {
        this.setUrl(url);
        this.setName(name);
        this.setStatus(status);
        this.setDescription(description);
        this.setCode(code);
        this.addBase(base);
        this.setType(type);
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public SearchParameter setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public SearchParameter setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public SearchParameter setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public SearchParameter setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public SearchParameter setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public SearchParameter setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    public CanonicalType getDerivedFromElement() {
        if (this.derivedFrom == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.derivedFrom");
            }
            if (Configuration.doAutoCreate()) {
                this.derivedFrom = new CanonicalType();
            }
        }
        return this.derivedFrom;
    }

    public boolean hasDerivedFromElement() {
        return this.derivedFrom != null && !this.derivedFrom.isEmpty();
    }

    public boolean hasDerivedFrom() {
        return this.derivedFrom != null && !this.derivedFrom.isEmpty();
    }

    public SearchParameter setDerivedFromElement(CanonicalType value) {
        this.derivedFrom = value;
        return this;
    }

    public String getDerivedFrom() {
        return this.derivedFrom == null ? null : (String)this.derivedFrom.getValue();
    }

    public SearchParameter setDerivedFrom(String value) {
        if (Utilities.noString(value)) {
            this.derivedFrom = null;
        } else {
            if (this.derivedFrom == null) {
                this.derivedFrom = new CanonicalType();
            }
            this.derivedFrom.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public SearchParameter setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public SearchParameter setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public SearchParameter setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public SearchParameter setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public SearchParameter setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public SearchParameter setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public SearchParameter setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public SearchParameter setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        return this.contact;
    }

    @Override
    public SearchParameter setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public SearchParameter addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactDetail>();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public SearchParameter setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public SearchParameter setDescription(String value) {
        if (this.description == null) {
            this.description = new MarkdownType();
        }
        this.description.setValue(value);
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        return this.useContext;
    }

    @Override
    public SearchParameter setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public SearchParameter addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList<UsageContext>();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        return this.jurisdiction;
    }

    @Override
    public SearchParameter setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public SearchParameter addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList<CodeableConcept>();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    @Override
    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    @Override
    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    @Override
    public SearchParameter setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    @Override
    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    @Override
    public SearchParameter setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public CodeType getCodeElement() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeType();
            }
        }
        return this.code;
    }

    public boolean hasCodeElement() {
        return this.code != null && !this.code.isEmpty();
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public SearchParameter setCodeElement(CodeType value) {
        this.code = value;
        return this;
    }

    public String getCode() {
        return this.code == null ? null : (String)this.code.getValue();
    }

    public SearchParameter setCode(String value) {
        if (this.code == null) {
            this.code = new CodeType();
        }
        this.code.setValue(value);
        return this;
    }

    public List<CodeType> getBase() {
        if (this.base == null) {
            this.base = new ArrayList<CodeType>();
        }
        return this.base;
    }

    public SearchParameter setBase(List<CodeType> theBase) {
        this.base = theBase;
        return this;
    }

    public boolean hasBase() {
        if (this.base == null) {
            return false;
        }
        for (CodeType item : this.base) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addBaseElement() {
        CodeType t = new CodeType();
        if (this.base == null) {
            this.base = new ArrayList<CodeType>();
        }
        this.base.add(t);
        return t;
    }

    public SearchParameter addBase(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.base == null) {
            this.base = new ArrayList<CodeType>();
        }
        this.base.add(t);
        return this;
    }

    public boolean hasBase(String value) {
        if (this.base == null) {
            return false;
        }
        for (CodeType v : this.base) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public Enumeration<Enumerations.SearchParamType> getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public SearchParameter setTypeElement(Enumeration<Enumerations.SearchParamType> value) {
        this.type = value;
        return this;
    }

    public Enumerations.SearchParamType getType() {
        return this.type == null ? null : (Enumerations.SearchParamType)((Object)this.type.getValue());
    }

    public SearchParameter setType(Enumerations.SearchParamType value) {
        if (this.type == null) {
            this.type = new Enumeration<Enumerations.SearchParamType>(new Enumerations.SearchParamTypeEnumFactory());
        }
        this.type.setValue((Object)value);
        return this;
    }

    public StringType getExpressionElement() {
        if (this.expression == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.expression");
            }
            if (Configuration.doAutoCreate()) {
                this.expression = new StringType();
            }
        }
        return this.expression;
    }

    public boolean hasExpressionElement() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public boolean hasExpression() {
        return this.expression != null && !this.expression.isEmpty();
    }

    public SearchParameter setExpressionElement(StringType value) {
        this.expression = value;
        return this;
    }

    public String getExpression() {
        return this.expression == null ? null : (String)this.expression.getValue();
    }

    public SearchParameter setExpression(String value) {
        if (Utilities.noString(value)) {
            this.expression = null;
        } else {
            if (this.expression == null) {
                this.expression = new StringType();
            }
            this.expression.setValue(value);
        }
        return this;
    }

    public StringType getXpathElement() {
        if (this.xpath == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.xpath");
            }
            if (Configuration.doAutoCreate()) {
                this.xpath = new StringType();
            }
        }
        return this.xpath;
    }

    public boolean hasXpathElement() {
        return this.xpath != null && !this.xpath.isEmpty();
    }

    public boolean hasXpath() {
        return this.xpath != null && !this.xpath.isEmpty();
    }

    public SearchParameter setXpathElement(StringType value) {
        this.xpath = value;
        return this;
    }

    public String getXpath() {
        return this.xpath == null ? null : (String)this.xpath.getValue();
    }

    public SearchParameter setXpath(String value) {
        if (Utilities.noString(value)) {
            this.xpath = null;
        } else {
            if (this.xpath == null) {
                this.xpath = new StringType();
            }
            this.xpath.setValue(value);
        }
        return this;
    }

    public Enumeration<XPathUsageType> getXpathUsageElement() {
        if (this.xpathUsage == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.xpathUsage");
            }
            if (Configuration.doAutoCreate()) {
                this.xpathUsage = new Enumeration<XPathUsageType>(new XPathUsageTypeEnumFactory());
            }
        }
        return this.xpathUsage;
    }

    public boolean hasXpathUsageElement() {
        return this.xpathUsage != null && !this.xpathUsage.isEmpty();
    }

    public boolean hasXpathUsage() {
        return this.xpathUsage != null && !this.xpathUsage.isEmpty();
    }

    public SearchParameter setXpathUsageElement(Enumeration<XPathUsageType> value) {
        this.xpathUsage = value;
        return this;
    }

    public XPathUsageType getXpathUsage() {
        return this.xpathUsage == null ? null : (XPathUsageType)((Object)this.xpathUsage.getValue());
    }

    public SearchParameter setXpathUsage(XPathUsageType value) {
        if (value == null) {
            this.xpathUsage = null;
        } else {
            if (this.xpathUsage == null) {
                this.xpathUsage = new Enumeration<XPathUsageType>(new XPathUsageTypeEnumFactory());
            }
            this.xpathUsage.setValue((Object)value);
        }
        return this;
    }

    public List<CodeType> getTarget() {
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        return this.target;
    }

    public SearchParameter setTarget(List<CodeType> theTarget) {
        this.target = theTarget;
        return this;
    }

    public boolean hasTarget() {
        if (this.target == null) {
            return false;
        }
        for (CodeType item : this.target) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeType addTargetElement() {
        CodeType t = new CodeType();
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        this.target.add(t);
        return t;
    }

    public SearchParameter addTarget(String value) {
        CodeType t = new CodeType();
        t.setValue(value);
        if (this.target == null) {
            this.target = new ArrayList<CodeType>();
        }
        this.target.add(t);
        return this;
    }

    public boolean hasTarget(String value) {
        if (this.target == null) {
            return false;
        }
        for (CodeType v : this.target) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public BooleanType getMultipleOrElement() {
        if (this.multipleOr == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.multipleOr");
            }
            if (Configuration.doAutoCreate()) {
                this.multipleOr = new BooleanType();
            }
        }
        return this.multipleOr;
    }

    public boolean hasMultipleOrElement() {
        return this.multipleOr != null && !this.multipleOr.isEmpty();
    }

    public boolean hasMultipleOr() {
        return this.multipleOr != null && !this.multipleOr.isEmpty();
    }

    public SearchParameter setMultipleOrElement(BooleanType value) {
        this.multipleOr = value;
        return this;
    }

    public boolean getMultipleOr() {
        return this.multipleOr == null || this.multipleOr.isEmpty() ? false : (Boolean)this.multipleOr.getValue();
    }

    public SearchParameter setMultipleOr(boolean value) {
        if (this.multipleOr == null) {
            this.multipleOr = new BooleanType();
        }
        this.multipleOr.setValue((Object)value);
        return this;
    }

    public BooleanType getMultipleAndElement() {
        if (this.multipleAnd == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create SearchParameter.multipleAnd");
            }
            if (Configuration.doAutoCreate()) {
                this.multipleAnd = new BooleanType();
            }
        }
        return this.multipleAnd;
    }

    public boolean hasMultipleAndElement() {
        return this.multipleAnd != null && !this.multipleAnd.isEmpty();
    }

    public boolean hasMultipleAnd() {
        return this.multipleAnd != null && !this.multipleAnd.isEmpty();
    }

    public SearchParameter setMultipleAndElement(BooleanType value) {
        this.multipleAnd = value;
        return this;
    }

    public boolean getMultipleAnd() {
        return this.multipleAnd == null || this.multipleAnd.isEmpty() ? false : (Boolean)this.multipleAnd.getValue();
    }

    public SearchParameter setMultipleAnd(boolean value) {
        if (this.multipleAnd == null) {
            this.multipleAnd = new BooleanType();
        }
        this.multipleAnd.setValue((Object)value);
        return this;
    }

    public List<Enumeration<SearchComparator>> getComparator() {
        if (this.comparator == null) {
            this.comparator = new ArrayList<Enumeration<SearchComparator>>();
        }
        return this.comparator;
    }

    public SearchParameter setComparator(List<Enumeration<SearchComparator>> theComparator) {
        this.comparator = theComparator;
        return this;
    }

    public boolean hasComparator() {
        if (this.comparator == null) {
            return false;
        }
        for (Enumeration<SearchComparator> item : this.comparator) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<SearchComparator> addComparatorElement() {
        Enumeration<SearchComparator> t = new Enumeration<SearchComparator>(new SearchComparatorEnumFactory());
        if (this.comparator == null) {
            this.comparator = new ArrayList<Enumeration<SearchComparator>>();
        }
        this.comparator.add(t);
        return t;
    }

    public SearchParameter addComparator(SearchComparator value) {
        Enumeration<SearchComparator> t = new Enumeration<SearchComparator>(new SearchComparatorEnumFactory());
        t.setValue((Object)value);
        if (this.comparator == null) {
            this.comparator = new ArrayList<Enumeration<SearchComparator>>();
        }
        this.comparator.add(t);
        return this;
    }

    public boolean hasComparator(SearchComparator value) {
        if (this.comparator == null) {
            return false;
        }
        for (Enumeration<SearchComparator> v : this.comparator) {
            if (!((SearchComparator)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public List<Enumeration<SearchModifierCode>> getModifier() {
        if (this.modifier == null) {
            this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
        }
        return this.modifier;
    }

    public SearchParameter setModifier(List<Enumeration<SearchModifierCode>> theModifier) {
        this.modifier = theModifier;
        return this;
    }

    public boolean hasModifier() {
        if (this.modifier == null) {
            return false;
        }
        for (Enumeration<SearchModifierCode> item : this.modifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Enumeration<SearchModifierCode> addModifierElement() {
        Enumeration<SearchModifierCode> t = new Enumeration<SearchModifierCode>(new SearchModifierCodeEnumFactory());
        if (this.modifier == null) {
            this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
        }
        this.modifier.add(t);
        return t;
    }

    public SearchParameter addModifier(SearchModifierCode value) {
        Enumeration<SearchModifierCode> t = new Enumeration<SearchModifierCode>(new SearchModifierCodeEnumFactory());
        t.setValue((Object)value);
        if (this.modifier == null) {
            this.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
        }
        this.modifier.add(t);
        return this;
    }

    public boolean hasModifier(SearchModifierCode value) {
        if (this.modifier == null) {
            return false;
        }
        for (Enumeration<SearchModifierCode> v : this.modifier) {
            if (!((SearchModifierCode)((Object)v.getValue())).equals((Object)value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getChain() {
        if (this.chain == null) {
            this.chain = new ArrayList<StringType>();
        }
        return this.chain;
    }

    public SearchParameter setChain(List<StringType> theChain) {
        this.chain = theChain;
        return this;
    }

    public boolean hasChain() {
        if (this.chain == null) {
            return false;
        }
        for (StringType item : this.chain) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addChainElement() {
        StringType t = new StringType();
        if (this.chain == null) {
            this.chain = new ArrayList<StringType>();
        }
        this.chain.add(t);
        return t;
    }

    public SearchParameter addChain(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.chain == null) {
            this.chain = new ArrayList<StringType>();
        }
        this.chain.add(t);
        return this;
    }

    public boolean hasChain(String value) {
        if (this.chain == null) {
            return false;
        }
        for (StringType v : this.chain) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<SearchParameterComponentComponent> getComponent() {
        if (this.component == null) {
            this.component = new ArrayList<SearchParameterComponentComponent>();
        }
        return this.component;
    }

    public SearchParameter setComponent(List<SearchParameterComponentComponent> theComponent) {
        this.component = theComponent;
        return this;
    }

    public boolean hasComponent() {
        if (this.component == null) {
            return false;
        }
        for (SearchParameterComponentComponent item : this.component) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SearchParameterComponentComponent addComponent() {
        SearchParameterComponentComponent t = new SearchParameterComponentComponent();
        if (this.component == null) {
            this.component = new ArrayList<SearchParameterComponentComponent>();
        }
        this.component.add(t);
        return t;
    }

    public SearchParameter addComponent(SearchParameterComponentComponent t) {
        if (t == null) {
            return this;
        }
        if (this.component == null) {
            this.component = new ArrayList<SearchParameterComponentComponent>();
        }
        this.component.add(t);
        return this;
    }

    public SearchParameterComponentComponent getComponentFirstRep() {
        if (this.getComponent().isEmpty()) {
            this.addComponent();
        }
        return this.getComponent().get(0);
    }

    @Override
    public int getIdentifierMax() {
        return 0;
    }

    @Override
    public List<Identifier> getIdentifier() {
        return new ArrayList<Identifier>();
    }

    @Override
    public SearchParameter setIdentifier(List<Identifier> theIdentifier) {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"identifier\"");
    }

    @Override
    public boolean hasIdentifier() {
        return false;
    }

    @Override
    public Identifier addIdentifier() {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"identifier\"");
    }

    @Override
    public SearchParameter addIdentifier(Identifier t) {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"identifier\"");
    }

    @Override
    public Identifier getIdentifierFirstRep() {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"identifier\"");
    }

    @Override
    public int getTitleMax() {
        return 0;
    }

    @Override
    public StringType getTitleElement() {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"title\"");
    }

    @Override
    public boolean hasTitleElement() {
        return false;
    }

    @Override
    public boolean hasTitle() {
        return false;
    }

    @Override
    public SearchParameter setTitleElement(StringType value) {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"title\"");
    }

    @Override
    public String getTitle() {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"title\"");
    }

    @Override
    public SearchParameter setTitle(String value) {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"title\"");
    }

    @Override
    public int getCopyrightMax() {
        return 0;
    }

    @Override
    public MarkdownType getCopyrightElement() {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"copyright\"");
    }

    @Override
    public boolean hasCopyrightElement() {
        return false;
    }

    @Override
    public boolean hasCopyright() {
        return false;
    }

    @Override
    public SearchParameter setCopyrightElement(MarkdownType value) {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"copyright\"");
    }

    @Override
    public String getCopyright() {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"copyright\"");
    }

    @Override
    public SearchParameter setCopyright(String value) {
        throw new Error("The resource type \"SearchParameter\" does not implement the property \"copyright\"");
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this search parameter when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this search parameter is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the search parameter is stored on different servers.", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the search parameter when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the search parameter author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the search parameter. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property("derivedFrom", "canonical(SearchParameter)", "Where this search parameter is originally defined. If a derivedFrom is provided, then the details in the search parameter must be consistent with the definition from which it is defined. i.e. the parameter should have the same meaning, and (usually) the functionality should be a proper subset of the underlying search parameter.", 0, 1, this.derivedFrom));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of this search parameter. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A Boolean value to indicate that this search parameter is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the search parameter was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the search parameter changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the search parameter.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "And how it used.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate search parameter instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the search parameter is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explanation of why this search parameter is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property(SP_CODE, SP_CODE, "The code used in the URL or the parameter name in a parameters resource for this search parameter.", 0, 1, this.code));
        children.add(new Property(SP_BASE, SP_CODE, "The base resource type(s) that this search parameter can be used against.", 0, Integer.MAX_VALUE, this.base));
        children.add(new Property(SP_TYPE, SP_CODE, "The type of value that a search parameter may contain, and how the content is interpreted.", 0, 1, this.type));
        children.add(new Property("expression", "string", "A FHIRPath expression that returns a set of elements for the search parameter.", 0, 1, this.expression));
        children.add(new Property("xpath", "string", "An XPath expression that returns a set of elements for the search parameter.", 0, 1, this.xpath));
        children.add(new Property("xpathUsage", SP_CODE, "How the search parameter relates to the set of elements returned by evaluating the xpath query.", 0, 1, this.xpathUsage));
        children.add(new Property(SP_TARGET, SP_CODE, "Types of resource (if a resource is referenced).", 0, Integer.MAX_VALUE, this.target));
        children.add(new Property("multipleOr", "boolean", "Whether multiple values are allowed for each time the parameter exists. Values are separated by commas, and the parameter matches if any of the values match.", 0, 1, this.multipleOr));
        children.add(new Property("multipleAnd", "boolean", "Whether multiple parameters are allowed - e.g. more than one parameter with the same name. The search matches if all the parameters match.", 0, 1, this.multipleAnd));
        children.add(new Property("comparator", SP_CODE, "Comparators supported for the search parameter.", 0, Integer.MAX_VALUE, this.comparator));
        children.add(new Property("modifier", SP_CODE, "A modifier supported for the search parameter.", 0, Integer.MAX_VALUE, this.modifier));
        children.add(new Property("chain", "string", "Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from SearchParameter.code for a parameter on the target resource type.", 0, Integer.MAX_VALUE, this.chain));
        children.add(new Property(SP_COMPONENT, "", "Used to define the parts of a composite search parameter.", 0, Integer.MAX_VALUE, this.component));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this search parameter when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this search parameter is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the search parameter is stored on different servers.", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the search parameter when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the search parameter author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the search parameter. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 1077922663: {
                return new Property("derivedFrom", "canonical(SearchParameter)", "Where this search parameter is originally defined. If a derivedFrom is provided, then the details in the search parameter must be consistent with the definition from which it is defined. i.e. the parameter should have the same meaning, and (usually) the functionality should be a proper subset of the underlying search parameter.", 0, 1, this.derivedFrom);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of this search parameter. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A Boolean value to indicate that this search parameter is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the search parameter was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the search parameter changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the organization or individual that published the search parameter.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "And how it used.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate search parameter instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the search parameter is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explanation of why this search parameter is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 3059181: {
                return new Property(SP_CODE, SP_CODE, "The code used in the URL or the parameter name in a parameters resource for this search parameter.", 0, 1, this.code);
            }
            case 3016401: {
                return new Property(SP_BASE, SP_CODE, "The base resource type(s) that this search parameter can be used against.", 0, Integer.MAX_VALUE, this.base);
            }
            case 3575610: {
                return new Property(SP_TYPE, SP_CODE, "The type of value that a search parameter may contain, and how the content is interpreted.", 0, 1, this.type);
            }
            case -1795452264: {
                return new Property("expression", "string", "A FHIRPath expression that returns a set of elements for the search parameter.", 0, 1, this.expression);
            }
            case 114256029: {
                return new Property("xpath", "string", "An XPath expression that returns a set of elements for the search parameter.", 0, 1, this.xpath);
            }
            case 1801322244: {
                return new Property("xpathUsage", SP_CODE, "How the search parameter relates to the set of elements returned by evaluating the xpath query.", 0, 1, this.xpathUsage);
            }
            case -880905839: {
                return new Property(SP_TARGET, SP_CODE, "Types of resource (if a resource is referenced).", 0, Integer.MAX_VALUE, this.target);
            }
            case 1265069075: {
                return new Property("multipleOr", "boolean", "Whether multiple values are allowed for each time the parameter exists. Values are separated by commas, and the parameter matches if any of the values match.", 0, 1, this.multipleOr);
            }
            case 562422183: {
                return new Property("multipleAnd", "boolean", "Whether multiple parameters are allowed - e.g. more than one parameter with the same name. The search matches if all the parameters match.", 0, 1, this.multipleAnd);
            }
            case -844673834: {
                return new Property("comparator", SP_CODE, "Comparators supported for the search parameter.", 0, Integer.MAX_VALUE, this.comparator);
            }
            case -615513385: {
                return new Property("modifier", SP_CODE, "A modifier supported for the search parameter.", 0, Integer.MAX_VALUE, this.modifier);
            }
            case 94623425: {
                return new Property("chain", "string", "Contains the names of any search parameters which may be chained to the containing search parameter. Chained parameters may be added to search parameters of type reference and specify that resources will only be returned if they contain a reference to a resource which matches the chained parameter value. Values for this field should be drawn from SearchParameter.code for a parameter on the target resource type.", 0, Integer.MAX_VALUE, this.chain);
            }
            case -1399907075: {
                return new Property(SP_COMPONENT, "", "Used to define the parts of a composite search parameter.", 0, Integer.MAX_VALUE, this.component);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 1077922663: {
                Base[] baseArray;
                if (this.derivedFrom == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.derivedFrom;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.code;
                }
                return baseArray;
            }
            case 3016401: {
                return this.base == null ? new Base[]{} : this.base.toArray(new Base[this.base.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.type;
                }
                return baseArray;
            }
            case -1795452264: {
                Base[] baseArray;
                if (this.expression == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.expression;
                }
                return baseArray;
            }
            case 114256029: {
                Base[] baseArray;
                if (this.xpath == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.xpath;
                }
                return baseArray;
            }
            case 1801322244: {
                Base[] baseArray;
                if (this.xpathUsage == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.xpathUsage;
                }
                return baseArray;
            }
            case -880905839: {
                return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
            }
            case 1265069075: {
                Base[] baseArray;
                if (this.multipleOr == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.multipleOr;
                }
                return baseArray;
            }
            case 562422183: {
                Base[] baseArray;
                if (this.multipleAnd == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.multipleAnd;
                }
                return baseArray;
            }
            case -844673834: {
                return this.comparator == null ? new Base[]{} : this.comparator.toArray(new Base[this.comparator.size()]);
            }
            case -615513385: {
                return this.modifier == null ? new Base[]{} : this.modifier.toArray(new Base[this.modifier.size()]);
            }
            case 94623425: {
                return this.chain == null ? new Base[]{} : this.chain.toArray(new Base[this.chain.size()]);
            }
            case -1399907075: {
                return this.component == null ? new Base[]{} : this.component.toArray(new Base[this.component.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = TypeConvertor.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = TypeConvertor.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = TypeConvertor.castToString(value);
                return value;
            }
            case 1077922663: {
                this.derivedFrom = TypeConvertor.castToCanonical(value);
                return value;
            }
            case -892481550: {
                value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -404562712: {
                this.experimental = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = TypeConvertor.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = TypeConvertor.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(TypeConvertor.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(TypeConvertor.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = TypeConvertor.castToMarkdown(value);
                return value;
            }
            case 3059181: {
                this.code = TypeConvertor.castToCode(value);
                return value;
            }
            case 3016401: {
                this.getBase().add(TypeConvertor.castToCode(value));
                return value;
            }
            case 3575610: {
                value = new Enumerations.SearchParamTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.type = value;
                return value;
            }
            case -1795452264: {
                this.expression = TypeConvertor.castToString(value);
                return value;
            }
            case 114256029: {
                this.xpath = TypeConvertor.castToString(value);
                return value;
            }
            case 1801322244: {
                value = new XPathUsageTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.xpathUsage = value;
                return value;
            }
            case -880905839: {
                this.getTarget().add(TypeConvertor.castToCode(value));
                return value;
            }
            case 1265069075: {
                this.multipleOr = TypeConvertor.castToBoolean(value);
                return value;
            }
            case 562422183: {
                this.multipleAnd = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -844673834: {
                value = new SearchComparatorEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getComparator().add(value);
                return value;
            }
            case -615513385: {
                value = new SearchModifierCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.getModifier().add(value);
                return value;
            }
            case 94623425: {
                this.getChain().add(TypeConvertor.castToString(value));
                return value;
            }
            case -1399907075: {
                this.getComponent().add((SearchParameterComponentComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = TypeConvertor.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = TypeConvertor.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = TypeConvertor.castToString(value);
        } else if (name.equals("derivedFrom")) {
            this.derivedFrom = TypeConvertor.castToCanonical(value);
        } else if (name.equals(SP_STATUS)) {
            value = new Enumerations.PublicationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("experimental")) {
            this.experimental = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = TypeConvertor.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = TypeConvertor.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(TypeConvertor.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = TypeConvertor.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(TypeConvertor.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = TypeConvertor.castToMarkdown(value);
        } else if (name.equals(SP_CODE)) {
            this.code = TypeConvertor.castToCode(value);
        } else if (name.equals(SP_BASE)) {
            this.getBase().add(TypeConvertor.castToCode(value));
        } else if (name.equals(SP_TYPE)) {
            value = new Enumerations.SearchParamTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.type = value;
        } else if (name.equals("expression")) {
            this.expression = TypeConvertor.castToString(value);
        } else if (name.equals("xpath")) {
            this.xpath = TypeConvertor.castToString(value);
        } else if (name.equals("xpathUsage")) {
            value = new XPathUsageTypeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.xpathUsage = value;
        } else if (name.equals(SP_TARGET)) {
            this.getTarget().add(TypeConvertor.castToCode(value));
        } else if (name.equals("multipleOr")) {
            this.multipleOr = TypeConvertor.castToBoolean(value);
        } else if (name.equals("multipleAnd")) {
            this.multipleAnd = TypeConvertor.castToBoolean(value);
        } else if (name.equals("comparator")) {
            value = new SearchComparatorEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.getComparator().add(value);
        } else if (name.equals("modifier")) {
            value = new SearchModifierCodeEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.getModifier().add(value);
        } else if (name.equals("chain")) {
            this.getChain().add(TypeConvertor.castToString(value));
        } else if (name.equals(SP_COMPONENT)) {
            this.getComponent().add((SearchParameterComponentComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 1077922663: {
                return this.getDerivedFromElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 3059181: {
                return this.getCodeElement();
            }
            case 3016401: {
                return this.addBaseElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case -1795452264: {
                return this.getExpressionElement();
            }
            case 114256029: {
                return this.getXpathElement();
            }
            case 1801322244: {
                return this.getXpathUsageElement();
            }
            case -880905839: {
                return this.addTargetElement();
            }
            case 1265069075: {
                return this.getMultipleOrElement();
            }
            case 562422183: {
                return this.getMultipleAndElement();
            }
            case -844673834: {
                return this.addComparatorElement();
            }
            case -615513385: {
                return this.addModifierElement();
            }
            case 94623425: {
                return this.addChainElement();
            }
            case -1399907075: {
                return this.addComponent();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 1077922663: {
                return new String[]{"canonical"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 3059181: {
                return new String[]{SP_CODE};
            }
            case 3016401: {
                return new String[]{SP_CODE};
            }
            case 3575610: {
                return new String[]{SP_CODE};
            }
            case -1795452264: {
                return new String[]{"string"};
            }
            case 114256029: {
                return new String[]{"string"};
            }
            case 1801322244: {
                return new String[]{SP_CODE};
            }
            case -880905839: {
                return new String[]{SP_CODE};
            }
            case 1265069075: {
                return new String[]{"boolean"};
            }
            case 562422183: {
                return new String[]{"boolean"};
            }
            case -844673834: {
                return new String[]{SP_CODE};
            }
            case -615513385: {
                return new String[]{SP_CODE};
            }
            case 94623425: {
                return new String[]{"string"};
            }
            case -1399907075: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.name");
        }
        if (name.equals("derivedFrom")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.derivedFrom");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.purpose");
        }
        if (name.equals(SP_CODE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.code");
        }
        if (name.equals(SP_BASE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.base");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.type");
        }
        if (name.equals("expression")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.expression");
        }
        if (name.equals("xpath")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.xpath");
        }
        if (name.equals("xpathUsage")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.xpathUsage");
        }
        if (name.equals(SP_TARGET)) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.target");
        }
        if (name.equals("multipleOr")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.multipleOr");
        }
        if (name.equals("multipleAnd")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.multipleAnd");
        }
        if (name.equals("comparator")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.comparator");
        }
        if (name.equals("modifier")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.modifier");
        }
        if (name.equals("chain")) {
            throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.chain");
        }
        if (name.equals(SP_COMPONENT)) {
            return this.addComponent();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "SearchParameter";
    }

    @Override
    public SearchParameter copy() {
        SearchParameter dst = new SearchParameter();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(SearchParameter dst) {
        super.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.derivedFrom = this.derivedFrom == null ? null : this.derivedFrom.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactDetail>();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList<UsageContext>();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        CodeType codeType = dst.code = this.code == null ? null : this.code.copy();
        if (this.base != null) {
            dst.base = new ArrayList<CodeType>();
            for (CodeType codeType2 : this.base) {
                dst.base.add(codeType2.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.expression = this.expression == null ? null : this.expression.copy();
        dst.xpath = this.xpath == null ? null : this.xpath.copy();
        Enumeration<XPathUsageType> enumeration = dst.xpathUsage = this.xpathUsage == null ? null : this.xpathUsage.copy();
        if (this.target != null) {
            dst.target = new ArrayList<CodeType>();
            for (CodeType codeType3 : this.target) {
                dst.target.add(codeType3.copy());
            }
        }
        dst.multipleOr = this.multipleOr == null ? null : this.multipleOr.copy();
        BooleanType booleanType = dst.multipleAnd = this.multipleAnd == null ? null : this.multipleAnd.copy();
        if (this.comparator != null) {
            dst.comparator = new ArrayList<Enumeration<SearchComparator>>();
            for (Enumeration enumeration2 : this.comparator) {
                dst.comparator.add((Enumeration<SearchComparator>)enumeration2.copy());
            }
        }
        if (this.modifier != null) {
            dst.modifier = new ArrayList<Enumeration<SearchModifierCode>>();
            for (Enumeration enumeration3 : this.modifier) {
                dst.modifier.add((Enumeration<SearchModifierCode>)enumeration3.copy());
            }
        }
        if (this.chain != null) {
            dst.chain = new ArrayList<StringType>();
            for (StringType stringType2 : this.chain) {
                dst.chain.add(stringType2.copy());
            }
        }
        if (this.component != null) {
            dst.component = new ArrayList<SearchParameterComponentComponent>();
            for (SearchParameterComponentComponent searchParameterComponentComponent : this.component) {
                dst.component.add(searchParameterComponentComponent.copy());
            }
        }
    }

    protected SearchParameter typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof SearchParameter)) {
            return false;
        }
        SearchParameter o = (SearchParameter)other_;
        return SearchParameter.compareDeep(this.url, o.url, true) && SearchParameter.compareDeep(this.version, o.version, true) && SearchParameter.compareDeep(this.name, o.name, true) && SearchParameter.compareDeep(this.derivedFrom, o.derivedFrom, true) && SearchParameter.compareDeep(this.status, o.status, true) && SearchParameter.compareDeep(this.experimental, o.experimental, true) && SearchParameter.compareDeep(this.date, o.date, true) && SearchParameter.compareDeep(this.publisher, o.publisher, true) && SearchParameter.compareDeep(this.contact, o.contact, true) && SearchParameter.compareDeep(this.description, o.description, true) && SearchParameter.compareDeep(this.useContext, o.useContext, true) && SearchParameter.compareDeep(this.jurisdiction, o.jurisdiction, true) && SearchParameter.compareDeep(this.purpose, o.purpose, true) && SearchParameter.compareDeep(this.code, o.code, true) && SearchParameter.compareDeep(this.base, o.base, true) && SearchParameter.compareDeep(this.type, o.type, true) && SearchParameter.compareDeep(this.expression, o.expression, true) && SearchParameter.compareDeep(this.xpath, o.xpath, true) && SearchParameter.compareDeep(this.xpathUsage, o.xpathUsage, true) && SearchParameter.compareDeep(this.target, o.target, true) && SearchParameter.compareDeep(this.multipleOr, o.multipleOr, true) && SearchParameter.compareDeep(this.multipleAnd, o.multipleAnd, true) && SearchParameter.compareDeep(this.comparator, o.comparator, true) && SearchParameter.compareDeep(this.modifier, o.modifier, true) && SearchParameter.compareDeep(this.chain, o.chain, true) && SearchParameter.compareDeep(this.component, o.component, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof SearchParameter)) {
            return false;
        }
        SearchParameter o = (SearchParameter)other_;
        return SearchParameter.compareValues(this.url, o.url, true) && SearchParameter.compareValues(this.version, o.version, true) && SearchParameter.compareValues(this.name, o.name, true) && SearchParameter.compareValues(this.derivedFrom, o.derivedFrom, true) && SearchParameter.compareValues(this.status, o.status, true) && SearchParameter.compareValues(this.experimental, o.experimental, true) && SearchParameter.compareValues(this.date, o.date, true) && SearchParameter.compareValues(this.publisher, o.publisher, true) && SearchParameter.compareValues(this.description, o.description, true) && SearchParameter.compareValues(this.purpose, o.purpose, true) && SearchParameter.compareValues(this.code, o.code, true) && SearchParameter.compareValues(this.base, o.base, true) && SearchParameter.compareValues(this.type, o.type, true) && SearchParameter.compareValues(this.expression, o.expression, true) && SearchParameter.compareValues(this.xpath, o.xpath, true) && SearchParameter.compareValues(this.xpathUsage, o.xpathUsage, true) && SearchParameter.compareValues(this.target, o.target, true) && SearchParameter.compareValues(this.multipleOr, o.multipleOr, true) && SearchParameter.compareValues(this.multipleAnd, o.multipleAnd, true) && SearchParameter.compareValues(this.comparator, o.comparator, true) && SearchParameter.compareValues(this.modifier, o.modifier, true) && SearchParameter.compareValues(this.chain, o.chain, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.url, this.version, this.name, this.derivedFrom, this.status, this.experimental, this.date, this.publisher, this.contact, this.description, this.useContext, this.jurisdiction, this.purpose, this.code, this.base, this.type, this.expression, this.xpath, this.xpathUsage, this.target, this.multipleOr, this.multipleAnd, this.comparator, this.modifier, this.chain, this.component);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.SearchParameter;
    }

    @Override
    public boolean supportsCopyright() {
        return false;
    }

    @Block
    public static class SearchParameterComponentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="definition", type={CanonicalType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Defines how the part works", formalDefinition="The definition of the search parameter that describes this part.")
        protected CanonicalType definition;
        @Child(name="expression", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Subexpression relative to main expression", formalDefinition="A sub-expression that defines how to extract values for this component from the output of the main SearchParameter.expression.")
        protected StringType expression;
        private static final long serialVersionUID = -1469435618L;

        public SearchParameterComponentComponent() {
        }

        public SearchParameterComponentComponent(String definition, String expression) {
            this.setDefinition(definition);
            this.setExpression(expression);
        }

        public CanonicalType getDefinitionElement() {
            if (this.definition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SearchParameterComponentComponent.definition");
                }
                if (Configuration.doAutoCreate()) {
                    this.definition = new CanonicalType();
                }
            }
            return this.definition;
        }

        public boolean hasDefinitionElement() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public boolean hasDefinition() {
            return this.definition != null && !this.definition.isEmpty();
        }

        public SearchParameterComponentComponent setDefinitionElement(CanonicalType value) {
            this.definition = value;
            return this;
        }

        public String getDefinition() {
            return this.definition == null ? null : (String)this.definition.getValue();
        }

        public SearchParameterComponentComponent setDefinition(String value) {
            if (this.definition == null) {
                this.definition = new CanonicalType();
            }
            this.definition.setValue(value);
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SearchParameterComponentComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public SearchParameterComponentComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public SearchParameterComponentComponent setExpression(String value) {
            if (this.expression == null) {
                this.expression = new StringType();
            }
            this.expression.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("definition", "canonical(SearchParameter)", "The definition of the search parameter that describes this part.", 0, 1, this.definition));
            children.add(new Property("expression", "string", "A sub-expression that defines how to extract values for this component from the output of the main SearchParameter.expression.", 0, 1, this.expression));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1014418093: {
                    return new Property("definition", "canonical(SearchParameter)", "The definition of the search parameter that describes this part.", 0, 1, this.definition);
                }
                case -1795452264: {
                    return new Property("expression", "string", "A sub-expression that defines how to extract values for this component from the output of the main SearchParameter.expression.", 0, 1, this.expression);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    Base[] baseArray;
                    if (this.definition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.definition;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.expression;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    this.definition = TypeConvertor.castToCanonical(value);
                    return value;
                }
                case -1795452264: {
                    this.expression = TypeConvertor.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("definition")) {
                this.definition = TypeConvertor.castToCanonical(value);
            } else if (name.equals("expression")) {
                this.expression = TypeConvertor.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    return this.getDefinitionElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1014418093: {
                    return new String[]{"canonical"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("definition")) {
                throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.component.definition");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type SearchParameter.component.expression");
            }
            return super.addChild(name);
        }

        @Override
        public SearchParameterComponentComponent copy() {
            SearchParameterComponentComponent dst = new SearchParameterComponentComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(SearchParameterComponentComponent dst) {
            super.copyValues(dst);
            dst.definition = this.definition == null ? null : this.definition.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof SearchParameterComponentComponent)) {
                return false;
            }
            SearchParameterComponentComponent o = (SearchParameterComponentComponent)other_;
            return SearchParameterComponentComponent.compareDeep(this.definition, o.definition, true) && SearchParameterComponentComponent.compareDeep(this.expression, o.expression, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof SearchParameterComponentComponent)) {
                return false;
            }
            SearchParameterComponentComponent o = (SearchParameterComponentComponent)other_;
            return SearchParameterComponentComponent.compareValues(this.definition, o.definition, true) && SearchParameterComponentComponent.compareValues(this.expression, o.expression, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.definition, this.expression);
        }

        @Override
        public String fhirType() {
            return "SearchParameter.component";
        }
    }

    public static class XPathUsageTypeEnumFactory
    implements EnumFactory<XPathUsageType> {
        @Override
        public XPathUsageType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return XPathUsageType.NORMAL;
            }
            if ("phonetic".equals(codeString)) {
                return XPathUsageType.PHONETIC;
            }
            if ("nearby".equals(codeString)) {
                return XPathUsageType.NEARBY;
            }
            if ("distance".equals(codeString)) {
                return XPathUsageType.DISTANCE;
            }
            if ("other".equals(codeString)) {
                return XPathUsageType.OTHER;
            }
            throw new IllegalArgumentException("Unknown XPathUsageType code '" + codeString + "'");
        }

        public Enumeration<XPathUsageType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<XPathUsageType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.NORMAL);
            }
            if ("phonetic".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.PHONETIC);
            }
            if ("nearby".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.NEARBY);
            }
            if ("distance".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.DISTANCE);
            }
            if ("other".equals(codeString)) {
                return new Enumeration<XPathUsageType>(this, XPathUsageType.OTHER);
            }
            throw new FHIRException("Unknown XPathUsageType code '" + codeString + "'");
        }

        @Override
        public String toCode(XPathUsageType code) {
            if (code == XPathUsageType.NORMAL) {
                return "normal";
            }
            if (code == XPathUsageType.PHONETIC) {
                return "phonetic";
            }
            if (code == XPathUsageType.NEARBY) {
                return "nearby";
            }
            if (code == XPathUsageType.DISTANCE) {
                return "distance";
            }
            if (code == XPathUsageType.OTHER) {
                return "other";
            }
            return "?";
        }

        @Override
        public String toSystem(XPathUsageType code) {
            return code.getSystem();
        }
    }

    public static enum XPathUsageType {
        NORMAL,
        PHONETIC,
        NEARBY,
        DISTANCE,
        OTHER,
        NULL;


        public static XPathUsageType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("normal".equals(codeString)) {
                return NORMAL;
            }
            if ("phonetic".equals(codeString)) {
                return PHONETIC;
            }
            if ("nearby".equals(codeString)) {
                return NEARBY;
            }
            if ("distance".equals(codeString)) {
                return DISTANCE;
            }
            if ("other".equals(codeString)) {
                return OTHER;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown XPathUsageType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case NORMAL: {
                    return "normal";
                }
                case PHONETIC: {
                    return "phonetic";
                }
                case NEARBY: {
                    return "nearby";
                }
                case DISTANCE: {
                    return "distance";
                }
                case OTHER: {
                    return "other";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case NORMAL: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case PHONETIC: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case NEARBY: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case DISTANCE: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
                case OTHER: {
                    return "http://hl7.org/fhir/search-xpath-usage";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case NORMAL: {
                    return "The search parameter is derived directly from the selected nodes based on the type definitions.";
                }
                case PHONETIC: {
                    return "The search parameter is derived by a phonetic transform from the selected nodes.";
                }
                case NEARBY: {
                    return "The search parameter is based on a spatial transform of the selected nodes.";
                }
                case DISTANCE: {
                    return "The search parameter is based on a spatial transform of the selected nodes, using physical distance from the middle.";
                }
                case OTHER: {
                    return "The interpretation of the xpath statement is unknown (and can't be automated).";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case NORMAL: {
                    return "Normal";
                }
                case PHONETIC: {
                    return "Phonetic";
                }
                case NEARBY: {
                    return "Nearby";
                }
                case DISTANCE: {
                    return "Distance";
                }
                case OTHER: {
                    return "Other";
                }
            }
            return "?";
        }
    }

    public static class SearchModifierCodeEnumFactory
    implements EnumFactory<SearchModifierCode> {
        @Override
        public SearchModifierCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return SearchModifierCode.MISSING;
            }
            if ("exact".equals(codeString)) {
                return SearchModifierCode.EXACT;
            }
            if ("contains".equals(codeString)) {
                return SearchModifierCode.CONTAINS;
            }
            if ("not".equals(codeString)) {
                return SearchModifierCode.NOT;
            }
            if ("text".equals(codeString)) {
                return SearchModifierCode.TEXT;
            }
            if ("in".equals(codeString)) {
                return SearchModifierCode.IN;
            }
            if ("not-in".equals(codeString)) {
                return SearchModifierCode.NOTIN;
            }
            if ("below".equals(codeString)) {
                return SearchModifierCode.BELOW;
            }
            if ("above".equals(codeString)) {
                return SearchModifierCode.ABOVE;
            }
            if (SearchParameter.SP_TYPE.equals(codeString)) {
                return SearchModifierCode.TYPE;
            }
            if ("identifier".equals(codeString)) {
                return SearchModifierCode.IDENTIFIER;
            }
            if ("ofType".equals(codeString)) {
                return SearchModifierCode.OFTYPE;
            }
            throw new IllegalArgumentException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        public Enumeration<SearchModifierCode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SearchModifierCode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.MISSING);
            }
            if ("exact".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.EXACT);
            }
            if ("contains".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.CONTAINS);
            }
            if ("not".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.NOT);
            }
            if ("text".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.TEXT);
            }
            if ("in".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.IN);
            }
            if ("not-in".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.NOTIN);
            }
            if ("below".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.BELOW);
            }
            if ("above".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.ABOVE);
            }
            if (SearchParameter.SP_TYPE.equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.TYPE);
            }
            if ("identifier".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.IDENTIFIER);
            }
            if ("ofType".equals(codeString)) {
                return new Enumeration<SearchModifierCode>(this, SearchModifierCode.OFTYPE);
            }
            throw new FHIRException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        @Override
        public String toCode(SearchModifierCode code) {
            if (code == SearchModifierCode.MISSING) {
                return "missing";
            }
            if (code == SearchModifierCode.EXACT) {
                return "exact";
            }
            if (code == SearchModifierCode.CONTAINS) {
                return "contains";
            }
            if (code == SearchModifierCode.NOT) {
                return "not";
            }
            if (code == SearchModifierCode.TEXT) {
                return "text";
            }
            if (code == SearchModifierCode.IN) {
                return "in";
            }
            if (code == SearchModifierCode.NOTIN) {
                return "not-in";
            }
            if (code == SearchModifierCode.BELOW) {
                return "below";
            }
            if (code == SearchModifierCode.ABOVE) {
                return "above";
            }
            if (code == SearchModifierCode.TYPE) {
                return SearchParameter.SP_TYPE;
            }
            if (code == SearchModifierCode.IDENTIFIER) {
                return "identifier";
            }
            if (code == SearchModifierCode.OFTYPE) {
                return "ofType";
            }
            return "?";
        }

        @Override
        public String toSystem(SearchModifierCode code) {
            return code.getSystem();
        }
    }

    public static enum SearchModifierCode {
        MISSING,
        EXACT,
        CONTAINS,
        NOT,
        TEXT,
        IN,
        NOTIN,
        BELOW,
        ABOVE,
        TYPE,
        IDENTIFIER,
        OFTYPE,
        NULL;


        public static SearchModifierCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("missing".equals(codeString)) {
                return MISSING;
            }
            if ("exact".equals(codeString)) {
                return EXACT;
            }
            if ("contains".equals(codeString)) {
                return CONTAINS;
            }
            if ("not".equals(codeString)) {
                return NOT;
            }
            if ("text".equals(codeString)) {
                return TEXT;
            }
            if ("in".equals(codeString)) {
                return IN;
            }
            if ("not-in".equals(codeString)) {
                return NOTIN;
            }
            if ("below".equals(codeString)) {
                return BELOW;
            }
            if ("above".equals(codeString)) {
                return ABOVE;
            }
            if (SearchParameter.SP_TYPE.equals(codeString)) {
                return TYPE;
            }
            if ("identifier".equals(codeString)) {
                return IDENTIFIER;
            }
            if ("ofType".equals(codeString)) {
                return OFTYPE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SearchModifierCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case MISSING: {
                    return "missing";
                }
                case EXACT: {
                    return "exact";
                }
                case CONTAINS: {
                    return "contains";
                }
                case NOT: {
                    return "not";
                }
                case TEXT: {
                    return "text";
                }
                case IN: {
                    return "in";
                }
                case NOTIN: {
                    return "not-in";
                }
                case BELOW: {
                    return "below";
                }
                case ABOVE: {
                    return "above";
                }
                case TYPE: {
                    return SearchParameter.SP_TYPE;
                }
                case IDENTIFIER: {
                    return "identifier";
                }
                case OFTYPE: {
                    return "ofType";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case MISSING: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case EXACT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case CONTAINS: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case NOT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case TEXT: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case IN: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case NOTIN: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case BELOW: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case ABOVE: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case TYPE: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case IDENTIFIER: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
                case OFTYPE: {
                    return "http://hl7.org/fhir/search-modifier-code";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case MISSING: {
                    return "The search parameter returns resources that have a value or not.";
                }
                case EXACT: {
                    return "The search parameter returns resources that have a value that exactly matches the supplied parameter (the whole string, including casing and accents).";
                }
                case CONTAINS: {
                    return "The search parameter returns resources that include the supplied parameter value anywhere within the field being searched.";
                }
                case NOT: {
                    return "The search parameter returns resources that do not contain a match.";
                }
                case TEXT: {
                    return "The search parameter is processed as a string that searches text associated with the code/value - either CodeableConcept.text, Coding.display, or Identifier.type.text.";
                }
                case IN: {
                    return "The search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the coding is in the specified value set.";
                }
                case NOTIN: {
                    return "The search parameter is a URI (relative or absolute) that identifies a value set, and the search parameter tests whether the coding is not in the specified value set.";
                }
                case BELOW: {
                    return "The search parameter tests whether the value in a resource is subsumed by the specified value (is-a, or hierarchical relationships).";
                }
                case ABOVE: {
                    return "The search parameter tests whether the value in a resource subsumes the specified value (is-a, or hierarchical relationships).";
                }
                case TYPE: {
                    return "The search parameter only applies to the Resource Type specified as a modifier (e.g. the modifier is not actually :type, but :Patient etc.).";
                }
                case IDENTIFIER: {
                    return "The search parameter applies to the identifier on the resource, not the reference.";
                }
                case OFTYPE: {
                    return "The search parameter has the format system|code|value, where the system and code refer to an Identifier.type.coding.system and .code, and match if any of the type codes match. All 3 parts must be present.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case MISSING: {
                    return "Missing";
                }
                case EXACT: {
                    return "Exact";
                }
                case CONTAINS: {
                    return "Contains";
                }
                case NOT: {
                    return "Not";
                }
                case TEXT: {
                    return "Text";
                }
                case IN: {
                    return "In";
                }
                case NOTIN: {
                    return "Not In";
                }
                case BELOW: {
                    return "Below";
                }
                case ABOVE: {
                    return "Above";
                }
                case TYPE: {
                    return "Type";
                }
                case IDENTIFIER: {
                    return "Identifier";
                }
                case OFTYPE: {
                    return "Of Type";
                }
            }
            return "?";
        }
    }

    public static class SearchComparatorEnumFactory
    implements EnumFactory<SearchComparator> {
        @Override
        public SearchComparator fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("eq".equals(codeString)) {
                return SearchComparator.EQ;
            }
            if ("ne".equals(codeString)) {
                return SearchComparator.NE;
            }
            if ("gt".equals(codeString)) {
                return SearchComparator.GT;
            }
            if ("lt".equals(codeString)) {
                return SearchComparator.LT;
            }
            if ("ge".equals(codeString)) {
                return SearchComparator.GE;
            }
            if ("le".equals(codeString)) {
                return SearchComparator.LE;
            }
            if ("sa".equals(codeString)) {
                return SearchComparator.SA;
            }
            if ("eb".equals(codeString)) {
                return SearchComparator.EB;
            }
            if ("ap".equals(codeString)) {
                return SearchComparator.AP;
            }
            throw new IllegalArgumentException("Unknown SearchComparator code '" + codeString + "'");
        }

        public Enumeration<SearchComparator> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<SearchComparator>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("eq".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.EQ);
            }
            if ("ne".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.NE);
            }
            if ("gt".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.GT);
            }
            if ("lt".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.LT);
            }
            if ("ge".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.GE);
            }
            if ("le".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.LE);
            }
            if ("sa".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.SA);
            }
            if ("eb".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.EB);
            }
            if ("ap".equals(codeString)) {
                return new Enumeration<SearchComparator>(this, SearchComparator.AP);
            }
            throw new FHIRException("Unknown SearchComparator code '" + codeString + "'");
        }

        @Override
        public String toCode(SearchComparator code) {
            if (code == SearchComparator.EQ) {
                return "eq";
            }
            if (code == SearchComparator.NE) {
                return "ne";
            }
            if (code == SearchComparator.GT) {
                return "gt";
            }
            if (code == SearchComparator.LT) {
                return "lt";
            }
            if (code == SearchComparator.GE) {
                return "ge";
            }
            if (code == SearchComparator.LE) {
                return "le";
            }
            if (code == SearchComparator.SA) {
                return "sa";
            }
            if (code == SearchComparator.EB) {
                return "eb";
            }
            if (code == SearchComparator.AP) {
                return "ap";
            }
            return "?";
        }

        @Override
        public String toSystem(SearchComparator code) {
            return code.getSystem();
        }
    }

    public static enum SearchComparator {
        EQ,
        NE,
        GT,
        LT,
        GE,
        LE,
        SA,
        EB,
        AP,
        NULL;


        public static SearchComparator fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("eq".equals(codeString)) {
                return EQ;
            }
            if ("ne".equals(codeString)) {
                return NE;
            }
            if ("gt".equals(codeString)) {
                return GT;
            }
            if ("lt".equals(codeString)) {
                return LT;
            }
            if ("ge".equals(codeString)) {
                return GE;
            }
            if ("le".equals(codeString)) {
                return LE;
            }
            if ("sa".equals(codeString)) {
                return SA;
            }
            if ("eb".equals(codeString)) {
                return EB;
            }
            if ("ap".equals(codeString)) {
                return AP;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown SearchComparator code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case EQ: {
                    return "eq";
                }
                case NE: {
                    return "ne";
                }
                case GT: {
                    return "gt";
                }
                case LT: {
                    return "lt";
                }
                case GE: {
                    return "ge";
                }
                case LE: {
                    return "le";
                }
                case SA: {
                    return "sa";
                }
                case EB: {
                    return "eb";
                }
                case AP: {
                    return "ap";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case EQ: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case NE: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case GT: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case LT: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case GE: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case LE: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case SA: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case EB: {
                    return "http://hl7.org/fhir/search-comparator";
                }
                case AP: {
                    return "http://hl7.org/fhir/search-comparator";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case EQ: {
                    return "the value for the parameter in the resource is equal to the provided value.";
                }
                case NE: {
                    return "the value for the parameter in the resource is not equal to the provided value.";
                }
                case GT: {
                    return "the value for the parameter in the resource is greater than the provided value.";
                }
                case LT: {
                    return "the value for the parameter in the resource is less than the provided value.";
                }
                case GE: {
                    return "the value for the parameter in the resource is greater or equal to the provided value.";
                }
                case LE: {
                    return "the value for the parameter in the resource is less or equal to the provided value.";
                }
                case SA: {
                    return "the value for the parameter in the resource starts after the provided value.";
                }
                case EB: {
                    return "the value for the parameter in the resource ends before the provided value.";
                }
                case AP: {
                    return "the value for the parameter in the resource is approximately the same to the provided value.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case EQ: {
                    return "Equals";
                }
                case NE: {
                    return "Not Equals";
                }
                case GT: {
                    return "Greater Than";
                }
                case LT: {
                    return "Less Than";
                }
                case GE: {
                    return "Greater or Equals";
                }
                case LE: {
                    return "Less of Equal";
                }
                case SA: {
                    return "Starts After";
                }
                case EB: {
                    return "Ends Before";
                }
                case AP: {
                    return "Approximately";
                }
            }
            return "?";
        }
    }
}

