/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="ManufacturedItemDefinition", profile="http://hl7.org/fhir/StructureDefinition/ManufacturedItemDefinition")
public class ManufacturedItemDefinition
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Unique identifier", formalDefinition="Unique identifier.")
    protected List<Identifier> identifier;
    @Child(name="manufacturedDoseForm", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product", formalDefinition="Dose form as manufactured and before any transformation into the pharmaceutical product.")
    protected CodeableConcept manufacturedDoseForm;
    @Child(name="unitOfPresentation", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The \u201creal world\u201d units in which the quantity of the manufactured item is described", formalDefinition="The \u201creal world\u201d units in which the quantity of the manufactured item is described.")
    protected CodeableConcept unitOfPresentation;
    @Child(name="manufacturer", type={Organization.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues)", formalDefinition="Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).")
    protected List<Reference> manufacturer;
    @Child(name="ingredient", type={CodeableReference.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The ingredients that make up this manufactured item", formalDefinition="The ingredients that make up this manufactured item.")
    protected List<CodeableReference> ingredient;
    @Child(name="property", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="General characteristics of this item", formalDefinition="General characteristics of this item.")
    protected List<ManufacturedItemDefinitionPropertyComponent> property;
    private static final long serialVersionUID = -863803904L;
    @SearchParamDefinition(name="dose-form", path="ManufacturedItemDefinition.manufacturedDoseForm", description="Dose form as manufactured and before any transformation into the pharmaceutical product", type="token")
    public static final String SP_DOSE_FORM = "dose-form";
    public static final TokenClientParam DOSE_FORM = new TokenClientParam("dose-form");
    @SearchParamDefinition(name="identifier", path="ManufacturedItemDefinition.identifier", description="Unique identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="ingredient", path="ManufacturedItemDefinition.ingredient.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_INGREDIENT = "ingredient";
    public static final ReferenceClientParam INGREDIENT = new ReferenceClientParam("ingredient");
    public static final Include INCLUDE_INGREDIENT = new Include("ManufacturedItemDefinition:ingredient").toLocked();
    @SearchParamDefinition(name="ingredient-code", path="ManufacturedItemDefinition.ingredient.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_INGREDIENT_CODE = "ingredient-code";
    public static final TokenClientParam INGREDIENT_CODE = new TokenClientParam("ingredient-code");

    public ManufacturedItemDefinition() {
    }

    public ManufacturedItemDefinition(CodeableConcept manufacturedDoseForm) {
        this.setManufacturedDoseForm(manufacturedDoseForm);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ManufacturedItemDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ManufacturedItemDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getManufacturedDoseForm() {
        if (this.manufacturedDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.manufacturedDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.manufacturedDoseForm = new CodeableConcept();
            }
        }
        return this.manufacturedDoseForm;
    }

    public boolean hasManufacturedDoseForm() {
        return this.manufacturedDoseForm != null && !this.manufacturedDoseForm.isEmpty();
    }

    public ManufacturedItemDefinition setManufacturedDoseForm(CodeableConcept value) {
        this.manufacturedDoseForm = value;
        return this;
    }

    public CodeableConcept getUnitOfPresentation() {
        if (this.unitOfPresentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ManufacturedItemDefinition.unitOfPresentation");
            }
            if (Configuration.doAutoCreate()) {
                this.unitOfPresentation = new CodeableConcept();
            }
        }
        return this.unitOfPresentation;
    }

    public boolean hasUnitOfPresentation() {
        return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
    }

    public ManufacturedItemDefinition setUnitOfPresentation(CodeableConcept value) {
        this.unitOfPresentation = value;
        return this;
    }

    public List<Reference> getManufacturer() {
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        return this.manufacturer;
    }

    public ManufacturedItemDefinition setManufacturer(List<Reference> theManufacturer) {
        this.manufacturer = theManufacturer;
        return this;
    }

    public boolean hasManufacturer() {
        if (this.manufacturer == null) {
            return false;
        }
        for (Reference item : this.manufacturer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addManufacturer() {
        Reference t = new Reference();
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return t;
    }

    public ManufacturedItemDefinition addManufacturer(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.manufacturer == null) {
            this.manufacturer = new ArrayList<Reference>();
        }
        this.manufacturer.add(t);
        return this;
    }

    public Reference getManufacturerFirstRep() {
        if (this.getManufacturer().isEmpty()) {
            this.addManufacturer();
        }
        return this.getManufacturer().get(0);
    }

    public List<CodeableReference> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableReference>();
        }
        return this.ingredient;
    }

    public ManufacturedItemDefinition setIngredient(List<CodeableReference> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (CodeableReference item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addIngredient() {
        CodeableReference t = new CodeableReference();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableReference>();
        }
        this.ingredient.add(t);
        return t;
    }

    public ManufacturedItemDefinition addIngredient(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<CodeableReference>();
        }
        this.ingredient.add(t);
        return this;
    }

    public CodeableReference getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    public List<ManufacturedItemDefinitionPropertyComponent> getProperty() {
        if (this.property == null) {
            this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
        }
        return this.property;
    }

    public ManufacturedItemDefinition setProperty(List<ManufacturedItemDefinitionPropertyComponent> theProperty) {
        this.property = theProperty;
        return this;
    }

    public boolean hasProperty() {
        if (this.property == null) {
            return false;
        }
        for (ManufacturedItemDefinitionPropertyComponent item : this.property) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ManufacturedItemDefinitionPropertyComponent addProperty() {
        ManufacturedItemDefinitionPropertyComponent t = new ManufacturedItemDefinitionPropertyComponent();
        if (this.property == null) {
            this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return t;
    }

    public ManufacturedItemDefinition addProperty(ManufacturedItemDefinitionPropertyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.property == null) {
            this.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
        }
        this.property.add(t);
        return this;
    }

    public ManufacturedItemDefinitionPropertyComponent getPropertyFirstRep() {
        if (this.getProperty().isEmpty()) {
            this.addProperty();
        }
        return this.getProperty().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm));
        children.add(new Property("unitOfPresentation", "CodeableConcept", "The \u201creal world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation));
        children.add(new Property("manufacturer", "Reference(Organization)", "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).", 0, Integer.MAX_VALUE, this.manufacturer));
        children.add(new Property(SP_INGREDIENT, "CodeableReference(Ingredient)", "The ingredients that make up this manufactured item.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Unique identifier.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1451400348: {
                return new Property("manufacturedDoseForm", "CodeableConcept", "Dose form as manufactured and before any transformation into the pharmaceutical product.", 0, 1, this.manufacturedDoseForm);
            }
            case -1427765963: {
                return new Property("unitOfPresentation", "CodeableConcept", "The \u201creal world\u201d units in which the quantity of the manufactured item is described.", 0, 1, this.unitOfPresentation);
            }
            case -1969347631: {
                return new Property("manufacturer", "Reference(Organization)", "Manufacturer of the item (Note that this should be named \"manufacturer\" but it currently causes technical issues).", 0, Integer.MAX_VALUE, this.manufacturer);
            }
            case -206409263: {
                return new Property(SP_INGREDIENT, "CodeableReference(Ingredient)", "The ingredients that make up this manufactured item.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -993141291: {
                return new Property("property", "", "General characteristics of this item.", 0, Integer.MAX_VALUE, this.property);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1451400348: {
                Base[] baseArray;
                if (this.manufacturedDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.manufacturedDoseForm;
                }
                return baseArray;
            }
            case -1427765963: {
                Base[] baseArray;
                if (this.unitOfPresentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.unitOfPresentation;
                }
                return baseArray;
            }
            case -1969347631: {
                return this.manufacturer == null ? new Base[]{} : this.manufacturer.toArray(new Base[this.manufacturer.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -993141291: {
                return this.property == null ? new Base[]{} : this.property.toArray(new Base[this.property.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1451400348: {
                this.manufacturedDoseForm = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1427765963: {
                this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1969347631: {
                this.getManufacturer().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case -993141291: {
                this.getProperty().add((ManufacturedItemDefinitionPropertyComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals("manufacturedDoseForm")) {
            this.manufacturedDoseForm = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("manufacturer")) {
            this.getManufacturer().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_INGREDIENT)) {
            this.getIngredient().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals("property")) {
            this.getProperty().add((ManufacturedItemDefinitionPropertyComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1451400348: {
                return this.getManufacturedDoseForm();
            }
            case -1427765963: {
                return this.getUnitOfPresentation();
            }
            case -1969347631: {
                return this.addManufacturer();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -993141291: {
                return this.addProperty();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1451400348: {
                return new String[]{"CodeableConcept"};
            }
            case -1427765963: {
                return new String[]{"CodeableConcept"};
            }
            case -1969347631: {
                return new String[]{"Reference"};
            }
            case -206409263: {
                return new String[]{"CodeableReference"};
            }
            case -993141291: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("manufacturedDoseForm")) {
            this.manufacturedDoseForm = new CodeableConcept();
            return this.manufacturedDoseForm;
        }
        if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = new CodeableConcept();
            return this.unitOfPresentation;
        }
        if (name.equals("manufacturer")) {
            return this.addManufacturer();
        }
        if (name.equals(SP_INGREDIENT)) {
            return this.addIngredient();
        }
        if (name.equals("property")) {
            return this.addProperty();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ManufacturedItemDefinition";
    }

    @Override
    public ManufacturedItemDefinition copy() {
        ManufacturedItemDefinition dst = new ManufacturedItemDefinition();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(ManufacturedItemDefinition dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.manufacturedDoseForm = this.manufacturedDoseForm == null ? null : this.manufacturedDoseForm.copy();
        CodeableConcept codeableConcept = dst.unitOfPresentation = this.unitOfPresentation == null ? null : this.unitOfPresentation.copy();
        if (this.manufacturer != null) {
            dst.manufacturer = new ArrayList<Reference>();
            for (Reference reference : this.manufacturer) {
                dst.manufacturer.add(reference.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.ingredient) {
                dst.ingredient.add(codeableReference.copy());
            }
        }
        if (this.property != null) {
            dst.property = new ArrayList<ManufacturedItemDefinitionPropertyComponent>();
            for (ManufacturedItemDefinitionPropertyComponent manufacturedItemDefinitionPropertyComponent : this.property) {
                dst.property.add(manufacturedItemDefinitionPropertyComponent.copy());
            }
        }
    }

    protected ManufacturedItemDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ManufacturedItemDefinition)) {
            return false;
        }
        ManufacturedItemDefinition o = (ManufacturedItemDefinition)other_;
        return ManufacturedItemDefinition.compareDeep(this.identifier, o.identifier, true) && ManufacturedItemDefinition.compareDeep(this.manufacturedDoseForm, o.manufacturedDoseForm, true) && ManufacturedItemDefinition.compareDeep(this.unitOfPresentation, o.unitOfPresentation, true) && ManufacturedItemDefinition.compareDeep(this.manufacturer, o.manufacturer, true) && ManufacturedItemDefinition.compareDeep(this.ingredient, o.ingredient, true) && ManufacturedItemDefinition.compareDeep(this.property, o.property, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ManufacturedItemDefinition)) {
            return false;
        }
        ManufacturedItemDefinition o = (ManufacturedItemDefinition)other_;
        return true;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.manufacturedDoseForm, this.unitOfPresentation, this.manufacturer, this.ingredient, this.property);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ManufacturedItemDefinition;
    }

    @Block
    public static class ManufacturedItemDefinitionPropertyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A code expressing the type of characteristic", formalDefinition="A code expressing the type of characteristic.")
        protected CodeableConcept type;
        @Child(name="value", type={CodeableConcept.class, Quantity.class, DateType.class, BooleanType.class, Attachment.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A value for the characteristic", formalDefinition="A value for the characteristic.")
        protected DataType value;
        private static final long serialVersionUID = -1659186716L;

        public ManufacturedItemDefinitionPropertyComponent() {
        }

        public ManufacturedItemDefinitionPropertyComponent(CodeableConcept type) {
            this.setType(type);
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ManufacturedItemDefinitionPropertyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ManufacturedItemDefinitionPropertyComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public DataType getValue() {
            return this.value;
        }

        public CodeableConcept getValueCodeableConcept() throws FHIRException {
            if (this.value == null) {
                this.value = new CodeableConcept();
            }
            if (!(this.value instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.value;
        }

        public boolean hasValueCodeableConcept() {
            return this != null && this.value instanceof CodeableConcept;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (this.value == null) {
                this.value = new Quantity();
            }
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this != null && this.value instanceof Quantity;
        }

        public DateType getValueDateType() throws FHIRException {
            if (this.value == null) {
                this.value = new DateType();
            }
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this != null && this.value instanceof DateType;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (this.value == null) {
                this.value = new BooleanType();
            }
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this != null && this.value instanceof BooleanType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (this.value == null) {
                this.value = new Attachment();
            }
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this != null && this.value instanceof Attachment;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ManufacturedItemDefinitionPropertyComponent setValue(DataType value) {
            if (!(value == null || value instanceof CodeableConcept || value instanceof Quantity || value instanceof DateType || value instanceof BooleanType || value instanceof Attachment)) {
                throw new Error("Not the right type for ManufacturedItemDefinition.property.value[x]: " + value.fhirType());
            }
            this.value = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type));
            children.add(new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "CodeableConcept", "A code expressing the type of characteristic.", 0, 1, this.type);
                }
                case -1410166417: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 111972721: {
                    return new Property("value[x]", "CodeableConcept|Quantity|date|boolean|Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
                case 924902896: {
                    return new Property("value[x]", "CodeableConcept", "A value for the characteristic.", 0, 1, this.value);
                }
                case -2029823716: {
                    return new Property("value[x]", "Quantity", "A value for the characteristic.", 0, 1, this.value);
                }
                case -766192449: {
                    return new Property("value[x]", "date", "A value for the characteristic.", 0, 1, this.value);
                }
                case 733421943: {
                    return new Property("value[x]", "boolean", "A value for the characteristic.", 0, 1, this.value);
                }
                case -475566732: {
                    return new Property("value[x]", "Attachment", "A value for the characteristic.", 0, 1, this.value);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 111972721: {
                    Base[] baseArray;
                    if (this.value == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.value;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 111972721: {
                    this.value = TypeConvertor.castToType(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("value[x]")) {
                this.value = TypeConvertor.castToType(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getType();
                }
                case -1410166417: {
                    return this.getValue();
                }
                case 111972721: {
                    return this.getValue();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case 111972721: {
                    return new String[]{"CodeableConcept", "Quantity", "date", "boolean", "Attachment"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("valueCodeableConcept")) {
                this.value = new CodeableConcept();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            return super.addChild(name);
        }

        @Override
        public ManufacturedItemDefinitionPropertyComponent copy() {
            ManufacturedItemDefinitionPropertyComponent dst = new ManufacturedItemDefinitionPropertyComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ManufacturedItemDefinitionPropertyComponent dst) {
            super.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.value = this.value == null ? null : this.value.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionPropertyComponent)) {
                return false;
            }
            ManufacturedItemDefinitionPropertyComponent o = (ManufacturedItemDefinitionPropertyComponent)other_;
            return ManufacturedItemDefinitionPropertyComponent.compareDeep(this.type, o.type, true) && ManufacturedItemDefinitionPropertyComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ManufacturedItemDefinitionPropertyComponent)) {
                return false;
            }
            ManufacturedItemDefinitionPropertyComponent o = (ManufacturedItemDefinitionPropertyComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.value);
        }

        @Override
        public String fhirType() {
            return "ManufacturedItemDefinition.property";
        }
    }
}

