/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.QuantityClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Account;
import org.hl7.fhir.r5.model.ActivityDefinition;
import org.hl7.fhir.r5.model.AdministrableProductDefinition;
import org.hl7.fhir.r5.model.AdverseEvent;
import org.hl7.fhir.r5.model.AllergyIntolerance;
import org.hl7.fhir.r5.model.Appointment;
import org.hl7.fhir.r5.model.AppointmentResponse;
import org.hl7.fhir.r5.model.AuditEvent;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Basic;
import org.hl7.fhir.r5.model.Binary;
import org.hl7.fhir.r5.model.BiologicallyDerivedProduct;
import org.hl7.fhir.r5.model.BodyStructure;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CapabilityStatement2;
import org.hl7.fhir.r5.model.CarePlan;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CatalogEntry;
import org.hl7.fhir.r5.model.ChargeItem;
import org.hl7.fhir.r5.model.ChargeItemDefinition;
import org.hl7.fhir.r5.model.Citation;
import org.hl7.fhir.r5.model.Claim;
import org.hl7.fhir.r5.model.ClaimResponse;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.ClinicalUseIssue;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.Communication;
import org.hl7.fhir.r5.model.CommunicationRequest;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.Composition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.Condition;
import org.hl7.fhir.r5.model.ConditionDefinition;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.Consent;
import org.hl7.fhir.r5.model.Contract;
import org.hl7.fhir.r5.model.Coverage;
import org.hl7.fhir.r5.model.CoverageEligibilityRequest;
import org.hl7.fhir.r5.model.CoverageEligibilityResponse;
import org.hl7.fhir.r5.model.DetectedIssue;
import org.hl7.fhir.r5.model.Device;
import org.hl7.fhir.r5.model.DeviceDefinition;
import org.hl7.fhir.r5.model.DeviceMetric;
import org.hl7.fhir.r5.model.DeviceRequest;
import org.hl7.fhir.r5.model.DeviceUsage;
import org.hl7.fhir.r5.model.DiagnosticReport;
import org.hl7.fhir.r5.model.DocumentManifest;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Duration;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.EnrollmentRequest;
import org.hl7.fhir.r5.model.EnrollmentResponse;
import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.EpisodeOfCare;
import org.hl7.fhir.r5.model.EventDefinition;
import org.hl7.fhir.r5.model.Evidence;
import org.hl7.fhir.r5.model.EvidenceReport;
import org.hl7.fhir.r5.model.EvidenceVariable;
import org.hl7.fhir.r5.model.ExampleScenario;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.FamilyMemberHistory;
import org.hl7.fhir.r5.model.Flag;
import org.hl7.fhir.r5.model.Goal;
import org.hl7.fhir.r5.model.GraphDefinition;
import org.hl7.fhir.r5.model.Group;
import org.hl7.fhir.r5.model.GuidanceResponse;
import org.hl7.fhir.r5.model.HealthcareService;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImagingStudy;
import org.hl7.fhir.r5.model.Immunization;
import org.hl7.fhir.r5.model.ImmunizationEvaluation;
import org.hl7.fhir.r5.model.ImmunizationRecommendation;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Ingredient;
import org.hl7.fhir.r5.model.InsurancePlan;
import org.hl7.fhir.r5.model.InventoryReport;
import org.hl7.fhir.r5.model.Invoice;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Linkage;
import org.hl7.fhir.r5.model.ListResource;
import org.hl7.fhir.r5.model.Location;
import org.hl7.fhir.r5.model.ManufacturedItemDefinition;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.MeasureReport;
import org.hl7.fhir.r5.model.Medication;
import org.hl7.fhir.r5.model.MedicationAdministration;
import org.hl7.fhir.r5.model.MedicationDispense;
import org.hl7.fhir.r5.model.MedicationKnowledge;
import org.hl7.fhir.r5.model.MedicationRequest;
import org.hl7.fhir.r5.model.MedicationUsage;
import org.hl7.fhir.r5.model.MedicinalProductDefinition;
import org.hl7.fhir.r5.model.MessageDefinition;
import org.hl7.fhir.r5.model.MessageHeader;
import org.hl7.fhir.r5.model.MolecularSequence;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.NutritionIntake;
import org.hl7.fhir.r5.model.NutritionOrder;
import org.hl7.fhir.r5.model.NutritionProduct;
import org.hl7.fhir.r5.model.Observation;
import org.hl7.fhir.r5.model.ObservationDefinition;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Organization;
import org.hl7.fhir.r5.model.OrganizationAffiliation;
import org.hl7.fhir.r5.model.PackagedProductDefinition;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.PaymentNotice;
import org.hl7.fhir.r5.model.PaymentReconciliation;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Permission;
import org.hl7.fhir.r5.model.Person;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PositiveIntType;
import org.hl7.fhir.r5.model.Practitioner;
import org.hl7.fhir.r5.model.PractitionerRole;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Procedure;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Provenance;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.QuestionnaireResponse;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.RegulatedAuthorization;
import org.hl7.fhir.r5.model.RelatedPerson;
import org.hl7.fhir.r5.model.RequestGroup;
import org.hl7.fhir.r5.model.ResearchStudy;
import org.hl7.fhir.r5.model.ResearchSubject;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.RiskAssessment;
import org.hl7.fhir.r5.model.Schedule;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.ServiceRequest;
import org.hl7.fhir.r5.model.Slot;
import org.hl7.fhir.r5.model.Specimen;
import org.hl7.fhir.r5.model.SpecimenDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.Subscription;
import org.hl7.fhir.r5.model.SubscriptionStatus;
import org.hl7.fhir.r5.model.SubscriptionTopic;
import org.hl7.fhir.r5.model.Substance;
import org.hl7.fhir.r5.model.SubstanceDefinition;
import org.hl7.fhir.r5.model.SubstanceNucleicAcid;
import org.hl7.fhir.r5.model.SubstancePolymer;
import org.hl7.fhir.r5.model.SubstanceProtein;
import org.hl7.fhir.r5.model.SubstanceReferenceInformation;
import org.hl7.fhir.r5.model.SubstanceSourceMaterial;
import org.hl7.fhir.r5.model.SupplyDelivery;
import org.hl7.fhir.r5.model.SupplyRequest;
import org.hl7.fhir.r5.model.Task;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.TestReport;
import org.hl7.fhir.r5.model.TestScript;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.model.VerificationResult;
import org.hl7.fhir.r5.model.VisionPrescription;

@ResourceDef(name="Encounter", profile="http://hl7.org/fhir/StructureDefinition/Encounter")
public class Encounter
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier(s) by which this encounter is known", formalDefinition="Identifier(s) by which this encounter is known.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown", formalDefinition="planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-status")
    protected Enumeration<EncounterStatus> status;
    @Child(name="statusHistory", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of past encounter statuses", formalDefinition="The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.")
    protected List<StatusHistoryComponent> statusHistory;
    @Child(name="class", type={Coding.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of patient encounter", formalDefinition="Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActEncounterCode")
    protected Coding class_;
    @Child(name="classHistory", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of past encounter classes", formalDefinition="The class history permits the tracking of the encounters transitions without needing to go  through the resource history.  This would be used for a case where an admission starts of as an emergency encounter, then transitions into an inpatient scenario. Doing this and not restarting a new encounter ensures that any lab/diagnostic results can more easily follow the patient and not require re-processing and not get lost or cancelled during a kind of discharge from emergency to inpatient.")
    protected List<ClassHistoryComponent> classHistory;
    @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of encounter", formalDefinition="Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-type")
    protected List<CodeableConcept> type;
    @Child(name="serviceType", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of service", formalDefinition="Broad categorization of the service that is to be provided (e.g. cardiology).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/service-type")
    protected CodeableConcept serviceType;
    @Child(name="priority", type={CodeableConcept.class}, order=7, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates the urgency of the encounter", formalDefinition="Indicates the urgency of the encounter.")
    @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActPriority")
    protected CodeableConcept priority;
    @Child(name="subject", type={Patient.class, Group.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient or group present at the encounter", formalDefinition="The patient or group present at the encounter.")
    protected Reference subject;
    @Child(name="subjectStatus", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The current status of the subject in relation to the Encounter", formalDefinition="The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-subject-status")
    protected CodeableConcept subjectStatus;
    @Child(name="episodeOfCare", type={EpisodeOfCare.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Episode(s) of care that this encounter should be recorded against", formalDefinition="Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).")
    protected List<Reference> episodeOfCare;
    @Child(name="basedOn", type={ServiceRequest.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The ServiceRequest that initiated this encounter", formalDefinition="The request this encounter satisfies (e.g. incoming referral or procedure request).")
    protected List<Reference> basedOn;
    @Child(name="participant", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="List of participants involved in the encounter", formalDefinition="The list of people responsible for providing the service.")
    protected List<EncounterParticipantComponent> participant;
    @Child(name="appointment", type={Appointment.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The appointment that scheduled this encounter", formalDefinition="The appointment that scheduled this encounter.")
    protected List<Reference> appointment;
    @Child(name="period", type={Period.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The start and end time of the encounter", formalDefinition="The start and end time of the encounter.")
    protected Period period;
    @Child(name="length", type={Duration.class}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Quantity of time the encounter lasted (less time absent)", formalDefinition="Quantity of time the encounter lasted. This excludes the time during leaves of absence.")
    protected Duration length;
    @Child(name="reason", type={CodeableReference.class}, order=16, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason the encounter takes place (core or reference)", formalDefinition="Reason the encounter takes place, expressed as a code or a reference to another resource. For admissions, this can be used for a coded admission diagnosis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-reason")
    protected List<CodeableReference> reason;
    @Child(name="diagnosis", type={}, order=17, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of diagnosis relevant to this encounter", formalDefinition="The list of diagnosis relevant to this encounter.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="account", type={Account.class}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The set of accounts that may be used for billing for this Encounter", formalDefinition="The set of accounts that may be used for billing for this Encounter.")
    protected List<Reference> account;
    @Child(name="hospitalization", type={}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about the admission to a healthcare service", formalDefinition="Details about the admission to a healthcare service.")
    protected EncounterHospitalizationComponent hospitalization;
    @Child(name="location", type={}, order=20, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of locations where the patient has been", formalDefinition="List of locations where  the patient has been during this encounter.")
    protected List<EncounterLocationComponent> location;
    @Child(name="serviceProvider", type={Organization.class}, order=21, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The organization (facility) responsible for this encounter", formalDefinition="The organization that is primarily responsible for this Encounter's services. This MAY be the same as the organization on the Patient record, however it could be different, such as if the actor performing the services was from an external organization (which may be billed seperately) for an external consultation.  Refer to the example bundle showing an abbreviated set of Encounters for a colonoscopy.")
    protected Reference serviceProvider;
    @Child(name="partOf", type={Encounter.class}, order=22, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Another Encounter this encounter is part of", formalDefinition="Another Encounter of which this encounter is a part of (administratively or in time).")
    protected Reference partOf;
    private static final long serialVersionUID = 62426777L;
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate | CarePlan.period | ClinicalImpression.date | Composition.date | Consent.dateTime | DiagnosticReport.effective | Encounter.period | EpisodeOfCare.period | FamilyMemberHistory.date | Flag.period | (Immunization.occurrence as dateTime) | List.date | Observation.effective | Procedure.occurrence | (RiskAssessment.occurrence as dateTime) | SupplyRequest.authoredOn", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Date first version of the resource instance was recorded\r\n* [CarePlan](careplan.html): Time period plan covers\r\n* [CareTeam](careteam.html): A date within the coverage time period.\r\n* [ClinicalImpression](clinicalimpression.html): When the assessment was documented\r\n* [Composition](composition.html): Composition editing time\r\n* [Consent](consent.html): When consent was agreed to\r\n* [DiagnosticReport](diagnosticreport.html): The clinically relevant time of the report\r\n* [Encounter](encounter.html): A date within the period the Encounter lasted\r\n* [EpisodeOfCare](episodeofcare.html): The provided date search value falls within the episode of care's period\r\n* [FamilyMemberHistory](familymemberhistory.html): When history was recorded or last updated\r\n* [Flag](flag.html): Time period when flag is active\r\n* [Immunization](immunization.html): Vaccination  (non)-Administration Date\r\n* [List](list.html): When the list was prepared\r\n* [Observation](observation.html): Obtained date/time. If the obtained element is a period, a date that falls in the period\r\n* [Procedure](procedure.html): When the procedure occurred or is occurring\r\n* [RiskAssessment](riskassessment.html): When was assessment made?\r\n* [SupplyRequest](supplyrequest.html): When the request was made\r\n", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="AllergyIntolerance.identifier | CarePlan.identifier | CareTeam.identifier | Composition.identifier | Condition.identifier | Consent.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DiagnosticReport.identifier | DocumentManifest.masterIdentifier | DocumentManifest.identifier | DocumentReference.content.identifier | DocumentReference.identifier | Encounter.identifier | EpisodeOfCare.identifier | FamilyMemberHistory.identifier | Goal.identifier | ImagingStudy.identifier | Immunization.identifier | List.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationUsage.identifier | NutritionOrder.identifier | Observation.identifier | Procedure.identifier | RiskAssessment.identifier | ServiceRequest.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentManifest](documentmanifest.html): Unique Identifier for the set of documents\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [List](list.html): Business identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationUsage](medicationusage.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="AllergyIntolerance.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ClinicalImpression.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | DetectedIssue.patient | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.subject | DiagnosticReport.subject.where(resolve() is Patient) | DocumentManifest.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EpisodeOfCare.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | List.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationUsage.subject.where(resolve() is Patient) | NutritionOrder.patient | Observation.subject.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | SupplyDelivery.patient | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ClinicalImpression](clinicalimpression.html): Patient or group assessed\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by subject - a patient\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentManifest](documentmanifest.html): The subject of the set of documents\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient or group present at the encounter\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [List](list.html): If all resources have the same subject\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationUsage](medicationusage.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the person who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Account.class, ActivityDefinition.class, AdministrableProductDefinition.class, AdverseEvent.class, AllergyIntolerance.class, Appointment.class, AppointmentResponse.class, AuditEvent.class, Basic.class, Binary.class, BiologicallyDerivedProduct.class, BodyStructure.class, Bundle.class, CapabilityStatement.class, CapabilityStatement2.class, CarePlan.class, CareTeam.class, CatalogEntry.class, ChargeItem.class, ChargeItemDefinition.class, Citation.class, Claim.class, ClaimResponse.class, ClinicalImpression.class, ClinicalUseIssue.class, CodeSystem.class, Communication.class, CommunicationRequest.class, CompartmentDefinition.class, Composition.class, ConceptMap.class, Condition.class, ConditionDefinition.class, Consent.class, Contract.class, Coverage.class, CoverageEligibilityRequest.class, CoverageEligibilityResponse.class, DetectedIssue.class, Device.class, DeviceDefinition.class, DeviceMetric.class, DeviceRequest.class, DeviceUsage.class, DiagnosticReport.class, DocumentManifest.class, DocumentReference.class, Encounter.class, Endpoint.class, EnrollmentRequest.class, EnrollmentResponse.class, EpisodeOfCare.class, EventDefinition.class, Evidence.class, EvidenceReport.class, EvidenceVariable.class, ExampleScenario.class, ExplanationOfBenefit.class, FamilyMemberHistory.class, Flag.class, Goal.class, GraphDefinition.class, Group.class, GuidanceResponse.class, HealthcareService.class, ImagingStudy.class, Immunization.class, ImmunizationEvaluation.class, ImmunizationRecommendation.class, ImplementationGuide.class, Ingredient.class, InsurancePlan.class, InventoryReport.class, Invoice.class, Library.class, Linkage.class, ListResource.class, Location.class, ManufacturedItemDefinition.class, Measure.class, MeasureReport.class, Medication.class, MedicationAdministration.class, MedicationDispense.class, MedicationKnowledge.class, MedicationRequest.class, MedicationUsage.class, MedicinalProductDefinition.class, MessageDefinition.class, MessageHeader.class, MolecularSequence.class, NamingSystem.class, NutritionIntake.class, NutritionOrder.class, NutritionProduct.class, Observation.class, ObservationDefinition.class, OperationDefinition.class, OperationOutcome.class, Organization.class, OrganizationAffiliation.class, PackagedProductDefinition.class, Patient.class, PaymentNotice.class, PaymentReconciliation.class, Permission.class, Person.class, PlanDefinition.class, Practitioner.class, PractitionerRole.class, Procedure.class, Provenance.class, Questionnaire.class, QuestionnaireResponse.class, RegulatedAuthorization.class, RelatedPerson.class, RequestGroup.class, ResearchStudy.class, ResearchSubject.class, RiskAssessment.class, Schedule.class, SearchParameter.class, ServiceRequest.class, Slot.class, Specimen.class, SpecimenDefinition.class, StructureDefinition.class, StructureMap.class, Subscription.class, SubscriptionStatus.class, SubscriptionTopic.class, Substance.class, SubstanceDefinition.class, SubstanceNucleicAcid.class, SubstancePolymer.class, SubstanceProtein.class, SubstanceReferenceInformation.class, SubstanceSourceMaterial.class, SupplyDelivery.class, SupplyRequest.class, Task.class, TerminologyCapabilities.class, TestReport.class, TestScript.class, ValueSet.class, VerificationResult.class, VisionPrescription.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Encounter:patient").toLocked();
    @SearchParamDefinition(name="type", path="AllergyIntolerance.type | Composition.type | DocumentManifest.type | DocumentReference.type | Encounter.type | EpisodeOfCare.type", description="Multiple Resources: \r\n\r\n* [AllergyIntolerance](allergyintolerance.html): allergy | intolerance - Underlying mechanism (if known)\r\n* [Composition](composition.html): Kind of composition (LOINC if possible)\r\n* [DocumentManifest](documentmanifest.html): Kind of document set\r\n* [DocumentReference](documentreference.html): Kind of document (LOINC if possible)\r\n* [Encounter](encounter.html): Specific type of encounter\r\n* [EpisodeOfCare](episodeofcare.html): Type/class  - e.g. specialist referral, disease management\r\n", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="account", path="Encounter.account", description="The set of accounts that may be used for billing for this Encounter", type="reference", target={Account.class})
    public static final String SP_ACCOUNT = "account";
    public static final ReferenceClientParam ACCOUNT = new ReferenceClientParam("account");
    public static final Include INCLUDE_ACCOUNT = new Include("Encounter:account").toLocked();
    @SearchParamDefinition(name="appointment", path="Encounter.appointment", description="The appointment that scheduled this encounter", type="reference", target={Appointment.class})
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    public static final Include INCLUDE_APPOINTMENT = new Include("Encounter:appointment").toLocked();
    @SearchParamDefinition(name="based-on", path="Encounter.basedOn", description="The ServiceRequest that initiated this encounter", type="reference", target={ServiceRequest.class})
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("Encounter:based-on").toLocked();
    @SearchParamDefinition(name="class", path="Encounter.class", description="Classification of patient encounter", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="diagnosis", path="Encounter.diagnosis.condition", description="The diagnosis or procedure relevant to the encounter", type="reference", target={Condition.class, Procedure.class})
    public static final String SP_DIAGNOSIS = "diagnosis";
    public static final ReferenceClientParam DIAGNOSIS = new ReferenceClientParam("diagnosis");
    public static final Include INCLUDE_DIAGNOSIS = new Include("Encounter:diagnosis").toLocked();
    @SearchParamDefinition(name="episode-of-care", path="Encounter.episodeOfCare", description="Episode(s) of care that this encounter should be recorded against", type="reference", target={EpisodeOfCare.class})
    public static final String SP_EPISODE_OF_CARE = "episode-of-care";
    public static final ReferenceClientParam EPISODE_OF_CARE = new ReferenceClientParam("episode-of-care");
    public static final Include INCLUDE_EPISODE_OF_CARE = new Include("Encounter:episode-of-care").toLocked();
    @SearchParamDefinition(name="length", path="Encounter.length", description="Length of encounter in days", type="quantity")
    public static final String SP_LENGTH = "length";
    public static final QuantityClientParam LENGTH = new QuantityClientParam("length");
    @SearchParamDefinition(name="location", path="Encounter.location.location", description="Location the encounter takes place", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Encounter:location").toLocked();
    @SearchParamDefinition(name="location-period", path="Encounter.location.period", description="Time period during which the patient was present at the location", type="date")
    public static final String SP_LOCATION_PERIOD = "location-period";
    public static final DateClientParam LOCATION_PERIOD = new DateClientParam("location-period");
    @SearchParamDefinition(name="part-of", path="Encounter.partOf", description="Another Encounter this encounter is part of", type="reference", target={Encounter.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Encounter:part-of").toLocked();
    @SearchParamDefinition(name="participant", path="Encounter.participant.individual", description="Persons involved in the encounter other than the patient", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner"), @Compartment(name="Base FHIR compartment definition for RelatedPerson")}, target={Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("Encounter:participant").toLocked();
    @SearchParamDefinition(name="participant-type", path="Encounter.participant.type", description="Role of participant in encounter", type="token")
    public static final String SP_PARTICIPANT_TYPE = "participant-type";
    public static final TokenClientParam PARTICIPANT_TYPE = new TokenClientParam("participant-type");
    @SearchParamDefinition(name="practitioner", path="Encounter.participant.individual.where(resolve() is Practitioner)", description="Persons involved in the encounter other than the patient", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Practitioner")}, target={Practitioner.class, PractitionerRole.class, RelatedPerson.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("Encounter:practitioner").toLocked();
    @SearchParamDefinition(name="reason-code", path="Encounter.reason.concept", description="Reference to a concept (by class)", type="token")
    public static final String SP_REASON_CODE = "reason-code";
    public static final TokenClientParam REASON_CODE = new TokenClientParam("reason-code");
    @SearchParamDefinition(name="reason-reference", path="Encounter.reason.reference", description="Reference to a resource (by instance)", type="reference")
    public static final String SP_REASON_REFERENCE = "reason-reference";
    public static final ReferenceClientParam REASON_REFERENCE = new ReferenceClientParam("reason-reference");
    public static final Include INCLUDE_REASON_REFERENCE = new Include("Encounter:reason-reference").toLocked();
    @SearchParamDefinition(name="service-provider", path="Encounter.serviceProvider", description="The organization (facility) responsible for this encounter", type="reference", target={Organization.class})
    public static final String SP_SERVICE_PROVIDER = "service-provider";
    public static final ReferenceClientParam SERVICE_PROVIDER = new ReferenceClientParam("service-provider");
    public static final Include INCLUDE_SERVICE_PROVIDER = new Include("Encounter:service-provider").toLocked();
    @SearchParamDefinition(name="special-arrangement", path="Encounter.hospitalization.specialArrangement", description="Wheelchair, translator, stretcher, etc.", type="token")
    public static final String SP_SPECIAL_ARRANGEMENT = "special-arrangement";
    public static final TokenClientParam SPECIAL_ARRANGEMENT = new TokenClientParam("special-arrangement");
    @SearchParamDefinition(name="status", path="Encounter.status", description="planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="Encounter.subject", description="The patient or group present at the encounter", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Encounter:subject").toLocked();
    @SearchParamDefinition(name="subject-status", path="Encounter.subjectStatus", description="The current status of the subject in relation to the Encounter", type="token")
    public static final String SP_SUBJECT_STATUS = "subject-status";
    public static final TokenClientParam SUBJECT_STATUS = new TokenClientParam("subject-status");

    public Encounter() {
    }

    public Encounter(EncounterStatus status, Coding class_) {
        this.setStatus(status);
        this.setClass_(class_);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Encounter setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Encounter addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EncounterStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EncounterStatus>(new EncounterStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Encounter setStatusElement(Enumeration<EncounterStatus> value) {
        this.status = value;
        return this;
    }

    public EncounterStatus getStatus() {
        return this.status == null ? null : (EncounterStatus)((Object)this.status.getValue());
    }

    public Encounter setStatus(EncounterStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<EncounterStatus>(new EncounterStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<StatusHistoryComponent> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<StatusHistoryComponent>();
        }
        return this.statusHistory;
    }

    public Encounter setStatusHistory(List<StatusHistoryComponent> theStatusHistory) {
        this.statusHistory = theStatusHistory;
        return this;
    }

    public boolean hasStatusHistory() {
        if (this.statusHistory == null) {
            return false;
        }
        for (StatusHistoryComponent item : this.statusHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StatusHistoryComponent addStatusHistory() {
        StatusHistoryComponent t = new StatusHistoryComponent();
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<StatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return t;
    }

    public Encounter addStatusHistory(StatusHistoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<StatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return this;
    }

    public StatusHistoryComponent getStatusHistoryFirstRep() {
        if (this.getStatusHistory().isEmpty()) {
            this.addStatusHistory();
        }
        return this.getStatusHistory().get(0);
    }

    public Coding getClass_() {
        if (this.class_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.class_");
            }
            if (Configuration.doAutoCreate()) {
                this.class_ = new Coding();
            }
        }
        return this.class_;
    }

    public boolean hasClass_() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public Encounter setClass_(Coding value) {
        this.class_ = value;
        return this;
    }

    public List<ClassHistoryComponent> getClassHistory() {
        if (this.classHistory == null) {
            this.classHistory = new ArrayList<ClassHistoryComponent>();
        }
        return this.classHistory;
    }

    public Encounter setClassHistory(List<ClassHistoryComponent> theClassHistory) {
        this.classHistory = theClassHistory;
        return this;
    }

    public boolean hasClassHistory() {
        if (this.classHistory == null) {
            return false;
        }
        for (ClassHistoryComponent item : this.classHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClassHistoryComponent addClassHistory() {
        ClassHistoryComponent t = new ClassHistoryComponent();
        if (this.classHistory == null) {
            this.classHistory = new ArrayList<ClassHistoryComponent>();
        }
        this.classHistory.add(t);
        return t;
    }

    public Encounter addClassHistory(ClassHistoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.classHistory == null) {
            this.classHistory = new ArrayList<ClassHistoryComponent>();
        }
        this.classHistory.add(t);
        return this;
    }

    public ClassHistoryComponent getClassHistoryFirstRep() {
        if (this.getClassHistory().isEmpty()) {
            this.addClassHistory();
        }
        return this.getClassHistory().get(0);
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public Encounter setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Encounter addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public CodeableConcept getServiceType() {
        if (this.serviceType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.serviceType");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceType = new CodeableConcept();
            }
        }
        return this.serviceType;
    }

    public boolean hasServiceType() {
        return this.serviceType != null && !this.serviceType.isEmpty();
    }

    public Encounter setServiceType(CodeableConcept value) {
        this.serviceType = value;
        return this;
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Encounter setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Encounter setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public CodeableConcept getSubjectStatus() {
        if (this.subjectStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.subjectStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.subjectStatus = new CodeableConcept();
            }
        }
        return this.subjectStatus;
    }

    public boolean hasSubjectStatus() {
        return this.subjectStatus != null && !this.subjectStatus.isEmpty();
    }

    public Encounter setSubjectStatus(CodeableConcept value) {
        this.subjectStatus = value;
        return this;
    }

    public List<Reference> getEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        return this.episodeOfCare;
    }

    public Encounter setEpisodeOfCare(List<Reference> theEpisodeOfCare) {
        this.episodeOfCare = theEpisodeOfCare;
        return this;
    }

    public boolean hasEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            return false;
        }
        for (Reference item : this.episodeOfCare) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEpisodeOfCare() {
        Reference t = new Reference();
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        this.episodeOfCare.add(t);
        return t;
    }

    public Encounter addEpisodeOfCare(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        this.episodeOfCare.add(t);
        return this;
    }

    public Reference getEpisodeOfCareFirstRep() {
        if (this.getEpisodeOfCare().isEmpty()) {
            this.addEpisodeOfCare();
        }
        return this.getEpisodeOfCare().get(0);
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public Encounter setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public Encounter addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    public List<EncounterParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        return this.participant;
    }

    public Encounter setParticipant(List<EncounterParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (EncounterParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterParticipantComponent addParticipant() {
        EncounterParticipantComponent t = new EncounterParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Encounter addParticipant(EncounterParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public EncounterParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public List<Reference> getAppointment() {
        if (this.appointment == null) {
            this.appointment = new ArrayList<Reference>();
        }
        return this.appointment;
    }

    public Encounter setAppointment(List<Reference> theAppointment) {
        this.appointment = theAppointment;
        return this;
    }

    public boolean hasAppointment() {
        if (this.appointment == null) {
            return false;
        }
        for (Reference item : this.appointment) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAppointment() {
        Reference t = new Reference();
        if (this.appointment == null) {
            this.appointment = new ArrayList<Reference>();
        }
        this.appointment.add(t);
        return t;
    }

    public Encounter addAppointment(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.appointment == null) {
            this.appointment = new ArrayList<Reference>();
        }
        this.appointment.add(t);
        return this;
    }

    public Reference getAppointmentFirstRep() {
        if (this.getAppointment().isEmpty()) {
            this.addAppointment();
        }
        return this.getAppointment().get(0);
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Encounter setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Duration getLength() {
        if (this.length == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.length");
            }
            if (Configuration.doAutoCreate()) {
                this.length = new Duration();
            }
        }
        return this.length;
    }

    public boolean hasLength() {
        return this.length != null && !this.length.isEmpty();
    }

    public Encounter setLength(Duration value) {
        this.length = value;
        return this;
    }

    public List<CodeableReference> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        return this.reason;
    }

    public Encounter setReason(List<CodeableReference> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableReference item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableReference addReason() {
        CodeableReference t = new CodeableReference();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return t;
    }

    public Encounter addReason(CodeableReference t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableReference>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableReference getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public Encounter setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public Encounter addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public DiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public List<Reference> getAccount() {
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        return this.account;
    }

    public Encounter setAccount(List<Reference> theAccount) {
        this.account = theAccount;
        return this;
    }

    public boolean hasAccount() {
        if (this.account == null) {
            return false;
        }
        for (Reference item : this.account) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAccount() {
        Reference t = new Reference();
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return t;
    }

    public Encounter addAccount(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return this;
    }

    public Reference getAccountFirstRep() {
        if (this.getAccount().isEmpty()) {
            this.addAccount();
        }
        return this.getAccount().get(0);
    }

    public EncounterHospitalizationComponent getHospitalization() {
        if (this.hospitalization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.hospitalization");
            }
            if (Configuration.doAutoCreate()) {
                this.hospitalization = new EncounterHospitalizationComponent();
            }
        }
        return this.hospitalization;
    }

    public boolean hasHospitalization() {
        return this.hospitalization != null && !this.hospitalization.isEmpty();
    }

    public Encounter setHospitalization(EncounterHospitalizationComponent value) {
        this.hospitalization = value;
        return this;
    }

    public List<EncounterLocationComponent> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        return this.location;
    }

    public Encounter setLocation(List<EncounterLocationComponent> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (EncounterLocationComponent item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterLocationComponent addLocation() {
        EncounterLocationComponent t = new EncounterLocationComponent();
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        this.location.add(t);
        return t;
    }

    public Encounter addLocation(EncounterLocationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        this.location.add(t);
        return this;
    }

    public EncounterLocationComponent getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public Reference getServiceProvider() {
        if (this.serviceProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.serviceProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceProvider = new Reference();
            }
        }
        return this.serviceProvider;
    }

    public boolean hasServiceProvider() {
        return this.serviceProvider != null && !this.serviceProvider.isEmpty();
    }

    public Encounter setServiceProvider(Reference value) {
        this.serviceProvider = value;
        return this;
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Encounter setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown.", 0, 1, this.status));
        children.add(new Property("statusHistory", "", "The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.", 0, Integer.MAX_VALUE, this.statusHistory));
        children.add(new Property(SP_CLASS, "Coding", "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.", 0, 1, this.class_));
        children.add(new Property("classHistory", "", "The class history permits the tracking of the encounters transitions without needing to go  through the resource history.  This would be used for a case where an admission starts of as an emergency encounter, then transitions into an inpatient scenario. Doing this and not restarting a new encounter ensures that any lab/diagnostic results can more easily follow the patient and not require re-processing and not get lost or cancelled during a kind of discharge from emergency to inpatient.", 0, Integer.MAX_VALUE, this.classHistory));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("serviceType", "CodeableConcept", "Broad categorization of the service that is to be provided (e.g. cardiology).", 0, 1, this.serviceType));
        children.add(new Property("priority", "CodeableConcept", "Indicates the urgency of the encounter.", 0, 1, this.priority));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group present at the encounter.", 0, 1, this.subject));
        children.add(new Property("subjectStatus", "CodeableConcept", "The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.", 0, 1, this.subjectStatus));
        children.add(new Property("episodeOfCare", "Reference(EpisodeOfCare)", "Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).", 0, Integer.MAX_VALUE, this.episodeOfCare));
        children.add(new Property("basedOn", "Reference(ServiceRequest)", "The request this encounter satisfies (e.g. incoming referral or procedure request).", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_PARTICIPANT, "", "The list of people responsible for providing the service.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property(SP_APPOINTMENT, "Reference(Appointment)", "The appointment that scheduled this encounter.", 0, Integer.MAX_VALUE, this.appointment));
        children.add(new Property("period", "Period", "The start and end time of the encounter.", 0, 1, this.period));
        children.add(new Property(SP_LENGTH, "Duration", "Quantity of time the encounter lasted. This excludes the time during leaves of absence.", 0, 1, this.length));
        children.add(new Property("reason", "CodeableReference(Condition|Procedure|Observation|ImmunizationRecommendation)", "Reason the encounter takes place, expressed as a code or a reference to another resource. For admissions, this can be used for a coded admission diagnosis.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property(SP_DIAGNOSIS, "", "The list of diagnosis relevant to this encounter.", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property(SP_ACCOUNT, "Reference(Account)", "The set of accounts that may be used for billing for this Encounter.", 0, Integer.MAX_VALUE, this.account));
        children.add(new Property("hospitalization", "", "Details about the admission to a healthcare service.", 0, 1, this.hospitalization));
        children.add(new Property(SP_LOCATION, "", "List of locations where  the patient has been during this encounter.", 0, Integer.MAX_VALUE, this.location));
        children.add(new Property("serviceProvider", "Reference(Organization)", "The organization that is primarily responsible for this Encounter's services. This MAY be the same as the organization on the Patient record, however it could be different, such as if the actor performing the services was from an external organization (which may be billed seperately) for an external consultation.  Refer to the example bundle showing an abbreviated set of Encounters for a colonoscopy.", 0, 1, this.serviceProvider));
        children.add(new Property("partOf", "Reference(Encounter)", "Another Encounter of which this encounter is a part of (administratively or in time).", 0, 1, this.partOf));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown.", 0, 1, this.status);
            }
            case -986695614: {
                return new Property("statusHistory", "", "The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.", 0, Integer.MAX_VALUE, this.statusHistory);
            }
            case 94742904: {
                return new Property(SP_CLASS, "Coding", "Concepts representing classification of patient encounter such as ambulatory (outpatient), inpatient, emergency, home health or others due to local variations.", 0, 1, this.class_);
            }
            case 962575356: {
                return new Property("classHistory", "", "The class history permits the tracking of the encounters transitions without needing to go  through the resource history.  This would be used for a case where an admission starts of as an emergency encounter, then transitions into an inpatient scenario. Doing this and not restarting a new encounter ensures that any lab/diagnostic results can more easily follow the patient and not require re-processing and not get lost or cancelled during a kind of discharge from emergency to inpatient.", 0, Integer.MAX_VALUE, this.classHistory);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type);
            }
            case -1928370289: {
                return new Property("serviceType", "CodeableConcept", "Broad categorization of the service that is to be provided (e.g. cardiology).", 0, 1, this.serviceType);
            }
            case -1165461084: {
                return new Property("priority", "CodeableConcept", "Indicates the urgency of the encounter.", 0, 1, this.priority);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient or group present at the encounter.", 0, 1, this.subject);
            }
            case 110854206: {
                return new Property("subjectStatus", "CodeableConcept", "The subjectStatus value can be used to track the patient's status within the encounter. It details whether the patient has arrived or departed, has been triaged or is currently in a waiting status.", 0, 1, this.subjectStatus);
            }
            case -1892140189: {
                return new Property("episodeOfCare", "Reference(EpisodeOfCare)", "Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).", 0, Integer.MAX_VALUE, this.episodeOfCare);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(ServiceRequest)", "The request this encounter satisfies (e.g. incoming referral or procedure request).", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case 767422259: {
                return new Property(SP_PARTICIPANT, "", "The list of people responsible for providing the service.", 0, Integer.MAX_VALUE, this.participant);
            }
            case -1474995297: {
                return new Property(SP_APPOINTMENT, "Reference(Appointment)", "The appointment that scheduled this encounter.", 0, Integer.MAX_VALUE, this.appointment);
            }
            case -991726143: {
                return new Property("period", "Period", "The start and end time of the encounter.", 0, 1, this.period);
            }
            case -1106363674: {
                return new Property(SP_LENGTH, "Duration", "Quantity of time the encounter lasted. This excludes the time during leaves of absence.", 0, 1, this.length);
            }
            case -934964668: {
                return new Property("reason", "CodeableReference(Condition|Procedure|Observation|ImmunizationRecommendation)", "Reason the encounter takes place, expressed as a code or a reference to another resource. For admissions, this can be used for a coded admission diagnosis.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1196993265: {
                return new Property(SP_DIAGNOSIS, "", "The list of diagnosis relevant to this encounter.", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -1177318867: {
                return new Property(SP_ACCOUNT, "Reference(Account)", "The set of accounts that may be used for billing for this Encounter.", 0, Integer.MAX_VALUE, this.account);
            }
            case 1057894634: {
                return new Property("hospitalization", "", "Details about the admission to a healthcare service.", 0, 1, this.hospitalization);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "", "List of locations where  the patient has been during this encounter.", 0, Integer.MAX_VALUE, this.location);
            }
            case 243182534: {
                return new Property("serviceProvider", "Reference(Organization)", "The organization that is primarily responsible for this Encounter's services. This MAY be the same as the organization on the Patient record, however it could be different, such as if the actor performing the services was from an external organization (which may be billed seperately) for an external consultation.  Refer to the example bundle showing an abbreviated set of Encounters for a colonoscopy.", 0, 1, this.serviceProvider);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Encounter)", "Another Encounter of which this encounter is a part of (administratively or in time).", 0, 1, this.partOf);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -986695614: {
                return this.statusHistory == null ? new Base[]{} : this.statusHistory.toArray(new Base[this.statusHistory.size()]);
            }
            case 94742904: {
                Base[] baseArray;
                if (this.class_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.class_;
                }
                return baseArray;
            }
            case 962575356: {
                return this.classHistory == null ? new Base[]{} : this.classHistory.toArray(new Base[this.classHistory.size()]);
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -1928370289: {
                Base[] baseArray;
                if (this.serviceType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.serviceType;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.subject;
                }
                return baseArray;
            }
            case 110854206: {
                Base[] baseArray;
                if (this.subjectStatus == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.subjectStatus;
                }
                return baseArray;
            }
            case -1892140189: {
                return this.episodeOfCare == null ? new Base[]{} : this.episodeOfCare.toArray(new Base[this.episodeOfCare.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -1474995297: {
                return this.appointment == null ? new Base[]{} : this.appointment.toArray(new Base[this.appointment.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.period;
                }
                return baseArray;
            }
            case -1106363674: {
                Base[] baseArray;
                if (this.length == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.length;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -1177318867: {
                return this.account == null ? new Base[]{} : this.account.toArray(new Base[this.account.size()]);
            }
            case 1057894634: {
                Base[] baseArray;
                if (this.hospitalization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.hospitalization;
                }
                return baseArray;
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 243182534: {
                Base[] baseArray;
                if (this.serviceProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.serviceProvider;
                }
                return baseArray;
            }
            case -995410646: {
                Base[] baseArray;
                if (this.partOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.partOf;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
                return value;
            }
            case -986695614: {
                this.getStatusHistory().add((StatusHistoryComponent)((Object)value));
                return value;
            }
            case 94742904: {
                this.class_ = TypeConvertor.castToCoding(value);
                return value;
            }
            case 962575356: {
                this.getClassHistory().add((ClassHistoryComponent)((Object)value));
                return value;
            }
            case 3575610: {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case -1928370289: {
                this.serviceType = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1165461084: {
                this.priority = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = TypeConvertor.castToReference(value);
                return value;
            }
            case 110854206: {
                this.subjectStatus = TypeConvertor.castToCodeableConcept(value);
                return value;
            }
            case -1892140189: {
                this.getEpisodeOfCare().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 767422259: {
                this.getParticipant().add((EncounterParticipantComponent)((Object)value));
                return value;
            }
            case -1474995297: {
                this.getAppointment().add(TypeConvertor.castToReference(value));
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1106363674: {
                this.length = TypeConvertor.castToDuration(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(TypeConvertor.castToCodeableReference(value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)((Object)value));
                return value;
            }
            case -1177318867: {
                this.getAccount().add(TypeConvertor.castToReference(value));
                return value;
            }
            case 1057894634: {
                this.hospitalization = (EncounterHospitalizationComponent)((Object)value);
                return value;
            }
            case 1901043637: {
                this.getLocation().add((EncounterLocationComponent)((Object)value));
                return value;
            }
            case 243182534: {
                this.serviceProvider = TypeConvertor.castToReference(value);
                return value;
            }
            case -995410646: {
                this.partOf = TypeConvertor.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.status = value;
        } else if (name.equals("statusHistory")) {
            this.getStatusHistory().add((StatusHistoryComponent)((Object)value));
        } else if (name.equals(SP_CLASS)) {
            this.class_ = TypeConvertor.castToCoding(value);
        } else if (name.equals("classHistory")) {
            this.getClassHistory().add((ClassHistoryComponent)((Object)value));
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals("serviceType")) {
            this.serviceType = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("priority")) {
            this.priority = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = TypeConvertor.castToReference(value);
        } else if (name.equals("subjectStatus")) {
            this.subjectStatus = TypeConvertor.castToCodeableConcept(value);
        } else if (name.equals("episodeOfCare")) {
            this.getEpisodeOfCare().add(TypeConvertor.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(TypeConvertor.castToReference(value));
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((EncounterParticipantComponent)((Object)value));
        } else if (name.equals(SP_APPOINTMENT)) {
            this.getAppointment().add(TypeConvertor.castToReference(value));
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals(SP_LENGTH)) {
            this.length = TypeConvertor.castToDuration(value);
        } else if (name.equals("reason")) {
            this.getReason().add(TypeConvertor.castToCodeableReference(value));
        } else if (name.equals(SP_DIAGNOSIS)) {
            this.getDiagnosis().add((DiagnosisComponent)((Object)value));
        } else if (name.equals(SP_ACCOUNT)) {
            this.getAccount().add(TypeConvertor.castToReference(value));
        } else if (name.equals("hospitalization")) {
            this.hospitalization = (EncounterHospitalizationComponent)((Object)value);
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add((EncounterLocationComponent)((Object)value));
        } else if (name.equals("serviceProvider")) {
            this.serviceProvider = TypeConvertor.castToReference(value);
        } else if (name.equals("partOf")) {
            this.partOf = TypeConvertor.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -986695614: {
                return this.addStatusHistory();
            }
            case 94742904: {
                return this.getClass_();
            }
            case 962575356: {
                return this.addClassHistory();
            }
            case 3575610: {
                return this.addType();
            }
            case -1928370289: {
                return this.getServiceType();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 110854206: {
                return this.getSubjectStatus();
            }
            case -1892140189: {
                return this.addEpisodeOfCare();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -1474995297: {
                return this.addAppointment();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1106363674: {
                return this.getLength();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -1177318867: {
                return this.addAccount();
            }
            case 1057894634: {
                return this.getHospitalization();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 243182534: {
                return this.getServiceProvider();
            }
            case -995410646: {
                return this.getPartOf();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -986695614: {
                return new String[0];
            }
            case 94742904: {
                return new String[]{"Coding"};
            }
            case 962575356: {
                return new String[0];
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1928370289: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 110854206: {
                return new String[]{"CodeableConcept"};
            }
            case -1892140189: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case 767422259: {
                return new String[0];
            }
            case -1474995297: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -1106363674: {
                return new String[]{"Duration"};
            }
            case -934964668: {
                return new String[]{"CodeableReference"};
            }
            case 1196993265: {
                return new String[0];
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
            case 1057894634: {
                return new String[0];
            }
            case 1901043637: {
                return new String[0];
            }
            case 243182534: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Encounter.status");
        }
        if (name.equals("statusHistory")) {
            return this.addStatusHistory();
        }
        if (name.equals(SP_CLASS)) {
            this.class_ = new Coding();
            return this.class_;
        }
        if (name.equals("classHistory")) {
            return this.addClassHistory();
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals("serviceType")) {
            this.serviceType = new CodeableConcept();
            return this.serviceType;
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("subjectStatus")) {
            this.subjectStatus = new CodeableConcept();
            return this.subjectStatus;
        }
        if (name.equals("episodeOfCare")) {
            return this.addEpisodeOfCare();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals(SP_APPOINTMENT)) {
            return this.addAppointment();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_LENGTH)) {
            this.length = new Duration();
            return this.length;
        }
        if (name.equals("reason")) {
            return this.addReason();
        }
        if (name.equals(SP_DIAGNOSIS)) {
            return this.addDiagnosis();
        }
        if (name.equals(SP_ACCOUNT)) {
            return this.addAccount();
        }
        if (name.equals("hospitalization")) {
            this.hospitalization = new EncounterHospitalizationComponent();
            return this.hospitalization;
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals("serviceProvider")) {
            this.serviceProvider = new Reference();
            return this.serviceProvider;
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Encounter";
    }

    @Override
    public Encounter copy() {
        Encounter dst = new Encounter();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(Encounter dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<EncounterStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusHistory != null) {
            dst.statusHistory = new ArrayList<StatusHistoryComponent>();
            for (StatusHistoryComponent statusHistoryComponent : this.statusHistory) {
                dst.statusHistory.add(statusHistoryComponent.copy());
            }
        }
        Coding coding = dst.class_ = this.class_ == null ? null : this.class_.copy();
        if (this.classHistory != null) {
            dst.classHistory = new ArrayList<ClassHistoryComponent>();
            for (ClassHistoryComponent classHistoryComponent : this.classHistory) {
                dst.classHistory.add(classHistoryComponent.copy());
            }
        }
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        dst.serviceType = this.serviceType == null ? null : this.serviceType.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        CodeableConcept codeableConcept = dst.subjectStatus = this.subjectStatus == null ? null : this.subjectStatus.copy();
        if (this.episodeOfCare != null) {
            dst.episodeOfCare = new ArrayList<Reference>();
            for (Reference reference : this.episodeOfCare) {
                dst.episodeOfCare.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.participant != null) {
            dst.participant = new ArrayList<EncounterParticipantComponent>();
            for (EncounterParticipantComponent encounterParticipantComponent : this.participant) {
                dst.participant.add(encounterParticipantComponent.copy());
            }
        }
        if (this.appointment != null) {
            dst.appointment = new ArrayList<Reference>();
            for (Reference reference : this.appointment) {
                dst.appointment.add(reference.copy());
            }
        }
        dst.period = this.period == null ? null : this.period.copy();
        Duration duration = dst.length = this.length == null ? null : this.length.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableReference>();
            for (CodeableReference codeableReference : this.reason) {
                dst.reason.add(codeableReference.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        if (this.account != null) {
            dst.account = new ArrayList<Reference>();
            for (Reference reference : this.account) {
                dst.account.add(reference.copy());
            }
        }
        EncounterHospitalizationComponent encounterHospitalizationComponent = dst.hospitalization = this.hospitalization == null ? null : this.hospitalization.copy();
        if (this.location != null) {
            dst.location = new ArrayList<EncounterLocationComponent>();
            for (EncounterLocationComponent encounterLocationComponent : this.location) {
                dst.location.add(encounterLocationComponent.copy());
            }
        }
        dst.serviceProvider = this.serviceProvider == null ? null : this.serviceProvider.copy();
        dst.partOf = this.partOf == null ? null : this.partOf.copy();
    }

    protected Encounter typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Encounter)) {
            return false;
        }
        Encounter o = (Encounter)other_;
        return Encounter.compareDeep(this.identifier, o.identifier, true) && Encounter.compareDeep(this.status, o.status, true) && Encounter.compareDeep(this.statusHistory, o.statusHistory, true) && Encounter.compareDeep(this.class_, o.class_, true) && Encounter.compareDeep(this.classHistory, o.classHistory, true) && Encounter.compareDeep(this.type, o.type, true) && Encounter.compareDeep(this.serviceType, o.serviceType, true) && Encounter.compareDeep(this.priority, o.priority, true) && Encounter.compareDeep(this.subject, o.subject, true) && Encounter.compareDeep(this.subjectStatus, o.subjectStatus, true) && Encounter.compareDeep(this.episodeOfCare, o.episodeOfCare, true) && Encounter.compareDeep(this.basedOn, o.basedOn, true) && Encounter.compareDeep(this.participant, o.participant, true) && Encounter.compareDeep(this.appointment, o.appointment, true) && Encounter.compareDeep(this.period, o.period, true) && Encounter.compareDeep(this.length, o.length, true) && Encounter.compareDeep(this.reason, o.reason, true) && Encounter.compareDeep(this.diagnosis, o.diagnosis, true) && Encounter.compareDeep(this.account, o.account, true) && Encounter.compareDeep(this.hospitalization, o.hospitalization, true) && Encounter.compareDeep(this.location, o.location, true) && Encounter.compareDeep(this.serviceProvider, o.serviceProvider, true) && Encounter.compareDeep(this.partOf, o.partOf, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Encounter)) {
            return false;
        }
        Encounter o = (Encounter)other_;
        return Encounter.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.statusHistory, this.class_, this.classHistory, this.type, this.serviceType, this.priority, this.subject, this.subjectStatus, this.episodeOfCare, this.basedOn, this.participant, this.appointment, this.period, this.length, this.reason, this.diagnosis, this.account, this.hospitalization, this.location, this.serviceProvider, this.partOf);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Encounter;
    }

    @Block
    public static class EncounterLocationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="location", type={Location.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location the encounter takes place", formalDefinition="The location where the encounter takes place.")
        protected Reference location;
        @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | active | reserved | completed", formalDefinition="The status of the participants' presence at the specified location during the period specified. If the participant is no longer at the location, then the period will have an end date/time.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-location-status")
        protected Enumeration<EncounterLocationStatus> status;
        @Child(name="physicalType", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The physical type of the location (usually the level in the location hierachy - bed room ward etc.)", formalDefinition="This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/location-physical-type")
        protected CodeableConcept physicalType;
        @Child(name="period", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time period during which the patient was present at the location", formalDefinition="Time period during which the patient was present at the location.")
        protected Period period;
        private static final long serialVersionUID = 1804020723L;

        public EncounterLocationComponent() {
        }

        public EncounterLocationComponent(Reference location) {
            this.setLocation(location);
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public EncounterLocationComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Enumeration<EncounterLocationStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EncounterLocationStatus>(new EncounterLocationStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public EncounterLocationComponent setStatusElement(Enumeration<EncounterLocationStatus> value) {
            this.status = value;
            return this;
        }

        public EncounterLocationStatus getStatus() {
            return this.status == null ? null : (EncounterLocationStatus)((Object)this.status.getValue());
        }

        public EncounterLocationComponent setStatus(EncounterLocationStatus value) {
            if (value == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration<EncounterLocationStatus>(new EncounterLocationStatusEnumFactory());
                }
                this.status.setValue((Object)value);
            }
            return this;
        }

        public CodeableConcept getPhysicalType() {
            if (this.physicalType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.physicalType");
                }
                if (Configuration.doAutoCreate()) {
                    this.physicalType = new CodeableConcept();
                }
            }
            return this.physicalType;
        }

        public boolean hasPhysicalType() {
            return this.physicalType != null && !this.physicalType.isEmpty();
        }

        public EncounterLocationComponent setPhysicalType(CodeableConcept value) {
            this.physicalType = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterLocationComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_LOCATION, "Reference(Location)", "The location where the encounter takes place.", 0, 1, this.location));
            children.add(new Property(Encounter.SP_STATUS, "code", "The status of the participants' presence at the specified location during the period specified. If the participant is no longer at the location, then the period will have an end date/time.", 0, 1, this.status));
            children.add(new Property("physicalType", "CodeableConcept", "This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.", 0, 1, this.physicalType));
            children.add(new Property("period", "Period", "Time period during which the patient was present at the location.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1901043637: {
                    return new Property(Encounter.SP_LOCATION, "Reference(Location)", "The location where the encounter takes place.", 0, 1, this.location);
                }
                case -892481550: {
                    return new Property(Encounter.SP_STATUS, "code", "The status of the participants' presence at the specified location during the period specified. If the participant is no longer at the location, then the period will have an end date/time.", 0, 1, this.status);
                }
                case -1474715471: {
                    return new Property("physicalType", "CodeableConcept", "This will be used to specify the required levels (bed/ward/room/etc.) desired to be recorded to simplify either messaging or query.", 0, 1, this.physicalType);
                }
                case -991726143: {
                    return new Property("period", "Period", "Time period during which the patient was present at the location.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.location;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case -1474715471: {
                    Base[] baseArray;
                    if (this.physicalType == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.physicalType;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    this.location = TypeConvertor.castToReference(value);
                    return value;
                }
                case -892481550: {
                    value = new EncounterLocationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.status = value;
                    return value;
                }
                case -1474715471: {
                    this.physicalType = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = TypeConvertor.castToReference(value);
            } else if (name.equals(Encounter.SP_STATUS)) {
                value = new EncounterLocationStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else if (name.equals("physicalType")) {
                this.physicalType = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return this.getLocation();
                }
                case -892481550: {
                    return this.getStatusElement();
                }
                case -1474715471: {
                    return this.getPhysicalType();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case -892481550: {
                    return new String[]{"code"};
                }
                case -1474715471: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(Encounter.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type Encounter.location.status");
            }
            if (name.equals("physicalType")) {
                this.physicalType = new CodeableConcept();
                return this.physicalType;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterLocationComponent copy() {
            EncounterLocationComponent dst = new EncounterLocationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EncounterLocationComponent dst) {
            super.copyValues(dst);
            dst.location = this.location == null ? null : this.location.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.physicalType = this.physicalType == null ? null : this.physicalType.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterLocationComponent)) {
                return false;
            }
            EncounterLocationComponent o = (EncounterLocationComponent)other_;
            return EncounterLocationComponent.compareDeep(this.location, o.location, true) && EncounterLocationComponent.compareDeep(this.status, o.status, true) && EncounterLocationComponent.compareDeep(this.physicalType, o.physicalType, true) && EncounterLocationComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterLocationComponent)) {
                return false;
            }
            EncounterLocationComponent o = (EncounterLocationComponent)other_;
            return EncounterLocationComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.location, this.status, this.physicalType, this.period);
        }

        @Override
        public String fhirType() {
            return "Encounter.location";
        }
    }

    @Block
    public static class EncounterHospitalizationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="preAdmissionIdentifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pre-admission identifier", formalDefinition="Pre-admission identifier.")
        protected Identifier preAdmissionIdentifier;
        @Child(name="origin", type={Location.class, Organization.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The location/organization from which the patient came before admission", formalDefinition="The location/organization from which the patient came before admission.")
        protected Reference origin;
        @Child(name="admitSource", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="From where patient was admitted (physician referral, transfer)", formalDefinition="From where patient was admitted (physician referral, transfer).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-admit-source")
        protected CodeableConcept admitSource;
        @Child(name="reAdmission", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of hospital re-admission that has occurred (if any). If the value is absent, then this is not identified as a readmission", formalDefinition="Whether this hospitalization is a readmission and why if known.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v2-0092")
        protected CodeableConcept reAdmission;
        @Child(name="dietPreference", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Diet preferences reported by the patient", formalDefinition="Diet preferences reported by the patient.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-diet")
        protected List<CodeableConcept> dietPreference;
        @Child(name="specialCourtesy", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Special courtesies (VIP, board member)", formalDefinition="Special courtesies (VIP, board member).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-special-courtesy")
        protected List<CodeableConcept> specialCourtesy;
        @Child(name="specialArrangement", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Wheelchair, translator, stretcher, etc.", formalDefinition="Any special requests that have been made for this hospitalization encounter, such as the provision of specific equipment or other things.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-special-arrangements")
        protected List<CodeableConcept> specialArrangement;
        @Child(name="destination", type={Location.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location/organization to which the patient is discharged", formalDefinition="Location/organization to which the patient is discharged.")
        protected Reference destination;
        @Child(name="dischargeDisposition", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category or kind of location after discharge", formalDefinition="Category or kind of location after discharge.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-discharge-disposition")
        protected CodeableConcept dischargeDisposition;
        private static final long serialVersionUID = -1173601498L;

        public Identifier getPreAdmissionIdentifier() {
            if (this.preAdmissionIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.preAdmissionIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.preAdmissionIdentifier = new Identifier();
                }
            }
            return this.preAdmissionIdentifier;
        }

        public boolean hasPreAdmissionIdentifier() {
            return this.preAdmissionIdentifier != null && !this.preAdmissionIdentifier.isEmpty();
        }

        public EncounterHospitalizationComponent setPreAdmissionIdentifier(Identifier value) {
            this.preAdmissionIdentifier = value;
            return this;
        }

        public Reference getOrigin() {
            if (this.origin == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.origin");
                }
                if (Configuration.doAutoCreate()) {
                    this.origin = new Reference();
                }
            }
            return this.origin;
        }

        public boolean hasOrigin() {
            return this.origin != null && !this.origin.isEmpty();
        }

        public EncounterHospitalizationComponent setOrigin(Reference value) {
            this.origin = value;
            return this;
        }

        public CodeableConcept getAdmitSource() {
            if (this.admitSource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.admitSource");
                }
                if (Configuration.doAutoCreate()) {
                    this.admitSource = new CodeableConcept();
                }
            }
            return this.admitSource;
        }

        public boolean hasAdmitSource() {
            return this.admitSource != null && !this.admitSource.isEmpty();
        }

        public EncounterHospitalizationComponent setAdmitSource(CodeableConcept value) {
            this.admitSource = value;
            return this;
        }

        public CodeableConcept getReAdmission() {
            if (this.reAdmission == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.reAdmission");
                }
                if (Configuration.doAutoCreate()) {
                    this.reAdmission = new CodeableConcept();
                }
            }
            return this.reAdmission;
        }

        public boolean hasReAdmission() {
            return this.reAdmission != null && !this.reAdmission.isEmpty();
        }

        public EncounterHospitalizationComponent setReAdmission(CodeableConcept value) {
            this.reAdmission = value;
            return this;
        }

        public List<CodeableConcept> getDietPreference() {
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            return this.dietPreference;
        }

        public EncounterHospitalizationComponent setDietPreference(List<CodeableConcept> theDietPreference) {
            this.dietPreference = theDietPreference;
            return this;
        }

        public boolean hasDietPreference() {
            if (this.dietPreference == null) {
                return false;
            }
            for (CodeableConcept item : this.dietPreference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDietPreference() {
            CodeableConcept t = new CodeableConcept();
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            this.dietPreference.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addDietPreference(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            this.dietPreference.add(t);
            return this;
        }

        public CodeableConcept getDietPreferenceFirstRep() {
            if (this.getDietPreference().isEmpty()) {
                this.addDietPreference();
            }
            return this.getDietPreference().get(0);
        }

        public List<CodeableConcept> getSpecialCourtesy() {
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            return this.specialCourtesy;
        }

        public EncounterHospitalizationComponent setSpecialCourtesy(List<CodeableConcept> theSpecialCourtesy) {
            this.specialCourtesy = theSpecialCourtesy;
            return this;
        }

        public boolean hasSpecialCourtesy() {
            if (this.specialCourtesy == null) {
                return false;
            }
            for (CodeableConcept item : this.specialCourtesy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSpecialCourtesy() {
            CodeableConcept t = new CodeableConcept();
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            this.specialCourtesy.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addSpecialCourtesy(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            this.specialCourtesy.add(t);
            return this;
        }

        public CodeableConcept getSpecialCourtesyFirstRep() {
            if (this.getSpecialCourtesy().isEmpty()) {
                this.addSpecialCourtesy();
            }
            return this.getSpecialCourtesy().get(0);
        }

        public List<CodeableConcept> getSpecialArrangement() {
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            return this.specialArrangement;
        }

        public EncounterHospitalizationComponent setSpecialArrangement(List<CodeableConcept> theSpecialArrangement) {
            this.specialArrangement = theSpecialArrangement;
            return this;
        }

        public boolean hasSpecialArrangement() {
            if (this.specialArrangement == null) {
                return false;
            }
            for (CodeableConcept item : this.specialArrangement) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSpecialArrangement() {
            CodeableConcept t = new CodeableConcept();
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            this.specialArrangement.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addSpecialArrangement(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            this.specialArrangement.add(t);
            return this;
        }

        public CodeableConcept getSpecialArrangementFirstRep() {
            if (this.getSpecialArrangement().isEmpty()) {
                this.addSpecialArrangement();
            }
            return this.getSpecialArrangement().get(0);
        }

        public Reference getDestination() {
            if (this.destination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destination = new Reference();
                }
            }
            return this.destination;
        }

        public boolean hasDestination() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public EncounterHospitalizationComponent setDestination(Reference value) {
            this.destination = value;
            return this;
        }

        public CodeableConcept getDischargeDisposition() {
            if (this.dischargeDisposition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.dischargeDisposition");
                }
                if (Configuration.doAutoCreate()) {
                    this.dischargeDisposition = new CodeableConcept();
                }
            }
            return this.dischargeDisposition;
        }

        public boolean hasDischargeDisposition() {
            return this.dischargeDisposition != null && !this.dischargeDisposition.isEmpty();
        }

        public EncounterHospitalizationComponent setDischargeDisposition(CodeableConcept value) {
            this.dischargeDisposition = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("preAdmissionIdentifier", "Identifier", "Pre-admission identifier.", 0, 1, this.preAdmissionIdentifier));
            children.add(new Property("origin", "Reference(Location|Organization)", "The location/organization from which the patient came before admission.", 0, 1, this.origin));
            children.add(new Property("admitSource", "CodeableConcept", "From where patient was admitted (physician referral, transfer).", 0, 1, this.admitSource));
            children.add(new Property("reAdmission", "CodeableConcept", "Whether this hospitalization is a readmission and why if known.", 0, 1, this.reAdmission));
            children.add(new Property("dietPreference", "CodeableConcept", "Diet preferences reported by the patient.", 0, Integer.MAX_VALUE, this.dietPreference));
            children.add(new Property("specialCourtesy", "CodeableConcept", "Special courtesies (VIP, board member).", 0, Integer.MAX_VALUE, this.specialCourtesy));
            children.add(new Property("specialArrangement", "CodeableConcept", "Any special requests that have been made for this hospitalization encounter, such as the provision of specific equipment or other things.", 0, Integer.MAX_VALUE, this.specialArrangement));
            children.add(new Property("destination", "Reference(Location|Organization)", "Location/organization to which the patient is discharged.", 0, 1, this.destination));
            children.add(new Property("dischargeDisposition", "CodeableConcept", "Category or kind of location after discharge.", 0, 1, this.dischargeDisposition));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -965394961: {
                    return new Property("preAdmissionIdentifier", "Identifier", "Pre-admission identifier.", 0, 1, this.preAdmissionIdentifier);
                }
                case -1008619738: {
                    return new Property("origin", "Reference(Location|Organization)", "The location/organization from which the patient came before admission.", 0, 1, this.origin);
                }
                case 538887120: {
                    return new Property("admitSource", "CodeableConcept", "From where patient was admitted (physician referral, transfer).", 0, 1, this.admitSource);
                }
                case 669348630: {
                    return new Property("reAdmission", "CodeableConcept", "Whether this hospitalization is a readmission and why if known.", 0, 1, this.reAdmission);
                }
                case -1360641041: {
                    return new Property("dietPreference", "CodeableConcept", "Diet preferences reported by the patient.", 0, Integer.MAX_VALUE, this.dietPreference);
                }
                case 1583588345: {
                    return new Property("specialCourtesy", "CodeableConcept", "Special courtesies (VIP, board member).", 0, Integer.MAX_VALUE, this.specialCourtesy);
                }
                case 47410321: {
                    return new Property("specialArrangement", "CodeableConcept", "Any special requests that have been made for this hospitalization encounter, such as the provision of specific equipment or other things.", 0, Integer.MAX_VALUE, this.specialArrangement);
                }
                case -1429847026: {
                    return new Property("destination", "Reference(Location|Organization)", "Location/organization to which the patient is discharged.", 0, 1, this.destination);
                }
                case 528065941: {
                    return new Property("dischargeDisposition", "CodeableConcept", "Category or kind of location after discharge.", 0, 1, this.dischargeDisposition);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    Base[] baseArray;
                    if (this.preAdmissionIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.preAdmissionIdentifier;
                    }
                    return baseArray;
                }
                case -1008619738: {
                    Base[] baseArray;
                    if (this.origin == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.origin;
                    }
                    return baseArray;
                }
                case 538887120: {
                    Base[] baseArray;
                    if (this.admitSource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.admitSource;
                    }
                    return baseArray;
                }
                case 669348630: {
                    Base[] baseArray;
                    if (this.reAdmission == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.reAdmission;
                    }
                    return baseArray;
                }
                case -1360641041: {
                    return this.dietPreference == null ? new Base[]{} : this.dietPreference.toArray(new Base[this.dietPreference.size()]);
                }
                case 1583588345: {
                    return this.specialCourtesy == null ? new Base[]{} : this.specialCourtesy.toArray(new Base[this.specialCourtesy.size()]);
                }
                case 47410321: {
                    return this.specialArrangement == null ? new Base[]{} : this.specialArrangement.toArray(new Base[this.specialArrangement.size()]);
                }
                case -1429847026: {
                    Base[] baseArray;
                    if (this.destination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.destination;
                    }
                    return baseArray;
                }
                case 528065941: {
                    Base[] baseArray;
                    if (this.dischargeDisposition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.dischargeDisposition;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    this.preAdmissionIdentifier = TypeConvertor.castToIdentifier(value);
                    return value;
                }
                case -1008619738: {
                    this.origin = TypeConvertor.castToReference(value);
                    return value;
                }
                case 538887120: {
                    this.admitSource = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 669348630: {
                    this.reAdmission = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1360641041: {
                    this.getDietPreference().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 1583588345: {
                    this.getSpecialCourtesy().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case 47410321: {
                    this.getSpecialArrangement().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -1429847026: {
                    this.destination = TypeConvertor.castToReference(value);
                    return value;
                }
                case 528065941: {
                    this.dischargeDisposition = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = TypeConvertor.castToIdentifier(value);
            } else if (name.equals("origin")) {
                this.origin = TypeConvertor.castToReference(value);
            } else if (name.equals("admitSource")) {
                this.admitSource = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("reAdmission")) {
                this.reAdmission = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("dietPreference")) {
                this.getDietPreference().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("specialCourtesy")) {
                this.getSpecialCourtesy().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("specialArrangement")) {
                this.getSpecialArrangement().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("destination")) {
                this.destination = TypeConvertor.castToReference(value);
            } else if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = TypeConvertor.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    return this.getPreAdmissionIdentifier();
                }
                case -1008619738: {
                    return this.getOrigin();
                }
                case 538887120: {
                    return this.getAdmitSource();
                }
                case 669348630: {
                    return this.getReAdmission();
                }
                case -1360641041: {
                    return this.addDietPreference();
                }
                case 1583588345: {
                    return this.addSpecialCourtesy();
                }
                case 47410321: {
                    return this.addSpecialArrangement();
                }
                case -1429847026: {
                    return this.getDestination();
                }
                case 528065941: {
                    return this.getDischargeDisposition();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    return new String[]{"Identifier"};
                }
                case -1008619738: {
                    return new String[]{"Reference"};
                }
                case 538887120: {
                    return new String[]{"CodeableConcept"};
                }
                case 669348630: {
                    return new String[]{"CodeableConcept"};
                }
                case -1360641041: {
                    return new String[]{"CodeableConcept"};
                }
                case 1583588345: {
                    return new String[]{"CodeableConcept"};
                }
                case 47410321: {
                    return new String[]{"CodeableConcept"};
                }
                case -1429847026: {
                    return new String[]{"Reference"};
                }
                case 528065941: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = new Identifier();
                return this.preAdmissionIdentifier;
            }
            if (name.equals("origin")) {
                this.origin = new Reference();
                return this.origin;
            }
            if (name.equals("admitSource")) {
                this.admitSource = new CodeableConcept();
                return this.admitSource;
            }
            if (name.equals("reAdmission")) {
                this.reAdmission = new CodeableConcept();
                return this.reAdmission;
            }
            if (name.equals("dietPreference")) {
                return this.addDietPreference();
            }
            if (name.equals("specialCourtesy")) {
                return this.addSpecialCourtesy();
            }
            if (name.equals("specialArrangement")) {
                return this.addSpecialArrangement();
            }
            if (name.equals("destination")) {
                this.destination = new Reference();
                return this.destination;
            }
            if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = new CodeableConcept();
                return this.dischargeDisposition;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterHospitalizationComponent copy() {
            EncounterHospitalizationComponent dst = new EncounterHospitalizationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EncounterHospitalizationComponent dst) {
            super.copyValues(dst);
            dst.preAdmissionIdentifier = this.preAdmissionIdentifier == null ? null : this.preAdmissionIdentifier.copy();
            dst.origin = this.origin == null ? null : this.origin.copy();
            dst.admitSource = this.admitSource == null ? null : this.admitSource.copy();
            CodeableConcept codeableConcept = dst.reAdmission = this.reAdmission == null ? null : this.reAdmission.copy();
            if (this.dietPreference != null) {
                dst.dietPreference = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.dietPreference) {
                    dst.dietPreference.add(i2.copy());
                }
            }
            if (this.specialCourtesy != null) {
                dst.specialCourtesy = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.specialCourtesy) {
                    dst.specialCourtesy.add(i2.copy());
                }
            }
            if (this.specialArrangement != null) {
                dst.specialArrangement = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.specialArrangement) {
                    dst.specialArrangement.add(i2.copy());
                }
            }
            dst.destination = this.destination == null ? null : this.destination.copy();
            dst.dischargeDisposition = this.dischargeDisposition == null ? null : this.dischargeDisposition.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterHospitalizationComponent)) {
                return false;
            }
            EncounterHospitalizationComponent o = (EncounterHospitalizationComponent)other_;
            return EncounterHospitalizationComponent.compareDeep(this.preAdmissionIdentifier, o.preAdmissionIdentifier, true) && EncounterHospitalizationComponent.compareDeep(this.origin, o.origin, true) && EncounterHospitalizationComponent.compareDeep(this.admitSource, o.admitSource, true) && EncounterHospitalizationComponent.compareDeep(this.reAdmission, o.reAdmission, true) && EncounterHospitalizationComponent.compareDeep(this.dietPreference, o.dietPreference, true) && EncounterHospitalizationComponent.compareDeep(this.specialCourtesy, o.specialCourtesy, true) && EncounterHospitalizationComponent.compareDeep(this.specialArrangement, o.specialArrangement, true) && EncounterHospitalizationComponent.compareDeep(this.destination, o.destination, true) && EncounterHospitalizationComponent.compareDeep(this.dischargeDisposition, o.dischargeDisposition, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterHospitalizationComponent)) {
                return false;
            }
            EncounterHospitalizationComponent o = (EncounterHospitalizationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.preAdmissionIdentifier, this.origin, this.admitSource, this.reAdmission, this.dietPreference, this.specialCourtesy, this.specialArrangement, this.destination, this.dischargeDisposition);
        }

        @Override
        public String fhirType() {
            return "Encounter.hospitalization";
        }
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="condition", type={Condition.class, Procedure.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The diagnosis or procedure relevant to the encounter", formalDefinition="Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.")
        protected Reference condition;
        @Child(name="use", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026)", formalDefinition="Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnosis-role")
        protected CodeableConcept use;
        @Child(name="rank", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Ranking of the diagnosis (for each role type)", formalDefinition="Ranking of the diagnosis (for each role type).")
        protected PositiveIntType rank;
        private static final long serialVersionUID = 1748818180L;

        public DiagnosisComponent() {
        }

        public DiagnosisComponent(Reference condition) {
            this.setCondition(condition);
        }

        public Reference getCondition() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new Reference();
                }
            }
            return this.condition;
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public DiagnosisComponent setCondition(Reference value) {
            this.condition = value;
            return this;
        }

        public CodeableConcept getUse() {
            if (this.use == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.use");
                }
                if (Configuration.doAutoCreate()) {
                    this.use = new CodeableConcept();
                }
            }
            return this.use;
        }

        public boolean hasUse() {
            return this.use != null && !this.use.isEmpty();
        }

        public DiagnosisComponent setUse(CodeableConcept value) {
            this.use = value;
            return this;
        }

        public PositiveIntType getRankElement() {
            if (this.rank == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.rank");
                }
                if (Configuration.doAutoCreate()) {
                    this.rank = new PositiveIntType();
                }
            }
            return this.rank;
        }

        public boolean hasRankElement() {
            return this.rank != null && !this.rank.isEmpty();
        }

        public boolean hasRank() {
            return this.rank != null && !this.rank.isEmpty();
        }

        public DiagnosisComponent setRankElement(PositiveIntType value) {
            this.rank = value;
            return this;
        }

        public int getRank() {
            return this.rank == null || this.rank.isEmpty() ? 0 : (Integer)this.rank.getValue();
        }

        public DiagnosisComponent setRank(int value) {
            if (this.rank == null) {
                this.rank = new PositiveIntType();
            }
            this.rank.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("condition", "Reference(Condition|Procedure)", "Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, 1, this.condition));
            children.add(new Property("use", "CodeableConcept", "Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).", 0, 1, this.use));
            children.add(new Property("rank", "positiveInt", "Ranking of the diagnosis (for each role type).", 0, 1, this.rank));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -861311717: {
                    return new Property("condition", "Reference(Condition|Procedure)", "Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, 1, this.condition);
                }
                case 116103: {
                    return new Property("use", "CodeableConcept", "Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).", 0, 1, this.use);
                }
                case 3492908: {
                    return new Property("rank", "positiveInt", "Ranking of the diagnosis (for each role type).", 0, 1, this.rank);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.condition;
                    }
                    return baseArray;
                }
                case 116103: {
                    Base[] baseArray;
                    if (this.use == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.use;
                    }
                    return baseArray;
                }
                case 3492908: {
                    Base[] baseArray;
                    if (this.rank == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.rank;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    this.condition = TypeConvertor.castToReference(value);
                    return value;
                }
                case 116103: {
                    this.use = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case 3492908: {
                    this.rank = TypeConvertor.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("condition")) {
                this.condition = TypeConvertor.castToReference(value);
            } else if (name.equals("use")) {
                this.use = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("rank")) {
                this.rank = TypeConvertor.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return this.getCondition();
                }
                case 116103: {
                    return this.getUse();
                }
                case 3492908: {
                    return this.getRankElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return new String[]{"Reference"};
                }
                case 116103: {
                    return new String[]{"CodeableConcept"};
                }
                case 3492908: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("condition")) {
                this.condition = new Reference();
                return this.condition;
            }
            if (name.equals("use")) {
                this.use = new CodeableConcept();
                return this.use;
            }
            if (name.equals("rank")) {
                throw new FHIRException("Cannot call addChild on a primitive type Encounter.diagnosis.rank");
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(DiagnosisComponent dst) {
            super.copyValues(dst);
            dst.condition = this.condition == null ? null : this.condition.copy();
            dst.use = this.use == null ? null : this.use.copy();
            dst.rank = this.rank == null ? null : this.rank.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.condition, o.condition, true) && DiagnosisComponent.compareDeep(this.use, o.use, true) && DiagnosisComponent.compareDeep(this.rank, o.rank, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareValues(this.rank, o.rank, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.condition, this.use, this.rank);
        }

        @Override
        public String fhirType() {
            return "Encounter.diagnosis";
        }
    }

    @Block
    public static class EncounterParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Role of participant in encounter", formalDefinition="Role of participant in encounter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
        protected List<CodeableConcept> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period of time during the encounter that the participant participated", formalDefinition="The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.")
        protected Period period;
        @Child(name="individual", type={Practitioner.class, PractitionerRole.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Persons involved in the encounter other than the patient", formalDefinition="Persons involved in the encounter other than the patient.")
        protected Reference individual;
        private static final long serialVersionUID = -678291961L;

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public EncounterParticipantComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public EncounterParticipantComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterParticipantComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterParticipantComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public Reference getIndividual() {
            if (this.individual == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterParticipantComponent.individual");
                }
                if (Configuration.doAutoCreate()) {
                    this.individual = new Reference();
                }
            }
            return this.individual;
        }

        public boolean hasIndividual() {
            return this.individual != null && !this.individual.isEmpty();
        }

        public EncounterParticipantComponent setIndividual(Reference value) {
            this.individual = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_TYPE, "CodeableConcept", "Role of participant in encounter.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("period", "Period", "The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.", 0, 1, this.period));
            children.add(new Property("individual", "Reference(Practitioner|PractitionerRole|RelatedPerson)", "Persons involved in the encounter other than the patient.", 0, 1, this.individual));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Encounter.SP_TYPE, "CodeableConcept", "Role of participant in encounter.", 0, Integer.MAX_VALUE, this.type);
                }
                case -991726143: {
                    return new Property("period", "Period", "The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.", 0, 1, this.period);
                }
                case -46292327: {
                    return new Property("individual", "Reference(Practitioner|PractitionerRole|RelatedPerson)", "Persons involved in the encounter other than the patient.", 0, 1, this.individual);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.period;
                    }
                    return baseArray;
                }
                case -46292327: {
                    Base[] baseArray;
                    if (this.individual == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.individual;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(TypeConvertor.castToCodeableConcept(value));
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
                case -46292327: {
                    this.individual = TypeConvertor.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                this.getType().add(TypeConvertor.castToCodeableConcept(value));
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else if (name.equals("individual")) {
                this.individual = TypeConvertor.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case -46292327: {
                    return this.getIndividual();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -46292327: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                return this.addType();
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("individual")) {
                this.individual = new Reference();
                return this.individual;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterParticipantComponent copy() {
            EncounterParticipantComponent dst = new EncounterParticipantComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(EncounterParticipantComponent dst) {
            super.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.type) {
                    dst.type.add(i2.copy());
                }
            }
            dst.period = this.period == null ? null : this.period.copy();
            dst.individual = this.individual == null ? null : this.individual.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterParticipantComponent)) {
                return false;
            }
            EncounterParticipantComponent o = (EncounterParticipantComponent)other_;
            return EncounterParticipantComponent.compareDeep(this.type, o.type, true) && EncounterParticipantComponent.compareDeep(this.period, o.period, true) && EncounterParticipantComponent.compareDeep(this.individual, o.individual, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterParticipantComponent)) {
                return false;
            }
            EncounterParticipantComponent o = (EncounterParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.period, this.individual);
        }

        @Override
        public String fhirType() {
            return "Encounter.participant";
        }
    }

    @Block
    public static class ClassHistoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="class", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="inpatient | outpatient | ambulatory | emergency +", formalDefinition="inpatient | outpatient | ambulatory | emergency +.")
        @Binding(valueSet="http://terminology.hl7.org/ValueSet/v3-ActEncounterCode")
        protected Coding class_;
        @Child(name="period", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The time that the episode was in the specified class", formalDefinition="The time that the episode was in the specified class.")
        protected Period period;
        private static final long serialVersionUID = 1331020311L;

        public ClassHistoryComponent() {
        }

        public ClassHistoryComponent(Coding class_, Period period) {
            this.setClass_(class_);
            this.setPeriod(period);
        }

        public Coding getClass_() {
            if (this.class_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassHistoryComponent.class_");
                }
                if (Configuration.doAutoCreate()) {
                    this.class_ = new Coding();
                }
            }
            return this.class_;
        }

        public boolean hasClass_() {
            return this.class_ != null && !this.class_.isEmpty();
        }

        public ClassHistoryComponent setClass_(Coding value) {
            this.class_ = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassHistoryComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ClassHistoryComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_CLASS, "Coding", "inpatient | outpatient | ambulatory | emergency +.", 0, 1, this.class_));
            children.add(new Property("period", "Period", "The time that the episode was in the specified class.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 94742904: {
                    return new Property(Encounter.SP_CLASS, "Coding", "inpatient | outpatient | ambulatory | emergency +.", 0, 1, this.class_);
                }
                case -991726143: {
                    return new Property("period", "Period", "The time that the episode was in the specified class.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 94742904: {
                    Base[] baseArray;
                    if (this.class_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.class_;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 94742904: {
                    this.class_ = TypeConvertor.castToCoding(value);
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_CLASS)) {
                this.class_ = TypeConvertor.castToCoding(value);
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742904: {
                    return this.getClass_();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742904: {
                    return new String[]{"Coding"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_CLASS)) {
                this.class_ = new Coding();
                return this.class_;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public ClassHistoryComponent copy() {
            ClassHistoryComponent dst = new ClassHistoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(ClassHistoryComponent dst) {
            super.copyValues(dst);
            dst.class_ = this.class_ == null ? null : this.class_.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClassHistoryComponent)) {
                return false;
            }
            ClassHistoryComponent o = (ClassHistoryComponent)other_;
            return ClassHistoryComponent.compareDeep(this.class_, o.class_, true) && ClassHistoryComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClassHistoryComponent)) {
                return false;
            }
            ClassHistoryComponent o = (ClassHistoryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.class_, this.period);
        }

        @Override
        public String fhirType() {
            return "Encounter.classHistory";
        }
    }

    @Block
    public static class StatusHistoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown", formalDefinition="planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-status")
        protected Enumeration<EncounterStatus> status;
        @Child(name="period", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The time that the episode was in the specified status", formalDefinition="The time that the episode was in the specified status.")
        protected Period period;
        private static final long serialVersionUID = -1893906736L;

        public StatusHistoryComponent() {
        }

        public StatusHistoryComponent(EncounterStatus status, Period period) {
            this.setStatus(status);
            this.setPeriod(period);
        }

        public Enumeration<EncounterStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatusHistoryComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EncounterStatus>(new EncounterStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public StatusHistoryComponent setStatusElement(Enumeration<EncounterStatus> value) {
            this.status = value;
            return this;
        }

        public EncounterStatus getStatus() {
            return this.status == null ? null : (EncounterStatus)((Object)this.status.getValue());
        }

        public StatusHistoryComponent setStatus(EncounterStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<EncounterStatus>(new EncounterStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatusHistoryComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public StatusHistoryComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_STATUS, "code", "planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown.", 0, 1, this.status));
            children.add(new Property("period", "Period", "The time that the episode was in the specified status.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property(Encounter.SP_STATUS, "code", "planned | in-progress | onhold | completed | cancelled | entered-in-error | unknown.", 0, 1, this.status);
                }
                case -991726143: {
                    return new Property("period", "Period", "The time that the episode was in the specified status.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    value = new EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                    this.status = value;
                    return value;
                }
                case -991726143: {
                    this.period = TypeConvertor.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_STATUS)) {
                value = new EncounterStatusEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.status = value;
            } else if (name.equals("period")) {
                this.period = TypeConvertor.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatusElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type Encounter.statusHistory.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public StatusHistoryComponent copy() {
            StatusHistoryComponent dst = new StatusHistoryComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(StatusHistoryComponent dst) {
            super.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatusHistoryComponent)) {
                return false;
            }
            StatusHistoryComponent o = (StatusHistoryComponent)other_;
            return StatusHistoryComponent.compareDeep(this.status, o.status, true) && StatusHistoryComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatusHistoryComponent)) {
                return false;
            }
            StatusHistoryComponent o = (StatusHistoryComponent)other_;
            return StatusHistoryComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.status, this.period);
        }

        @Override
        public String fhirType() {
            return "Encounter.statusHistory";
        }
    }

    public static class EncounterStatusEnumFactory
    implements EnumFactory<EncounterStatus> {
        @Override
        public EncounterStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EncounterStatus.PLANNED;
            }
            if ("in-progress".equals(codeString)) {
                return EncounterStatus.INPROGRESS;
            }
            if ("onhold".equals(codeString)) {
                return EncounterStatus.ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return EncounterStatus.COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return EncounterStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return EncounterStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return EncounterStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown EncounterStatus code '" + codeString + "'");
        }

        public Enumeration<EncounterStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EncounterStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.PLANNED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.INPROGRESS);
            }
            if ("onhold".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.ONHOLD);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.COMPLETED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown EncounterStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EncounterStatus code) {
            if (code == EncounterStatus.PLANNED) {
                return "planned";
            }
            if (code == EncounterStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == EncounterStatus.ONHOLD) {
                return "onhold";
            }
            if (code == EncounterStatus.COMPLETED) {
                return "completed";
            }
            if (code == EncounterStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EncounterStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == EncounterStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(EncounterStatus code) {
            return code.getSystem();
        }
    }

    public static enum EncounterStatus {
        PLANNED,
        INPROGRESS,
        ONHOLD,
        COMPLETED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static EncounterStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("onhold".equals(codeString)) {
                return ONHOLD;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EncounterStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONHOLD: {
                    return "onhold";
                }
                case COMPLETED: {
                    return "completed";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case ONHOLD: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/encounter-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The Encounter has not yet started.";
                }
                case INPROGRESS: {
                    return "The Encounter has begun and the patient is present / the practitioner and the patient are meeting.";
                }
                case ONHOLD: {
                    return "The Encounter has begun, but is currently on hold, e.g. because the patient is temporarily on leave.";
                }
                case COMPLETED: {
                    return "The Encounter has ended.";
                }
                case CANCELLED: {
                    return "The Encounter has ended before it has begun.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case UNKNOWN: {
                    return "The encounter status is unknown. Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONHOLD: {
                    return "On Hold";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
            }
            return "?";
        }
    }

    public static class EncounterLocationStatusEnumFactory
    implements EnumFactory<EncounterLocationStatus> {
        @Override
        public EncounterLocationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EncounterLocationStatus.PLANNED;
            }
            if ("active".equals(codeString)) {
                return EncounterLocationStatus.ACTIVE;
            }
            if ("reserved".equals(codeString)) {
                return EncounterLocationStatus.RESERVED;
            }
            if ("completed".equals(codeString)) {
                return EncounterLocationStatus.COMPLETED;
            }
            throw new IllegalArgumentException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        public Enumeration<EncounterLocationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EncounterLocationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.PLANNED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.ACTIVE);
            }
            if ("reserved".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.RESERVED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.COMPLETED);
            }
            throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EncounterLocationStatus code) {
            if (code == EncounterLocationStatus.PLANNED) {
                return "planned";
            }
            if (code == EncounterLocationStatus.ACTIVE) {
                return "active";
            }
            if (code == EncounterLocationStatus.RESERVED) {
                return "reserved";
            }
            if (code == EncounterLocationStatus.COMPLETED) {
                return "completed";
            }
            return "?";
        }

        @Override
        public String toSystem(EncounterLocationStatus code) {
            return code.getSystem();
        }
    }

    public static enum EncounterLocationStatus {
        PLANNED,
        ACTIVE,
        RESERVED,
        COMPLETED,
        NULL;


        public static EncounterLocationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("reserved".equals(codeString)) {
                return RESERVED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case ACTIVE: {
                    return "active";
                }
                case RESERVED: {
                    return "reserved";
                }
                case COMPLETED: {
                    return "completed";
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case RESERVED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The patient is planned to be moved to this location at some point in the future.";
                }
                case ACTIVE: {
                    return "The patient is currently at this location, or was between the period specified.\r\rA system may update these records when the patient leaves the location to either reserved, or completed.";
                }
                case RESERVED: {
                    return "This location is held empty for this patient.";
                }
                case COMPLETED: {
                    return "The patient was at this location during the period specified.\r\rNot to be used when the patient is currently at the location.";
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case ACTIVE: {
                    return "Active";
                }
                case RESERVED: {
                    return "Reserved";
                }
                case COMPLETED: {
                    return "Completed";
                }
            }
            return "?";
        }
    }
}

