/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class Base
implements Serializable,
IBase,
IElement {
    private Map<String, Object> userData;
    private List<String> formatCommentsPre;
    private List<String> formatCommentsPost;

    @Override
    public Object getUserData(String name) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(name);
    }

    @Override
    public void setUserData(String name, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(name, value);
    }

    public void clearUserData(String name) {
        if (this.userData != null) {
            this.userData.remove(name);
        }
    }

    public void setUserDataINN(String name, Object value) {
        if (value == null) {
            return;
        }
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(name, value);
    }

    public boolean hasUserData(String name) {
        if (this.userData == null) {
            return false;
        }
        return this.userData.containsKey(name);
    }

    public String getUserString(String name) {
        Object ud = this.getUserData(name);
        if (ud == null) {
            return null;
        }
        if (ud instanceof String) {
            return (String)ud;
        }
        return ud.toString();
    }

    public int getUserInt(String name) {
        if (!this.hasUserData(name)) {
            return 0;
        }
        return (Integer)this.getUserData(name);
    }

    public void copyUserData(Base other) {
        if (other.userData != null) {
            if (this.userData == null) {
                this.userData = new HashMap<String, Object>();
            }
            this.userData.putAll(other.userData);
        }
    }

    @Override
    public boolean hasFormatComment() {
        return this.formatCommentsPre != null && !this.formatCommentsPre.isEmpty() || this.formatCommentsPost != null && !this.formatCommentsPost.isEmpty();
    }

    @Override
    public List<String> getFormatCommentsPre() {
        if (this.formatCommentsPre == null) {
            this.formatCommentsPre = new ArrayList<String>();
        }
        return this.formatCommentsPre;
    }

    @Override
    public List<String> getFormatCommentsPost() {
        if (this.formatCommentsPost == null) {
            this.formatCommentsPost = new ArrayList<String>();
        }
        return this.formatCommentsPost;
    }

    public boolean isPrimitive() {
        return false;
    }

    public boolean isBooleanPrimitive() {
        return false;
    }

    public boolean hasPrimitiveValue() {
        return this.isPrimitive();
    }

    public String primitiveValue() {
        return null;
    }

    public boolean isDateTime() {
        return false;
    }

    public BaseDateTimeType dateTimeValue() {
        return null;
    }

    @Override
    public abstract String fhirType();

    public boolean hasType(String ... name) {
        String t = this.fhirType();
        for (String n : name) {
            if (!n.equalsIgnoreCase(t)) continue;
            return true;
        }
        return false;
    }

    protected void listChildren(List<Property> result) {
    }

    public Base setProperty(String name, Base value) throws FHIRException {
        throw new FHIRException("Attempt to set unknown property " + name);
    }

    public Base addChild(String name) throws FHIRException {
        throw new FHIRException("Attempt to add child with unknown name " + name);
    }

    public List<Property> children() {
        ArrayList<Property> result = new ArrayList<Property>();
        this.listChildren(result);
        return result;
    }

    public Property getChildByName(String name) {
        ArrayList<Property> children = new ArrayList<Property>();
        this.listChildren(children);
        for (Property c : children) {
            if (!c.getName().equals(name) && !c.getName().equals(name + "[x]")) continue;
            return c;
        }
        return null;
    }

    public List<Base> listChildrenByName(String name) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base b : this.listChildrenByName(name, true)) {
            if (b == null) continue;
            result.add(b);
        }
        return result;
    }

    public Base[] listChildrenByName(String name, boolean checkValid) throws FHIRException {
        if (name.equals("*")) {
            ArrayList<Property> children = new ArrayList<Property>();
            this.listChildren(children);
            ArrayList<Base> result = new ArrayList<Base>();
            for (Property c : children) {
                result.addAll(c.getValues());
            }
            return result.toArray(new Base[result.size()]);
        }
        return this.getProperty(name.hashCode(), name, checkValid);
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    public boolean equalsDeep(Base other) {
        return other != null;
    }

    public boolean equalsShallow(Base other) {
        return other != null;
    }

    public static boolean compareDeep(String s1, String s2, boolean allowNull) {
        if (allowNull) {
            boolean noRight;
            boolean noLeft = s1 == null || Utilities.noString(s1);
            boolean bl = noRight = s2 == null || Utilities.noString(s2);
            if (noLeft && noRight) {
                return true;
            }
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    public static boolean compareDeep(List<? extends Base> e1, List<? extends Base> e2, boolean allowNull) {
        if (Base.noList(e1) && Base.noList(e2) && allowNull) {
            return true;
        }
        if (Base.noList(e1) || Base.noList(e2)) {
            return false;
        }
        if (e1.size() != e2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < e1.size(); ++i2) {
            if (Base.compareDeep(e1.get(i2), e2.get(i2), allowNull)) continue;
            return false;
        }
        return true;
    }

    private static boolean noList(List<? extends Base> list) {
        return list == null || list.isEmpty() || list.size() == 1 && list.get(0).isEmpty();
    }

    public static boolean compareDeep(Base e1, Base e2, boolean allowNull) {
        if (allowNull) {
            boolean noRight;
            boolean noLeft = e1 == null || e1.isEmpty();
            boolean bl = noRight = e2 == null || e2.isEmpty();
            if (noLeft && noRight) {
                return true;
            }
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e2.isMetadataBased() && !e1.isMetadataBased()) {
            return e2.equalsDeep(e1);
        }
        return e1.equalsDeep(e2);
    }

    public static boolean compareDeep(XhtmlNode div1, XhtmlNode div2, boolean allowNull) {
        if (div1 == null && div2 == null && allowNull) {
            return true;
        }
        if (div1 == null || div2 == null) {
            return false;
        }
        return div1.equalsDeep(div2);
    }

    public static boolean compareValues(List<? extends PrimitiveType> e1, List<? extends PrimitiveType> e2, boolean allowNull) {
        if (e1 == null && e2 == null && allowNull) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        if (e1.size() != e2.size()) {
            return false;
        }
        for (int i2 = 0; i2 < e1.size(); ++i2) {
            if (Base.compareValues(e1.get(i2), e2.get(i2), allowNull)) continue;
            return false;
        }
        return true;
    }

    public static boolean compareValues(PrimitiveType e1, PrimitiveType e2, boolean allowNull) {
        boolean noRight;
        boolean noLeft = e1 == null || e1.isEmpty();
        boolean bl = noRight = e2 == null || e2.isEmpty();
        if (noLeft && noRight && allowNull) {
            return true;
        }
        if (noLeft != noRight) {
            return false;
        }
        return e1.equalsShallow(e2);
    }

    protected boolean isMetadataBased() {
        return false;
    }

    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        if (checkValid) {
            throw new FHIRException("Attempt to read invalid property '" + name + "' on type " + this.fhirType());
        }
        return null;
    }

    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        throw new FHIRException("Attempt to write to invalid property '" + name + "' on type " + this.fhirType());
    }

    public Base makeProperty(int hash, String name) throws FHIRException {
        throw new FHIRException("Attempt to make an invalid property '" + name + "' on type " + this.fhirType());
    }

    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        throw new FHIRException("Attempt to get types for an invalid property '" + name + "' on type " + this.fhirType());
    }

    public static boolean equals(String v1, String v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 == null || v2 == null) {
            return false;
        }
        return v1.equals(v2);
    }

    public boolean isResource() {
        return false;
    }

    public abstract String getIdBase();

    public abstract void setIdBase(String var1);

    public Property getNamedProperty(String _name) throws FHIRException {
        return this.getNamedProperty(_name.hashCode(), _name, false);
    }

    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        if (_checkValid) {
            throw new FHIRException("Attempt to read invalid property '" + _name + "' on type " + this.fhirType());
        }
        return null;
    }

    public void copyValues(Base dst) {
    }

    public XhtmlNode getXhtml() {
        return null;
    }
}

