/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.MetadataResource;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.utilities.Utilities;

public class Unbundler {
    public static void main(String[] args2) throws Exception {
        Unbundler.unbundle(args2[0]);
    }

    private static void unbundle(String src) throws FHIRFormatError, FileNotFoundException, IOException {
        String folder = Utilities.getDirectoryForFile(src);
        Bundle bnd = (Bundle)new JsonParser().parse(new FileInputStream(src));
        for (Bundle.BundleEntryComponent be : bnd.getEntry()) {
            String tgt;
            Resource r = be.getResource();
            if (r == null) continue;
            if (StringUtils.isBlank((CharSequence)r.getId()) && r instanceof MetadataResource) {
                r.setId(Unbundler.tail((MetadataResource)r));
            }
            if (StringUtils.isBlank((CharSequence)r.getId()) || new File(tgt = Utilities.path(folder, r.fhirType() + "-" + r.getId() + ".json")).exists()) continue;
            new JsonParser().compose(new FileOutputStream(tgt), r);
        }
    }

    private static String tail(MetadataResource r) {
        return r.getUrl().contains("/") ? r.getUrl().substring(r.getUrl().lastIndexOf("/") + 1) : null;
    }
}

