/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r4.context.IWorkerContext;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.StructureDefinition;

public class DefinitionNavigator {
    private IWorkerContext context;
    private StructureDefinition structure;
    private int index;
    private List<DefinitionNavigator> children;
    private List<DefinitionNavigator> typeChildren;
    private List<DefinitionNavigator> slices;
    private List<String> names = new ArrayList<String>();
    private ElementDefinition.TypeRefComponent typeOfChildren;
    private String path;

    public DefinitionNavigator(IWorkerContext context, StructureDefinition structure) throws DefinitionException {
        if (!structure.hasSnapshot()) {
            throw new DefinitionException("Snapshot required");
        }
        this.context = context;
        this.structure = structure;
        this.index = 0;
        this.path = this.current().getPath();
        this.names.add(this.nameTail());
    }

    private DefinitionNavigator(IWorkerContext context, StructureDefinition structure, int index, String path, List<String> names, String type) {
        this.path = path;
        this.context = context;
        this.structure = structure;
        this.index = index;
        if (type == null) {
            for (String name : names) {
                this.names.add(name + "." + this.nameTail());
            }
        } else {
            this.names.addAll(names);
            this.names.add(type);
        }
    }

    public List<String> getNames() {
        return this.names;
    }

    public ElementDefinition current() {
        return this.structure.getSnapshot().getElement().get(this.index);
    }

    public List<DefinitionNavigator> slices() throws DefinitionException {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.slices;
    }

    public List<DefinitionNavigator> children() throws DefinitionException {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.children;
    }

    private void loadChildren() throws DefinitionException {
        this.children = new ArrayList<DefinitionNavigator>();
        String prefix = this.current().getPath() + ".";
        HashMap<String, DefinitionNavigator> nameMap = new HashMap<String, DefinitionNavigator>();
        for (int i2 = this.index + 1; i2 < this.structure.getSnapshot().getElement().size(); ++i2) {
            String path = this.structure.getSnapshot().getElement().get(i2).getPath();
            if (path.startsWith(prefix) && !path.substring(prefix.length()).contains(".")) {
                DefinitionNavigator dn = new DefinitionNavigator(this.context, this.structure, i2, this.path + "." + this.tail(path), this.names, null);
                if (nameMap.containsKey(path)) {
                    DefinitionNavigator master = (DefinitionNavigator)nameMap.get(path);
                    if (!master.current().hasSlicing()) {
                        throw new DefinitionException("Found slices with no slicing details at " + dn.current().getPath());
                    }
                    if (master.slices == null) {
                        master.slices = new ArrayList<DefinitionNavigator>();
                    }
                    master.slices.add(dn);
                    continue;
                }
                nameMap.put(path, dn);
                this.children.add(dn);
                continue;
            }
            if (path.length() < prefix.length()) break;
        }
    }

    public String path() {
        return this.path;
    }

    private String tail(String p) {
        if (p.contains(".")) {
            return p.substring(p.lastIndexOf(46) + 1);
        }
        return p;
    }

    public String nameTail() {
        return this.tail(this.path);
    }

    public boolean hasTypeChildren(ElementDefinition.TypeRefComponent type) throws DefinitionException {
        if (this.typeChildren == null || this.typeOfChildren != type) {
            this.loadTypedChildren(type);
        }
        return !this.typeChildren.isEmpty();
    }

    private void loadTypedChildren(ElementDefinition.TypeRefComponent type) throws DefinitionException {
        this.typeOfChildren = null;
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, type.getWorkingCode());
        if (sd == null) {
            throw new DefinitionException("Unable to find definition for " + type.getWorkingCode() + (type.hasProfile() ? "(" + type.getProfile() + ")" : ""));
        }
        DefinitionNavigator dn = new DefinitionNavigator(this.context, sd, 0, this.path, this.names, sd.getType());
        this.typeChildren = dn.children();
        this.typeOfChildren = type;
    }

    public List<DefinitionNavigator> childrenFromType(ElementDefinition.TypeRefComponent type) throws DefinitionException {
        if (this.typeChildren == null || this.typeOfChildren != type) {
            this.loadTypedChildren(type);
        }
        return this.typeChildren;
    }
}

