/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DefinitionUse {
    FHIRSTRUCTURE,
    CUSTOMRESOURCE,
    DAM,
    WIREFORMAT,
    ARCHETYPE,
    TEMPLATE,
    NULL;


    public static DefinitionUse fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fhir-structure".equals(codeString)) {
            return FHIRSTRUCTURE;
        }
        if ("custom-resource".equals(codeString)) {
            return CUSTOMRESOURCE;
        }
        if ("dam".equals(codeString)) {
            return DAM;
        }
        if ("wire-format".equals(codeString)) {
            return WIREFORMAT;
        }
        if ("archetype".equals(codeString)) {
            return ARCHETYPE;
        }
        if ("template".equals(codeString)) {
            return TEMPLATE;
        }
        throw new FHIRException("Unknown DefinitionUse code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FHIRSTRUCTURE: {
                return "fhir-structure";
            }
            case CUSTOMRESOURCE: {
                return "custom-resource";
            }
            case DAM: {
                return "dam";
            }
            case WIREFORMAT: {
                return "wire-format";
            }
            case ARCHETYPE: {
                return "archetype";
            }
            case TEMPLATE: {
                return "template";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/definition-use";
    }

    public String getDefinition() {
        switch (this) {
            case FHIRSTRUCTURE: {
                return "This structure is defined as part of the base FHIR Specification";
            }
            case CUSTOMRESOURCE: {
                return "This structure is intended to be treated like a FHIR resource (e.g. on the FHIR API)";
            }
            case DAM: {
                return "This structure captures an analysis of a domain";
            }
            case WIREFORMAT: {
                return "This structure represents and existing structure (e.g. CDA, HL7 v2)";
            }
            case ARCHETYPE: {
                return "This structure captures an analysis of a domain";
            }
            case TEMPLATE: {
                return "This structure is a template (n.b: 'template' has many meanings)";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FHIRSTRUCTURE: {
                return "FHIR Structure";
            }
            case CUSTOMRESOURCE: {
                return "Custom Resource";
            }
            case DAM: {
                return "Domain Analysis Model";
            }
            case WIREFORMAT: {
                return "Wire Format";
            }
            case ARCHETYPE: {
                return "Domain Analysis Model";
            }
            case TEMPLATE: {
                return "Template";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

