/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum TypeDerivationRule {
    SPECIALIZATION,
    CONSTRAINT,
    NULL;


    public static TypeDerivationRule fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("specialization".equals(codeString)) {
            return SPECIALIZATION;
        }
        if ("constraint".equals(codeString)) {
            return CONSTRAINT;
        }
        throw new FHIRException("Unknown TypeDerivationRule code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SPECIALIZATION: {
                return "specialization";
            }
            case CONSTRAINT: {
                return "constraint";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/type-derivation-rule";
    }

    public String getDefinition() {
        switch (this) {
            case SPECIALIZATION: {
                return "This definition defines a new type that adds additional elements to the base type";
            }
            case CONSTRAINT: {
                return "This definition adds additional rules to an existing concrete type";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SPECIALIZATION: {
                return "Specialization";
            }
            case CONSTRAINT: {
                return "Constraint";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

