/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConstraintSeverity {
    ERROR,
    WARNING,
    NULL;


    public static ConstraintSeverity fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("error".equals(codeString)) {
            return ERROR;
        }
        if ("warning".equals(codeString)) {
            return WARNING;
        }
        throw new FHIRException("Unknown ConstraintSeverity code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ERROR: {
                return "error";
            }
            case WARNING: {
                return "warning";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/constraint-severity";
    }

    public String getDefinition() {
        switch (this) {
            case ERROR: {
                return "If the constraint is violated, the resource is not conformant.";
            }
            case WARNING: {
                return "If the constraint is violated, the resource is conformant, but it is not necessarily following best practice.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ERROR: {
                return "Error";
            }
            case WARNING: {
                return "Warning";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

