/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AllergyIntoleranceStatus {
    ACTIVE,
    ACTIVECONFIRMED,
    INACTIVE,
    RESOLVED,
    REFUTED,
    ENTEREDINERROR,
    NULL;


    public static AllergyIntoleranceStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("active-confirmed".equals(codeString)) {
            return ACTIVECONFIRMED;
        }
        if ("inactive".equals(codeString)) {
            return INACTIVE;
        }
        if ("resolved".equals(codeString)) {
            return RESOLVED;
        }
        if ("refuted".equals(codeString)) {
            return REFUTED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown AllergyIntoleranceStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIVE: {
                return "active";
            }
            case ACTIVECONFIRMED: {
                return "active-confirmed";
            }
            case INACTIVE: {
                return "inactive";
            }
            case RESOLVED: {
                return "resolved";
            }
            case REFUTED: {
                return "refuted";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/allergy-intolerance-status";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIVE: {
                return "An active record of a risk of a reaction to the identified substance.";
            }
            case ACTIVECONFIRMED: {
                return "A high level of certainty about the propensity for a reaction to the identified substance, which may include clinical evidence by testing or rechallenge.";
            }
            case INACTIVE: {
                return "An inactivated record of a risk of a reaction to the identified substance";
            }
            case RESOLVED: {
                return "A reaction to the identified substance has been clinically reassessed by testing or re-exposure and considered to be resolved";
            }
            case REFUTED: {
                return "A propensity for a reaction to the identified substance has been disproven with a high level of clinical certainty, which may include testing or rechallenge, and is refuted.";
            }
            case ENTEREDINERROR: {
                return "The statement was entered in error and is not valid.";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIVE: {
                return "Active";
            }
            case ACTIVECONFIRMED: {
                return "Active Confirmed";
            }
            case INACTIVE: {
                return "Inactive";
            }
            case RESOLVED: {
                return "Resolved";
            }
            case REFUTED: {
                return "Refuted";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

