/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.dstu3.model.ValueSet;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="StructureDefinition", profile="http://hl7.org/fhir/Profile/StructureDefinition")
@ChildOrder(names={"url", "identifier", "version", "name", "title", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "copyright", "keyword", "fhirVersion", "mapping", "kind", "abstract", "contextType", "context", "contextInvariant", "type", "baseDefinition", "derivation", "snapshot", "differential"})
public class StructureDefinition
extends MetadataResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Additional identifier for the structure definition", formalDefinition="A formal identifier that is used to identify this structure definition when it is represented in other formats, or referenced in a specification, model, design or an instance.")
    protected List<Identifier> identifier;
    @Child(name="purpose", type={MarkdownType.class}, order=1, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this structure definition is defined", formalDefinition="Explaination of why this structure definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="copyright", type={MarkdownType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the structure definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the structure definition.")
    protected MarkdownType copyright;
    @Child(name="keyword", type={Coding.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Assist with indexing and finding", formalDefinition="A set of key words or terms from external terminologies that may be used to assist with indexing and searching of templates.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/profile-code")
    protected List<Coding> keyword;
    @Child(name="fhirVersion", type={IdType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version this StructureDefinition targets", formalDefinition="The version of the FHIR specification on which this StructureDefinition is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.0.2 for this version.")
    protected IdType fhirVersion;
    @Child(name="mapping", type={}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="External specification that the content is mapped to", formalDefinition="An external specification that the content is mapped to.")
    protected List<StructureDefinitionMappingComponent> mapping;
    @Child(name="kind", type={CodeType.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="primitive-type | complex-type | resource | logical", formalDefinition="Defines the kind of structure that this definition is describing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/structure-definition-kind")
    protected Enumeration<StructureDefinitionKind> kind;
    @Child(name="abstract", type={BooleanType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Whether the structure is abstract", formalDefinition="Whether structure this definition describes is abstract or not  - that is, whether the structure is not intended to be instantiated. For Resources and Data types, abstract types will never be exchanged  between systems.")
    protected BooleanType abstract_;
    @Child(name="contextType", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="resource | datatype | extension", formalDefinition="If this is an extension, Identifies the context within FHIR resources where the extension can be used.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/extension-context")
    protected Enumeration<ExtensionContext> contextType;
    @Child(name="context", type={StringType.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Where the extension can be used in instances", formalDefinition="Identifies the types of resource or data type elements to which the extension can be applied.")
    protected List<StringType> context;
    @Child(name="contextInvariant", type={StringType.class}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="FHIRPath invariants - when the extension can be used", formalDefinition="A set of rules as Fluent Invariants about when the extension can be used (e.g. co-occurrence variants for the extension).")
    protected List<StringType> contextInvariant;
    @Child(name="type", type={CodeType.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Type defined or constrained by this structure", formalDefinition="The type this structure describes. If the derivation kind is 'specialization' then this is the master definition for a type, and there is always one of these (a data type, an extension, a resource, including abstract ones). Otherwise the structure definition is a constraint on the stated type (and in this case, the type cannot be an abstract type).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/defined-types")
    protected CodeType type;
    @Child(name="baseDefinition", type={UriType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Definition that this type is constrained/specialized from", formalDefinition="An absolute URI that is the base structure from which this type is derived, either by specialization or constraint.")
    protected UriType baseDefinition;
    @Child(name="derivation", type={CodeType.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="specialization | constraint - How relates to base definition", formalDefinition="How the type relates to the baseDefinition.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/type-derivation-rule")
    protected Enumeration<TypeDerivationRule> derivation;
    @Child(name="snapshot", type={}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Snapshot view of the structure", formalDefinition="A snapshot view is expressed in a stand alone form that can be used and interpreted without considering the base StructureDefinition.")
    protected StructureDefinitionSnapshotComponent snapshot;
    @Child(name="differential", type={}, order=15, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Differential view of the structure", formalDefinition="A differential view is expressed relative to the base StructureDefinition - a statement of differences that it applies.")
    protected StructureDefinitionDifferentialComponent differential;
    private static final long serialVersionUID = -1511739381L;
    @SearchParamDefinition(name="date", path="StructureDefinition.date", description="The structure definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="StructureDefinition.identifier", description="External identifier for the structure definition", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="valueset", path="StructureDefinition.snapshot.element.binding.valueSet", description="A vocabulary binding reference", type="reference", target={ValueSet.class})
    public static final String SP_VALUESET = "valueset";
    public static final ReferenceClientParam VALUESET = new ReferenceClientParam("valueset");
    public static final Include INCLUDE_VALUESET = new Include("StructureDefinition:valueset").toLocked();
    @SearchParamDefinition(name="kind", path="StructureDefinition.kind", description="primitive-type | complex-type | resource | logical", type="token")
    public static final String SP_KIND = "kind";
    public static final TokenClientParam KIND = new TokenClientParam("kind");
    @SearchParamDefinition(name="jurisdiction", path="StructureDefinition.jurisdiction", description="Intended jurisdiction for the structure definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="description", path="StructureDefinition.description", description="The description of the structure definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="experimental", path="StructureDefinition.experimental", description="For testing purposes, not real usage", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="context-type", path="StructureDefinition.contextType", description="resource | datatype | extension", type="token")
    public static final String SP_CONTEXT_TYPE = "context-type";
    public static final TokenClientParam CONTEXT_TYPE = new TokenClientParam("context-type");
    @SearchParamDefinition(name="abstract", path="StructureDefinition.abstract", description="Whether the structure is abstract", type="token")
    public static final String SP_ABSTRACT = "abstract";
    public static final TokenClientParam ABSTRACT = new TokenClientParam("abstract");
    @SearchParamDefinition(name="title", path="StructureDefinition.title", description="The human-friendly name of the structure definition", type="string")
    public static final String SP_TITLE = "title";
    public static final StringClientParam TITLE = new StringClientParam("title");
    @SearchParamDefinition(name="type", path="StructureDefinition.type", description="Type defined or constrained by this structure", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="version", path="StructureDefinition.version", description="The business version of the structure definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="StructureDefinition.url", description="The uri that identifies the structure definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="path", path="StructureDefinition.snapshot.element.path | StructureDefinition.differential.element.path", description="A path that is constrained in the profile", type="token")
    public static final String SP_PATH = "path";
    public static final TokenClientParam PATH = new TokenClientParam("path");
    @SearchParamDefinition(name="ext-context", path="StructureDefinition.context", description="Where the extension can be used in instances", type="string")
    public static final String SP_EXT_CONTEXT = "ext-context";
    public static final StringClientParam EXT_CONTEXT = new StringClientParam("ext-context");
    @SearchParamDefinition(name="name", path="StructureDefinition.name", description="Computationally friendly name of the structure definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="base-path", path="StructureDefinition.snapshot.element.base.path | StructureDefinition.differential.element.base.path", description="Path that identifies the base element", type="token")
    public static final String SP_BASE_PATH = "base-path";
    public static final TokenClientParam BASE_PATH = new TokenClientParam("base-path");
    @SearchParamDefinition(name="publisher", path="StructureDefinition.publisher", description="Name of the publisher of the structure definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="derivation", path="StructureDefinition.derivation", description="specialization | constraint - How relates to base definition", type="token")
    public static final String SP_DERIVATION = "derivation";
    public static final TokenClientParam DERIVATION = new TokenClientParam("derivation");
    @SearchParamDefinition(name="keyword", path="StructureDefinition.keyword", description="A code for the profile", type="token")
    public static final String SP_KEYWORD = "keyword";
    public static final TokenClientParam KEYWORD = new TokenClientParam("keyword");
    @SearchParamDefinition(name="status", path="StructureDefinition.status", description="The current status of the structure definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="base", path="StructureDefinition.baseDefinition", description="Definition that this type is constrained/specialized from", type="uri")
    public static final String SP_BASE = "base";
    public static final UriClientParam BASE = new UriClientParam("base");

    public StructureDefinition() {
    }

    public StructureDefinition(UriType url, StringType name, Enumeration<Enumerations.PublicationStatus> status, Enumeration<StructureDefinitionKind> kind, BooleanType abstract_, CodeType type) {
        this.url = url;
        this.name = name;
        this.status = status;
        this.kind = kind;
        this.abstract_ = abstract_;
        this.type = type;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public StructureDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public StructureDefinition setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public StructureDefinition setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public StructureDefinition addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public StructureDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public StructureDefinition setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public StructureDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public StructureDefinition setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public StringType getTitleElement() {
        if (this.title == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.title");
            }
            if (Configuration.doAutoCreate()) {
                this.title = new StringType();
            }
        }
        return this.title;
    }

    @Override
    public boolean hasTitleElement() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public boolean hasTitle() {
        return this.title != null && !this.title.isEmpty();
    }

    @Override
    public StructureDefinition setTitleElement(StringType value) {
        this.title = value;
        return this;
    }

    @Override
    public String getTitle() {
        return this.title == null ? null : (String)this.title.getValue();
    }

    @Override
    public StructureDefinition setTitle(String value) {
        if (Utilities.noString(value)) {
            this.title = null;
        } else {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
        }
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public StructureDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public StructureDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public StructureDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public StructureDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public StructureDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public StructureDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public StructureDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public StructureDefinition setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public StructureDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public StructureDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public StructureDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public StructureDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public StructureDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public StructureDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public StructureDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public StructureDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public StructureDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public StructureDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public StructureDefinition setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public StructureDefinition setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public List<Coding> getKeyword() {
        if (this.keyword == null) {
            this.keyword = new ArrayList<Coding>();
        }
        return this.keyword;
    }

    public StructureDefinition setKeyword(List<Coding> theKeyword) {
        this.keyword = theKeyword;
        return this;
    }

    public boolean hasKeyword() {
        if (this.keyword == null) {
            return false;
        }
        for (Coding item : this.keyword) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addKeyword() {
        Coding t = new Coding();
        if (this.keyword == null) {
            this.keyword = new ArrayList<Coding>();
        }
        this.keyword.add(t);
        return t;
    }

    public StructureDefinition addKeyword(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.keyword == null) {
            this.keyword = new ArrayList<Coding>();
        }
        this.keyword.add(t);
        return this;
    }

    public Coding getKeywordFirstRep() {
        if (this.getKeyword().isEmpty()) {
            this.addKeyword();
        }
        return this.getKeyword().get(0);
    }

    public IdType getFhirVersionElement() {
        if (this.fhirVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.fhirVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirVersion = new IdType();
            }
        }
        return this.fhirVersion;
    }

    public boolean hasFhirVersionElement() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public boolean hasFhirVersion() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public StructureDefinition setFhirVersionElement(IdType value) {
        this.fhirVersion = value;
        return this;
    }

    public String getFhirVersion() {
        return this.fhirVersion == null ? null : this.fhirVersion.getValue();
    }

    public StructureDefinition setFhirVersion(String value) {
        if (Utilities.noString(value)) {
            this.fhirVersion = null;
        } else {
            if (this.fhirVersion == null) {
                this.fhirVersion = new IdType();
            }
            this.fhirVersion.setValue(value);
        }
        return this;
    }

    public List<StructureDefinitionMappingComponent> getMapping() {
        if (this.mapping == null) {
            this.mapping = new ArrayList<StructureDefinitionMappingComponent>();
        }
        return this.mapping;
    }

    public StructureDefinition setMapping(List<StructureDefinitionMappingComponent> theMapping) {
        this.mapping = theMapping;
        return this;
    }

    public boolean hasMapping() {
        if (this.mapping == null) {
            return false;
        }
        for (StructureDefinitionMappingComponent item : this.mapping) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StructureDefinitionMappingComponent addMapping() {
        StructureDefinitionMappingComponent t = new StructureDefinitionMappingComponent();
        if (this.mapping == null) {
            this.mapping = new ArrayList<StructureDefinitionMappingComponent>();
        }
        this.mapping.add(t);
        return t;
    }

    public StructureDefinition addMapping(StructureDefinitionMappingComponent t) {
        if (t == null) {
            return this;
        }
        if (this.mapping == null) {
            this.mapping = new ArrayList<StructureDefinitionMappingComponent>();
        }
        this.mapping.add(t);
        return this;
    }

    public StructureDefinitionMappingComponent getMappingFirstRep() {
        if (this.getMapping().isEmpty()) {
            this.addMapping();
        }
        return this.getMapping().get(0);
    }

    public Enumeration<StructureDefinitionKind> getKindElement() {
        if (this.kind == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.kind");
            }
            if (Configuration.doAutoCreate()) {
                this.kind = new Enumeration<StructureDefinitionKind>(new StructureDefinitionKindEnumFactory());
            }
        }
        return this.kind;
    }

    public boolean hasKindElement() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public boolean hasKind() {
        return this.kind != null && !this.kind.isEmpty();
    }

    public StructureDefinition setKindElement(Enumeration<StructureDefinitionKind> value) {
        this.kind = value;
        return this;
    }

    public StructureDefinitionKind getKind() {
        return this.kind == null ? null : (StructureDefinitionKind)((Object)this.kind.getValue());
    }

    public StructureDefinition setKind(StructureDefinitionKind value) {
        if (this.kind == null) {
            this.kind = new Enumeration<StructureDefinitionKind>(new StructureDefinitionKindEnumFactory());
        }
        this.kind.setValue((Object)value);
        return this;
    }

    public BooleanType getAbstractElement() {
        if (this.abstract_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.abstract_");
            }
            if (Configuration.doAutoCreate()) {
                this.abstract_ = new BooleanType();
            }
        }
        return this.abstract_;
    }

    public boolean hasAbstractElement() {
        return this.abstract_ != null && !this.abstract_.isEmpty();
    }

    public boolean hasAbstract() {
        return this.abstract_ != null && !this.abstract_.isEmpty();
    }

    public StructureDefinition setAbstractElement(BooleanType value) {
        this.abstract_ = value;
        return this;
    }

    public boolean getAbstract() {
        return this.abstract_ == null || this.abstract_.isEmpty() ? false : (Boolean)this.abstract_.getValue();
    }

    public StructureDefinition setAbstract(boolean value) {
        if (this.abstract_ == null) {
            this.abstract_ = new BooleanType();
        }
        this.abstract_.setValue((Object)value);
        return this;
    }

    public Enumeration<ExtensionContext> getContextTypeElement() {
        if (this.contextType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.contextType");
            }
            if (Configuration.doAutoCreate()) {
                this.contextType = new Enumeration<ExtensionContext>(new ExtensionContextEnumFactory());
            }
        }
        return this.contextType;
    }

    public boolean hasContextTypeElement() {
        return this.contextType != null && !this.contextType.isEmpty();
    }

    public boolean hasContextType() {
        return this.contextType != null && !this.contextType.isEmpty();
    }

    public StructureDefinition setContextTypeElement(Enumeration<ExtensionContext> value) {
        this.contextType = value;
        return this;
    }

    public ExtensionContext getContextType() {
        return this.contextType == null ? null : (ExtensionContext)((Object)this.contextType.getValue());
    }

    public StructureDefinition setContextType(ExtensionContext value) {
        if (value == null) {
            this.contextType = null;
        } else {
            if (this.contextType == null) {
                this.contextType = new Enumeration<ExtensionContext>(new ExtensionContextEnumFactory());
            }
            this.contextType.setValue((Object)value);
        }
        return this;
    }

    public List<StringType> getContext() {
        if (this.context == null) {
            this.context = new ArrayList<StringType>();
        }
        return this.context;
    }

    public StructureDefinition setContext(List<StringType> theContext) {
        this.context = theContext;
        return this;
    }

    public boolean hasContext() {
        if (this.context == null) {
            return false;
        }
        for (StringType item : this.context) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addContextElement() {
        StringType t = new StringType();
        if (this.context == null) {
            this.context = new ArrayList<StringType>();
        }
        this.context.add(t);
        return t;
    }

    public StructureDefinition addContext(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.context == null) {
            this.context = new ArrayList<StringType>();
        }
        this.context.add(t);
        return this;
    }

    public boolean hasContext(String value) {
        if (this.context == null) {
            return false;
        }
        for (StringType v : this.context) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<StringType> getContextInvariant() {
        if (this.contextInvariant == null) {
            this.contextInvariant = new ArrayList<StringType>();
        }
        return this.contextInvariant;
    }

    public StructureDefinition setContextInvariant(List<StringType> theContextInvariant) {
        this.contextInvariant = theContextInvariant;
        return this;
    }

    public boolean hasContextInvariant() {
        if (this.contextInvariant == null) {
            return false;
        }
        for (StringType item : this.contextInvariant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addContextInvariantElement() {
        StringType t = new StringType();
        if (this.contextInvariant == null) {
            this.contextInvariant = new ArrayList<StringType>();
        }
        this.contextInvariant.add(t);
        return t;
    }

    public StructureDefinition addContextInvariant(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.contextInvariant == null) {
            this.contextInvariant = new ArrayList<StringType>();
        }
        this.contextInvariant.add(t);
        return this;
    }

    public boolean hasContextInvariant(String value) {
        if (this.contextInvariant == null) {
            return false;
        }
        for (StringType v : this.contextInvariant) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public CodeType getTypeElement() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeType();
            }
        }
        return this.type;
    }

    public boolean hasTypeElement() {
        return this.type != null && !this.type.isEmpty();
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public StructureDefinition setTypeElement(CodeType value) {
        this.type = value;
        return this;
    }

    public String getType() {
        return this.type == null ? null : (String)this.type.getValue();
    }

    public StructureDefinition setType(String value) {
        if (this.type == null) {
            this.type = new CodeType();
        }
        this.type.setValue(value);
        return this;
    }

    public UriType getBaseDefinitionElement() {
        if (this.baseDefinition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.baseDefinition");
            }
            if (Configuration.doAutoCreate()) {
                this.baseDefinition = new UriType();
            }
        }
        return this.baseDefinition;
    }

    public boolean hasBaseDefinitionElement() {
        return this.baseDefinition != null && !this.baseDefinition.isEmpty();
    }

    public boolean hasBaseDefinition() {
        return this.baseDefinition != null && !this.baseDefinition.isEmpty();
    }

    public StructureDefinition setBaseDefinitionElement(UriType value) {
        this.baseDefinition = value;
        return this;
    }

    public String getBaseDefinition() {
        return this.baseDefinition == null ? null : (String)this.baseDefinition.getValue();
    }

    public StructureDefinition setBaseDefinition(String value) {
        if (Utilities.noString(value)) {
            this.baseDefinition = null;
        } else {
            if (this.baseDefinition == null) {
                this.baseDefinition = new UriType();
            }
            this.baseDefinition.setValue(value);
        }
        return this;
    }

    public Enumeration<TypeDerivationRule> getDerivationElement() {
        if (this.derivation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.derivation");
            }
            if (Configuration.doAutoCreate()) {
                this.derivation = new Enumeration<TypeDerivationRule>(new TypeDerivationRuleEnumFactory());
            }
        }
        return this.derivation;
    }

    public boolean hasDerivationElement() {
        return this.derivation != null && !this.derivation.isEmpty();
    }

    public boolean hasDerivation() {
        return this.derivation != null && !this.derivation.isEmpty();
    }

    public StructureDefinition setDerivationElement(Enumeration<TypeDerivationRule> value) {
        this.derivation = value;
        return this;
    }

    public TypeDerivationRule getDerivation() {
        return this.derivation == null ? null : (TypeDerivationRule)((Object)this.derivation.getValue());
    }

    public StructureDefinition setDerivation(TypeDerivationRule value) {
        if (value == null) {
            this.derivation = null;
        } else {
            if (this.derivation == null) {
                this.derivation = new Enumeration<TypeDerivationRule>(new TypeDerivationRuleEnumFactory());
            }
            this.derivation.setValue((Object)value);
        }
        return this;
    }

    public StructureDefinitionSnapshotComponent getSnapshot() {
        if (this.snapshot == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.snapshot");
            }
            if (Configuration.doAutoCreate()) {
                this.snapshot = new StructureDefinitionSnapshotComponent();
            }
        }
        return this.snapshot;
    }

    public boolean hasSnapshot() {
        return this.snapshot != null && !this.snapshot.isEmpty();
    }

    public StructureDefinition setSnapshot(StructureDefinitionSnapshotComponent value) {
        this.snapshot = value;
        return this;
    }

    public StructureDefinitionDifferentialComponent getDifferential() {
        if (this.differential == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create StructureDefinition.differential");
            }
            if (Configuration.doAutoCreate()) {
                this.differential = new StructureDefinitionDifferentialComponent();
            }
        }
        return this.differential;
    }

    public boolean hasDifferential() {
        return this.differential != null && !this.differential.isEmpty();
    }

    public StructureDefinition setDifferential(StructureDefinitionDifferentialComponent value) {
        this.differential = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this structure definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure definition is (or will be) published. The URL SHOULD include the major version of the structure definition. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this structure definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the structure definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the structure definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the structure definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the structure definition.", 0, 1, this.title));
        children.add(new Property(SP_STATUS, "code", "The status of this structure definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_EXPERIMENTAL, "boolean", "A boolean value to indicate that this structure definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the structure definition was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the structure definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the structure definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the structure definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate structure definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the structure definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explaination of why this structure definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the structure definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the structure definition.", 0, 1, this.copyright));
        children.add(new Property(SP_KEYWORD, "Coding", "A set of key words or terms from external terminologies that may be used to assist with indexing and searching of templates.", 0, Integer.MAX_VALUE, this.keyword));
        children.add(new Property("fhirVersion", "id", "The version of the FHIR specification on which this StructureDefinition is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.0.2 for this version.", 0, 1, this.fhirVersion));
        children.add(new Property("mapping", "", "An external specification that the content is mapped to.", 0, Integer.MAX_VALUE, this.mapping));
        children.add(new Property(SP_KIND, "code", "Defines the kind of structure that this definition is describing.", 0, 1, this.kind));
        children.add(new Property(SP_ABSTRACT, "boolean", "Whether structure this definition describes is abstract or not  - that is, whether the structure is not intended to be instantiated. For Resources and Data types, abstract types will never be exchanged  between systems.", 0, 1, this.abstract_));
        children.add(new Property("contextType", "code", "If this is an extension, Identifies the context within FHIR resources where the extension can be used.", 0, 1, this.contextType));
        children.add(new Property("context", "string", "Identifies the types of resource or data type elements to which the extension can be applied.", 0, Integer.MAX_VALUE, this.context));
        children.add(new Property("contextInvariant", "string", "A set of rules as Fluent Invariants about when the extension can be used (e.g. co-occurrence variants for the extension).", 0, Integer.MAX_VALUE, this.contextInvariant));
        children.add(new Property(SP_TYPE, "code", "The type this structure describes. If the derivation kind is 'specialization' then this is the master definition for a type, and there is always one of these (a data type, an extension, a resource, including abstract ones). Otherwise the structure definition is a constraint on the stated type (and in this case, the type cannot be an abstract type).", 0, 1, this.type));
        children.add(new Property("baseDefinition", "uri", "An absolute URI that is the base structure from which this type is derived, either by specialization or constraint.", 0, 1, this.baseDefinition));
        children.add(new Property(SP_DERIVATION, "code", "How the type relates to the baseDefinition.", 0, 1, this.derivation));
        children.add(new Property("snapshot", "", "A snapshot view is expressed in a stand alone form that can be used and interpreted without considering the base StructureDefinition.", 0, 1, this.snapshot));
        children.add(new Property("differential", "", "A differential view is expressed relative to the base StructureDefinition - a statement of differences that it applies.", 0, 1, this.differential));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this structure definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this structure definition is (or will be) published. The URL SHOULD include the major version of the structure definition. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "A formal identifier that is used to identify this structure definition when it is represented in other formats, or referenced in a specification, model, design or an instance.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the structure definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the structure definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the structure definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case 110371416: {
                return new Property(SP_TITLE, "string", "A short, descriptive, user-friendly title for the structure definition.", 0, 1, this.title);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this structure definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property(SP_EXPERIMENTAL, "boolean", "A boolean value to indicate that this structure definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the structure definition was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the structure definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the structure definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the structure definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate structure definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the structure definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explaination of why this structure definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the structure definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the structure definition.", 0, 1, this.copyright);
            }
            case -814408215: {
                return new Property(SP_KEYWORD, "Coding", "A set of key words or terms from external terminologies that may be used to assist with indexing and searching of templates.", 0, Integer.MAX_VALUE, this.keyword);
            }
            case 461006061: {
                return new Property("fhirVersion", "id", "The version of the FHIR specification on which this StructureDefinition is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.0.2 for this version.", 0, 1, this.fhirVersion);
            }
            case 837556430: {
                return new Property("mapping", "", "An external specification that the content is mapped to.", 0, Integer.MAX_VALUE, this.mapping);
            }
            case 3292052: {
                return new Property(SP_KIND, "code", "Defines the kind of structure that this definition is describing.", 0, 1, this.kind);
            }
            case 1732898850: {
                return new Property(SP_ABSTRACT, "boolean", "Whether structure this definition describes is abstract or not  - that is, whether the structure is not intended to be instantiated. For Resources and Data types, abstract types will never be exchanged  between systems.", 0, 1, this.abstract_);
            }
            case -102839927: {
                return new Property("contextType", "code", "If this is an extension, Identifies the context within FHIR resources where the extension can be used.", 0, 1, this.contextType);
            }
            case 951530927: {
                return new Property("context", "string", "Identifies the types of resource or data type elements to which the extension can be applied.", 0, Integer.MAX_VALUE, this.context);
            }
            case -802505007: {
                return new Property("contextInvariant", "string", "A set of rules as Fluent Invariants about when the extension can be used (e.g. co-occurrence variants for the extension).", 0, Integer.MAX_VALUE, this.contextInvariant);
            }
            case 3575610: {
                return new Property(SP_TYPE, "code", "The type this structure describes. If the derivation kind is 'specialization' then this is the master definition for a type, and there is always one of these (a data type, an extension, a resource, including abstract ones). Otherwise the structure definition is a constraint on the stated type (and in this case, the type cannot be an abstract type).", 0, 1, this.type);
            }
            case 1139771140: {
                return new Property("baseDefinition", "uri", "An absolute URI that is the base structure from which this type is derived, either by specialization or constraint.", 0, 1, this.baseDefinition);
            }
            case -1353885513: {
                return new Property(SP_DERIVATION, "code", "How the type relates to the baseDefinition.", 0, 1, this.derivation);
            }
            case 284874180: {
                return new Property("snapshot", "", "A snapshot view is expressed in a stand alone form that can be used and interpreted without considering the base StructureDefinition.", 0, 1, this.snapshot);
            }
            case -1196150917: {
                return new Property("differential", "", "A differential view is expressed relative to the base StructureDefinition - a statement of differences that it applies.", 0, 1, this.differential);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case 110371416: {
                Base[] baseArray;
                if (this.title == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.title;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.purpose;
                }
                return baseArray;
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.copyright;
                }
                return baseArray;
            }
            case -814408215: {
                return this.keyword == null ? new Base[]{} : this.keyword.toArray(new Base[this.keyword.size()]);
            }
            case 461006061: {
                Base[] baseArray;
                if (this.fhirVersion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.fhirVersion;
                }
                return baseArray;
            }
            case 837556430: {
                return this.mapping == null ? new Base[]{} : this.mapping.toArray(new Base[this.mapping.size()]);
            }
            case 3292052: {
                Base[] baseArray;
                if (this.kind == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.kind;
                }
                return baseArray;
            }
            case 1732898850: {
                Base[] baseArray;
                if (this.abstract_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.abstract_;
                }
                return baseArray;
            }
            case -102839927: {
                Base[] baseArray;
                if (this.contextType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray16 = new Base[1];
                    baseArray = baseArray16;
                    baseArray16[0] = this.contextType;
                }
                return baseArray;
            }
            case 951530927: {
                return this.context == null ? new Base[]{} : this.context.toArray(new Base[this.context.size()]);
            }
            case -802505007: {
                return this.contextInvariant == null ? new Base[]{} : this.contextInvariant.toArray(new Base[this.contextInvariant.size()]);
            }
            case 3575610: {
                Base[] baseArray;
                if (this.type == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray17 = new Base[1];
                    baseArray = baseArray17;
                    baseArray17[0] = this.type;
                }
                return baseArray;
            }
            case 1139771140: {
                Base[] baseArray;
                if (this.baseDefinition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray18 = new Base[1];
                    baseArray = baseArray18;
                    baseArray18[0] = this.baseDefinition;
                }
                return baseArray;
            }
            case -1353885513: {
                Base[] baseArray;
                if (this.derivation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray19 = new Base[1];
                    baseArray = baseArray19;
                    baseArray19[0] = this.derivation;
                }
                return baseArray;
            }
            case 284874180: {
                Base[] baseArray;
                if (this.snapshot == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray20 = new Base[1];
                    baseArray = baseArray20;
                    baseArray20[0] = this.snapshot;
                }
                return baseArray;
            }
            case -1196150917: {
                Base[] baseArray;
                if (this.differential == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray21 = new Base[1];
                    baseArray = baseArray21;
                    baseArray21[0] = this.differential;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case 110371416: {
                this.title = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case -814408215: {
                this.getKeyword().add(this.castToCoding(value));
                return value;
            }
            case 461006061: {
                this.fhirVersion = this.castToId(value);
                return value;
            }
            case 837556430: {
                this.getMapping().add((StructureDefinitionMappingComponent)((Object)value));
                return value;
            }
            case 3292052: {
                value = new StructureDefinitionKindEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
                return value;
            }
            case 1732898850: {
                this.abstract_ = this.castToBoolean(value);
                return value;
            }
            case -102839927: {
                value = new ExtensionContextEnumFactory().fromType(this.castToCode(value));
                this.contextType = value;
                return value;
            }
            case 951530927: {
                this.getContext().add(this.castToString(value));
                return value;
            }
            case -802505007: {
                this.getContextInvariant().add(this.castToString(value));
                return value;
            }
            case 3575610: {
                this.type = this.castToCode(value);
                return value;
            }
            case 1139771140: {
                this.baseDefinition = this.castToUri(value);
                return value;
            }
            case -1353885513: {
                value = new TypeDerivationRuleEnumFactory().fromType(this.castToCode(value));
                this.derivation = value;
                return value;
            }
            case 284874180: {
                this.snapshot = (StructureDefinitionSnapshotComponent)((Object)value);
                return value;
            }
            case -1196150917: {
                this.differential = (StructureDefinitionDifferentialComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TITLE)) {
            this.title = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals(SP_KEYWORD)) {
            this.getKeyword().add(this.castToCoding(value));
        } else if (name.equals("fhirVersion")) {
            this.fhirVersion = this.castToId(value);
        } else if (name.equals("mapping")) {
            this.getMapping().add((StructureDefinitionMappingComponent)((Object)value));
        } else if (name.equals(SP_KIND)) {
            value = new StructureDefinitionKindEnumFactory().fromType(this.castToCode(value));
            this.kind = value;
        } else if (name.equals(SP_ABSTRACT)) {
            this.abstract_ = this.castToBoolean(value);
        } else if (name.equals("contextType")) {
            value = new ExtensionContextEnumFactory().fromType(this.castToCode(value));
            this.contextType = value;
        } else if (name.equals("context")) {
            this.getContext().add(this.castToString(value));
        } else if (name.equals("contextInvariant")) {
            this.getContextInvariant().add(this.castToString(value));
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCode(value);
        } else if (name.equals("baseDefinition")) {
            this.baseDefinition = this.castToUri(value);
        } else if (name.equals(SP_DERIVATION)) {
            value = new TypeDerivationRuleEnumFactory().fromType(this.castToCode(value));
            this.derivation = value;
        } else if (name.equals("snapshot")) {
            this.snapshot = (StructureDefinitionSnapshotComponent)((Object)value);
        } else if (name.equals("differential")) {
            this.differential = (StructureDefinitionDifferentialComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case 110371416: {
                return this.getTitleElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case -814408215: {
                return this.addKeyword();
            }
            case 461006061: {
                return this.getFhirVersionElement();
            }
            case 837556430: {
                return this.addMapping();
            }
            case 3292052: {
                return this.getKindElement();
            }
            case 1732898850: {
                return this.getAbstractElement();
            }
            case -102839927: {
                return this.getContextTypeElement();
            }
            case 951530927: {
                return this.addContextElement();
            }
            case -802505007: {
                return this.addContextInvariantElement();
            }
            case 3575610: {
                return this.getTypeElement();
            }
            case 1139771140: {
                return this.getBaseDefinitionElement();
            }
            case -1353885513: {
                return this.getDerivationElement();
            }
            case 284874180: {
                return this.getSnapshot();
            }
            case -1196150917: {
                return this.getDifferential();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case 110371416: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case -814408215: {
                return new String[]{"Coding"};
            }
            case 461006061: {
                return new String[]{"id"};
            }
            case 837556430: {
                return new String[0];
            }
            case 3292052: {
                return new String[]{"code"};
            }
            case 1732898850: {
                return new String[]{"boolean"};
            }
            case -102839927: {
                return new String[]{"code"};
            }
            case 951530927: {
                return new String[]{"string"};
            }
            case -802505007: {
                return new String[]{"string"};
            }
            case 3575610: {
                return new String[]{"code"};
            }
            case 1139771140: {
                return new String[]{"uri"};
            }
            case -1353885513: {
                return new String[]{"code"};
            }
            case 284874180: {
                return new String[0];
            }
            case -1196150917: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.url");
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.name");
        }
        if (name.equals(SP_TITLE)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.title");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.purpose");
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.copyright");
        }
        if (name.equals(SP_KEYWORD)) {
            return this.addKeyword();
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.fhirVersion");
        }
        if (name.equals("mapping")) {
            return this.addMapping();
        }
        if (name.equals(SP_KIND)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.kind");
        }
        if (name.equals(SP_ABSTRACT)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.abstract");
        }
        if (name.equals("contextType")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.contextType");
        }
        if (name.equals("context")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.context");
        }
        if (name.equals("contextInvariant")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.contextInvariant");
        }
        if (name.equals(SP_TYPE)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.type");
        }
        if (name.equals("baseDefinition")) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.baseDefinition");
        }
        if (name.equals(SP_DERIVATION)) {
            throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.derivation");
        }
        if (name.equals("snapshot")) {
            this.snapshot = new StructureDefinitionSnapshotComponent();
            return this.snapshot;
        }
        if (name.equals("differential")) {
            this.differential = new StructureDefinitionDifferentialComponent();
            return this.differential;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "StructureDefinition";
    }

    @Override
    public StructureDefinition copy() {
        StructureDefinition dst = new StructureDefinition();
        this.copyValues(dst);
        UriType uriType = dst.url = this.url == null ? null : this.url.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.title = this.title == null ? null : this.title.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        MarkdownType markdownType2 = dst.copyright = this.copyright == null ? null : this.copyright.copy();
        if (this.keyword != null) {
            dst.keyword = new ArrayList<Coding>();
            for (Coding coding : this.keyword) {
                dst.keyword.add(coding.copy());
            }
        }
        IdType idType = dst.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        if (this.mapping != null) {
            dst.mapping = new ArrayList<StructureDefinitionMappingComponent>();
            for (StructureDefinitionMappingComponent structureDefinitionMappingComponent : this.mapping) {
                dst.mapping.add(structureDefinitionMappingComponent.copy());
            }
        }
        dst.kind = this.kind == null ? null : this.kind.copy();
        dst.abstract_ = this.abstract_ == null ? null : this.abstract_.copy();
        Enumeration<ExtensionContext> enumeration = dst.contextType = this.contextType == null ? null : this.contextType.copy();
        if (this.context != null) {
            dst.context = new ArrayList<StringType>();
            for (StringType stringType2 : this.context) {
                dst.context.add(stringType2.copy());
            }
        }
        if (this.contextInvariant != null) {
            dst.contextInvariant = new ArrayList<StringType>();
            for (StringType stringType3 : this.contextInvariant) {
                dst.contextInvariant.add(stringType3.copy());
            }
        }
        dst.type = this.type == null ? null : this.type.copy();
        dst.baseDefinition = this.baseDefinition == null ? null : this.baseDefinition.copy();
        dst.derivation = this.derivation == null ? null : this.derivation.copy();
        dst.snapshot = this.snapshot == null ? null : this.snapshot.copy();
        dst.differential = this.differential == null ? null : this.differential.copy();
        return dst;
    }

    protected StructureDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof StructureDefinition)) {
            return false;
        }
        StructureDefinition o = (StructureDefinition)other_;
        return StructureDefinition.compareDeep(this.identifier, o.identifier, true) && StructureDefinition.compareDeep(this.purpose, o.purpose, true) && StructureDefinition.compareDeep(this.copyright, o.copyright, true) && StructureDefinition.compareDeep(this.keyword, o.keyword, true) && StructureDefinition.compareDeep(this.fhirVersion, o.fhirVersion, true) && StructureDefinition.compareDeep(this.mapping, o.mapping, true) && StructureDefinition.compareDeep(this.kind, o.kind, true) && StructureDefinition.compareDeep(this.abstract_, o.abstract_, true) && StructureDefinition.compareDeep(this.contextType, o.contextType, true) && StructureDefinition.compareDeep(this.context, o.context, true) && StructureDefinition.compareDeep(this.contextInvariant, o.contextInvariant, true) && StructureDefinition.compareDeep(this.type, o.type, true) && StructureDefinition.compareDeep(this.baseDefinition, o.baseDefinition, true) && StructureDefinition.compareDeep(this.derivation, o.derivation, true) && StructureDefinition.compareDeep(this.snapshot, o.snapshot, true) && StructureDefinition.compareDeep(this.differential, o.differential, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof StructureDefinition)) {
            return false;
        }
        StructureDefinition o = (StructureDefinition)other_;
        return StructureDefinition.compareValues(this.purpose, o.purpose, true) && StructureDefinition.compareValues(this.copyright, o.copyright, true) && StructureDefinition.compareValues(this.fhirVersion, o.fhirVersion, true) && StructureDefinition.compareValues(this.kind, o.kind, true) && StructureDefinition.compareValues(this.abstract_, o.abstract_, true) && StructureDefinition.compareValues(this.contextType, o.contextType, true) && StructureDefinition.compareValues(this.context, o.context, true) && StructureDefinition.compareValues(this.contextInvariant, o.contextInvariant, true) && StructureDefinition.compareValues(this.type, o.type, true) && StructureDefinition.compareValues(this.baseDefinition, o.baseDefinition, true) && StructureDefinition.compareValues(this.derivation, o.derivation, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.purpose, this.copyright, this.keyword, this.fhirVersion, this.mapping, this.kind, this.abstract_, this.contextType, this.context, this.contextInvariant, this.type, this.baseDefinition, this.derivation, this.snapshot, this.differential);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.StructureDefinition;
    }

    @Block
    public static class StructureDefinitionDifferentialComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="element", type={ElementDefinition.class}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Definition of elements in the resource (if no StructureDefinition)", formalDefinition="Captures constraints on each element within the resource.")
        protected List<ElementDefinition> element;
        private static final long serialVersionUID = 53896641L;

        public List<ElementDefinition> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            return this.element;
        }

        public StructureDefinitionDifferentialComponent setElement(List<ElementDefinition> theElement) {
            this.element = theElement;
            return this;
        }

        public boolean hasElement() {
            if (this.element == null) {
                return false;
            }
            for (ElementDefinition item : this.element) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ElementDefinition addElement() {
            ElementDefinition t = new ElementDefinition();
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            this.element.add(t);
            return t;
        }

        public StructureDefinitionDifferentialComponent addElement(ElementDefinition t) {
            if (t == null) {
                return this;
            }
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            this.element.add(t);
            return this;
        }

        public ElementDefinition getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                this.addElement();
            }
            return this.getElement().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("element", "ElementDefinition", "Captures constraints on each element within the resource.", 0, Integer.MAX_VALUE, this.element));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1662836996: {
                    return new Property("element", "ElementDefinition", "Captures constraints on each element within the resource.", 0, Integer.MAX_VALUE, this.element);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    this.getElement().add(this.castToElementDefinition(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("element")) {
                return super.setProperty(name, value);
            }
            this.getElement().add(this.castToElementDefinition(value));
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return this.addElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return new String[]{"ElementDefinition"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("element")) {
                return this.addElement();
            }
            return super.addChild(name);
        }

        @Override
        public StructureDefinitionDifferentialComponent copy() {
            StructureDefinitionDifferentialComponent dst = new StructureDefinitionDifferentialComponent();
            this.copyValues(dst);
            if (this.element != null) {
                dst.element = new ArrayList<ElementDefinition>();
                for (ElementDefinition i2 : this.element) {
                    dst.element.add(i2.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureDefinitionDifferentialComponent)) {
                return false;
            }
            StructureDefinitionDifferentialComponent o = (StructureDefinitionDifferentialComponent)other_;
            return StructureDefinitionDifferentialComponent.compareDeep(this.element, o.element, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureDefinitionDifferentialComponent)) {
                return false;
            }
            StructureDefinitionDifferentialComponent o = (StructureDefinitionDifferentialComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.element);
        }

        @Override
        public String fhirType() {
            return "StructureDefinition.differential";
        }
    }

    @Block
    public static class StructureDefinitionSnapshotComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="element", type={ElementDefinition.class}, order=1, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Definition of elements in the resource (if no StructureDefinition)", formalDefinition="Captures constraints on each element within the resource.")
        protected List<ElementDefinition> element;
        private static final long serialVersionUID = 53896641L;

        public List<ElementDefinition> getElement() {
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            return this.element;
        }

        public StructureDefinitionSnapshotComponent setElement(List<ElementDefinition> theElement) {
            this.element = theElement;
            return this;
        }

        public boolean hasElement() {
            if (this.element == null) {
                return false;
            }
            for (ElementDefinition item : this.element) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ElementDefinition addElement() {
            ElementDefinition t = new ElementDefinition();
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            this.element.add(t);
            return t;
        }

        public StructureDefinitionSnapshotComponent addElement(ElementDefinition t) {
            if (t == null) {
                return this;
            }
            if (this.element == null) {
                this.element = new ArrayList<ElementDefinition>();
            }
            this.element.add(t);
            return this;
        }

        public ElementDefinition getElementFirstRep() {
            if (this.getElement().isEmpty()) {
                this.addElement();
            }
            return this.getElement().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("element", "ElementDefinition", "Captures constraints on each element within the resource.", 0, Integer.MAX_VALUE, this.element));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1662836996: {
                    return new Property("element", "ElementDefinition", "Captures constraints on each element within the resource.", 0, Integer.MAX_VALUE, this.element);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return this.element == null ? new Base[]{} : this.element.toArray(new Base[this.element.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    this.getElement().add(this.castToElementDefinition(value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (!name.equals("element")) {
                return super.setProperty(name, value);
            }
            this.getElement().add(this.castToElementDefinition(value));
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return this.addElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1662836996: {
                    return new String[]{"ElementDefinition"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("element")) {
                return this.addElement();
            }
            return super.addChild(name);
        }

        @Override
        public StructureDefinitionSnapshotComponent copy() {
            StructureDefinitionSnapshotComponent dst = new StructureDefinitionSnapshotComponent();
            this.copyValues(dst);
            if (this.element != null) {
                dst.element = new ArrayList<ElementDefinition>();
                for (ElementDefinition i2 : this.element) {
                    dst.element.add(i2.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureDefinitionSnapshotComponent)) {
                return false;
            }
            StructureDefinitionSnapshotComponent o = (StructureDefinitionSnapshotComponent)other_;
            return StructureDefinitionSnapshotComponent.compareDeep(this.element, o.element, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureDefinitionSnapshotComponent)) {
                return false;
            }
            StructureDefinitionSnapshotComponent o = (StructureDefinitionSnapshotComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.element);
        }

        @Override
        public String fhirType() {
            return "StructureDefinition.snapshot";
        }
    }

    @Block
    public static class StructureDefinitionMappingComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identity", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Internal id when this mapping is used", formalDefinition="An Internal id that is used to identify this mapping set when specific mappings are made.")
        protected IdType identity;
        @Child(name="uri", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies what this mapping refers to", formalDefinition="An absolute URI that identifies the specification that this mapping is expressed to.")
        protected UriType uri;
        @Child(name="name", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Names what this mapping refers to", formalDefinition="A name for the specification that is being mapped to.")
        protected StringType name;
        @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Versions, Issues, Scope limitations etc.", formalDefinition="Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.")
        protected StringType comment;
        private static final long serialVersionUID = 9610265L;

        public StructureDefinitionMappingComponent() {
        }

        public StructureDefinitionMappingComponent(IdType identity) {
            this.identity = identity;
        }

        public IdType getIdentityElement() {
            if (this.identity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionMappingComponent.identity");
                }
                if (Configuration.doAutoCreate()) {
                    this.identity = new IdType();
                }
            }
            return this.identity;
        }

        public boolean hasIdentityElement() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public boolean hasIdentity() {
            return this.identity != null && !this.identity.isEmpty();
        }

        public StructureDefinitionMappingComponent setIdentityElement(IdType value) {
            this.identity = value;
            return this;
        }

        public String getIdentity() {
            return this.identity == null ? null : this.identity.getValue();
        }

        public StructureDefinitionMappingComponent setIdentity(String value) {
            if (this.identity == null) {
                this.identity = new IdType();
            }
            this.identity.setValue(value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionMappingComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public StructureDefinitionMappingComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public StructureDefinitionMappingComponent setUri(String value) {
            if (Utilities.noString(value)) {
                this.uri = null;
            } else {
                if (this.uri == null) {
                    this.uri = new UriType();
                }
                this.uri.setValue(value);
            }
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionMappingComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public StructureDefinitionMappingComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public StructureDefinitionMappingComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StructureDefinitionMappingComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public StructureDefinitionMappingComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public StructureDefinitionMappingComponent setComment(String value) {
            if (Utilities.noString(value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("identity", "id", "An Internal id that is used to identify this mapping set when specific mappings are made.", 0, 1, this.identity));
            children.add(new Property("uri", "uri", "An absolute URI that identifies the specification that this mapping is expressed to.", 0, 1, this.uri));
            children.add(new Property(StructureDefinition.SP_NAME, "string", "A name for the specification that is being mapped to.", 0, 1, this.name));
            children.add(new Property("comment", "string", "Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.", 0, 1, this.comment));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -135761730: {
                    return new Property("identity", "id", "An Internal id that is used to identify this mapping set when specific mappings are made.", 0, 1, this.identity);
                }
                case 116076: {
                    return new Property("uri", "uri", "An absolute URI that identifies the specification that this mapping is expressed to.", 0, 1, this.uri);
                }
                case 3373707: {
                    return new Property(StructureDefinition.SP_NAME, "string", "A name for the specification that is being mapped to.", 0, 1, this.name);
                }
                case 950398559: {
                    return new Property("comment", "string", "Comments about this mapping, including version notes, issues, scope limitations, and other important notes for usage.", 0, 1, this.comment);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    Base[] baseArray;
                    if (this.identity == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.identity;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.name;
                    }
                    return baseArray;
                }
                case 950398559: {
                    Base[] baseArray;
                    if (this.comment == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.comment;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    this.identity = this.castToId(value);
                    return value;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case 950398559: {
                    this.comment = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identity")) {
                this.identity = this.castToId(value);
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else if (name.equals(StructureDefinition.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    return this.getIdentityElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case 950398559: {
                    return this.getCommentElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -135761730: {
                    return new String[]{"id"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case 950398559: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identity")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.identity");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.uri");
            }
            if (name.equals(StructureDefinition.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.name");
            }
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a primitive type StructureDefinition.comment");
            }
            return super.addChild(name);
        }

        @Override
        public StructureDefinitionMappingComponent copy() {
            StructureDefinitionMappingComponent dst = new StructureDefinitionMappingComponent();
            this.copyValues(dst);
            dst.identity = this.identity == null ? null : this.identity.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.comment = this.comment == null ? null : this.comment.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureDefinitionMappingComponent)) {
                return false;
            }
            StructureDefinitionMappingComponent o = (StructureDefinitionMappingComponent)other_;
            return StructureDefinitionMappingComponent.compareDeep(this.identity, o.identity, true) && StructureDefinitionMappingComponent.compareDeep(this.uri, o.uri, true) && StructureDefinitionMappingComponent.compareDeep(this.name, o.name, true) && StructureDefinitionMappingComponent.compareDeep(this.comment, o.comment, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StructureDefinitionMappingComponent)) {
                return false;
            }
            StructureDefinitionMappingComponent o = (StructureDefinitionMappingComponent)other_;
            return StructureDefinitionMappingComponent.compareValues(this.identity, o.identity, true) && StructureDefinitionMappingComponent.compareValues(this.uri, o.uri, true) && StructureDefinitionMappingComponent.compareValues(this.name, o.name, true) && StructureDefinitionMappingComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.identity, this.uri, this.name, this.comment);
        }

        @Override
        public String fhirType() {
            return "StructureDefinition.mapping";
        }
    }

    public static class TypeDerivationRuleEnumFactory
    implements EnumFactory<TypeDerivationRule> {
        @Override
        public TypeDerivationRule fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("specialization".equals(codeString)) {
                return TypeDerivationRule.SPECIALIZATION;
            }
            if ("constraint".equals(codeString)) {
                return TypeDerivationRule.CONSTRAINT;
            }
            throw new IllegalArgumentException("Unknown TypeDerivationRule code '" + codeString + "'");
        }

        public Enumeration<TypeDerivationRule> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<TypeDerivationRule>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("specialization".equals(codeString)) {
                return new Enumeration<TypeDerivationRule>(this, TypeDerivationRule.SPECIALIZATION);
            }
            if ("constraint".equals(codeString)) {
                return new Enumeration<TypeDerivationRule>(this, TypeDerivationRule.CONSTRAINT);
            }
            throw new FHIRException("Unknown TypeDerivationRule code '" + codeString + "'");
        }

        @Override
        public String toCode(TypeDerivationRule code) {
            if (code == TypeDerivationRule.SPECIALIZATION) {
                return "specialization";
            }
            if (code == TypeDerivationRule.CONSTRAINT) {
                return "constraint";
            }
            return "?";
        }

        @Override
        public String toSystem(TypeDerivationRule code) {
            return code.getSystem();
        }
    }

    public static enum TypeDerivationRule {
        SPECIALIZATION,
        CONSTRAINT,
        NULL;


        public static TypeDerivationRule fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("specialization".equals(codeString)) {
                return SPECIALIZATION;
            }
            if ("constraint".equals(codeString)) {
                return CONSTRAINT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown TypeDerivationRule code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case SPECIALIZATION: {
                    return "specialization";
                }
                case CONSTRAINT: {
                    return "constraint";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case SPECIALIZATION: {
                    return "http://hl7.org/fhir/type-derivation-rule";
                }
                case CONSTRAINT: {
                    return "http://hl7.org/fhir/type-derivation-rule";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case SPECIALIZATION: {
                    return "This definition defines a new type that adds additional elements to the base type";
                }
                case CONSTRAINT: {
                    return "This definition adds additional rules to an existing concrete type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case SPECIALIZATION: {
                    return "Specialization";
                }
                case CONSTRAINT: {
                    return "Constraint";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ExtensionContextEnumFactory
    implements EnumFactory<ExtensionContext> {
        @Override
        public ExtensionContext fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("resource".equals(codeString)) {
                return ExtensionContext.RESOURCE;
            }
            if ("datatype".equals(codeString)) {
                return ExtensionContext.DATATYPE;
            }
            if ("extension".equals(codeString)) {
                return ExtensionContext.EXTENSION;
            }
            throw new IllegalArgumentException("Unknown ExtensionContext code '" + codeString + "'");
        }

        public Enumeration<ExtensionContext> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ExtensionContext>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("resource".equals(codeString)) {
                return new Enumeration<ExtensionContext>(this, ExtensionContext.RESOURCE);
            }
            if ("datatype".equals(codeString)) {
                return new Enumeration<ExtensionContext>(this, ExtensionContext.DATATYPE);
            }
            if ("extension".equals(codeString)) {
                return new Enumeration<ExtensionContext>(this, ExtensionContext.EXTENSION);
            }
            throw new FHIRException("Unknown ExtensionContext code '" + codeString + "'");
        }

        @Override
        public String toCode(ExtensionContext code) {
            if (code == ExtensionContext.RESOURCE) {
                return "resource";
            }
            if (code == ExtensionContext.DATATYPE) {
                return "datatype";
            }
            if (code == ExtensionContext.EXTENSION) {
                return "extension";
            }
            return "?";
        }

        @Override
        public String toSystem(ExtensionContext code) {
            return code.getSystem();
        }
    }

    public static enum ExtensionContext {
        RESOURCE,
        DATATYPE,
        EXTENSION,
        NULL;


        public static ExtensionContext fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("resource".equals(codeString)) {
                return RESOURCE;
            }
            if ("datatype".equals(codeString)) {
                return DATATYPE;
            }
            if ("extension".equals(codeString)) {
                return EXTENSION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ExtensionContext code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case RESOURCE: {
                    return "resource";
                }
                case DATATYPE: {
                    return "datatype";
                }
                case EXTENSION: {
                    return "extension";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case RESOURCE: {
                    return "http://hl7.org/fhir/extension-context";
                }
                case DATATYPE: {
                    return "http://hl7.org/fhir/extension-context";
                }
                case EXTENSION: {
                    return "http://hl7.org/fhir/extension-context";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case RESOURCE: {
                    return "The context is all elements matching a particular resource element path.";
                }
                case DATATYPE: {
                    return "The context is all nodes matching a particular data type element path (root or repeating element) or all elements referencing a particular primitive data type (expressed as the datatype name).";
                }
                case EXTENSION: {
                    return "The context is a particular extension from a particular profile, a uri that identifies the extension definition.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case RESOURCE: {
                    return "Resource";
                }
                case DATATYPE: {
                    return "Datatype";
                }
                case EXTENSION: {
                    return "Extension";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class StructureDefinitionKindEnumFactory
    implements EnumFactory<StructureDefinitionKind> {
        @Override
        public StructureDefinitionKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("primitive-type".equals(codeString)) {
                return StructureDefinitionKind.PRIMITIVETYPE;
            }
            if ("complex-type".equals(codeString)) {
                return StructureDefinitionKind.COMPLEXTYPE;
            }
            if ("resource".equals(codeString)) {
                return StructureDefinitionKind.RESOURCE;
            }
            if ("logical".equals(codeString)) {
                return StructureDefinitionKind.LOGICAL;
            }
            throw new IllegalArgumentException("Unknown StructureDefinitionKind code '" + codeString + "'");
        }

        public Enumeration<StructureDefinitionKind> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<StructureDefinitionKind>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("primitive-type".equals(codeString)) {
                return new Enumeration<StructureDefinitionKind>(this, StructureDefinitionKind.PRIMITIVETYPE);
            }
            if ("complex-type".equals(codeString)) {
                return new Enumeration<StructureDefinitionKind>(this, StructureDefinitionKind.COMPLEXTYPE);
            }
            if ("resource".equals(codeString)) {
                return new Enumeration<StructureDefinitionKind>(this, StructureDefinitionKind.RESOURCE);
            }
            if ("logical".equals(codeString)) {
                return new Enumeration<StructureDefinitionKind>(this, StructureDefinitionKind.LOGICAL);
            }
            throw new FHIRException("Unknown StructureDefinitionKind code '" + codeString + "'");
        }

        @Override
        public String toCode(StructureDefinitionKind code) {
            if (code == StructureDefinitionKind.PRIMITIVETYPE) {
                return "primitive-type";
            }
            if (code == StructureDefinitionKind.COMPLEXTYPE) {
                return "complex-type";
            }
            if (code == StructureDefinitionKind.RESOURCE) {
                return "resource";
            }
            if (code == StructureDefinitionKind.LOGICAL) {
                return "logical";
            }
            return "?";
        }

        @Override
        public String toSystem(StructureDefinitionKind code) {
            return code.getSystem();
        }
    }

    public static enum StructureDefinitionKind {
        PRIMITIVETYPE,
        COMPLEXTYPE,
        RESOURCE,
        LOGICAL,
        NULL;


        public static StructureDefinitionKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("primitive-type".equals(codeString)) {
                return PRIMITIVETYPE;
            }
            if ("complex-type".equals(codeString)) {
                return COMPLEXTYPE;
            }
            if ("resource".equals(codeString)) {
                return RESOURCE;
            }
            if ("logical".equals(codeString)) {
                return LOGICAL;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown StructureDefinitionKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PRIMITIVETYPE: {
                    return "primitive-type";
                }
                case COMPLEXTYPE: {
                    return "complex-type";
                }
                case RESOURCE: {
                    return "resource";
                }
                case LOGICAL: {
                    return "logical";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PRIMITIVETYPE: {
                    return "http://hl7.org/fhir/structure-definition-kind";
                }
                case COMPLEXTYPE: {
                    return "http://hl7.org/fhir/structure-definition-kind";
                }
                case RESOURCE: {
                    return "http://hl7.org/fhir/structure-definition-kind";
                }
                case LOGICAL: {
                    return "http://hl7.org/fhir/structure-definition-kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PRIMITIVETYPE: {
                    return "A primitive type that has a value and an extension. These can be used throughout Resource and extension definitions. Only the base specification can define primitive types.";
                }
                case COMPLEXTYPE: {
                    return "A  complex structure that defines a set of data elements. These can be used throughout Resource and extension definitions, and in logical models.";
                }
                case RESOURCE: {
                    return "A resource defined by the FHIR specification.";
                }
                case LOGICAL: {
                    return "A conceptual package of data that will be mapped to resources for implementation.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PRIMITIVETYPE: {
                    return "Primitive Data Type";
                }
                case COMPLEXTYPE: {
                    return "Complex Data Type";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case LOGICAL: {
                    return "Logical Model";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

