/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.ActivityDefinition;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.Device;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Encounter;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.HealthcareService;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Observation;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PlanDefinition;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Provenance;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.Specimen;
import org.hl7.fhir.dstu3.model.Timing;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="ProcedureRequest", profile="http://hl7.org/fhir/Profile/ProcedureRequest")
public class ProcedureRequest
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifiers assigned to this order", formalDefinition="Identifiers assigned to this order instance by the orderer and/or the receiver and/or order fulfiller.")
    protected List<Identifier> identifier;
    @Child(name="definition", type={ActivityDefinition.class, PlanDefinition.class}, order=1, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Protocol or definition", formalDefinition="Protocol or definition followed by this request.")
    protected List<Reference> definition;
    protected List<Resource> definitionTarget;
    @Child(name="basedOn", type={Reference.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What request fulfills", formalDefinition="Plan/proposal/order fulfilled by this request.")
    protected List<Reference> basedOn;
    protected List<Resource> basedOnTarget;
    @Child(name="replaces", type={Reference.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="What request replaces", formalDefinition="The request takes the place of the referenced completed or terminated request(s).")
    protected List<Reference> replaces;
    protected List<Resource> replacesTarget;
    @Child(name="requisition", type={Identifier.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Composite Request ID", formalDefinition="A shared identifier common to all procedure or diagnostic requests that were authorized more or less simultaneously by a single author, representing the composite or group identifier.")
    protected Identifier requisition;
    @Child(name="status", type={CodeType.class}, order=5, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="draft | active | suspended | completed | entered-in-error | cancelled", formalDefinition="The status of the order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-status")
    protected Enumeration<ProcedureRequestStatus> status;
    @Child(name="intent", type={CodeType.class}, order=6, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposal | plan | order +", formalDefinition="Whether the request is a proposal, plan, an original order or a reflex order.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-intent")
    protected Enumeration<ProcedureRequestIntent> intent;
    @Child(name="priority", type={CodeType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | asap | stat", formalDefinition="Indicates how quickly the ProcedureRequest should be addressed with respect to other requests.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/request-priority")
    protected Enumeration<ProcedureRequestPriority> priority;
    @Child(name="doNotPerform", type={BooleanType.class}, order=8, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="True if procedure should not be performed", formalDefinition="Set this to true if the record is saying that the procedure should NOT be performed.")
    protected BooleanType doNotPerform;
    @Child(name="category", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Classification of procedure", formalDefinition="A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-category")
    protected List<CodeableConcept> category;
    @Child(name="code", type={CodeableConcept.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What is being requested/ordered", formalDefinition="A code that identifies a particular procedure, diagnostic investigation, or panel of investigations, that have been requested.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-code")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Location.class, Device.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Individual the service is ordered for", formalDefinition="On whom or what the procedure or diagnostic is to be performed. This is usually a human patient, but can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans).")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="context", type={Encounter.class, EpisodeOfCare.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter or Episode during which request was created", formalDefinition="An encounter or episode of care that provides additional information about the healthcare context in which this request is made.")
    protected Reference context;
    protected Resource contextTarget;
    @Child(name="occurrence", type={DateTimeType.class, Period.class, Timing.class}, order=13, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When procedure should occur", formalDefinition="The date/time at which the diagnostic testing should occur.")
    protected Type occurrence;
    @Child(name="asNeeded", type={BooleanType.class, CodeableConcept.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Preconditions for procedure or diagnostic", formalDefinition="If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.  For example \"pain\", \"on flare-up\", etc.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/medication-as-needed-reason")
    protected Type asNeeded;
    @Child(name="authoredOn", type={DateTimeType.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date request signed", formalDefinition="When the request transitioned to being actionable.")
    protected DateTimeType authoredOn;
    @Child(name="requester", type={}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who/what is requesting procedure or diagnostic", formalDefinition="The individual who initiated the request and has responsibility for its activation.")
    protected ProcedureRequestRequesterComponent requester;
    @Child(name="performerType", type={CodeableConcept.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Performer role", formalDefinition="Desired type of performer for doing the diagnostic testing.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/participant-role")
    protected CodeableConcept performerType;
    @Child(name="performer", type={Practitioner.class, Organization.class, Patient.class, Device.class, RelatedPerson.class, HealthcareService.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Requested perfomer", formalDefinition="The desired perfomer for doing the diagnostic testing.  For example, the surgeon, dermatopathologist, endoscopist, etc.")
    protected Reference performer;
    protected Resource performerTarget;
    @Child(name="reasonCode", type={CodeableConcept.class}, order=19, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Explanation/Justification for test", formalDefinition="An explanation or justification for why this diagnostic investigation is being requested in coded or textual form.   This is often for billing purposes.  May relate to the resources referred to in supportingInformation.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/procedure-reason")
    protected List<CodeableConcept> reasonCode;
    @Child(name="reasonReference", type={Condition.class, Observation.class}, order=20, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Explanation/Justification for test", formalDefinition="Indicates another resource that provides a justification for why this diagnostic investigation is being requested.   May relate to the resources referred to in supportingInformation.")
    protected List<Reference> reasonReference;
    protected List<Resource> reasonReferenceTarget;
    @Child(name="supportingInfo", type={Reference.class}, order=21, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional clinical information", formalDefinition="Additional clinical information about the patient or specimen that may influence the procedure or diagnostics or their interpretations.     This information includes diagnosis, clinical findings and other observations.  In laboratory ordering these are typically referred to as \"ask at order entry questions (AOEs)\".  This includes observations explicitly requested by the producer (filler) to provide context or supporting information needed to complete the order. For example,  reporting the amount of inspired oxygen for blood gas measurements.")
    protected List<Reference> supportingInfo;
    protected List<Resource> supportingInfoTarget;
    @Child(name="specimen", type={Specimen.class}, order=22, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Procedure Samples", formalDefinition="One or more specimens that the laboratory procedure will use.")
    protected List<Reference> specimen;
    protected List<Specimen> specimenTarget;
    @Child(name="bodySite", type={CodeableConcept.class}, order=23, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Location on Body", formalDefinition="Anatomic location where the procedure should be performed. This is the target site.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/body-site")
    protected List<CodeableConcept> bodySite;
    @Child(name="note", type={Annotation.class}, order=24, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Comments", formalDefinition="Any other notes and comments made about the service request. For example, letting provider know that \"patient hates needles\" or other provider instructions.")
    protected List<Annotation> note;
    @Child(name="relevantHistory", type={Provenance.class}, order=25, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Request provenance", formalDefinition="Key events in the history of the request.")
    protected List<Reference> relevantHistory;
    protected List<Provenance> relevantHistoryTarget;
    private static final long serialVersionUID = 184396216L;
    @SearchParamDefinition(name="authored", path="ProcedureRequest.authoredOn", description="Date request signed", type="date")
    public static final String SP_AUTHORED = "authored";
    public static final DateClientParam AUTHORED = new DateClientParam("authored");
    @SearchParamDefinition(name="requester", path="ProcedureRequest.requester.agent", description="Individual making the request", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Practitioner")}, target={Device.class, Organization.class, Practitioner.class})
    public static final String SP_REQUESTER = "requester";
    public static final ReferenceClientParam REQUESTER = new ReferenceClientParam("requester");
    public static final Include INCLUDE_REQUESTER = new Include("ProcedureRequest:requester").toLocked();
    @SearchParamDefinition(name="identifier", path="ProcedureRequest.identifier", description="Identifiers assigned to this order", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="code", path="ProcedureRequest.code", description="What is being requested/ordered", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="performer", path="ProcedureRequest.performer", description="Requested perfomer", type="reference", providesMembershipIn={@Compartment(name="Device"), @Compartment(name="Patient"), @Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Device.class, HealthcareService.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class})
    public static final String SP_PERFORMER = "performer";
    public static final ReferenceClientParam PERFORMER = new ReferenceClientParam("performer");
    public static final Include INCLUDE_PERFORMER = new Include("ProcedureRequest:performer").toLocked();
    @SearchParamDefinition(name="requisition", path="ProcedureRequest.requisition", description="Composite Request ID", type="token")
    public static final String SP_REQUISITION = "requisition";
    public static final TokenClientParam REQUISITION = new TokenClientParam("requisition");
    @SearchParamDefinition(name="replaces", path="ProcedureRequest.replaces", description="What request replaces", type="reference")
    public static final String SP_REPLACES = "replaces";
    public static final ReferenceClientParam REPLACES = new ReferenceClientParam("replaces");
    public static final Include INCLUDE_REPLACES = new Include("ProcedureRequest:replaces").toLocked();
    @SearchParamDefinition(name="subject", path="ProcedureRequest.subject", description="Search by subject", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Device.class, Group.class, Location.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ProcedureRequest:subject").toLocked();
    @SearchParamDefinition(name="encounter", path="ProcedureRequest.context", description="An encounter in which this request is made", type="reference", target={Encounter.class})
    public static final String SP_ENCOUNTER = "encounter";
    public static final ReferenceClientParam ENCOUNTER = new ReferenceClientParam("encounter");
    public static final Include INCLUDE_ENCOUNTER = new Include("ProcedureRequest:encounter").toLocked();
    @SearchParamDefinition(name="occurrence", path="ProcedureRequest.occurrence", description="When procedure should occur", type="date")
    public static final String SP_OCCURRENCE = "occurrence";
    public static final DateClientParam OCCURRENCE = new DateClientParam("occurrence");
    @SearchParamDefinition(name="priority", path="ProcedureRequest.priority", description="routine | urgent | asap | stat", type="token")
    public static final String SP_PRIORITY = "priority";
    public static final TokenClientParam PRIORITY = new TokenClientParam("priority");
    @SearchParamDefinition(name="intent", path="ProcedureRequest.intent", description="proposal | plan | order +", type="token")
    public static final String SP_INTENT = "intent";
    public static final TokenClientParam INTENT = new TokenClientParam("intent");
    @SearchParamDefinition(name="performer-type", path="ProcedureRequest.performerType", description="Performer role", type="token")
    public static final String SP_PERFORMER_TYPE = "performer-type";
    public static final TokenClientParam PERFORMER_TYPE = new TokenClientParam("performer-type");
    @SearchParamDefinition(name="based-on", path="ProcedureRequest.basedOn", description="What request fulfills", type="reference")
    public static final String SP_BASED_ON = "based-on";
    public static final ReferenceClientParam BASED_ON = new ReferenceClientParam("based-on");
    public static final Include INCLUDE_BASED_ON = new Include("ProcedureRequest:based-on").toLocked();
    @SearchParamDefinition(name="patient", path="ProcedureRequest.subject", description="Search by subject - a patient", type="reference", target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ProcedureRequest:patient").toLocked();
    @SearchParamDefinition(name="specimen", path="ProcedureRequest.specimen", description="Specimen to be tested", type="reference", target={Specimen.class})
    public static final String SP_SPECIMEN = "specimen";
    public static final ReferenceClientParam SPECIMEN = new ReferenceClientParam("specimen");
    public static final Include INCLUDE_SPECIMEN = new Include("ProcedureRequest:specimen").toLocked();
    @SearchParamDefinition(name="context", path="ProcedureRequest.context", description="Encounter or Episode during which request was created", type="reference", providesMembershipIn={@Compartment(name="Encounter")}, target={Encounter.class, EpisodeOfCare.class})
    public static final String SP_CONTEXT = "context";
    public static final ReferenceClientParam CONTEXT = new ReferenceClientParam("context");
    public static final Include INCLUDE_CONTEXT = new Include("ProcedureRequest:context").toLocked();
    @SearchParamDefinition(name="definition", path="ProcedureRequest.definition", description="Protocol or definition", type="reference", target={ActivityDefinition.class, PlanDefinition.class})
    public static final String SP_DEFINITION = "definition";
    public static final ReferenceClientParam DEFINITION = new ReferenceClientParam("definition");
    public static final Include INCLUDE_DEFINITION = new Include("ProcedureRequest:definition").toLocked();
    @SearchParamDefinition(name="body-site", path="ProcedureRequest.bodySite", description="Where procedure is going to be done", type="token")
    public static final String SP_BODY_SITE = "body-site";
    public static final TokenClientParam BODY_SITE = new TokenClientParam("body-site");
    @SearchParamDefinition(name="status", path="ProcedureRequest.status", description="draft | active | suspended | completed | entered-in-error | cancelled", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ProcedureRequest() {
    }

    public ProcedureRequest(Enumeration<ProcedureRequestStatus> status, Enumeration<ProcedureRequestIntent> intent, CodeableConcept code, Reference subject) {
        this.status = status;
        this.intent = intent;
        this.code = code;
        this.subject = subject;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public ProcedureRequest setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ProcedureRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public List<Reference> getDefinition() {
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        return this.definition;
    }

    public ProcedureRequest setDefinition(List<Reference> theDefinition) {
        this.definition = theDefinition;
        return this;
    }

    public boolean hasDefinition() {
        if (this.definition == null) {
            return false;
        }
        for (Reference item : this.definition) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDefinition() {
        Reference t = new Reference();
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return t;
    }

    public ProcedureRequest addDefinition(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.definition == null) {
            this.definition = new ArrayList<Reference>();
        }
        this.definition.add(t);
        return this;
    }

    public Reference getDefinitionFirstRep() {
        if (this.getDefinition().isEmpty()) {
            this.addDefinition();
        }
        return this.getDefinition().get(0);
    }

    @Deprecated
    public List<Resource> getDefinitionTarget() {
        if (this.definitionTarget == null) {
            this.definitionTarget = new ArrayList<Resource>();
        }
        return this.definitionTarget;
    }

    public List<Reference> getBasedOn() {
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        return this.basedOn;
    }

    public ProcedureRequest setBasedOn(List<Reference> theBasedOn) {
        this.basedOn = theBasedOn;
        return this;
    }

    public boolean hasBasedOn() {
        if (this.basedOn == null) {
            return false;
        }
        for (Reference item : this.basedOn) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addBasedOn() {
        Reference t = new Reference();
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return t;
    }

    public ProcedureRequest addBasedOn(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.basedOn == null) {
            this.basedOn = new ArrayList<Reference>();
        }
        this.basedOn.add(t);
        return this;
    }

    public Reference getBasedOnFirstRep() {
        if (this.getBasedOn().isEmpty()) {
            this.addBasedOn();
        }
        return this.getBasedOn().get(0);
    }

    @Deprecated
    public List<Resource> getBasedOnTarget() {
        if (this.basedOnTarget == null) {
            this.basedOnTarget = new ArrayList<Resource>();
        }
        return this.basedOnTarget;
    }

    public List<Reference> getReplaces() {
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        return this.replaces;
    }

    public ProcedureRequest setReplaces(List<Reference> theReplaces) {
        this.replaces = theReplaces;
        return this;
    }

    public boolean hasReplaces() {
        if (this.replaces == null) {
            return false;
        }
        for (Reference item : this.replaces) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReplaces() {
        Reference t = new Reference();
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return t;
    }

    public ProcedureRequest addReplaces(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.replaces == null) {
            this.replaces = new ArrayList<Reference>();
        }
        this.replaces.add(t);
        return this;
    }

    public Reference getReplacesFirstRep() {
        if (this.getReplaces().isEmpty()) {
            this.addReplaces();
        }
        return this.getReplaces().get(0);
    }

    @Deprecated
    public List<Resource> getReplacesTarget() {
        if (this.replacesTarget == null) {
            this.replacesTarget = new ArrayList<Resource>();
        }
        return this.replacesTarget;
    }

    public Identifier getRequisition() {
        if (this.requisition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.requisition");
            }
            if (Configuration.doAutoCreate()) {
                this.requisition = new Identifier();
            }
        }
        return this.requisition;
    }

    public boolean hasRequisition() {
        return this.requisition != null && !this.requisition.isEmpty();
    }

    public ProcedureRequest setRequisition(Identifier value) {
        this.requisition = value;
        return this;
    }

    public Enumeration<ProcedureRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<ProcedureRequestStatus>(new ProcedureRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public ProcedureRequest setStatusElement(Enumeration<ProcedureRequestStatus> value) {
        this.status = value;
        return this;
    }

    public ProcedureRequestStatus getStatus() {
        return this.status == null ? null : (ProcedureRequestStatus)((Object)this.status.getValue());
    }

    public ProcedureRequest setStatus(ProcedureRequestStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<ProcedureRequestStatus>(new ProcedureRequestStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Enumeration<ProcedureRequestIntent> getIntentElement() {
        if (this.intent == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.intent");
            }
            if (Configuration.doAutoCreate()) {
                this.intent = new Enumeration<ProcedureRequestIntent>(new ProcedureRequestIntentEnumFactory());
            }
        }
        return this.intent;
    }

    public boolean hasIntentElement() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public boolean hasIntent() {
        return this.intent != null && !this.intent.isEmpty();
    }

    public ProcedureRequest setIntentElement(Enumeration<ProcedureRequestIntent> value) {
        this.intent = value;
        return this;
    }

    public ProcedureRequestIntent getIntent() {
        return this.intent == null ? null : (ProcedureRequestIntent)((Object)this.intent.getValue());
    }

    public ProcedureRequest setIntent(ProcedureRequestIntent value) {
        if (this.intent == null) {
            this.intent = new Enumeration<ProcedureRequestIntent>(new ProcedureRequestIntentEnumFactory());
        }
        this.intent.setValue((Object)value);
        return this;
    }

    public Enumeration<ProcedureRequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<ProcedureRequestPriority>(new ProcedureRequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public ProcedureRequest setPriorityElement(Enumeration<ProcedureRequestPriority> value) {
        this.priority = value;
        return this;
    }

    public ProcedureRequestPriority getPriority() {
        return this.priority == null ? null : (ProcedureRequestPriority)((Object)this.priority.getValue());
    }

    public ProcedureRequest setPriority(ProcedureRequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<ProcedureRequestPriority>(new ProcedureRequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    public BooleanType getDoNotPerformElement() {
        if (this.doNotPerform == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.doNotPerform");
            }
            if (Configuration.doAutoCreate()) {
                this.doNotPerform = new BooleanType();
            }
        }
        return this.doNotPerform;
    }

    public boolean hasDoNotPerformElement() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public boolean hasDoNotPerform() {
        return this.doNotPerform != null && !this.doNotPerform.isEmpty();
    }

    public ProcedureRequest setDoNotPerformElement(BooleanType value) {
        this.doNotPerform = value;
        return this;
    }

    public boolean getDoNotPerform() {
        return this.doNotPerform == null || this.doNotPerform.isEmpty() ? false : (Boolean)this.doNotPerform.getValue();
    }

    public ProcedureRequest setDoNotPerform(boolean value) {
        if (this.doNotPerform == null) {
            this.doNotPerform = new BooleanType();
        }
        this.doNotPerform.setValue((Object)value);
        return this;
    }

    public List<CodeableConcept> getCategory() {
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        return this.category;
    }

    public ProcedureRequest setCategory(List<CodeableConcept> theCategory) {
        this.category = theCategory;
        return this;
    }

    public boolean hasCategory() {
        if (this.category == null) {
            return false;
        }
        for (CodeableConcept item : this.category) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCategory() {
        CodeableConcept t = new CodeableConcept();
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return t;
    }

    public ProcedureRequest addCategory(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.category == null) {
            this.category = new ArrayList<CodeableConcept>();
        }
        this.category.add(t);
        return this;
    }

    public CodeableConcept getCategoryFirstRep() {
        if (this.getCategory().isEmpty()) {
            this.addCategory();
        }
        return this.getCategory().get(0);
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public ProcedureRequest setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public ProcedureRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public ProcedureRequest setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getContext() {
        if (this.context == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.context");
            }
            if (Configuration.doAutoCreate()) {
                this.context = new Reference();
            }
        }
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null && !this.context.isEmpty();
    }

    public ProcedureRequest setContext(Reference value) {
        this.context = value;
        return this;
    }

    public Resource getContextTarget() {
        return this.contextTarget;
    }

    public ProcedureRequest setContextTarget(Resource value) {
        this.contextTarget = value;
        return this;
    }

    public Type getOccurrence() {
        return this.occurrence;
    }

    public DateTimeType getOccurrenceDateTimeType() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.occurrence;
    }

    public boolean hasOccurrenceDateTimeType() {
        return this != null && this.occurrence instanceof DateTimeType;
    }

    public Period getOccurrencePeriod() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Period)this.occurrence;
    }

    public boolean hasOccurrencePeriod() {
        return this != null && this.occurrence instanceof Period;
    }

    public Timing getOccurrenceTiming() throws FHIRException {
        if (this.occurrence == null) {
            return null;
        }
        if (!(this.occurrence instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.occurrence.getClass().getName() + " was encountered");
        }
        return (Timing)this.occurrence;
    }

    public boolean hasOccurrenceTiming() {
        return this != null && this.occurrence instanceof Timing;
    }

    public boolean hasOccurrence() {
        return this.occurrence != null && !this.occurrence.isEmpty();
    }

    public ProcedureRequest setOccurrence(Type value) throws FHIRFormatError {
        if (!(value == null || value instanceof DateTimeType || value instanceof Period || value instanceof Timing)) {
            throw new FHIRFormatError("Not the right type for ProcedureRequest.occurrence[x]: " + value.fhirType());
        }
        this.occurrence = value;
        return this;
    }

    public Type getAsNeeded() {
        return this.asNeeded;
    }

    public BooleanType getAsNeededBooleanType() throws FHIRException {
        if (this.asNeeded == null) {
            return null;
        }
        if (!(this.asNeeded instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.asNeeded;
    }

    public boolean hasAsNeededBooleanType() {
        return this != null && this.asNeeded instanceof BooleanType;
    }

    public CodeableConcept getAsNeededCodeableConcept() throws FHIRException {
        if (this.asNeeded == null) {
            return null;
        }
        if (!(this.asNeeded instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.asNeeded.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.asNeeded;
    }

    public boolean hasAsNeededCodeableConcept() {
        return this != null && this.asNeeded instanceof CodeableConcept;
    }

    public boolean hasAsNeeded() {
        return this.asNeeded != null && !this.asNeeded.isEmpty();
    }

    public ProcedureRequest setAsNeeded(Type value) throws FHIRFormatError {
        if (value != null && !(value instanceof BooleanType) && !(value instanceof CodeableConcept)) {
            throw new FHIRFormatError("Not the right type for ProcedureRequest.asNeeded[x]: " + value.fhirType());
        }
        this.asNeeded = value;
        return this;
    }

    public DateTimeType getAuthoredOnElement() {
        if (this.authoredOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.authoredOn");
            }
            if (Configuration.doAutoCreate()) {
                this.authoredOn = new DateTimeType();
            }
        }
        return this.authoredOn;
    }

    public boolean hasAuthoredOnElement() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public boolean hasAuthoredOn() {
        return this.authoredOn != null && !this.authoredOn.isEmpty();
    }

    public ProcedureRequest setAuthoredOnElement(DateTimeType value) {
        this.authoredOn = value;
        return this;
    }

    public Date getAuthoredOn() {
        return this.authoredOn == null ? null : (Date)this.authoredOn.getValue();
    }

    public ProcedureRequest setAuthoredOn(Date value) {
        if (value == null) {
            this.authoredOn = null;
        } else {
            if (this.authoredOn == null) {
                this.authoredOn = new DateTimeType();
            }
            this.authoredOn.setValue(value);
        }
        return this;
    }

    public ProcedureRequestRequesterComponent getRequester() {
        if (this.requester == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.requester");
            }
            if (Configuration.doAutoCreate()) {
                this.requester = new ProcedureRequestRequesterComponent();
            }
        }
        return this.requester;
    }

    public boolean hasRequester() {
        return this.requester != null && !this.requester.isEmpty();
    }

    public ProcedureRequest setRequester(ProcedureRequestRequesterComponent value) {
        this.requester = value;
        return this;
    }

    public CodeableConcept getPerformerType() {
        if (this.performerType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.performerType");
            }
            if (Configuration.doAutoCreate()) {
                this.performerType = new CodeableConcept();
            }
        }
        return this.performerType;
    }

    public boolean hasPerformerType() {
        return this.performerType != null && !this.performerType.isEmpty();
    }

    public ProcedureRequest setPerformerType(CodeableConcept value) {
        this.performerType = value;
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ProcedureRequest.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public ProcedureRequest setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Resource getPerformerTarget() {
        return this.performerTarget;
    }

    public ProcedureRequest setPerformerTarget(Resource value) {
        this.performerTarget = value;
        return this;
    }

    public List<CodeableConcept> getReasonCode() {
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        return this.reasonCode;
    }

    public ProcedureRequest setReasonCode(List<CodeableConcept> theReasonCode) {
        this.reasonCode = theReasonCode;
        return this;
    }

    public boolean hasReasonCode() {
        if (this.reasonCode == null) {
            return false;
        }
        for (CodeableConcept item : this.reasonCode) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReasonCode() {
        CodeableConcept t = new CodeableConcept();
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return t;
    }

    public ProcedureRequest addReasonCode(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reasonCode == null) {
            this.reasonCode = new ArrayList<CodeableConcept>();
        }
        this.reasonCode.add(t);
        return this;
    }

    public CodeableConcept getReasonCodeFirstRep() {
        if (this.getReasonCode().isEmpty()) {
            this.addReasonCode();
        }
        return this.getReasonCode().get(0);
    }

    public List<Reference> getReasonReference() {
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        return this.reasonReference;
    }

    public ProcedureRequest setReasonReference(List<Reference> theReasonReference) {
        this.reasonReference = theReasonReference;
        return this;
    }

    public boolean hasReasonReference() {
        if (this.reasonReference == null) {
            return false;
        }
        for (Reference item : this.reasonReference) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addReasonReference() {
        Reference t = new Reference();
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return t;
    }

    public ProcedureRequest addReasonReference(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.reasonReference == null) {
            this.reasonReference = new ArrayList<Reference>();
        }
        this.reasonReference.add(t);
        return this;
    }

    public Reference getReasonReferenceFirstRep() {
        if (this.getReasonReference().isEmpty()) {
            this.addReasonReference();
        }
        return this.getReasonReference().get(0);
    }

    @Deprecated
    public List<Resource> getReasonReferenceTarget() {
        if (this.reasonReferenceTarget == null) {
            this.reasonReferenceTarget = new ArrayList<Resource>();
        }
        return this.reasonReferenceTarget;
    }

    public List<Reference> getSupportingInfo() {
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        return this.supportingInfo;
    }

    public ProcedureRequest setSupportingInfo(List<Reference> theSupportingInfo) {
        this.supportingInfo = theSupportingInfo;
        return this;
    }

    public boolean hasSupportingInfo() {
        if (this.supportingInfo == null) {
            return false;
        }
        for (Reference item : this.supportingInfo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSupportingInfo() {
        Reference t = new Reference();
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return t;
    }

    public ProcedureRequest addSupportingInfo(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.supportingInfo == null) {
            this.supportingInfo = new ArrayList<Reference>();
        }
        this.supportingInfo.add(t);
        return this;
    }

    public Reference getSupportingInfoFirstRep() {
        if (this.getSupportingInfo().isEmpty()) {
            this.addSupportingInfo();
        }
        return this.getSupportingInfo().get(0);
    }

    @Deprecated
    public List<Resource> getSupportingInfoTarget() {
        if (this.supportingInfoTarget == null) {
            this.supportingInfoTarget = new ArrayList<Resource>();
        }
        return this.supportingInfoTarget;
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public ProcedureRequest setSpecimen(List<Reference> theSpecimen) {
        this.specimen = theSpecimen;
        return this;
    }

    public boolean hasSpecimen() {
        if (this.specimen == null) {
            return false;
        }
        for (Reference item : this.specimen) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSpecimen() {
        Reference t = new Reference();
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return t;
    }

    public ProcedureRequest addSpecimen(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return this;
    }

    public Reference getSpecimenFirstRep() {
        if (this.getSpecimen().isEmpty()) {
            this.addSpecimen();
        }
        return this.getSpecimen().get(0);
    }

    @Deprecated
    public List<Specimen> getSpecimenTarget() {
        if (this.specimenTarget == null) {
            this.specimenTarget = new ArrayList<Specimen>();
        }
        return this.specimenTarget;
    }

    @Deprecated
    public Specimen addSpecimenTarget() {
        Specimen r = new Specimen();
        if (this.specimenTarget == null) {
            this.specimenTarget = new ArrayList<Specimen>();
        }
        this.specimenTarget.add(r);
        return r;
    }

    public List<CodeableConcept> getBodySite() {
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        return this.bodySite;
    }

    public ProcedureRequest setBodySite(List<CodeableConcept> theBodySite) {
        this.bodySite = theBodySite;
        return this;
    }

    public boolean hasBodySite() {
        if (this.bodySite == null) {
            return false;
        }
        for (CodeableConcept item : this.bodySite) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addBodySite() {
        CodeableConcept t = new CodeableConcept();
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return t;
    }

    public ProcedureRequest addBodySite(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.bodySite == null) {
            this.bodySite = new ArrayList<CodeableConcept>();
        }
        this.bodySite.add(t);
        return this;
    }

    public CodeableConcept getBodySiteFirstRep() {
        if (this.getBodySite().isEmpty()) {
            this.addBodySite();
        }
        return this.getBodySite().get(0);
    }

    public List<Annotation> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        return this.note;
    }

    public ProcedureRequest setNote(List<Annotation> theNote) {
        this.note = theNote;
        return this;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (Annotation item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Annotation addNote() {
        Annotation t = new Annotation();
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return t;
    }

    public ProcedureRequest addNote(Annotation t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<Annotation>();
        }
        this.note.add(t);
        return this;
    }

    public Annotation getNoteFirstRep() {
        if (this.getNote().isEmpty()) {
            this.addNote();
        }
        return this.getNote().get(0);
    }

    public List<Reference> getRelevantHistory() {
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        return this.relevantHistory;
    }

    public ProcedureRequest setRelevantHistory(List<Reference> theRelevantHistory) {
        this.relevantHistory = theRelevantHistory;
        return this;
    }

    public boolean hasRelevantHistory() {
        if (this.relevantHistory == null) {
            return false;
        }
        for (Reference item : this.relevantHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRelevantHistory() {
        Reference t = new Reference();
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return t;
    }

    public ProcedureRequest addRelevantHistory(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.relevantHistory == null) {
            this.relevantHistory = new ArrayList<Reference>();
        }
        this.relevantHistory.add(t);
        return this;
    }

    public Reference getRelevantHistoryFirstRep() {
        if (this.getRelevantHistory().isEmpty()) {
            this.addRelevantHistory();
        }
        return this.getRelevantHistory().get(0);
    }

    @Deprecated
    public List<Provenance> getRelevantHistoryTarget() {
        if (this.relevantHistoryTarget == null) {
            this.relevantHistoryTarget = new ArrayList<Provenance>();
        }
        return this.relevantHistoryTarget;
    }

    @Deprecated
    public Provenance addRelevantHistoryTarget() {
        Provenance r = new Provenance();
        if (this.relevantHistoryTarget == null) {
            this.relevantHistoryTarget = new ArrayList<Provenance>();
        }
        this.relevantHistoryTarget.add(r);
        return r;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order instance by the orderer and/or the receiver and/or order fulfiller.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_DEFINITION, "Reference(ActivityDefinition|PlanDefinition)", "Protocol or definition followed by this request.", 0, Integer.MAX_VALUE, this.definition));
        children.add(new Property("basedOn", "Reference(Any)", "Plan/proposal/order fulfilled by this request.", 0, Integer.MAX_VALUE, this.basedOn));
        children.add(new Property(SP_REPLACES, "Reference(Any)", "The request takes the place of the referenced completed or terminated request(s).", 0, Integer.MAX_VALUE, this.replaces));
        children.add(new Property(SP_REQUISITION, "Identifier", "A shared identifier common to all procedure or diagnostic requests that were authorized more or less simultaneously by a single author, representing the composite or group identifier.", 0, 1, this.requisition));
        children.add(new Property(SP_STATUS, SP_CODE, "The status of the order.", 0, 1, this.status));
        children.add(new Property(SP_INTENT, SP_CODE, "Whether the request is a proposal, plan, an original order or a reflex order.", 0, 1, this.intent));
        children.add(new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the ProcedureRequest should be addressed with respect to other requests.", 0, 1, this.priority));
        children.add(new Property("doNotPerform", "boolean", "Set this to true if the record is saying that the procedure should NOT be performed.", 0, 1, this.doNotPerform));
        children.add(new Property("category", "CodeableConcept", "A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").", 0, Integer.MAX_VALUE, this.category));
        children.add(new Property(SP_CODE, "CodeableConcept", "A code that identifies a particular procedure, diagnostic investigation, or panel of investigations, that have been requested.", 0, 1, this.code));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Location|Device)", "On whom or what the procedure or diagnostic is to be performed. This is usually a human patient, but can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans).", 0, 1, this.subject));
        children.add(new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "An encounter or episode of care that provides additional information about the healthcare context in which this request is made.", 0, 1, this.context));
        children.add(new Property("occurrence[x]", "dateTime|Period|Timing", "The date/time at which the diagnostic testing should occur.", 0, 1, this.occurrence));
        children.add(new Property("asNeeded[x]", "boolean|CodeableConcept", "If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.  For example \"pain\", \"on flare-up\", etc.", 0, 1, this.asNeeded));
        children.add(new Property("authoredOn", "dateTime", "When the request transitioned to being actionable.", 0, 1, this.authoredOn));
        children.add(new Property(SP_REQUESTER, "", "The individual who initiated the request and has responsibility for its activation.", 0, 1, this.requester));
        children.add(new Property("performerType", "CodeableConcept", "Desired type of performer for doing the diagnostic testing.", 0, 1, this.performerType));
        children.add(new Property(SP_PERFORMER, "Reference(Practitioner|Organization|Patient|Device|RelatedPerson|HealthcareService)", "The desired perfomer for doing the diagnostic testing.  For example, the surgeon, dermatopathologist, endoscopist, etc.", 0, 1, this.performer));
        children.add(new Property("reasonCode", "CodeableConcept", "An explanation or justification for why this diagnostic investigation is being requested in coded or textual form.   This is often for billing purposes.  May relate to the resources referred to in supportingInformation.", 0, Integer.MAX_VALUE, this.reasonCode));
        children.add(new Property("reasonReference", "Reference(Condition|Observation)", "Indicates another resource that provides a justification for why this diagnostic investigation is being requested.   May relate to the resources referred to in supportingInformation.", 0, Integer.MAX_VALUE, this.reasonReference));
        children.add(new Property("supportingInfo", "Reference(Any)", "Additional clinical information about the patient or specimen that may influence the procedure or diagnostics or their interpretations.     This information includes diagnosis, clinical findings and other observations.  In laboratory ordering these are typically referred to as \"ask at order entry questions (AOEs)\".  This includes observations explicitly requested by the producer (filler) to provide context or supporting information needed to complete the order. For example,  reporting the amount of inspired oxygen for blood gas measurements.", 0, Integer.MAX_VALUE, this.supportingInfo));
        children.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "One or more specimens that the laboratory procedure will use.", 0, Integer.MAX_VALUE, this.specimen));
        children.add(new Property("bodySite", "CodeableConcept", "Anatomic location where the procedure should be performed. This is the target site.", 0, Integer.MAX_VALUE, this.bodySite));
        children.add(new Property("note", "Annotation", "Any other notes and comments made about the service request. For example, letting provider know that \"patient hates needles\" or other provider instructions.", 0, Integer.MAX_VALUE, this.note));
        children.add(new Property("relevantHistory", "Reference(Provenance)", "Key events in the history of the request.", 0, Integer.MAX_VALUE, this.relevantHistory));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifiers assigned to this order instance by the orderer and/or the receiver and/or order fulfiller.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1014418093: {
                return new Property(SP_DEFINITION, "Reference(ActivityDefinition|PlanDefinition)", "Protocol or definition followed by this request.", 0, Integer.MAX_VALUE, this.definition);
            }
            case -332612366: {
                return new Property("basedOn", "Reference(Any)", "Plan/proposal/order fulfilled by this request.", 0, Integer.MAX_VALUE, this.basedOn);
            }
            case -430332865: {
                return new Property(SP_REPLACES, "Reference(Any)", "The request takes the place of the referenced completed or terminated request(s).", 0, Integer.MAX_VALUE, this.replaces);
            }
            case 395923612: {
                return new Property(SP_REQUISITION, "Identifier", "A shared identifier common to all procedure or diagnostic requests that were authorized more or less simultaneously by a single author, representing the composite or group identifier.", 0, 1, this.requisition);
            }
            case -892481550: {
                return new Property(SP_STATUS, SP_CODE, "The status of the order.", 0, 1, this.status);
            }
            case -1183762788: {
                return new Property(SP_INTENT, SP_CODE, "Whether the request is a proposal, plan, an original order or a reflex order.", 0, 1, this.intent);
            }
            case -1165461084: {
                return new Property(SP_PRIORITY, SP_CODE, "Indicates how quickly the ProcedureRequest should be addressed with respect to other requests.", 0, 1, this.priority);
            }
            case -1788508167: {
                return new Property("doNotPerform", "boolean", "Set this to true if the record is saying that the procedure should NOT be performed.", 0, 1, this.doNotPerform);
            }
            case 50511102: {
                return new Property("category", "CodeableConcept", "A code that classifies the procedure for searching, sorting and display purposes (e.g. \"Surgical Procedure\").", 0, Integer.MAX_VALUE, this.category);
            }
            case 3059181: {
                return new Property(SP_CODE, "CodeableConcept", "A code that identifies a particular procedure, diagnostic investigation, or panel of investigations, that have been requested.", 0, 1, this.code);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group|Location|Device)", "On whom or what the procedure or diagnostic is to be performed. This is usually a human patient, but can also be requested on animals, groups of humans or animals, devices such as dialysis machines, or even locations (typically for environmental scans).", 0, 1, this.subject);
            }
            case 951530927: {
                return new Property(SP_CONTEXT, "Reference(Encounter|EpisodeOfCare)", "An encounter or episode of care that provides additional information about the healthcare context in which this request is made.", 0, 1, this.context);
            }
            case -2022646513: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date/time at which the diagnostic testing should occur.", 0, 1, this.occurrence);
            }
            case 1687874001: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date/time at which the diagnostic testing should occur.", 0, 1, this.occurrence);
            }
            case -298443636: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date/time at which the diagnostic testing should occur.", 0, 1, this.occurrence);
            }
            case 1397156594: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date/time at which the diagnostic testing should occur.", 0, 1, this.occurrence);
            }
            case 1515218299: {
                return new Property("occurrence[x]", "dateTime|Period|Timing", "The date/time at which the diagnostic testing should occur.", 0, 1, this.occurrence);
            }
            case -544329575: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.  For example \"pain\", \"on flare-up\", etc.", 0, 1, this.asNeeded);
            }
            case -1432923513: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.  For example \"pain\", \"on flare-up\", etc.", 0, 1, this.asNeeded);
            }
            case -591717471: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.  For example \"pain\", \"on flare-up\", etc.", 0, 1, this.asNeeded);
            }
            case 1556420122: {
                return new Property("asNeeded[x]", "boolean|CodeableConcept", "If a CodeableConcept is present, it indicates the pre-condition for performing the procedure.  For example \"pain\", \"on flare-up\", etc.", 0, 1, this.asNeeded);
            }
            case -1500852503: {
                return new Property("authoredOn", "dateTime", "When the request transitioned to being actionable.", 0, 1, this.authoredOn);
            }
            case 693933948: {
                return new Property(SP_REQUESTER, "", "The individual who initiated the request and has responsibility for its activation.", 0, 1, this.requester);
            }
            case -901444568: {
                return new Property("performerType", "CodeableConcept", "Desired type of performer for doing the diagnostic testing.", 0, 1, this.performerType);
            }
            case 481140686: {
                return new Property(SP_PERFORMER, "Reference(Practitioner|Organization|Patient|Device|RelatedPerson|HealthcareService)", "The desired perfomer for doing the diagnostic testing.  For example, the surgeon, dermatopathologist, endoscopist, etc.", 0, 1, this.performer);
            }
            case 722137681: {
                return new Property("reasonCode", "CodeableConcept", "An explanation or justification for why this diagnostic investigation is being requested in coded or textual form.   This is often for billing purposes.  May relate to the resources referred to in supportingInformation.", 0, Integer.MAX_VALUE, this.reasonCode);
            }
            case -1146218137: {
                return new Property("reasonReference", "Reference(Condition|Observation)", "Indicates another resource that provides a justification for why this diagnostic investigation is being requested.   May relate to the resources referred to in supportingInformation.", 0, Integer.MAX_VALUE, this.reasonReference);
            }
            case 1922406657: {
                return new Property("supportingInfo", "Reference(Any)", "Additional clinical information about the patient or specimen that may influence the procedure or diagnostics or their interpretations.     This information includes diagnosis, clinical findings and other observations.  In laboratory ordering these are typically referred to as \"ask at order entry questions (AOEs)\".  This includes observations explicitly requested by the producer (filler) to provide context or supporting information needed to complete the order. For example,  reporting the amount of inspired oxygen for blood gas measurements.", 0, Integer.MAX_VALUE, this.supportingInfo);
            }
            case -2132868344: {
                return new Property(SP_SPECIMEN, "Reference(Specimen)", "One or more specimens that the laboratory procedure will use.", 0, Integer.MAX_VALUE, this.specimen);
            }
            case 1702620169: {
                return new Property("bodySite", "CodeableConcept", "Anatomic location where the procedure should be performed. This is the target site.", 0, Integer.MAX_VALUE, this.bodySite);
            }
            case 3387378: {
                return new Property("note", "Annotation", "Any other notes and comments made about the service request. For example, letting provider know that \"patient hates needles\" or other provider instructions.", 0, Integer.MAX_VALUE, this.note);
            }
            case 1538891575: {
                return new Property("relevantHistory", "Reference(Provenance)", "Key events in the history of the request.", 0, Integer.MAX_VALUE, this.relevantHistory);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1014418093: {
                return this.definition == null ? new Base[]{} : this.definition.toArray(new Base[this.definition.size()]);
            }
            case -332612366: {
                return this.basedOn == null ? new Base[]{} : this.basedOn.toArray(new Base[this.basedOn.size()]);
            }
            case -430332865: {
                return this.replaces == null ? new Base[]{} : this.replaces.toArray(new Base[this.replaces.size()]);
            }
            case 395923612: {
                Base[] baseArray;
                if (this.requisition == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.requisition;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.status;
                }
                return baseArray;
            }
            case -1183762788: {
                Base[] baseArray;
                if (this.intent == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.intent;
                }
                return baseArray;
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.priority;
                }
                return baseArray;
            }
            case -1788508167: {
                Base[] baseArray;
                if (this.doNotPerform == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.doNotPerform;
                }
                return baseArray;
            }
            case 50511102: {
                return this.category == null ? new Base[]{} : this.category.toArray(new Base[this.category.size()]);
            }
            case 3059181: {
                Base[] baseArray;
                if (this.code == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.code;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.subject;
                }
                return baseArray;
            }
            case 951530927: {
                Base[] baseArray;
                if (this.context == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.context;
                }
                return baseArray;
            }
            case 1687874001: {
                Base[] baseArray;
                if (this.occurrence == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.occurrence;
                }
                return baseArray;
            }
            case -1432923513: {
                Base[] baseArray;
                if (this.asNeeded == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.asNeeded;
                }
                return baseArray;
            }
            case -1500852503: {
                Base[] baseArray;
                if (this.authoredOn == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.authoredOn;
                }
                return baseArray;
            }
            case 693933948: {
                Base[] baseArray;
                if (this.requester == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray13 = new Base[1];
                    baseArray = baseArray13;
                    baseArray13[0] = this.requester;
                }
                return baseArray;
            }
            case -901444568: {
                Base[] baseArray;
                if (this.performerType == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray14 = new Base[1];
                    baseArray = baseArray14;
                    baseArray14[0] = this.performerType;
                }
                return baseArray;
            }
            case 481140686: {
                Base[] baseArray;
                if (this.performer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray15 = new Base[1];
                    baseArray = baseArray15;
                    baseArray15[0] = this.performer;
                }
                return baseArray;
            }
            case 722137681: {
                return this.reasonCode == null ? new Base[]{} : this.reasonCode.toArray(new Base[this.reasonCode.size()]);
            }
            case -1146218137: {
                return this.reasonReference == null ? new Base[]{} : this.reasonReference.toArray(new Base[this.reasonReference.size()]);
            }
            case 1922406657: {
                return this.supportingInfo == null ? new Base[]{} : this.supportingInfo.toArray(new Base[this.supportingInfo.size()]);
            }
            case -2132868344: {
                return this.specimen == null ? new Base[]{} : this.specimen.toArray(new Base[this.specimen.size()]);
            }
            case 1702620169: {
                return this.bodySite == null ? new Base[]{} : this.bodySite.toArray(new Base[this.bodySite.size()]);
            }
            case 3387378: {
                return this.note == null ? new Base[]{} : this.note.toArray(new Base[this.note.size()]);
            }
            case 1538891575: {
                return this.relevantHistory == null ? new Base[]{} : this.relevantHistory.toArray(new Base[this.relevantHistory.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -1014418093: {
                this.getDefinition().add(this.castToReference(value));
                return value;
            }
            case -332612366: {
                this.getBasedOn().add(this.castToReference(value));
                return value;
            }
            case -430332865: {
                this.getReplaces().add(this.castToReference(value));
                return value;
            }
            case 395923612: {
                this.requisition = this.castToIdentifier(value);
                return value;
            }
            case -892481550: {
                value = new ProcedureRequestStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -1183762788: {
                value = new ProcedureRequestIntentEnumFactory().fromType(this.castToCode(value));
                this.intent = value;
                return value;
            }
            case -1165461084: {
                value = new ProcedureRequestPriorityEnumFactory().fromType(this.castToCode(value));
                this.priority = value;
                return value;
            }
            case -1788508167: {
                this.doNotPerform = this.castToBoolean(value);
                return value;
            }
            case 50511102: {
                this.getCategory().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3059181: {
                this.code = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case 951530927: {
                this.context = this.castToReference(value);
                return value;
            }
            case 1687874001: {
                this.occurrence = this.castToType(value);
                return value;
            }
            case -1432923513: {
                this.asNeeded = this.castToType(value);
                return value;
            }
            case -1500852503: {
                this.authoredOn = this.castToDateTime(value);
                return value;
            }
            case 693933948: {
                this.requester = (ProcedureRequestRequesterComponent)((Object)value);
                return value;
            }
            case -901444568: {
                this.performerType = this.castToCodeableConcept(value);
                return value;
            }
            case 481140686: {
                this.performer = this.castToReference(value);
                return value;
            }
            case 722137681: {
                this.getReasonCode().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1146218137: {
                this.getReasonReference().add(this.castToReference(value));
                return value;
            }
            case 1922406657: {
                this.getSupportingInfo().add(this.castToReference(value));
                return value;
            }
            case -2132868344: {
                this.getSpecimen().add(this.castToReference(value));
                return value;
            }
            case 1702620169: {
                this.getBodySite().add(this.castToCodeableConcept(value));
                return value;
            }
            case 3387378: {
                this.getNote().add(this.castToAnnotation(value));
                return value;
            }
            case 1538891575: {
                this.getRelevantHistory().add(this.castToReference(value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_DEFINITION)) {
            this.getDefinition().add(this.castToReference(value));
        } else if (name.equals("basedOn")) {
            this.getBasedOn().add(this.castToReference(value));
        } else if (name.equals(SP_REPLACES)) {
            this.getReplaces().add(this.castToReference(value));
        } else if (name.equals(SP_REQUISITION)) {
            this.requisition = this.castToIdentifier(value);
        } else if (name.equals(SP_STATUS)) {
            value = new ProcedureRequestStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals(SP_INTENT)) {
            value = new ProcedureRequestIntentEnumFactory().fromType(this.castToCode(value));
            this.intent = value;
        } else if (name.equals(SP_PRIORITY)) {
            value = new ProcedureRequestPriorityEnumFactory().fromType(this.castToCode(value));
            this.priority = value;
        } else if (name.equals("doNotPerform")) {
            this.doNotPerform = this.castToBoolean(value);
        } else if (name.equals("category")) {
            this.getCategory().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_CONTEXT)) {
            this.context = this.castToReference(value);
        } else if (name.equals("occurrence[x]")) {
            this.occurrence = this.castToType(value);
        } else if (name.equals("asNeeded[x]")) {
            this.asNeeded = this.castToType(value);
        } else if (name.equals("authoredOn")) {
            this.authoredOn = this.castToDateTime(value);
        } else if (name.equals(SP_REQUESTER)) {
            this.requester = (ProcedureRequestRequesterComponent)((Object)value);
        } else if (name.equals("performerType")) {
            this.performerType = this.castToCodeableConcept(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = this.castToReference(value);
        } else if (name.equals("reasonCode")) {
            this.getReasonCode().add(this.castToCodeableConcept(value));
        } else if (name.equals("reasonReference")) {
            this.getReasonReference().add(this.castToReference(value));
        } else if (name.equals("supportingInfo")) {
            this.getSupportingInfo().add(this.castToReference(value));
        } else if (name.equals(SP_SPECIMEN)) {
            this.getSpecimen().add(this.castToReference(value));
        } else if (name.equals("bodySite")) {
            this.getBodySite().add(this.castToCodeableConcept(value));
        } else if (name.equals("note")) {
            this.getNote().add(this.castToAnnotation(value));
        } else if (name.equals("relevantHistory")) {
            this.getRelevantHistory().add(this.castToReference(value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1014418093: {
                return this.addDefinition();
            }
            case -332612366: {
                return this.addBasedOn();
            }
            case -430332865: {
                return this.addReplaces();
            }
            case 395923612: {
                return this.getRequisition();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -1183762788: {
                return this.getIntentElement();
            }
            case -1165461084: {
                return this.getPriorityElement();
            }
            case -1788508167: {
                return this.getDoNotPerformElement();
            }
            case 50511102: {
                return this.addCategory();
            }
            case 3059181: {
                return this.getCode();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case 951530927: {
                return this.getContext();
            }
            case -2022646513: {
                return this.getOccurrence();
            }
            case 1687874001: {
                return this.getOccurrence();
            }
            case -544329575: {
                return this.getAsNeeded();
            }
            case -1432923513: {
                return this.getAsNeeded();
            }
            case -1500852503: {
                return this.getAuthoredOnElement();
            }
            case 693933948: {
                return this.getRequester();
            }
            case -901444568: {
                return this.getPerformerType();
            }
            case 481140686: {
                return this.getPerformer();
            }
            case 722137681: {
                return this.addReasonCode();
            }
            case -1146218137: {
                return this.addReasonReference();
            }
            case 1922406657: {
                return this.addSupportingInfo();
            }
            case -2132868344: {
                return this.addSpecimen();
            }
            case 1702620169: {
                return this.addBodySite();
            }
            case 3387378: {
                return this.addNote();
            }
            case 1538891575: {
                return this.addRelevantHistory();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1014418093: {
                return new String[]{"Reference"};
            }
            case -332612366: {
                return new String[]{"Reference"};
            }
            case -430332865: {
                return new String[]{"Reference"};
            }
            case 395923612: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{SP_CODE};
            }
            case -1183762788: {
                return new String[]{SP_CODE};
            }
            case -1165461084: {
                return new String[]{SP_CODE};
            }
            case -1788508167: {
                return new String[]{"boolean"};
            }
            case 50511102: {
                return new String[]{"CodeableConcept"};
            }
            case 3059181: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case 951530927: {
                return new String[]{"Reference"};
            }
            case 1687874001: {
                return new String[]{"dateTime", "Period", "Timing"};
            }
            case -1432923513: {
                return new String[]{"boolean", "CodeableConcept"};
            }
            case -1500852503: {
                return new String[]{"dateTime"};
            }
            case 693933948: {
                return new String[0];
            }
            case -901444568: {
                return new String[]{"CodeableConcept"};
            }
            case 481140686: {
                return new String[]{"Reference"};
            }
            case 722137681: {
                return new String[]{"CodeableConcept"};
            }
            case -1146218137: {
                return new String[]{"Reference"};
            }
            case 1922406657: {
                return new String[]{"Reference"};
            }
            case -2132868344: {
                return new String[]{"Reference"};
            }
            case 1702620169: {
                return new String[]{"CodeableConcept"};
            }
            case 3387378: {
                return new String[]{"Annotation"};
            }
            case 1538891575: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_DEFINITION)) {
            return this.addDefinition();
        }
        if (name.equals("basedOn")) {
            return this.addBasedOn();
        }
        if (name.equals(SP_REPLACES)) {
            return this.addReplaces();
        }
        if (name.equals(SP_REQUISITION)) {
            this.requisition = new Identifier();
            return this.requisition;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcedureRequest.status");
        }
        if (name.equals(SP_INTENT)) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcedureRequest.intent");
        }
        if (name.equals(SP_PRIORITY)) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcedureRequest.priority");
        }
        if (name.equals("doNotPerform")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcedureRequest.doNotPerform");
        }
        if (name.equals("category")) {
            return this.addCategory();
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_CONTEXT)) {
            this.context = new Reference();
            return this.context;
        }
        if (name.equals("occurrenceDateTime")) {
            this.occurrence = new DateTimeType();
            return this.occurrence;
        }
        if (name.equals("occurrencePeriod")) {
            this.occurrence = new Period();
            return this.occurrence;
        }
        if (name.equals("occurrenceTiming")) {
            this.occurrence = new Timing();
            return this.occurrence;
        }
        if (name.equals("asNeededBoolean")) {
            this.asNeeded = new BooleanType();
            return this.asNeeded;
        }
        if (name.equals("asNeededCodeableConcept")) {
            this.asNeeded = new CodeableConcept();
            return this.asNeeded;
        }
        if (name.equals("authoredOn")) {
            throw new FHIRException("Cannot call addChild on a primitive type ProcedureRequest.authoredOn");
        }
        if (name.equals(SP_REQUESTER)) {
            this.requester = new ProcedureRequestRequesterComponent();
            return this.requester;
        }
        if (name.equals("performerType")) {
            this.performerType = new CodeableConcept();
            return this.performerType;
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals("reasonCode")) {
            return this.addReasonCode();
        }
        if (name.equals("reasonReference")) {
            return this.addReasonReference();
        }
        if (name.equals("supportingInfo")) {
            return this.addSupportingInfo();
        }
        if (name.equals(SP_SPECIMEN)) {
            return this.addSpecimen();
        }
        if (name.equals("bodySite")) {
            return this.addBodySite();
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("relevantHistory")) {
            return this.addRelevantHistory();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ProcedureRequest";
    }

    @Override
    public ProcedureRequest copy() {
        ProcedureRequest dst = new ProcedureRequest();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.definition != null) {
            dst.definition = new ArrayList<Reference>();
            for (Reference reference : this.definition) {
                dst.definition.add(reference.copy());
            }
        }
        if (this.basedOn != null) {
            dst.basedOn = new ArrayList<Reference>();
            for (Reference reference : this.basedOn) {
                dst.basedOn.add(reference.copy());
            }
        }
        if (this.replaces != null) {
            dst.replaces = new ArrayList<Reference>();
            for (Reference reference : this.replaces) {
                dst.replaces.add(reference.copy());
            }
        }
        dst.requisition = this.requisition == null ? null : this.requisition.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.intent = this.intent == null ? null : this.intent.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        BooleanType booleanType = dst.doNotPerform = this.doNotPerform == null ? null : this.doNotPerform.copy();
        if (this.category != null) {
            dst.category = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.category) {
                dst.category.add(codeableConcept.copy());
            }
        }
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.context = this.context == null ? null : this.context.copy();
        dst.occurrence = this.occurrence == null ? null : this.occurrence.copy();
        dst.asNeeded = this.asNeeded == null ? null : this.asNeeded.copy();
        dst.authoredOn = this.authoredOn == null ? null : this.authoredOn.copy();
        dst.requester = this.requester == null ? null : this.requester.copy();
        dst.performerType = this.performerType == null ? null : this.performerType.copy();
        Reference reference = dst.performer = this.performer == null ? null : this.performer.copy();
        if (this.reasonCode != null) {
            dst.reasonCode = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reasonCode) {
                dst.reasonCode.add(codeableConcept.copy());
            }
        }
        if (this.reasonReference != null) {
            dst.reasonReference = new ArrayList<Reference>();
            for (Reference reference2 : this.reasonReference) {
                dst.reasonReference.add(reference2.copy());
            }
        }
        if (this.supportingInfo != null) {
            dst.supportingInfo = new ArrayList<Reference>();
            for (Reference reference3 : this.supportingInfo) {
                dst.supportingInfo.add(reference3.copy());
            }
        }
        if (this.specimen != null) {
            dst.specimen = new ArrayList<Reference>();
            for (Reference reference4 : this.specimen) {
                dst.specimen.add(reference4.copy());
            }
        }
        if (this.bodySite != null) {
            dst.bodySite = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.bodySite) {
                dst.bodySite.add(codeableConcept.copy());
            }
        }
        if (this.note != null) {
            dst.note = new ArrayList<Annotation>();
            for (Annotation annotation : this.note) {
                dst.note.add(annotation.copy());
            }
        }
        if (this.relevantHistory != null) {
            dst.relevantHistory = new ArrayList<Reference>();
            for (Reference reference5 : this.relevantHistory) {
                dst.relevantHistory.add(reference5.copy());
            }
        }
        return dst;
    }

    protected ProcedureRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ProcedureRequest)) {
            return false;
        }
        ProcedureRequest o = (ProcedureRequest)other_;
        return ProcedureRequest.compareDeep(this.identifier, o.identifier, true) && ProcedureRequest.compareDeep(this.definition, o.definition, true) && ProcedureRequest.compareDeep(this.basedOn, o.basedOn, true) && ProcedureRequest.compareDeep(this.replaces, o.replaces, true) && ProcedureRequest.compareDeep(this.requisition, o.requisition, true) && ProcedureRequest.compareDeep(this.status, o.status, true) && ProcedureRequest.compareDeep(this.intent, o.intent, true) && ProcedureRequest.compareDeep(this.priority, o.priority, true) && ProcedureRequest.compareDeep(this.doNotPerform, o.doNotPerform, true) && ProcedureRequest.compareDeep(this.category, o.category, true) && ProcedureRequest.compareDeep(this.code, o.code, true) && ProcedureRequest.compareDeep(this.subject, o.subject, true) && ProcedureRequest.compareDeep(this.context, o.context, true) && ProcedureRequest.compareDeep(this.occurrence, o.occurrence, true) && ProcedureRequest.compareDeep(this.asNeeded, o.asNeeded, true) && ProcedureRequest.compareDeep(this.authoredOn, o.authoredOn, true) && ProcedureRequest.compareDeep(this.requester, o.requester, true) && ProcedureRequest.compareDeep(this.performerType, o.performerType, true) && ProcedureRequest.compareDeep(this.performer, o.performer, true) && ProcedureRequest.compareDeep(this.reasonCode, o.reasonCode, true) && ProcedureRequest.compareDeep(this.reasonReference, o.reasonReference, true) && ProcedureRequest.compareDeep(this.supportingInfo, o.supportingInfo, true) && ProcedureRequest.compareDeep(this.specimen, o.specimen, true) && ProcedureRequest.compareDeep(this.bodySite, o.bodySite, true) && ProcedureRequest.compareDeep(this.note, o.note, true) && ProcedureRequest.compareDeep(this.relevantHistory, o.relevantHistory, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ProcedureRequest)) {
            return false;
        }
        ProcedureRequest o = (ProcedureRequest)other_;
        return ProcedureRequest.compareValues(this.status, o.status, true) && ProcedureRequest.compareValues(this.intent, o.intent, true) && ProcedureRequest.compareValues(this.priority, o.priority, true) && ProcedureRequest.compareValues(this.doNotPerform, o.doNotPerform, true) && ProcedureRequest.compareValues(this.authoredOn, o.authoredOn, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.definition, this.basedOn, this.replaces, this.requisition, this.status, this.intent, this.priority, this.doNotPerform, this.category, this.code, this.subject, this.context, this.occurrence, this.asNeeded, this.authoredOn, this.requester, this.performerType, this.performer, this.reasonCode, this.reasonReference, this.supportingInfo, this.specimen, this.bodySite, this.note, this.relevantHistory);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ProcedureRequest;
    }

    @Block
    public static class ProcedureRequestRequesterComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="agent", type={Device.class, Practitioner.class, Organization.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Individual making the request", formalDefinition="The device, practitioner or organization who initiated the request.")
        protected Reference agent;
        protected Resource agentTarget;
        @Child(name="onBehalfOf", type={Organization.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Organization agent is acting for", formalDefinition="The organization the device or practitioner was acting on behalf of.")
        protected Reference onBehalfOf;
        protected Organization onBehalfOfTarget;
        private static final long serialVersionUID = -71453027L;

        public ProcedureRequestRequesterComponent() {
        }

        public ProcedureRequestRequesterComponent(Reference agent) {
            this.agent = agent;
        }

        public Reference getAgent() {
            if (this.agent == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureRequestRequesterComponent.agent");
                }
                if (Configuration.doAutoCreate()) {
                    this.agent = new Reference();
                }
            }
            return this.agent;
        }

        public boolean hasAgent() {
            return this.agent != null && !this.agent.isEmpty();
        }

        public ProcedureRequestRequesterComponent setAgent(Reference value) {
            this.agent = value;
            return this;
        }

        public Resource getAgentTarget() {
            return this.agentTarget;
        }

        public ProcedureRequestRequesterComponent setAgentTarget(Resource value) {
            this.agentTarget = value;
            return this;
        }

        public Reference getOnBehalfOf() {
            if (this.onBehalfOf == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureRequestRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOf = new Reference();
                }
            }
            return this.onBehalfOf;
        }

        public boolean hasOnBehalfOf() {
            return this.onBehalfOf != null && !this.onBehalfOf.isEmpty();
        }

        public ProcedureRequestRequesterComponent setOnBehalfOf(Reference value) {
            this.onBehalfOf = value;
            return this;
        }

        public Organization getOnBehalfOfTarget() {
            if (this.onBehalfOfTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ProcedureRequestRequesterComponent.onBehalfOf");
                }
                if (Configuration.doAutoCreate()) {
                    this.onBehalfOfTarget = new Organization();
                }
            }
            return this.onBehalfOfTarget;
        }

        public ProcedureRequestRequesterComponent setOnBehalfOfTarget(Organization value) {
            this.onBehalfOfTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("agent", "Reference(Device|Practitioner|Organization)", "The device, practitioner or organization who initiated the request.", 0, 1, this.agent));
            children.add(new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 92750597: {
                    return new Property("agent", "Reference(Device|Practitioner|Organization)", "The device, practitioner or organization who initiated the request.", 0, 1, this.agent);
                }
                case -14402964: {
                    return new Property("onBehalfOf", "Reference(Organization)", "The organization the device or practitioner was acting on behalf of.", 0, 1, this.onBehalfOf);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    Base[] baseArray;
                    if (this.agent == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.agent;
                    }
                    return baseArray;
                }
                case -14402964: {
                    Base[] baseArray;
                    if (this.onBehalfOf == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.onBehalfOf;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    this.agent = this.castToReference(value);
                    return value;
                }
                case -14402964: {
                    this.onBehalfOf = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = this.castToReference(value);
            } else if (name.equals("onBehalfOf")) {
                this.onBehalfOf = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return this.getAgent();
                }
                case -14402964: {
                    return this.getOnBehalfOf();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 92750597: {
                    return new String[]{"Reference"};
                }
                case -14402964: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("agent")) {
                this.agent = new Reference();
                return this.agent;
            }
            if (name.equals("onBehalfOf")) {
                this.onBehalfOf = new Reference();
                return this.onBehalfOf;
            }
            return super.addChild(name);
        }

        @Override
        public ProcedureRequestRequesterComponent copy() {
            ProcedureRequestRequesterComponent dst = new ProcedureRequestRequesterComponent();
            this.copyValues(dst);
            dst.agent = this.agent == null ? null : this.agent.copy();
            dst.onBehalfOf = this.onBehalfOf == null ? null : this.onBehalfOf.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureRequestRequesterComponent)) {
                return false;
            }
            ProcedureRequestRequesterComponent o = (ProcedureRequestRequesterComponent)other_;
            return ProcedureRequestRequesterComponent.compareDeep(this.agent, o.agent, true) && ProcedureRequestRequesterComponent.compareDeep(this.onBehalfOf, o.onBehalfOf, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ProcedureRequestRequesterComponent)) {
                return false;
            }
            ProcedureRequestRequesterComponent o = (ProcedureRequestRequesterComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.agent, this.onBehalfOf);
        }

        @Override
        public String fhirType() {
            return "ProcedureRequest.requester";
        }
    }

    public static class ProcedureRequestPriorityEnumFactory
    implements EnumFactory<ProcedureRequestPriority> {
        @Override
        public ProcedureRequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ProcedureRequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return ProcedureRequestPriority.URGENT;
            }
            if ("asap".equals(codeString)) {
                return ProcedureRequestPriority.ASAP;
            }
            if ("stat".equals(codeString)) {
                return ProcedureRequestPriority.STAT;
            }
            throw new IllegalArgumentException("Unknown ProcedureRequestPriority code '" + codeString + "'");
        }

        public Enumeration<ProcedureRequestPriority> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ProcedureRequestPriority>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<ProcedureRequestPriority>(this, ProcedureRequestPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<ProcedureRequestPriority>(this, ProcedureRequestPriority.URGENT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<ProcedureRequestPriority>(this, ProcedureRequestPriority.ASAP);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<ProcedureRequestPriority>(this, ProcedureRequestPriority.STAT);
            }
            throw new FHIRException("Unknown ProcedureRequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(ProcedureRequestPriority code) {
            if (code == ProcedureRequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == ProcedureRequestPriority.URGENT) {
                return "urgent";
            }
            if (code == ProcedureRequestPriority.ASAP) {
                return "asap";
            }
            if (code == ProcedureRequestPriority.STAT) {
                return "stat";
            }
            return "?";
        }

        @Override
        public String toSystem(ProcedureRequestPriority code) {
            return code.getSystem();
        }
    }

    public static enum ProcedureRequestPriority {
        ROUTINE,
        URGENT,
        ASAP,
        STAT,
        NULL;


        public static ProcedureRequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ProcedureRequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case ASAP: {
                    return "asap";
                }
                case STAT: {
                    return "stat";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/request-priority";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has normal priority";
                }
                case URGENT: {
                    return "The request should be actioned promptly - higher priority than routine";
                }
                case ASAP: {
                    return "The request should be actioned as soon as possible - higher priority than urgent";
                }
                case STAT: {
                    return "The request should be actioned immediately - highest possible priority.  E.g. an emergency";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case ASAP: {
                    return "ASAP";
                }
                case STAT: {
                    return "STAT";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ProcedureRequestIntentEnumFactory
    implements EnumFactory<ProcedureRequestIntent> {
        @Override
        public ProcedureRequestIntent fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return ProcedureRequestIntent.PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return ProcedureRequestIntent.PLAN;
            }
            if ("order".equals(codeString)) {
                return ProcedureRequestIntent.ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ProcedureRequestIntent.ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return ProcedureRequestIntent.REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return ProcedureRequestIntent.FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return ProcedureRequestIntent.INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return ProcedureRequestIntent.OPTION;
            }
            throw new IllegalArgumentException("Unknown ProcedureRequestIntent code '" + codeString + "'");
        }

        public Enumeration<ProcedureRequestIntent> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ProcedureRequestIntent>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return new Enumeration<ProcedureRequestIntent>(this, ProcedureRequestIntent.PROPOSAL);
            }
            if ("plan".equals(codeString)) {
                return new Enumeration<ProcedureRequestIntent>(this, ProcedureRequestIntent.PLAN);
            }
            if ("order".equals(codeString)) {
                return new Enumeration<ProcedureRequestIntent>(this, ProcedureRequestIntent.ORDER);
            }
            if ("original-order".equals(codeString)) {
                return new Enumeration<ProcedureRequestIntent>(this, ProcedureRequestIntent.ORIGINALORDER);
            }
            if ("reflex-order".equals(codeString)) {
                return new Enumeration<ProcedureRequestIntent>(this, ProcedureRequestIntent.REFLEXORDER);
            }
            if ("filler-order".equals(codeString)) {
                return new Enumeration<ProcedureRequestIntent>(this, ProcedureRequestIntent.FILLERORDER);
            }
            if ("instance-order".equals(codeString)) {
                return new Enumeration<ProcedureRequestIntent>(this, ProcedureRequestIntent.INSTANCEORDER);
            }
            if ("option".equals(codeString)) {
                return new Enumeration<ProcedureRequestIntent>(this, ProcedureRequestIntent.OPTION);
            }
            throw new FHIRException("Unknown ProcedureRequestIntent code '" + codeString + "'");
        }

        @Override
        public String toCode(ProcedureRequestIntent code) {
            if (code == ProcedureRequestIntent.PROPOSAL) {
                return "proposal";
            }
            if (code == ProcedureRequestIntent.PLAN) {
                return "plan";
            }
            if (code == ProcedureRequestIntent.ORDER) {
                return "order";
            }
            if (code == ProcedureRequestIntent.ORIGINALORDER) {
                return "original-order";
            }
            if (code == ProcedureRequestIntent.REFLEXORDER) {
                return "reflex-order";
            }
            if (code == ProcedureRequestIntent.FILLERORDER) {
                return "filler-order";
            }
            if (code == ProcedureRequestIntent.INSTANCEORDER) {
                return "instance-order";
            }
            if (code == ProcedureRequestIntent.OPTION) {
                return "option";
            }
            return "?";
        }

        @Override
        public String toSystem(ProcedureRequestIntent code) {
            return code.getSystem();
        }
    }

    public static enum ProcedureRequestIntent {
        PROPOSAL,
        PLAN,
        ORDER,
        ORIGINALORDER,
        REFLEXORDER,
        FILLERORDER,
        INSTANCEORDER,
        OPTION,
        NULL;


        public static ProcedureRequestIntent fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposal".equals(codeString)) {
                return PROPOSAL;
            }
            if ("plan".equals(codeString)) {
                return PLAN;
            }
            if ("order".equals(codeString)) {
                return ORDER;
            }
            if ("original-order".equals(codeString)) {
                return ORIGINALORDER;
            }
            if ("reflex-order".equals(codeString)) {
                return REFLEXORDER;
            }
            if ("filler-order".equals(codeString)) {
                return FILLERORDER;
            }
            if ("instance-order".equals(codeString)) {
                return INSTANCEORDER;
            }
            if ("option".equals(codeString)) {
                return OPTION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ProcedureRequestIntent code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSAL: {
                    return "proposal";
                }
                case PLAN: {
                    return "plan";
                }
                case ORDER: {
                    return "order";
                }
                case ORIGINALORDER: {
                    return "original-order";
                }
                case REFLEXORDER: {
                    return "reflex-order";
                }
                case FILLERORDER: {
                    return "filler-order";
                }
                case INSTANCEORDER: {
                    return "instance-order";
                }
                case OPTION: {
                    return "option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSAL: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case PLAN: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case ORIGINALORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case REFLEXORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case FILLERORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case INSTANCEORDER: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case OPTION: {
                    return "http://hl7.org/fhir/request-intent";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSAL: {
                    return "The request is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
                }
                case PLAN: {
                    return "The request represents an intension to ensure something occurs without providing an authorization for others to act";
                }
                case ORDER: {
                    return "The request represents a request/demand and authorization for action";
                }
                case ORIGINALORDER: {
                    return "The request represents an original authorization for action";
                }
                case REFLEXORDER: {
                    return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization";
                }
                case FILLERORDER: {
                    return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order";
                }
                case INSTANCEORDER: {
                    return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
                }
                case OPTION: {
                    return "The request represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.\n\nRefer to [[[RequestGroup]]] for additional information on how this status is used";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSAL: {
                    return "Proposal";
                }
                case PLAN: {
                    return "Plan";
                }
                case ORDER: {
                    return "Order";
                }
                case ORIGINALORDER: {
                    return "Original Order";
                }
                case REFLEXORDER: {
                    return "Reflex Order";
                }
                case FILLERORDER: {
                    return "Filler Order";
                }
                case INSTANCEORDER: {
                    return "Instance Order";
                }
                case OPTION: {
                    return "Option";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class ProcedureRequestStatusEnumFactory
    implements EnumFactory<ProcedureRequestStatus> {
        @Override
        public ProcedureRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return ProcedureRequestStatus.DRAFT;
            }
            if ("active".equals(codeString)) {
                return ProcedureRequestStatus.ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return ProcedureRequestStatus.SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return ProcedureRequestStatus.CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return ProcedureRequestStatus.COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ProcedureRequestStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return ProcedureRequestStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown ProcedureRequestStatus code '" + codeString + "'");
        }

        public Enumeration<ProcedureRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<ProcedureRequestStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.DRAFT);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.ACTIVE);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.SUSPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.CANCELLED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.COMPLETED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<ProcedureRequestStatus>(this, ProcedureRequestStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown ProcedureRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(ProcedureRequestStatus code) {
            if (code == ProcedureRequestStatus.DRAFT) {
                return "draft";
            }
            if (code == ProcedureRequestStatus.ACTIVE) {
                return "active";
            }
            if (code == ProcedureRequestStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == ProcedureRequestStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == ProcedureRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == ProcedureRequestStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == ProcedureRequestStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(ProcedureRequestStatus code) {
            return code.getSystem();
        }
    }

    public static enum ProcedureRequestStatus {
        DRAFT,
        ACTIVE,
        SUSPENDED,
        CANCELLED,
        COMPLETED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static ProcedureRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("draft".equals(codeString)) {
                return DRAFT;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown ProcedureRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case DRAFT: {
                    return "draft";
                }
                case ACTIVE: {
                    return "active";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case COMPLETED: {
                    return "completed";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case DRAFT: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/request-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/request-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/request-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/request-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case DRAFT: {
                    return "The request has been created but is not yet complete or ready for action";
                }
                case ACTIVE: {
                    return "The request is ready to be acted upon";
                }
                case SUSPENDED: {
                    return "The authorization/request to act has been temporarily withdrawn but is expected to resume in the future";
                }
                case CANCELLED: {
                    return "The authorization/request to act has been terminated prior to the full completion of the intended actions.  No further activity should occur.";
                }
                case COMPLETED: {
                    return "Activity against the request has been sufficiently completed to the satisfaction of the requester";
                }
                case ENTEREDINERROR: {
                    return "This electronic record should never have existed, though it is possible that real-world decisions were based on it.  (If real-world activity has occurred, the status should be \"cancelled\" rather than \"entered-in-error\".)";
                }
                case UNKNOWN: {
                    return "The authoring system does not know which of the status values currently applies for this request.  Note: This concept is not to be used for \"other\" . One of the listed statuses is presumed to apply,  but the system creating the request doesn't know.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case DRAFT: {
                    return "Draft";
                }
                case ACTIVE: {
                    return "Active";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

