/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.IdType;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.Type;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImplementationGuide", profile="http://hl7.org/fhir/Profile/ImplementationGuide")
@ChildOrder(names={"url", "version", "name", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "copyright", "fhirVersion", "dependency", "package", "global", "binary", "page"})
public class ImplementationGuide
extends MetadataResource {
    @Child(name="copyright", type={MarkdownType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Use and/or publishing restrictions", formalDefinition="A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.")
    protected MarkdownType copyright;
    @Child(name="fhirVersion", type={IdType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="FHIR Version this Implementation Guide targets", formalDefinition="The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.0.2 for this version.")
    protected IdType fhirVersion;
    @Child(name="dependency", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Another Implementation guide this depends on", formalDefinition="Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.")
    protected List<ImplementationGuideDependencyComponent> dependency;
    @Child(name="package", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Group of resources as used in .page.package", formalDefinition="A logical group of resources. Logical groups can be used when building pages.")
    protected List<ImplementationGuidePackageComponent> package_;
    @Child(name="global", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Profiles that apply globally", formalDefinition="A set of profiles that all resources covered by this implementation guide must conform to.")
    protected List<ImplementationGuideGlobalComponent> global;
    @Child(name="binary", type={UriType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Image, css, script, etc.", formalDefinition="A binary file that is included in the  implementation guide when it is published.")
    protected List<UriType> binary;
    @Child(name="page", type={}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Page/Section in the Guide", formalDefinition="A page / section in the implementation guide. The root page is the implementation guide home page.")
    protected ImplementationGuidePageComponent page;
    private static final long serialVersionUID = -1252164384L;
    @SearchParamDefinition(name="date", path="ImplementationGuide.date", description="The implementation guide publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="dependency", path="ImplementationGuide.dependency.uri", description="Where to find dependency", type="uri")
    public static final String SP_DEPENDENCY = "dependency";
    public static final UriClientParam DEPENDENCY = new UriClientParam("dependency");
    @SearchParamDefinition(name="resource", path="ImplementationGuide.package.resource.source", description="Location of the resource", type="reference")
    public static final String SP_RESOURCE = "resource";
    public static final ReferenceClientParam RESOURCE = new ReferenceClientParam("resource");
    public static final Include INCLUDE_RESOURCE = new Include("ImplementationGuide:resource").toLocked();
    @SearchParamDefinition(name="jurisdiction", path="ImplementationGuide.jurisdiction", description="Intended jurisdiction for the implementation guide", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="ImplementationGuide.name", description="Computationally friendly name of the implementation guide", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="description", path="ImplementationGuide.description", description="The description of the implementation guide", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="publisher", path="ImplementationGuide.publisher", description="Name of the publisher of the implementation guide", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="experimental", path="ImplementationGuide.experimental", description="For testing purposes, not real usage", type="token")
    public static final String SP_EXPERIMENTAL = "experimental";
    public static final TokenClientParam EXPERIMENTAL = new TokenClientParam("experimental");
    @SearchParamDefinition(name="version", path="ImplementationGuide.version", description="The business version of the implementation guide", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="ImplementationGuide.url", description="The uri that identifies the implementation guide", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="status", path="ImplementationGuide.status", description="The current status of the implementation guide", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public ImplementationGuide() {
    }

    public ImplementationGuide(UriType url, StringType name, Enumeration<Enumerations.PublicationStatus> status) {
        this.url = url;
        this.name = name;
        this.status = status;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public ImplementationGuide setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public ImplementationGuide setUrl(String value) {
        if (this.url == null) {
            this.url = new UriType();
        }
        this.url.setValue(value);
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public ImplementationGuide setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public ImplementationGuide setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public ImplementationGuide setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public ImplementationGuide setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public ImplementationGuide setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public ImplementationGuide setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public ImplementationGuide setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public ImplementationGuide setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public ImplementationGuide setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public ImplementationGuide setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public ImplementationGuide setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public ImplementationGuide setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public ImplementationGuide setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public ImplementationGuide setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public ImplementationGuide setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public ImplementationGuide setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public ImplementationGuide setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public ImplementationGuide addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getCopyrightElement() {
        if (this.copyright == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.copyright");
            }
            if (Configuration.doAutoCreate()) {
                this.copyright = new MarkdownType();
            }
        }
        return this.copyright;
    }

    public boolean hasCopyrightElement() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public boolean hasCopyright() {
        return this.copyright != null && !this.copyright.isEmpty();
    }

    public ImplementationGuide setCopyrightElement(MarkdownType value) {
        this.copyright = value;
        return this;
    }

    public String getCopyright() {
        return this.copyright == null ? null : (String)this.copyright.getValue();
    }

    public ImplementationGuide setCopyright(String value) {
        if (value == null) {
            this.copyright = null;
        } else {
            if (this.copyright == null) {
                this.copyright = new MarkdownType();
            }
            this.copyright.setValue(value);
        }
        return this;
    }

    public IdType getFhirVersionElement() {
        if (this.fhirVersion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.fhirVersion");
            }
            if (Configuration.doAutoCreate()) {
                this.fhirVersion = new IdType();
            }
        }
        return this.fhirVersion;
    }

    public boolean hasFhirVersionElement() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public boolean hasFhirVersion() {
        return this.fhirVersion != null && !this.fhirVersion.isEmpty();
    }

    public ImplementationGuide setFhirVersionElement(IdType value) {
        this.fhirVersion = value;
        return this;
    }

    public String getFhirVersion() {
        return this.fhirVersion == null ? null : this.fhirVersion.getValue();
    }

    public ImplementationGuide setFhirVersion(String value) {
        if (Utilities.noString(value)) {
            this.fhirVersion = null;
        } else {
            if (this.fhirVersion == null) {
                this.fhirVersion = new IdType();
            }
            this.fhirVersion.setValue(value);
        }
        return this;
    }

    public List<ImplementationGuideDependencyComponent> getDependency() {
        if (this.dependency == null) {
            this.dependency = new ArrayList<ImplementationGuideDependencyComponent>();
        }
        return this.dependency;
    }

    public ImplementationGuide setDependency(List<ImplementationGuideDependencyComponent> theDependency) {
        this.dependency = theDependency;
        return this;
    }

    public boolean hasDependency() {
        if (this.dependency == null) {
            return false;
        }
        for (ImplementationGuideDependencyComponent item : this.dependency) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideDependencyComponent addDependency() {
        ImplementationGuideDependencyComponent t = new ImplementationGuideDependencyComponent();
        if (this.dependency == null) {
            this.dependency = new ArrayList<ImplementationGuideDependencyComponent>();
        }
        this.dependency.add(t);
        return t;
    }

    public ImplementationGuide addDependency(ImplementationGuideDependencyComponent t) {
        if (t == null) {
            return this;
        }
        if (this.dependency == null) {
            this.dependency = new ArrayList<ImplementationGuideDependencyComponent>();
        }
        this.dependency.add(t);
        return this;
    }

    public ImplementationGuideDependencyComponent getDependencyFirstRep() {
        if (this.getDependency().isEmpty()) {
            this.addDependency();
        }
        return this.getDependency().get(0);
    }

    public List<ImplementationGuidePackageComponent> getPackage() {
        if (this.package_ == null) {
            this.package_ = new ArrayList<ImplementationGuidePackageComponent>();
        }
        return this.package_;
    }

    public ImplementationGuide setPackage(List<ImplementationGuidePackageComponent> thePackage) {
        this.package_ = thePackage;
        return this;
    }

    public boolean hasPackage() {
        if (this.package_ == null) {
            return false;
        }
        for (ImplementationGuidePackageComponent item : this.package_) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuidePackageComponent addPackage() {
        ImplementationGuidePackageComponent t = new ImplementationGuidePackageComponent();
        if (this.package_ == null) {
            this.package_ = new ArrayList<ImplementationGuidePackageComponent>();
        }
        this.package_.add(t);
        return t;
    }

    public ImplementationGuide addPackage(ImplementationGuidePackageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.package_ == null) {
            this.package_ = new ArrayList<ImplementationGuidePackageComponent>();
        }
        this.package_.add(t);
        return this;
    }

    public ImplementationGuidePackageComponent getPackageFirstRep() {
        if (this.getPackage().isEmpty()) {
            this.addPackage();
        }
        return this.getPackage().get(0);
    }

    public List<ImplementationGuideGlobalComponent> getGlobal() {
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        return this.global;
    }

    public ImplementationGuide setGlobal(List<ImplementationGuideGlobalComponent> theGlobal) {
        this.global = theGlobal;
        return this;
    }

    public boolean hasGlobal() {
        if (this.global == null) {
            return false;
        }
        for (ImplementationGuideGlobalComponent item : this.global) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuideGlobalComponent addGlobal() {
        ImplementationGuideGlobalComponent t = new ImplementationGuideGlobalComponent();
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        this.global.add(t);
        return t;
    }

    public ImplementationGuide addGlobal(ImplementationGuideGlobalComponent t) {
        if (t == null) {
            return this;
        }
        if (this.global == null) {
            this.global = new ArrayList<ImplementationGuideGlobalComponent>();
        }
        this.global.add(t);
        return this;
    }

    public ImplementationGuideGlobalComponent getGlobalFirstRep() {
        if (this.getGlobal().isEmpty()) {
            this.addGlobal();
        }
        return this.getGlobal().get(0);
    }

    public List<UriType> getBinary() {
        if (this.binary == null) {
            this.binary = new ArrayList<UriType>();
        }
        return this.binary;
    }

    public ImplementationGuide setBinary(List<UriType> theBinary) {
        this.binary = theBinary;
        return this;
    }

    public boolean hasBinary() {
        if (this.binary == null) {
            return false;
        }
        for (UriType item : this.binary) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public UriType addBinaryElement() {
        UriType t = new UriType();
        if (this.binary == null) {
            this.binary = new ArrayList<UriType>();
        }
        this.binary.add(t);
        return t;
    }

    public ImplementationGuide addBinary(String value) {
        UriType t = new UriType();
        t.setValue(value);
        if (this.binary == null) {
            this.binary = new ArrayList<UriType>();
        }
        this.binary.add(t);
        return this;
    }

    public boolean hasBinary(String value) {
        if (this.binary == null) {
            return false;
        }
        for (UriType v : this.binary) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public ImplementationGuidePageComponent getPage() {
        if (this.page == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImplementationGuide.page");
            }
            if (Configuration.doAutoCreate()) {
                this.page = new ImplementationGuidePageComponent();
            }
        }
        return this.page;
    }

    public boolean hasPage() {
        return this.page != null && !this.page.isEmpty();
    }

    public ImplementationGuide setPage(ImplementationGuidePageComponent value) {
        this.page = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this implementation guide is (or will be) published. The URL SHOULD include the major version of the implementation guide. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the implementation guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the implementation guide author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the implementation guide. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of this implementation guide. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property(SP_EXPERIMENTAL, "boolean", "A boolean value to indicate that this implementation guide is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the implementation guide was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the implementation guide.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the implementation guide from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate implementation guide instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the implementation guide is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("copyright", "markdown", "A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.", 0, 1, this.copyright));
        children.add(new Property("fhirVersion", "id", "The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.0.2 for this version.", 0, 1, this.fhirVersion));
        children.add(new Property(SP_DEPENDENCY, "", "Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.", 0, Integer.MAX_VALUE, this.dependency));
        children.add(new Property("package", "", "A logical group of resources. Logical groups can be used when building pages.", 0, Integer.MAX_VALUE, this.package_));
        children.add(new Property("global", "", "A set of profiles that all resources covered by this implementation guide must conform to.", 0, Integer.MAX_VALUE, this.global));
        children.add(new Property("binary", "uri", "A binary file that is included in the  implementation guide when it is published.", 0, Integer.MAX_VALUE, this.binary));
        children.add(new Property("page", "", "A page / section in the implementation guide. The root page is the implementation guide home page.", 0, 1, this.page));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this implementation guide when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this implementation guide is (or will be) published. The URL SHOULD include the major version of the implementation guide. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the implementation guide when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the implementation guide author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the implementation guide. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this implementation guide. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property(SP_EXPERIMENTAL, "boolean", "A boolean value to indicate that this implementation guide is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the implementation guide was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the implementation guide changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the implementation guide.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the implementation guide from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate implementation guide instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the implementation guide is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case 1522889671: {
                return new Property("copyright", "markdown", "A copyright statement relating to the implementation guide and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the implementation guide.", 0, 1, this.copyright);
            }
            case 461006061: {
                return new Property("fhirVersion", "id", "The version of the FHIR specification on which this ImplementationGuide is based - this is the formal version of the specification, without the revision number, e.g. [publication].[major].[minor], which is 3.0.2 for this version.", 0, 1, this.fhirVersion);
            }
            case -26291381: {
                return new Property(SP_DEPENDENCY, "", "Another implementation guide that this implementation depends on. Typically, an implementation guide uses value sets, profiles etc.defined in other implementation guides.", 0, Integer.MAX_VALUE, this.dependency);
            }
            case -807062458: {
                return new Property("package", "", "A logical group of resources. Logical groups can be used when building pages.", 0, Integer.MAX_VALUE, this.package_);
            }
            case -1243020381: {
                return new Property("global", "", "A set of profiles that all resources covered by this implementation guide must conform to.", 0, Integer.MAX_VALUE, this.global);
            }
            case -1388966911: {
                return new Property("binary", "uri", "A binary file that is included in the  implementation guide when it is published.", 0, Integer.MAX_VALUE, this.binary);
            }
            case 3433103: {
                return new Property("page", "", "A page / section in the implementation guide. The root page is the implementation guide home page.", 0, 1, this.page);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case 1522889671: {
                Base[] baseArray;
                if (this.copyright == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.copyright;
                }
                return baseArray;
            }
            case 461006061: {
                Base[] baseArray;
                if (this.fhirVersion == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.fhirVersion;
                }
                return baseArray;
            }
            case -26291381: {
                return this.dependency == null ? new Base[]{} : this.dependency.toArray(new Base[this.dependency.size()]);
            }
            case -807062458: {
                return this.package_ == null ? new Base[]{} : this.package_.toArray(new Base[this.package_.size()]);
            }
            case -1243020381: {
                return this.global == null ? new Base[]{} : this.global.toArray(new Base[this.global.size()]);
            }
            case -1388966911: {
                return this.binary == null ? new Base[]{} : this.binary.toArray(new Base[this.binary.size()]);
            }
            case 3433103: {
                Base[] baseArray;
                if (this.page == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.page;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1522889671: {
                this.copyright = this.castToMarkdown(value);
                return value;
            }
            case 461006061: {
                this.fhirVersion = this.castToId(value);
                return value;
            }
            case -26291381: {
                this.getDependency().add((ImplementationGuideDependencyComponent)((Object)value));
                return value;
            }
            case -807062458: {
                this.getPackage().add((ImplementationGuidePackageComponent)((Object)value));
                return value;
            }
            case -1243020381: {
                this.getGlobal().add((ImplementationGuideGlobalComponent)((Object)value));
                return value;
            }
            case -1388966911: {
                this.getBinary().add(this.castToUri(value));
                return value;
            }
            case 3433103: {
                this.page = (ImplementationGuidePageComponent)((Object)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals(SP_EXPERIMENTAL)) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("copyright")) {
            this.copyright = this.castToMarkdown(value);
        } else if (name.equals("fhirVersion")) {
            this.fhirVersion = this.castToId(value);
        } else if (name.equals(SP_DEPENDENCY)) {
            this.getDependency().add((ImplementationGuideDependencyComponent)((Object)value));
        } else if (name.equals("package")) {
            this.getPackage().add((ImplementationGuidePackageComponent)((Object)value));
        } else if (name.equals("global")) {
            this.getGlobal().add((ImplementationGuideGlobalComponent)((Object)value));
        } else if (name.equals("binary")) {
            this.getBinary().add(this.castToUri(value));
        } else if (name.equals("page")) {
            this.page = (ImplementationGuidePageComponent)((Object)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case 1522889671: {
                return this.getCopyrightElement();
            }
            case 461006061: {
                return this.getFhirVersionElement();
            }
            case -26291381: {
                return this.addDependency();
            }
            case -807062458: {
                return this.addPackage();
            }
            case -1243020381: {
                return this.addGlobal();
            }
            case -1388966911: {
                return this.addBinaryElement();
            }
            case 3433103: {
                return this.getPage();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case 1522889671: {
                return new String[]{"markdown"};
            }
            case 461006061: {
                return new String[]{"id"};
            }
            case -26291381: {
                return new String[0];
            }
            case -807062458: {
                return new String[0];
            }
            case -1243020381: {
                return new String[0];
            }
            case -1388966911: {
                return new String[]{"uri"};
            }
            case 3433103: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.status");
        }
        if (name.equals(SP_EXPERIMENTAL)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("copyright")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.copyright");
        }
        if (name.equals("fhirVersion")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.fhirVersion");
        }
        if (name.equals(SP_DEPENDENCY)) {
            return this.addDependency();
        }
        if (name.equals("package")) {
            return this.addPackage();
        }
        if (name.equals("global")) {
            return this.addGlobal();
        }
        if (name.equals("binary")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.binary");
        }
        if (name.equals("page")) {
            this.page = new ImplementationGuidePageComponent();
            return this.page;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImplementationGuide";
    }

    @Override
    public ImplementationGuide copy() {
        ImplementationGuide dst = new ImplementationGuide();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.copyright = this.copyright == null ? null : this.copyright.copy();
        IdType idType = dst.fhirVersion = this.fhirVersion == null ? null : this.fhirVersion.copy();
        if (this.dependency != null) {
            dst.dependency = new ArrayList<ImplementationGuideDependencyComponent>();
            for (ImplementationGuideDependencyComponent implementationGuideDependencyComponent : this.dependency) {
                dst.dependency.add(implementationGuideDependencyComponent.copy());
            }
        }
        if (this.package_ != null) {
            dst.package_ = new ArrayList<ImplementationGuidePackageComponent>();
            for (ImplementationGuidePackageComponent implementationGuidePackageComponent : this.package_) {
                dst.package_.add(implementationGuidePackageComponent.copy());
            }
        }
        if (this.global != null) {
            dst.global = new ArrayList<ImplementationGuideGlobalComponent>();
            for (ImplementationGuideGlobalComponent implementationGuideGlobalComponent : this.global) {
                dst.global.add(implementationGuideGlobalComponent.copy());
            }
        }
        if (this.binary != null) {
            dst.binary = new ArrayList<UriType>();
            for (UriType uriType : this.binary) {
                dst.binary.add(uriType.copy());
            }
        }
        dst.page = this.page == null ? null : this.page.copy();
        return dst;
    }

    protected ImplementationGuide typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof ImplementationGuide)) {
            return false;
        }
        ImplementationGuide o = (ImplementationGuide)other_;
        return ImplementationGuide.compareDeep(this.copyright, o.copyright, true) && ImplementationGuide.compareDeep(this.fhirVersion, o.fhirVersion, true) && ImplementationGuide.compareDeep(this.dependency, o.dependency, true) && ImplementationGuide.compareDeep(this.package_, o.package_, true) && ImplementationGuide.compareDeep(this.global, o.global, true) && ImplementationGuide.compareDeep(this.binary, o.binary, true) && ImplementationGuide.compareDeep(this.page, o.page, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof ImplementationGuide)) {
            return false;
        }
        ImplementationGuide o = (ImplementationGuide)other_;
        return ImplementationGuide.compareValues(this.copyright, o.copyright, true) && ImplementationGuide.compareValues(this.fhirVersion, o.fhirVersion, true) && ImplementationGuide.compareValues(this.binary, o.binary, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.copyright, this.fhirVersion, this.dependency, this.package_, this.global, this.binary, this.page);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImplementationGuide;
    }

    @Block
    public static class ImplementationGuidePageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="source", type={UriType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where to find that page", formalDefinition="The source address for the page.")
        protected UriType source;
        @Child(name="title", type={StringType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Short title shown for navigational assistance", formalDefinition="A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.")
        protected StringType title;
        @Child(name="kind", type={CodeType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="page | example | list | include | directory | dictionary | toc | resource", formalDefinition="The kind of page that this is. Some pages are autogenerated (list, example), and other kinds are of interest so that tools can navigate the user to the page of interest.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/guide-page-kind")
        protected Enumeration<GuidePageKind> kind;
        @Child(name="type", type={CodeType.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Kind of resource to include in the list", formalDefinition="For constructed pages, what kind of resources to include in the list.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected List<CodeType> type;
        @Child(name="package", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Name of package to include", formalDefinition="For constructed pages, a list of packages to include in the page (or else empty for everything).")
        protected List<StringType> package_;
        @Child(name="format", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Format of the page (e.g. html, markdown, etc.)", formalDefinition="The format of the page.")
        protected CodeType format;
        @Child(name="page", type={ImplementationGuidePageComponent.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Pages / Sections", formalDefinition="Nested Pages/Sections under this page.")
        protected List<ImplementationGuidePageComponent> page;
        private static final long serialVersionUID = -687763908L;

        public ImplementationGuidePageComponent() {
        }

        public ImplementationGuidePageComponent(UriType source, StringType title, Enumeration<GuidePageKind> kind) {
            this.source = source;
            this.title = title;
            this.kind = kind;
        }

        public UriType getSourceElement() {
            if (this.source == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePageComponent.source");
                }
                if (Configuration.doAutoCreate()) {
                    this.source = new UriType();
                }
            }
            return this.source;
        }

        public boolean hasSourceElement() {
            return this.source != null && !this.source.isEmpty();
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ImplementationGuidePageComponent setSourceElement(UriType value) {
            this.source = value;
            return this;
        }

        public String getSource() {
            return this.source == null ? null : (String)this.source.getValue();
        }

        public ImplementationGuidePageComponent setSource(String value) {
            if (this.source == null) {
                this.source = new UriType();
            }
            this.source.setValue(value);
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePageComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ImplementationGuidePageComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ImplementationGuidePageComponent setTitle(String value) {
            if (this.title == null) {
                this.title = new StringType();
            }
            this.title.setValue(value);
            return this;
        }

        public Enumeration<GuidePageKind> getKindElement() {
            if (this.kind == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePageComponent.kind");
                }
                if (Configuration.doAutoCreate()) {
                    this.kind = new Enumeration<GuidePageKind>(new GuidePageKindEnumFactory());
                }
            }
            return this.kind;
        }

        public boolean hasKindElement() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public boolean hasKind() {
            return this.kind != null && !this.kind.isEmpty();
        }

        public ImplementationGuidePageComponent setKindElement(Enumeration<GuidePageKind> value) {
            this.kind = value;
            return this;
        }

        public GuidePageKind getKind() {
            return this.kind == null ? null : (GuidePageKind)((Object)this.kind.getValue());
        }

        public ImplementationGuidePageComponent setKind(GuidePageKind value) {
            if (this.kind == null) {
                this.kind = new Enumeration<GuidePageKind>(new GuidePageKindEnumFactory());
            }
            this.kind.setValue((Object)value);
            return this;
        }

        public List<CodeType> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeType>();
            }
            return this.type;
        }

        public ImplementationGuidePageComponent setType(List<CodeType> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeType item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeType addTypeElement() {
            CodeType t = new CodeType();
            if (this.type == null) {
                this.type = new ArrayList<CodeType>();
            }
            this.type.add(t);
            return t;
        }

        public ImplementationGuidePageComponent addType(String value) {
            CodeType t = new CodeType();
            t.setValue(value);
            if (this.type == null) {
                this.type = new ArrayList<CodeType>();
            }
            this.type.add(t);
            return this;
        }

        public boolean hasType(String value) {
            if (this.type == null) {
                return false;
            }
            for (CodeType v : this.type) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<StringType> getPackage() {
            if (this.package_ == null) {
                this.package_ = new ArrayList<StringType>();
            }
            return this.package_;
        }

        public ImplementationGuidePageComponent setPackage(List<StringType> thePackage) {
            this.package_ = thePackage;
            return this;
        }

        public boolean hasPackage() {
            if (this.package_ == null) {
                return false;
            }
            for (StringType item : this.package_) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPackageElement() {
            StringType t = new StringType();
            if (this.package_ == null) {
                this.package_ = new ArrayList<StringType>();
            }
            this.package_.add(t);
            return t;
        }

        public ImplementationGuidePageComponent addPackage(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.package_ == null) {
                this.package_ = new ArrayList<StringType>();
            }
            this.package_.add(t);
            return this;
        }

        public boolean hasPackage(String value) {
            if (this.package_ == null) {
                return false;
            }
            for (StringType v : this.package_) {
                if (!((String)v.getValue()).equals(value)) continue;
                return true;
            }
            return false;
        }

        public CodeType getFormatElement() {
            if (this.format == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePageComponent.format");
                }
                if (Configuration.doAutoCreate()) {
                    this.format = new CodeType();
                }
            }
            return this.format;
        }

        public boolean hasFormatElement() {
            return this.format != null && !this.format.isEmpty();
        }

        public boolean hasFormat() {
            return this.format != null && !this.format.isEmpty();
        }

        public ImplementationGuidePageComponent setFormatElement(CodeType value) {
            this.format = value;
            return this;
        }

        public String getFormat() {
            return this.format == null ? null : (String)this.format.getValue();
        }

        public ImplementationGuidePageComponent setFormat(String value) {
            if (Utilities.noString(value)) {
                this.format = null;
            } else {
                if (this.format == null) {
                    this.format = new CodeType();
                }
                this.format.setValue(value);
            }
            return this;
        }

        public List<ImplementationGuidePageComponent> getPage() {
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuidePageComponent>();
            }
            return this.page;
        }

        public ImplementationGuidePageComponent setPage(List<ImplementationGuidePageComponent> thePage) {
            this.page = thePage;
            return this;
        }

        public boolean hasPage() {
            if (this.page == null) {
                return false;
            }
            for (ImplementationGuidePageComponent item : this.page) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuidePageComponent addPage() {
            ImplementationGuidePageComponent t = new ImplementationGuidePageComponent();
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuidePageComponent>();
            }
            this.page.add(t);
            return t;
        }

        public ImplementationGuidePageComponent addPage(ImplementationGuidePageComponent t) {
            if (t == null) {
                return this;
            }
            if (this.page == null) {
                this.page = new ArrayList<ImplementationGuidePageComponent>();
            }
            this.page.add(t);
            return this;
        }

        public ImplementationGuidePageComponent getPageFirstRep() {
            if (this.getPage().isEmpty()) {
                this.addPage();
            }
            return this.getPage().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("source", "uri", "The source address for the page.", 0, 1, this.source));
            children.add(new Property("title", "string", "A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.", 0, 1, this.title));
            children.add(new Property("kind", "code", "The kind of page that this is. Some pages are autogenerated (list, example), and other kinds are of interest so that tools can navigate the user to the page of interest.", 0, 1, this.kind));
            children.add(new Property("type", "code", "For constructed pages, what kind of resources to include in the list.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("package", "string", "For constructed pages, a list of packages to include in the page (or else empty for everything).", 0, Integer.MAX_VALUE, this.package_));
            children.add(new Property("format", "code", "The format of the page.", 0, 1, this.format));
            children.add(new Property("page", "@ImplementationGuide.page", "Nested Pages/Sections under this page.", 0, Integer.MAX_VALUE, this.page));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -896505829: {
                    return new Property("source", "uri", "The source address for the page.", 0, 1, this.source);
                }
                case 110371416: {
                    return new Property("title", "string", "A short title used to represent this page in navigational structures such as table of contents, bread crumbs, etc.", 0, 1, this.title);
                }
                case 3292052: {
                    return new Property("kind", "code", "The kind of page that this is. Some pages are autogenerated (list, example), and other kinds are of interest so that tools can navigate the user to the page of interest.", 0, 1, this.kind);
                }
                case 3575610: {
                    return new Property("type", "code", "For constructed pages, what kind of resources to include in the list.", 0, Integer.MAX_VALUE, this.type);
                }
                case -807062458: {
                    return new Property("package", "string", "For constructed pages, a list of packages to include in the page (or else empty for everything).", 0, Integer.MAX_VALUE, this.package_);
                }
                case -1268779017: {
                    return new Property("format", "code", "The format of the page.", 0, 1, this.format);
                }
                case 3433103: {
                    return new Property("page", "@ImplementationGuide.page", "Nested Pages/Sections under this page.", 0, Integer.MAX_VALUE, this.page);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.source;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.title;
                    }
                    return baseArray;
                }
                case 3292052: {
                    Base[] baseArray;
                    if (this.kind == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.kind;
                    }
                    return baseArray;
                }
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -807062458: {
                    return this.package_ == null ? new Base[]{} : this.package_.toArray(new Base[this.package_.size()]);
                }
                case -1268779017: {
                    Base[] baseArray;
                    if (this.format == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.format;
                    }
                    return baseArray;
                }
                case 3433103: {
                    return this.page == null ? new Base[]{} : this.page.toArray(new Base[this.page.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    this.source = this.castToUri(value);
                    return value;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    return value;
                }
                case 3292052: {
                    value = new GuidePageKindEnumFactory().fromType(this.castToCode(value));
                    this.kind = value;
                    return value;
                }
                case 3575610: {
                    this.getType().add(this.castToCode(value));
                    return value;
                }
                case -807062458: {
                    this.getPackage().add(this.castToString(value));
                    return value;
                }
                case -1268779017: {
                    this.format = this.castToCode(value);
                    return value;
                }
                case 3433103: {
                    this.getPage().add((ImplementationGuidePageComponent)((Object)value));
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("source")) {
                this.source = this.castToUri(value);
            } else if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("kind")) {
                value = new GuidePageKindEnumFactory().fromType(this.castToCode(value));
                this.kind = value;
            } else if (name.equals("type")) {
                this.getType().add(this.castToCode(value));
            } else if (name.equals("package")) {
                this.getPackage().add(this.castToString(value));
            } else if (name.equals("format")) {
                this.format = this.castToCode(value);
            } else if (name.equals("page")) {
                this.getPage().add((ImplementationGuidePageComponent)((Object)value));
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return this.getSourceElement();
                }
                case 110371416: {
                    return this.getTitleElement();
                }
                case 3292052: {
                    return this.getKindElement();
                }
                case 3575610: {
                    return this.addTypeElement();
                }
                case -807062458: {
                    return this.addPackageElement();
                }
                case -1268779017: {
                    return this.getFormatElement();
                }
                case 3433103: {
                    return this.addPage();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -896505829: {
                    return new String[]{"uri"};
                }
                case 110371416: {
                    return new String[]{"string"};
                }
                case 3292052: {
                    return new String[]{"code"};
                }
                case 3575610: {
                    return new String[]{"code"};
                }
                case -807062458: {
                    return new String[]{"string"};
                }
                case -1268779017: {
                    return new String[]{"code"};
                }
                case 3433103: {
                    return new String[]{"@ImplementationGuide.page"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("source")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.source");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.title");
            }
            if (name.equals("kind")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.kind");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.type");
            }
            if (name.equals("package")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.package");
            }
            if (name.equals("format")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.format");
            }
            if (name.equals("page")) {
                return this.addPage();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuidePageComponent copy() {
            ImplementationGuidePageComponent dst = new ImplementationGuidePageComponent();
            this.copyValues(dst);
            dst.source = this.source == null ? null : this.source.copy();
            dst.title = this.title == null ? null : this.title.copy();
            Enumeration<GuidePageKind> enumeration = dst.kind = this.kind == null ? null : this.kind.copy();
            if (this.type != null) {
                dst.type = new ArrayList<CodeType>();
                for (CodeType codeType : this.type) {
                    dst.type.add(codeType.copy());
                }
            }
            if (this.package_ != null) {
                dst.package_ = new ArrayList<StringType>();
                for (StringType stringType : this.package_) {
                    dst.package_.add(stringType.copy());
                }
            }
            CodeType codeType = dst.format = this.format == null ? null : this.format.copy();
            if (this.page != null) {
                dst.page = new ArrayList<ImplementationGuidePageComponent>();
                for (ImplementationGuidePageComponent implementationGuidePageComponent : this.page) {
                    dst.page.add(implementationGuidePageComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuidePageComponent)) {
                return false;
            }
            ImplementationGuidePageComponent o = (ImplementationGuidePageComponent)other_;
            return ImplementationGuidePageComponent.compareDeep(this.source, o.source, true) && ImplementationGuidePageComponent.compareDeep(this.title, o.title, true) && ImplementationGuidePageComponent.compareDeep(this.kind, o.kind, true) && ImplementationGuidePageComponent.compareDeep(this.type, o.type, true) && ImplementationGuidePageComponent.compareDeep(this.package_, o.package_, true) && ImplementationGuidePageComponent.compareDeep(this.format, o.format, true) && ImplementationGuidePageComponent.compareDeep(this.page, o.page, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuidePageComponent)) {
                return false;
            }
            ImplementationGuidePageComponent o = (ImplementationGuidePageComponent)other_;
            return ImplementationGuidePageComponent.compareValues(this.source, o.source, true) && ImplementationGuidePageComponent.compareValues(this.title, o.title, true) && ImplementationGuidePageComponent.compareValues(this.kind, o.kind, true) && ImplementationGuidePageComponent.compareValues(this.type, o.type, true) && ImplementationGuidePageComponent.compareValues(this.package_, o.package_, true) && ImplementationGuidePageComponent.compareValues(this.format, o.format, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.source, this.title, this.kind, this.type, this.package_, this.format, this.page);
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.page";
        }
    }

    @Block
    public static class ImplementationGuideGlobalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type this profiles applies to", formalDefinition="The type of resource that all instances must conform to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected CodeType type;
        @Child(name="profile", type={StructureDefinition.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Profile that all resources must conform to", formalDefinition="A reference to the profile that all instances must conform to.")
        protected Reference profile;
        protected StructureDefinition profileTarget;
        private static final long serialVersionUID = 2011731959L;

        public ImplementationGuideGlobalComponent() {
        }

        public ImplementationGuideGlobalComponent(CodeType type, Reference profile2) {
            this.type = type;
            this.profile = profile2;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ImplementationGuideGlobalComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ImplementationGuideGlobalComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public Reference getProfile() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new Reference();
                }
            }
            return this.profile;
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public ImplementationGuideGlobalComponent setProfile(Reference value) {
            this.profile = value;
            return this;
        }

        public StructureDefinition getProfileTarget() {
            if (this.profileTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideGlobalComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profileTarget = new StructureDefinition();
                }
            }
            return this.profileTarget;
        }

        public ImplementationGuideGlobalComponent setProfileTarget(StructureDefinition value) {
            this.profileTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "The type of resource that all instances must conform to.", 0, 1, this.type));
            children.add(new Property("profile", "Reference(StructureDefinition)", "A reference to the profile that all instances must conform to.", 0, 1, this.profile));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "The type of resource that all instances must conform to.", 0, 1, this.type);
                }
                case -309425751: {
                    return new Property("profile", "Reference(StructureDefinition)", "A reference to the profile that all instances must conform to.", 0, 1, this.profile);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCode(value);
                    return value;
                }
                case -309425751: {
                    this.profile = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -309425751: {
                    return this.getProfile();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -309425751: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.type");
            }
            if (name.equals("profile")) {
                this.profile = new Reference();
                return this.profile;
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideGlobalComponent copy() {
            ImplementationGuideGlobalComponent dst = new ImplementationGuideGlobalComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.profile = this.profile == null ? null : this.profile.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideGlobalComponent)) {
                return false;
            }
            ImplementationGuideGlobalComponent o = (ImplementationGuideGlobalComponent)other_;
            return ImplementationGuideGlobalComponent.compareDeep(this.type, o.type, true) && ImplementationGuideGlobalComponent.compareDeep(this.profile, o.profile, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideGlobalComponent)) {
                return false;
            }
            ImplementationGuideGlobalComponent o = (ImplementationGuideGlobalComponent)other_;
            return ImplementationGuideGlobalComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.profile);
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.global";
        }
    }

    @Block
    public static class ImplementationGuidePackageResourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="example", type={BooleanType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="If not an example, has its normal meaning", formalDefinition="Whether a resource is included in the guide as part of the rules defined by the guide, or just as an example of a resource that conforms to the rules and/or help implementers understand the intent of the guide.")
        protected BooleanType example;
        @Child(name="name", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human Name for the resource", formalDefinition="A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason why included in guide", formalDefinition="A description of the reason that a resource has been included in the implementation guide.")
        protected StringType description;
        @Child(name="acronym", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Short code to identify the resource", formalDefinition="A short code that may be used to identify the resource throughout the implementation guide.")
        protected StringType acronym;
        @Child(name="source", type={UriType.class, Reference.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Location of the resource", formalDefinition="Where this resource is found.")
        protected Type source;
        @Child(name="exampleFor", type={StructureDefinition.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Resource this is an example of (if applicable)", formalDefinition="Another resource that this resource is an example for. This is mostly used for resources that are included as examples of StructureDefinitions.")
        protected Reference exampleFor;
        protected StructureDefinition exampleForTarget;
        private static final long serialVersionUID = 2085404852L;

        public ImplementationGuidePackageResourceComponent() {
        }

        public ImplementationGuidePackageResourceComponent(BooleanType example, Type source) {
            this.example = example;
            this.source = source;
        }

        public BooleanType getExampleElement() {
            if (this.example == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.example");
                }
                if (Configuration.doAutoCreate()) {
                    this.example = new BooleanType();
                }
            }
            return this.example;
        }

        public boolean hasExampleElement() {
            return this.example != null && !this.example.isEmpty();
        }

        public boolean hasExample() {
            return this.example != null && !this.example.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setExampleElement(BooleanType value) {
            this.example = value;
            return this;
        }

        public boolean getExample() {
            return this.example == null || this.example.isEmpty() ? false : (Boolean)this.example.getValue();
        }

        public ImplementationGuidePackageResourceComponent setExample(boolean value) {
            if (this.example == null) {
                this.example = new BooleanType();
            }
            this.example.setValue((Object)value);
            return this;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuidePackageResourceComponent setName(String value) {
            if (Utilities.noString(value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImplementationGuidePackageResourceComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public StringType getAcronymElement() {
            if (this.acronym == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.acronym");
                }
                if (Configuration.doAutoCreate()) {
                    this.acronym = new StringType();
                }
            }
            return this.acronym;
        }

        public boolean hasAcronymElement() {
            return this.acronym != null && !this.acronym.isEmpty();
        }

        public boolean hasAcronym() {
            return this.acronym != null && !this.acronym.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setAcronymElement(StringType value) {
            this.acronym = value;
            return this;
        }

        public String getAcronym() {
            return this.acronym == null ? null : (String)this.acronym.getValue();
        }

        public ImplementationGuidePackageResourceComponent setAcronym(String value) {
            if (Utilities.noString(value)) {
                this.acronym = null;
            } else {
                if (this.acronym == null) {
                    this.acronym = new StringType();
                }
                this.acronym.setValue(value);
            }
            return this;
        }

        public Type getSource() {
            return this.source;
        }

        public UriType getSourceUriType() throws FHIRException {
            if (this.source == null) {
                return null;
            }
            if (!(this.source instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (UriType)this.source;
        }

        public boolean hasSourceUriType() {
            return this != null && this.source instanceof UriType;
        }

        public Reference getSourceReference() throws FHIRException {
            if (this.source == null) {
                return null;
            }
            if (!(this.source instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.source.getClass().getName() + " was encountered");
            }
            return (Reference)this.source;
        }

        public boolean hasSourceReference() {
            return this != null && this.source instanceof Reference;
        }

        public boolean hasSource() {
            return this.source != null && !this.source.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setSource(Type value) throws FHIRFormatError {
            if (value != null && !(value instanceof UriType) && !(value instanceof Reference)) {
                throw new FHIRFormatError("Not the right type for ImplementationGuide.package.resource.source[x]: " + value.fhirType());
            }
            this.source = value;
            return this;
        }

        public Reference getExampleFor() {
            if (this.exampleFor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.exampleFor");
                }
                if (Configuration.doAutoCreate()) {
                    this.exampleFor = new Reference();
                }
            }
            return this.exampleFor;
        }

        public boolean hasExampleFor() {
            return this.exampleFor != null && !this.exampleFor.isEmpty();
        }

        public ImplementationGuidePackageResourceComponent setExampleFor(Reference value) {
            this.exampleFor = value;
            return this;
        }

        public StructureDefinition getExampleForTarget() {
            if (this.exampleForTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageResourceComponent.exampleFor");
                }
                if (Configuration.doAutoCreate()) {
                    this.exampleForTarget = new StructureDefinition();
                }
            }
            return this.exampleForTarget;
        }

        public ImplementationGuidePackageResourceComponent setExampleForTarget(StructureDefinition value) {
            this.exampleForTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("example", "boolean", "Whether a resource is included in the guide as part of the rules defined by the guide, or just as an example of a resource that conforms to the rules and/or help implementers understand the intent of the guide.", 0, 1, this.example));
            children.add(new Property(ImplementationGuide.SP_NAME, "string", "A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).", 0, 1, this.name));
            children.add(new Property(ImplementationGuide.SP_DESCRIPTION, "string", "A description of the reason that a resource has been included in the implementation guide.", 0, 1, this.description));
            children.add(new Property("acronym", "string", "A short code that may be used to identify the resource throughout the implementation guide.", 0, 1, this.acronym));
            children.add(new Property("source[x]", "uri|Reference(Any)", "Where this resource is found.", 0, 1, this.source));
            children.add(new Property("exampleFor", "Reference(StructureDefinition)", "Another resource that this resource is an example for. This is mostly used for resources that are included as examples of StructureDefinitions.", 0, 1, this.exampleFor));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1322970774: {
                    return new Property("example", "boolean", "Whether a resource is included in the guide as part of the rules defined by the guide, or just as an example of a resource that conforms to the rules and/or help implementers understand the intent of the guide.", 0, 1, this.example);
                }
                case 3373707: {
                    return new Property(ImplementationGuide.SP_NAME, "string", "A human assigned name for the resource. All resources SHOULD have a name, but the name may be extracted from the resource (e.g. ValueSet.name).", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(ImplementationGuide.SP_DESCRIPTION, "string", "A description of the reason that a resource has been included in the implementation guide.", 0, 1, this.description);
                }
                case -1163472445: {
                    return new Property("acronym", "string", "A short code that may be used to identify the resource throughout the implementation guide.", 0, 1, this.acronym);
                }
                case -1698413947: {
                    return new Property("source[x]", "uri|Reference(Any)", "Where this resource is found.", 0, 1, this.source);
                }
                case -896505829: {
                    return new Property("source[x]", "uri|Reference(Any)", "Where this resource is found.", 0, 1, this.source);
                }
                case -1698419887: {
                    return new Property("source[x]", "uri|Reference(Any)", "Where this resource is found.", 0, 1, this.source);
                }
                case -244259472: {
                    return new Property("source[x]", "uri|Reference(Any)", "Where this resource is found.", 0, 1, this.source);
                }
                case -2002349313: {
                    return new Property("exampleFor", "Reference(StructureDefinition)", "Another resource that this resource is an example for. This is mostly used for resources that are included as examples of StructureDefinitions.", 0, 1, this.exampleFor);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1322970774: {
                    Base[] baseArray;
                    if (this.example == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.example;
                    }
                    return baseArray;
                }
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.description;
                    }
                    return baseArray;
                }
                case -1163472445: {
                    Base[] baseArray;
                    if (this.acronym == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.acronym;
                    }
                    return baseArray;
                }
                case -896505829: {
                    Base[] baseArray;
                    if (this.source == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.source;
                    }
                    return baseArray;
                }
                case -2002349313: {
                    Base[] baseArray;
                    if (this.exampleFor == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.exampleFor;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1322970774: {
                    this.example = this.castToBoolean(value);
                    return value;
                }
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -1163472445: {
                    this.acronym = this.castToString(value);
                    return value;
                }
                case -896505829: {
                    this.source = this.castToType(value);
                    return value;
                }
                case -2002349313: {
                    this.exampleFor = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("example")) {
                this.example = this.castToBoolean(value);
            } else if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("acronym")) {
                this.acronym = this.castToString(value);
            } else if (name.equals("source[x]")) {
                this.source = this.castToType(value);
            } else if (name.equals("exampleFor")) {
                this.exampleFor = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1322970774: {
                    return this.getExampleElement();
                }
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -1163472445: {
                    return this.getAcronymElement();
                }
                case -1698413947: {
                    return this.getSource();
                }
                case -896505829: {
                    return this.getSource();
                }
                case -2002349313: {
                    return this.getExampleFor();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1322970774: {
                    return new String[]{"boolean"};
                }
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -1163472445: {
                    return new String[]{"string"};
                }
                case -896505829: {
                    return new String[]{"uri", "Reference"};
                }
                case -2002349313: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("example")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.example");
            }
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
            }
            if (name.equals("acronym")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.acronym");
            }
            if (name.equals("sourceUri")) {
                this.source = new UriType();
                return this.source;
            }
            if (name.equals("sourceReference")) {
                this.source = new Reference();
                return this.source;
            }
            if (name.equals("exampleFor")) {
                this.exampleFor = new Reference();
                return this.exampleFor;
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuidePackageResourceComponent copy() {
            ImplementationGuidePackageResourceComponent dst = new ImplementationGuidePackageResourceComponent();
            this.copyValues(dst);
            dst.example = this.example == null ? null : this.example.copy();
            dst.name = this.name == null ? null : this.name.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.acronym = this.acronym == null ? null : this.acronym.copy();
            dst.source = this.source == null ? null : this.source.copy();
            dst.exampleFor = this.exampleFor == null ? null : this.exampleFor.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuidePackageResourceComponent)) {
                return false;
            }
            ImplementationGuidePackageResourceComponent o = (ImplementationGuidePackageResourceComponent)other_;
            return ImplementationGuidePackageResourceComponent.compareDeep(this.example, o.example, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.name, o.name, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.description, o.description, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.acronym, o.acronym, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.source, o.source, true) && ImplementationGuidePackageResourceComponent.compareDeep(this.exampleFor, o.exampleFor, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuidePackageResourceComponent)) {
                return false;
            }
            ImplementationGuidePackageResourceComponent o = (ImplementationGuidePackageResourceComponent)other_;
            return ImplementationGuidePackageResourceComponent.compareValues(this.example, o.example, true) && ImplementationGuidePackageResourceComponent.compareValues(this.name, o.name, true) && ImplementationGuidePackageResourceComponent.compareValues(this.description, o.description, true) && ImplementationGuidePackageResourceComponent.compareValues(this.acronym, o.acronym, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.example, this.name, this.description, this.acronym, this.source, this.exampleFor);
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.package.resource";
        }
    }

    @Block
    public static class ImplementationGuidePackageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name used .page.package", formalDefinition="The name for the group, as used in page.package.")
        protected StringType name;
        @Child(name="description", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human readable text describing the package", formalDefinition="Human readable text describing the package.")
        protected StringType description;
        @Child(name="resource", type={}, order=3, min=1, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Resource in the implementation guide", formalDefinition="A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.")
        protected List<ImplementationGuidePackageResourceComponent> resource;
        private static final long serialVersionUID = -701846580L;

        public ImplementationGuidePackageComponent() {
        }

        public ImplementationGuidePackageComponent(StringType name) {
            this.name = name;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ImplementationGuidePackageComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public ImplementationGuidePackageComponent setName(String value) {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuidePackageComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImplementationGuidePackageComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImplementationGuidePackageComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<ImplementationGuidePackageResourceComponent> getResource() {
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuidePackageResourceComponent>();
            }
            return this.resource;
        }

        public ImplementationGuidePackageComponent setResource(List<ImplementationGuidePackageResourceComponent> theResource) {
            this.resource = theResource;
            return this;
        }

        public boolean hasResource() {
            if (this.resource == null) {
                return false;
            }
            for (ImplementationGuidePackageResourceComponent item : this.resource) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImplementationGuidePackageResourceComponent addResource() {
            ImplementationGuidePackageResourceComponent t = new ImplementationGuidePackageResourceComponent();
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuidePackageResourceComponent>();
            }
            this.resource.add(t);
            return t;
        }

        public ImplementationGuidePackageComponent addResource(ImplementationGuidePackageResourceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.resource == null) {
                this.resource = new ArrayList<ImplementationGuidePackageResourceComponent>();
            }
            this.resource.add(t);
            return this;
        }

        public ImplementationGuidePackageResourceComponent getResourceFirstRep() {
            if (this.getResource().isEmpty()) {
                this.addResource();
            }
            return this.getResource().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(ImplementationGuide.SP_NAME, "string", "The name for the group, as used in page.package.", 0, 1, this.name));
            children.add(new Property(ImplementationGuide.SP_DESCRIPTION, "string", "Human readable text describing the package.", 0, 1, this.description));
            children.add(new Property(ImplementationGuide.SP_RESOURCE, "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3373707: {
                    return new Property(ImplementationGuide.SP_NAME, "string", "The name for the group, as used in page.package.", 0, 1, this.name);
                }
                case -1724546052: {
                    return new Property(ImplementationGuide.SP_DESCRIPTION, "string", "Human readable text describing the package.", 0, 1, this.description);
                }
                case -341064690: {
                    return new Property(ImplementationGuide.SP_RESOURCE, "", "A resource that is part of the implementation guide. Conformance resources (value set, structure definition, capability statements etc.) are obvious candidates for inclusion, but any kind of resource can be included as an example resource.", 0, Integer.MAX_VALUE, this.resource);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    Base[] baseArray;
                    if (this.name == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.name;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.description;
                    }
                    return baseArray;
                }
                case -341064690: {
                    return this.resource == null ? new Base[]{} : this.resource.toArray(new Base[this.resource.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    this.name = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -341064690: {
                    this.getResource().add((ImplementationGuidePackageResourceComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                this.name = this.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                this.getResource().add((ImplementationGuidePackageResourceComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return this.getNameElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -341064690: {
                    return this.addResource();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3373707: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -341064690: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImplementationGuide.SP_NAME)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.name");
            }
            if (name.equals(ImplementationGuide.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.description");
            }
            if (name.equals(ImplementationGuide.SP_RESOURCE)) {
                return this.addResource();
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuidePackageComponent copy() {
            ImplementationGuidePackageComponent dst = new ImplementationGuidePackageComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.resource != null) {
                dst.resource = new ArrayList<ImplementationGuidePackageResourceComponent>();
                for (ImplementationGuidePackageResourceComponent i2 : this.resource) {
                    dst.resource.add(i2.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuidePackageComponent)) {
                return false;
            }
            ImplementationGuidePackageComponent o = (ImplementationGuidePackageComponent)other_;
            return ImplementationGuidePackageComponent.compareDeep(this.name, o.name, true) && ImplementationGuidePackageComponent.compareDeep(this.description, o.description, true) && ImplementationGuidePackageComponent.compareDeep(this.resource, o.resource, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuidePackageComponent)) {
                return false;
            }
            ImplementationGuidePackageComponent o = (ImplementationGuidePackageComponent)other_;
            return ImplementationGuidePackageComponent.compareValues(this.name, o.name, true) && ImplementationGuidePackageComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.name, this.description, this.resource);
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.package";
        }
    }

    @Block
    public static class ImplementationGuideDependencyComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="reference | inclusion", formalDefinition="How the dependency is represented when the guide is published.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/guide-dependency-type")
        protected Enumeration<GuideDependencyType> type;
        @Child(name="uri", type={UriType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Where to find dependency", formalDefinition="Where the dependency is located.")
        protected UriType uri;
        private static final long serialVersionUID = 162447098L;

        public ImplementationGuideDependencyComponent() {
        }

        public ImplementationGuideDependencyComponent(Enumeration<GuideDependencyType> type, UriType uri) {
            this.type = type;
            this.uri = uri;
        }

        public Enumeration<GuideDependencyType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependencyComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<GuideDependencyType>(new GuideDependencyTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ImplementationGuideDependencyComponent setTypeElement(Enumeration<GuideDependencyType> value) {
            this.type = value;
            return this;
        }

        public GuideDependencyType getType() {
            return this.type == null ? null : (GuideDependencyType)((Object)this.type.getValue());
        }

        public ImplementationGuideDependencyComponent setType(GuideDependencyType value) {
            if (this.type == null) {
                this.type = new Enumeration<GuideDependencyType>(new GuideDependencyTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        public UriType getUriElement() {
            if (this.uri == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImplementationGuideDependencyComponent.uri");
                }
                if (Configuration.doAutoCreate()) {
                    this.uri = new UriType();
                }
            }
            return this.uri;
        }

        public boolean hasUriElement() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public boolean hasUri() {
            return this.uri != null && !this.uri.isEmpty();
        }

        public ImplementationGuideDependencyComponent setUriElement(UriType value) {
            this.uri = value;
            return this;
        }

        public String getUri() {
            return this.uri == null ? null : (String)this.uri.getValue();
        }

        public ImplementationGuideDependencyComponent setUri(String value) {
            if (this.uri == null) {
                this.uri = new UriType();
            }
            this.uri.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "How the dependency is represented when the guide is published.", 0, 1, this.type));
            children.add(new Property("uri", "uri", "Where the dependency is located.", 0, 1, this.uri));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "How the dependency is represented when the guide is published.", 0, 1, this.type);
                }
                case 116076: {
                    return new Property("uri", "uri", "Where the dependency is located.", 0, 1, this.uri);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case 116076: {
                    Base[] baseArray;
                    if (this.uri == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.uri;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    value = new GuideDependencyTypeEnumFactory().fromType(this.castToCode(value));
                    this.type = value;
                    return value;
                }
                case 116076: {
                    this.uri = this.castToUri(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                value = new GuideDependencyTypeEnumFactory().fromType(this.castToCode(value));
                this.type = value;
            } else if (name.equals("uri")) {
                this.uri = this.castToUri(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case 116076: {
                    return this.getUriElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case 116076: {
                    return new String[]{"uri"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.type");
            }
            if (name.equals("uri")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImplementationGuide.uri");
            }
            return super.addChild(name);
        }

        @Override
        public ImplementationGuideDependencyComponent copy() {
            ImplementationGuideDependencyComponent dst = new ImplementationGuideDependencyComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.uri = this.uri == null ? null : this.uri.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDependencyComponent)) {
                return false;
            }
            ImplementationGuideDependencyComponent o = (ImplementationGuideDependencyComponent)other_;
            return ImplementationGuideDependencyComponent.compareDeep(this.type, o.type, true) && ImplementationGuideDependencyComponent.compareDeep(this.uri, o.uri, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ImplementationGuideDependencyComponent)) {
                return false;
            }
            ImplementationGuideDependencyComponent o = (ImplementationGuideDependencyComponent)other_;
            return ImplementationGuideDependencyComponent.compareValues(this.type, o.type, true) && ImplementationGuideDependencyComponent.compareValues(this.uri, o.uri, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.uri);
        }

        @Override
        public String fhirType() {
            return "ImplementationGuide.dependency";
        }
    }

    public static class GuidePageKindEnumFactory
    implements EnumFactory<GuidePageKind> {
        @Override
        public GuidePageKind fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("page".equals(codeString)) {
                return GuidePageKind.PAGE;
            }
            if ("example".equals(codeString)) {
                return GuidePageKind.EXAMPLE;
            }
            if ("list".equals(codeString)) {
                return GuidePageKind.LIST;
            }
            if ("include".equals(codeString)) {
                return GuidePageKind.INCLUDE;
            }
            if ("directory".equals(codeString)) {
                return GuidePageKind.DIRECTORY;
            }
            if ("dictionary".equals(codeString)) {
                return GuidePageKind.DICTIONARY;
            }
            if ("toc".equals(codeString)) {
                return GuidePageKind.TOC;
            }
            if (ImplementationGuide.SP_RESOURCE.equals(codeString)) {
                return GuidePageKind.RESOURCE;
            }
            throw new IllegalArgumentException("Unknown GuidePageKind code '" + codeString + "'");
        }

        public Enumeration<GuidePageKind> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GuidePageKind>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("page".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.PAGE);
            }
            if ("example".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.EXAMPLE);
            }
            if ("list".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.LIST);
            }
            if ("include".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.INCLUDE);
            }
            if ("directory".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.DIRECTORY);
            }
            if ("dictionary".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.DICTIONARY);
            }
            if ("toc".equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.TOC);
            }
            if (ImplementationGuide.SP_RESOURCE.equals(codeString)) {
                return new Enumeration<GuidePageKind>(this, GuidePageKind.RESOURCE);
            }
            throw new FHIRException("Unknown GuidePageKind code '" + codeString + "'");
        }

        @Override
        public String toCode(GuidePageKind code) {
            if (code == GuidePageKind.PAGE) {
                return "page";
            }
            if (code == GuidePageKind.EXAMPLE) {
                return "example";
            }
            if (code == GuidePageKind.LIST) {
                return "list";
            }
            if (code == GuidePageKind.INCLUDE) {
                return "include";
            }
            if (code == GuidePageKind.DIRECTORY) {
                return "directory";
            }
            if (code == GuidePageKind.DICTIONARY) {
                return "dictionary";
            }
            if (code == GuidePageKind.TOC) {
                return "toc";
            }
            if (code == GuidePageKind.RESOURCE) {
                return ImplementationGuide.SP_RESOURCE;
            }
            return "?";
        }

        @Override
        public String toSystem(GuidePageKind code) {
            return code.getSystem();
        }
    }

    public static enum GuidePageKind {
        PAGE,
        EXAMPLE,
        LIST,
        INCLUDE,
        DIRECTORY,
        DICTIONARY,
        TOC,
        RESOURCE,
        NULL;


        public static GuidePageKind fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("page".equals(codeString)) {
                return PAGE;
            }
            if ("example".equals(codeString)) {
                return EXAMPLE;
            }
            if ("list".equals(codeString)) {
                return LIST;
            }
            if ("include".equals(codeString)) {
                return INCLUDE;
            }
            if ("directory".equals(codeString)) {
                return DIRECTORY;
            }
            if ("dictionary".equals(codeString)) {
                return DICTIONARY;
            }
            if ("toc".equals(codeString)) {
                return TOC;
            }
            if (ImplementationGuide.SP_RESOURCE.equals(codeString)) {
                return RESOURCE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GuidePageKind code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PAGE: {
                    return "page";
                }
                case EXAMPLE: {
                    return "example";
                }
                case LIST: {
                    return "list";
                }
                case INCLUDE: {
                    return "include";
                }
                case DIRECTORY: {
                    return "directory";
                }
                case DICTIONARY: {
                    return "dictionary";
                }
                case TOC: {
                    return "toc";
                }
                case RESOURCE: {
                    return ImplementationGuide.SP_RESOURCE;
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PAGE: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case EXAMPLE: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case LIST: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case INCLUDE: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case DIRECTORY: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case DICTIONARY: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case TOC: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case RESOURCE: {
                    return "http://hl7.org/fhir/guide-page-kind";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PAGE: {
                    return "This is a page of content that is included in the implementation guide. It has no particular function.";
                }
                case EXAMPLE: {
                    return "This is a page that represents a human readable rendering of an example.";
                }
                case LIST: {
                    return "This is a page that represents a list of resources of one or more types.";
                }
                case INCLUDE: {
                    return "This is a page showing where an included guide is injected.";
                }
                case DIRECTORY: {
                    return "This is a page that lists the resources of a given type, and also creates pages for all the listed types as other pages in the section.";
                }
                case DICTIONARY: {
                    return "This is a page that creates the listed resources as a dictionary.";
                }
                case TOC: {
                    return "This is a generated page that contains the table of contents.";
                }
                case RESOURCE: {
                    return "This is a page that represents a presented resource. This is typically used for generated conformance resource presentations.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PAGE: {
                    return "Page";
                }
                case EXAMPLE: {
                    return "Example";
                }
                case LIST: {
                    return "List";
                }
                case INCLUDE: {
                    return "Include";
                }
                case DIRECTORY: {
                    return "Directory";
                }
                case DICTIONARY: {
                    return "Dictionary";
                }
                case TOC: {
                    return "Table Of Contents";
                }
                case RESOURCE: {
                    return "Resource";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class GuideDependencyTypeEnumFactory
    implements EnumFactory<GuideDependencyType> {
        @Override
        public GuideDependencyType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("reference".equals(codeString)) {
                return GuideDependencyType.REFERENCE;
            }
            if ("inclusion".equals(codeString)) {
                return GuideDependencyType.INCLUSION;
            }
            throw new IllegalArgumentException("Unknown GuideDependencyType code '" + codeString + "'");
        }

        public Enumeration<GuideDependencyType> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GuideDependencyType>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("reference".equals(codeString)) {
                return new Enumeration<GuideDependencyType>(this, GuideDependencyType.REFERENCE);
            }
            if ("inclusion".equals(codeString)) {
                return new Enumeration<GuideDependencyType>(this, GuideDependencyType.INCLUSION);
            }
            throw new FHIRException("Unknown GuideDependencyType code '" + codeString + "'");
        }

        @Override
        public String toCode(GuideDependencyType code) {
            if (code == GuideDependencyType.REFERENCE) {
                return "reference";
            }
            if (code == GuideDependencyType.INCLUSION) {
                return "inclusion";
            }
            return "?";
        }

        @Override
        public String toSystem(GuideDependencyType code) {
            return code.getSystem();
        }
    }

    public static enum GuideDependencyType {
        REFERENCE,
        INCLUSION,
        NULL;


        public static GuideDependencyType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("reference".equals(codeString)) {
                return REFERENCE;
            }
            if ("inclusion".equals(codeString)) {
                return INCLUSION;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GuideDependencyType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REFERENCE: {
                    return "reference";
                }
                case INCLUSION: {
                    return "inclusion";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REFERENCE: {
                    return "http://hl7.org/fhir/guide-dependency-type";
                }
                case INCLUSION: {
                    return "http://hl7.org/fhir/guide-dependency-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REFERENCE: {
                    return "The guide is referred to by URL.";
                }
                case INCLUSION: {
                    return "The guide is embedded in this guide when published.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REFERENCE: {
                    return "Reference";
                }
                case INCLUSION: {
                    return "Inclusion";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

