/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.ChildOrder;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.BooleanType;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.ContactDetail;
import org.hl7.fhir.dstu3.model.DateTimeType;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.IntegerType;
import org.hl7.fhir.dstu3.model.MarkdownType;
import org.hl7.fhir.dstu3.model.MetadataResource;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="GraphDefinition", profile="http://hl7.org/fhir/Profile/GraphDefinition")
@ChildOrder(names={"url", "version", "name", "status", "experimental", "date", "publisher", "contact", "description", "useContext", "jurisdiction", "purpose", "start", "profile", "link"})
public class GraphDefinition
extends MetadataResource {
    @Child(name="purpose", type={MarkdownType.class}, order=0, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Why this graph definition is defined", formalDefinition="Explaination of why this graph definition is needed and why it has been designed as it has.")
    protected MarkdownType purpose;
    @Child(name="start", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Type of resource at which the graph starts", formalDefinition="The type of FHIR resource at which instances of this graph start.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
    protected CodeType start;
    @Child(name="profile", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Profile on base resource", formalDefinition="The profile that describes the use of the base resource.")
    protected UriType profile;
    @Child(name="link", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Links this graph makes rules about", formalDefinition="Links this graph makes rules about.")
    protected List<GraphDefinitionLinkComponent> link;
    private static final long serialVersionUID = 86877575L;
    @SearchParamDefinition(name="date", path="GraphDefinition.date", description="The graph definition publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="jurisdiction", path="GraphDefinition.jurisdiction", description="Intended jurisdiction for the graph definition", type="token")
    public static final String SP_JURISDICTION = "jurisdiction";
    public static final TokenClientParam JURISDICTION = new TokenClientParam("jurisdiction");
    @SearchParamDefinition(name="name", path="GraphDefinition.name", description="Computationally friendly name of the graph definition", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="start", path="GraphDefinition.start", description="Type of resource at which the graph starts", type="token")
    public static final String SP_START = "start";
    public static final TokenClientParam START = new TokenClientParam("start");
    @SearchParamDefinition(name="description", path="GraphDefinition.description", description="The description of the graph definition", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="publisher", path="GraphDefinition.publisher", description="Name of the publisher of the graph definition", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="version", path="GraphDefinition.version", description="The business version of the graph definition", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="url", path="GraphDefinition.url", description="The uri that identifies the graph definition", type="uri")
    public static final String SP_URL = "url";
    public static final UriClientParam URL = new UriClientParam("url");
    @SearchParamDefinition(name="status", path="GraphDefinition.status", description="The current status of the graph definition", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public GraphDefinition() {
    }

    public GraphDefinition(StringType name, Enumeration<Enumerations.PublicationStatus> status, CodeType start) {
        this.name = name;
        this.status = status;
        this.start = start;
    }

    @Override
    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    @Override
    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    @Override
    public GraphDefinition setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    @Override
    public GraphDefinition setUrl(String value) {
        if (Utilities.noString(value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getVersionElement() {
        if (this.version == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.version");
            }
            if (Configuration.doAutoCreate()) {
                this.version = new StringType();
            }
        }
        return this.version;
    }

    @Override
    public boolean hasVersionElement() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public boolean hasVersion() {
        return this.version != null && !this.version.isEmpty();
    }

    @Override
    public GraphDefinition setVersionElement(StringType value) {
        this.version = value;
        return this;
    }

    @Override
    public String getVersion() {
        return this.version == null ? null : (String)this.version.getValue();
    }

    @Override
    public GraphDefinition setVersion(String value) {
        if (Utilities.noString(value)) {
            this.version = null;
        } else {
            if (this.version == null) {
                this.version = new StringType();
            }
            this.version.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    @Override
    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    @Override
    public GraphDefinition setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    @Override
    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    @Override
    public GraphDefinition setName(String value) {
        if (this.name == null) {
            this.name = new StringType();
        }
        this.name.setValue(value);
        return this;
    }

    @Override
    public Enumeration<Enumerations.PublicationStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
            }
        }
        return this.status;
    }

    @Override
    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    @Override
    public GraphDefinition setStatusElement(Enumeration<Enumerations.PublicationStatus> value) {
        this.status = value;
        return this;
    }

    @Override
    public Enumerations.PublicationStatus getStatus() {
        return this.status == null ? null : (Enumerations.PublicationStatus)((Object)this.status.getValue());
    }

    @Override
    public GraphDefinition setStatus(Enumerations.PublicationStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<Enumerations.PublicationStatus>(new Enumerations.PublicationStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    @Override
    public BooleanType getExperimentalElement() {
        if (this.experimental == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.experimental");
            }
            if (Configuration.doAutoCreate()) {
                this.experimental = new BooleanType();
            }
        }
        return this.experimental;
    }

    @Override
    public boolean hasExperimentalElement() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public boolean hasExperimental() {
        return this.experimental != null && !this.experimental.isEmpty();
    }

    @Override
    public GraphDefinition setExperimentalElement(BooleanType value) {
        this.experimental = value;
        return this;
    }

    @Override
    public boolean getExperimental() {
        return this.experimental == null || this.experimental.isEmpty() ? false : (Boolean)this.experimental.getValue();
    }

    @Override
    public GraphDefinition setExperimental(boolean value) {
        if (this.experimental == null) {
            this.experimental = new BooleanType();
        }
        this.experimental.setValue((Object)value);
        return this;
    }

    @Override
    public DateTimeType getDateElement() {
        if (this.date == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.date");
            }
            if (Configuration.doAutoCreate()) {
                this.date = new DateTimeType();
            }
        }
        return this.date;
    }

    @Override
    public boolean hasDateElement() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public boolean hasDate() {
        return this.date != null && !this.date.isEmpty();
    }

    @Override
    public GraphDefinition setDateElement(DateTimeType value) {
        this.date = value;
        return this;
    }

    @Override
    public Date getDate() {
        return this.date == null ? null : (Date)this.date.getValue();
    }

    @Override
    public GraphDefinition setDate(Date value) {
        if (value == null) {
            this.date = null;
        } else {
            if (this.date == null) {
                this.date = new DateTimeType();
            }
            this.date.setValue(value);
        }
        return this;
    }

    @Override
    public StringType getPublisherElement() {
        if (this.publisher == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.publisher");
            }
            if (Configuration.doAutoCreate()) {
                this.publisher = new StringType();
            }
        }
        return this.publisher;
    }

    @Override
    public boolean hasPublisherElement() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public boolean hasPublisher() {
        return this.publisher != null && !this.publisher.isEmpty();
    }

    @Override
    public GraphDefinition setPublisherElement(StringType value) {
        this.publisher = value;
        return this;
    }

    @Override
    public String getPublisher() {
        return this.publisher == null ? null : (String)this.publisher.getValue();
    }

    @Override
    public GraphDefinition setPublisher(String value) {
        if (Utilities.noString(value)) {
            this.publisher = null;
        } else {
            if (this.publisher == null) {
                this.publisher = new StringType();
            }
            this.publisher.setValue(value);
        }
        return this;
    }

    @Override
    public List<ContactDetail> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        return this.contact;
    }

    @Override
    public GraphDefinition setContact(List<ContactDetail> theContact) {
        this.contact = theContact;
        return this;
    }

    @Override
    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactDetail item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ContactDetail addContact() {
        ContactDetail t = new ContactDetail();
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return t;
    }

    @Override
    public GraphDefinition addContact(ContactDetail t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList();
        }
        this.contact.add(t);
        return this;
    }

    @Override
    public ContactDetail getContactFirstRep() {
        if (this.getContact().isEmpty()) {
            this.addContact();
        }
        return this.getContact().get(0);
    }

    @Override
    public MarkdownType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new MarkdownType();
            }
        }
        return this.description;
    }

    @Override
    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    @Override
    public GraphDefinition setDescriptionElement(MarkdownType value) {
        this.description = value;
        return this;
    }

    @Override
    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    @Override
    public GraphDefinition setDescription(String value) {
        if (value == null) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new MarkdownType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    public List<UsageContext> getUseContext() {
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        return this.useContext;
    }

    @Override
    public GraphDefinition setUseContext(List<UsageContext> theUseContext) {
        this.useContext = theUseContext;
        return this;
    }

    @Override
    public boolean hasUseContext() {
        if (this.useContext == null) {
            return false;
        }
        for (UsageContext item : this.useContext) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public UsageContext addUseContext() {
        UsageContext t = new UsageContext();
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return t;
    }

    @Override
    public GraphDefinition addUseContext(UsageContext t) {
        if (t == null) {
            return this;
        }
        if (this.useContext == null) {
            this.useContext = new ArrayList();
        }
        this.useContext.add(t);
        return this;
    }

    @Override
    public UsageContext getUseContextFirstRep() {
        if (this.getUseContext().isEmpty()) {
            this.addUseContext();
        }
        return this.getUseContext().get(0);
    }

    @Override
    public List<CodeableConcept> getJurisdiction() {
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        return this.jurisdiction;
    }

    @Override
    public GraphDefinition setJurisdiction(List<CodeableConcept> theJurisdiction) {
        this.jurisdiction = theJurisdiction;
        return this;
    }

    @Override
    public boolean hasJurisdiction() {
        if (this.jurisdiction == null) {
            return false;
        }
        for (CodeableConcept item : this.jurisdiction) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public CodeableConcept addJurisdiction() {
        CodeableConcept t = new CodeableConcept();
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return t;
    }

    @Override
    public GraphDefinition addJurisdiction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.jurisdiction == null) {
            this.jurisdiction = new ArrayList();
        }
        this.jurisdiction.add(t);
        return this;
    }

    @Override
    public CodeableConcept getJurisdictionFirstRep() {
        if (this.getJurisdiction().isEmpty()) {
            this.addJurisdiction();
        }
        return this.getJurisdiction().get(0);
    }

    public MarkdownType getPurposeElement() {
        if (this.purpose == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.purpose");
            }
            if (Configuration.doAutoCreate()) {
                this.purpose = new MarkdownType();
            }
        }
        return this.purpose;
    }

    public boolean hasPurposeElement() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public boolean hasPurpose() {
        return this.purpose != null && !this.purpose.isEmpty();
    }

    public GraphDefinition setPurposeElement(MarkdownType value) {
        this.purpose = value;
        return this;
    }

    public String getPurpose() {
        return this.purpose == null ? null : (String)this.purpose.getValue();
    }

    public GraphDefinition setPurpose(String value) {
        if (value == null) {
            this.purpose = null;
        } else {
            if (this.purpose == null) {
                this.purpose = new MarkdownType();
            }
            this.purpose.setValue(value);
        }
        return this;
    }

    public CodeType getStartElement() {
        if (this.start == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.start");
            }
            if (Configuration.doAutoCreate()) {
                this.start = new CodeType();
            }
        }
        return this.start;
    }

    public boolean hasStartElement() {
        return this.start != null && !this.start.isEmpty();
    }

    public boolean hasStart() {
        return this.start != null && !this.start.isEmpty();
    }

    public GraphDefinition setStartElement(CodeType value) {
        this.start = value;
        return this;
    }

    public String getStart() {
        return this.start == null ? null : (String)this.start.getValue();
    }

    public GraphDefinition setStart(String value) {
        if (this.start == null) {
            this.start = new CodeType();
        }
        this.start.setValue(value);
        return this;
    }

    public UriType getProfileElement() {
        if (this.profile == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create GraphDefinition.profile");
            }
            if (Configuration.doAutoCreate()) {
                this.profile = new UriType();
            }
        }
        return this.profile;
    }

    public boolean hasProfileElement() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public boolean hasProfile() {
        return this.profile != null && !this.profile.isEmpty();
    }

    public GraphDefinition setProfileElement(UriType value) {
        this.profile = value;
        return this;
    }

    public String getProfile() {
        return this.profile == null ? null : (String)this.profile.getValue();
    }

    public GraphDefinition setProfile(String value) {
        if (Utilities.noString(value)) {
            this.profile = null;
        } else {
            if (this.profile == null) {
                this.profile = new UriType();
            }
            this.profile.setValue(value);
        }
        return this;
    }

    public List<GraphDefinitionLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<GraphDefinitionLinkComponent>();
        }
        return this.link;
    }

    public GraphDefinition setLink(List<GraphDefinitionLinkComponent> theLink) {
        this.link = theLink;
        return this;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (GraphDefinitionLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public GraphDefinitionLinkComponent addLink() {
        GraphDefinitionLinkComponent t = new GraphDefinitionLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<GraphDefinitionLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public GraphDefinition addLink(GraphDefinitionLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<GraphDefinitionLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    public GraphDefinitionLinkComponent getLinkFirstRep() {
        if (this.getLink().isEmpty()) {
            this.addLink();
        }
        return this.getLink().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_URL, "uri", "An absolute URI that is used to identify this graph definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this graph definition is (or will be) published. The URL SHOULD include the major version of the graph definition. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url));
        children.add(new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the graph definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the graph definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version));
        children.add(new Property(SP_NAME, "string", "A natural language name identifying the graph definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name));
        children.add(new Property(SP_STATUS, "code", "The status of this graph definition. Enables tracking the life-cycle of the content.", 0, 1, this.status));
        children.add(new Property("experimental", "boolean", "A boolean value to indicate that this graph definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental));
        children.add(new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the graph definition was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the graph definition changes.", 0, 1, this.date));
        children.add(new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the graph definition.", 0, 1, this.publisher));
        children.add(new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact));
        children.add(new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the graph definition from a consumer's perspective.", 0, 1, this.description));
        children.add(new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate graph definition instances.", 0, Integer.MAX_VALUE, this.useContext));
        children.add(new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the graph definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction));
        children.add(new Property("purpose", "markdown", "Explaination of why this graph definition is needed and why it has been designed as it has.", 0, 1, this.purpose));
        children.add(new Property(SP_START, "code", "The type of FHIR resource at which instances of this graph start.", 0, 1, this.start));
        children.add(new Property("profile", "uri", "The profile that describes the use of the base resource.", 0, 1, this.profile));
        children.add(new Property("link", "", "Links this graph makes rules about.", 0, Integer.MAX_VALUE, this.link));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case 116079: {
                return new Property(SP_URL, "uri", "An absolute URI that is used to identify this graph definition when it is referenced in a specification, model, design or an instance. This SHALL be a URL, SHOULD be globally unique, and SHOULD be an address at which this graph definition is (or will be) published. The URL SHOULD include the major version of the graph definition. For more information see [Technical and Business Versions](resource.html#versions).", 0, 1, this.url);
            }
            case 351608024: {
                return new Property(SP_VERSION, "string", "The identifier that is used to identify this version of the graph definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the graph definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.", 0, 1, this.version);
            }
            case 3373707: {
                return new Property(SP_NAME, "string", "A natural language name identifying the graph definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.", 0, 1, this.name);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "The status of this graph definition. Enables tracking the life-cycle of the content.", 0, 1, this.status);
            }
            case -404562712: {
                return new Property("experimental", "boolean", "A boolean value to indicate that this graph definition is authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage.", 0, 1, this.experimental);
            }
            case 3076014: {
                return new Property(SP_DATE, "dateTime", "The date  (and optionally time) when the graph definition was published. The date must change if and when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the graph definition changes.", 0, 1, this.date);
            }
            case 1447404028: {
                return new Property(SP_PUBLISHER, "string", "The name of the individual or organization that published the graph definition.", 0, 1, this.publisher);
            }
            case 951526432: {
                return new Property("contact", "ContactDetail", "Contact details to assist a user in finding and communicating with the publisher.", 0, Integer.MAX_VALUE, this.contact);
            }
            case -1724546052: {
                return new Property(SP_DESCRIPTION, "markdown", "A free text natural language description of the graph definition from a consumer's perspective.", 0, 1, this.description);
            }
            case -669707736: {
                return new Property("useContext", "UsageContext", "The content was developed with a focus and intent of supporting the contexts that are listed. These terms may be used to assist with indexing and searching for appropriate graph definition instances.", 0, Integer.MAX_VALUE, this.useContext);
            }
            case -507075711: {
                return new Property(SP_JURISDICTION, "CodeableConcept", "A legal or geographic region in which the graph definition is intended to be used.", 0, Integer.MAX_VALUE, this.jurisdiction);
            }
            case -220463842: {
                return new Property("purpose", "markdown", "Explaination of why this graph definition is needed and why it has been designed as it has.", 0, 1, this.purpose);
            }
            case 109757538: {
                return new Property(SP_START, "code", "The type of FHIR resource at which instances of this graph start.", 0, 1, this.start);
            }
            case -309425751: {
                return new Property("profile", "uri", "The profile that describes the use of the base resource.", 0, 1, this.profile);
            }
            case 3321850: {
                return new Property("link", "", "Links this graph makes rules about.", 0, Integer.MAX_VALUE, this.link);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.url;
                }
                return baseArray;
            }
            case 351608024: {
                Base[] baseArray;
                if (this.version == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.version;
                }
                return baseArray;
            }
            case 3373707: {
                Base[] baseArray;
                if (this.name == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.name;
                }
                return baseArray;
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.status;
                }
                return baseArray;
            }
            case -404562712: {
                Base[] baseArray;
                if (this.experimental == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.experimental;
                }
                return baseArray;
            }
            case 3076014: {
                Base[] baseArray;
                if (this.date == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.date;
                }
                return baseArray;
            }
            case 1447404028: {
                Base[] baseArray;
                if (this.publisher == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.publisher;
                }
                return baseArray;
            }
            case 951526432: {
                return this.contact == null ? new Base[]{} : this.contact.toArray(new Base[this.contact.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.description;
                }
                return baseArray;
            }
            case -669707736: {
                return this.useContext == null ? new Base[]{} : this.useContext.toArray(new Base[this.useContext.size()]);
            }
            case -507075711: {
                return this.jurisdiction == null ? new Base[]{} : this.jurisdiction.toArray(new Base[this.jurisdiction.size()]);
            }
            case -220463842: {
                Base[] baseArray;
                if (this.purpose == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.purpose;
                }
                return baseArray;
            }
            case 109757538: {
                Base[] baseArray;
                if (this.start == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.start;
                }
                return baseArray;
            }
            case -309425751: {
                Base[] baseArray;
                if (this.profile == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.profile;
                }
                return baseArray;
            }
            case 3321850: {
                return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 116079: {
                this.url = this.castToUri(value);
                return value;
            }
            case 351608024: {
                this.version = this.castToString(value);
                return value;
            }
            case 3373707: {
                this.name = this.castToString(value);
                return value;
            }
            case -892481550: {
                this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
                return value;
            }
            case -404562712: {
                this.experimental = this.castToBoolean(value);
                return value;
            }
            case 3076014: {
                this.date = this.castToDateTime(value);
                return value;
            }
            case 1447404028: {
                this.publisher = this.castToString(value);
                return value;
            }
            case 951526432: {
                this.getContact().add(this.castToContactDetail(value));
                return value;
            }
            case -1724546052: {
                this.description = this.castToMarkdown(value);
                return value;
            }
            case -669707736: {
                this.getUseContext().add(this.castToUsageContext(value));
                return value;
            }
            case -507075711: {
                this.getJurisdiction().add(this.castToCodeableConcept(value));
                return value;
            }
            case -220463842: {
                this.purpose = this.castToMarkdown(value);
                return value;
            }
            case 109757538: {
                this.start = this.castToCode(value);
                return value;
            }
            case -309425751: {
                this.profile = this.castToUri(value);
                return value;
            }
            case 3321850: {
                this.getLink().add((GraphDefinitionLinkComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_URL)) {
            this.url = this.castToUri(value);
        } else if (name.equals(SP_VERSION)) {
            this.version = this.castToString(value);
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = value = new Enumerations.PublicationStatusEnumFactory().fromType(this.castToCode(value));
        } else if (name.equals("experimental")) {
            this.experimental = this.castToBoolean(value);
        } else if (name.equals(SP_DATE)) {
            this.date = this.castToDateTime(value);
        } else if (name.equals(SP_PUBLISHER)) {
            this.publisher = this.castToString(value);
        } else if (name.equals("contact")) {
            this.getContact().add(this.castToContactDetail(value));
        } else if (name.equals(SP_DESCRIPTION)) {
            this.description = this.castToMarkdown(value);
        } else if (name.equals("useContext")) {
            this.getUseContext().add(this.castToUsageContext(value));
        } else if (name.equals(SP_JURISDICTION)) {
            this.getJurisdiction().add(this.castToCodeableConcept(value));
        } else if (name.equals("purpose")) {
            this.purpose = this.castToMarkdown(value);
        } else if (name.equals(SP_START)) {
            this.start = this.castToCode(value);
        } else if (name.equals("profile")) {
            this.profile = this.castToUri(value);
        } else if (name.equals("link")) {
            this.getLink().add((GraphDefinitionLinkComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return this.getUrlElement();
            }
            case 351608024: {
                return this.getVersionElement();
            }
            case 3373707: {
                return this.getNameElement();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -404562712: {
                return this.getExperimentalElement();
            }
            case 3076014: {
                return this.getDateElement();
            }
            case 1447404028: {
                return this.getPublisherElement();
            }
            case 951526432: {
                return this.addContact();
            }
            case -1724546052: {
                return this.getDescriptionElement();
            }
            case -669707736: {
                return this.addUseContext();
            }
            case -507075711: {
                return this.addJurisdiction();
            }
            case -220463842: {
                return this.getPurposeElement();
            }
            case 109757538: {
                return this.getStartElement();
            }
            case -309425751: {
                return this.getProfileElement();
            }
            case 3321850: {
                return this.addLink();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 116079: {
                return new String[]{"uri"};
            }
            case 351608024: {
                return new String[]{"string"};
            }
            case 3373707: {
                return new String[]{"string"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -404562712: {
                return new String[]{"boolean"};
            }
            case 3076014: {
                return new String[]{"dateTime"};
            }
            case 1447404028: {
                return new String[]{"string"};
            }
            case 951526432: {
                return new String[]{"ContactDetail"};
            }
            case -1724546052: {
                return new String[]{"markdown"};
            }
            case -669707736: {
                return new String[]{"UsageContext"};
            }
            case -507075711: {
                return new String[]{"CodeableConcept"};
            }
            case -220463842: {
                return new String[]{"markdown"};
            }
            case 109757538: {
                return new String[]{"code"};
            }
            case -309425751: {
                return new String[]{"uri"};
            }
            case 3321850: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_URL)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.url");
        }
        if (name.equals(SP_VERSION)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.version");
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.name");
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.status");
        }
        if (name.equals("experimental")) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.experimental");
        }
        if (name.equals(SP_DATE)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.date");
        }
        if (name.equals(SP_PUBLISHER)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.publisher");
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals(SP_DESCRIPTION)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.description");
        }
        if (name.equals("useContext")) {
            return this.addUseContext();
        }
        if (name.equals(SP_JURISDICTION)) {
            return this.addJurisdiction();
        }
        if (name.equals("purpose")) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.purpose");
        }
        if (name.equals(SP_START)) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.start");
        }
        if (name.equals("profile")) {
            throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.profile");
        }
        if (name.equals("link")) {
            return this.addLink();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "GraphDefinition";
    }

    @Override
    public GraphDefinition copy() {
        GraphDefinition dst = new GraphDefinition();
        this.copyValues(dst);
        dst.url = this.url == null ? null : this.url.copy();
        dst.version = this.version == null ? null : this.version.copy();
        dst.name = this.name == null ? null : this.name.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.experimental = this.experimental == null ? null : this.experimental.copy();
        dst.date = this.date == null ? null : this.date.copy();
        StringType stringType = dst.publisher = this.publisher == null ? null : this.publisher.copy();
        if (this.contact != null) {
            dst.contact = new ArrayList();
            for (ContactDetail contactDetail : this.contact) {
                dst.contact.add(contactDetail.copy());
            }
        }
        MarkdownType markdownType = dst.description = this.description == null ? null : this.description.copy();
        if (this.useContext != null) {
            dst.useContext = new ArrayList();
            for (UsageContext usageContext : this.useContext) {
                dst.useContext.add(usageContext.copy());
            }
        }
        if (this.jurisdiction != null) {
            dst.jurisdiction = new ArrayList();
            for (CodeableConcept codeableConcept : this.jurisdiction) {
                dst.jurisdiction.add(codeableConcept.copy());
            }
        }
        dst.purpose = this.purpose == null ? null : this.purpose.copy();
        dst.start = this.start == null ? null : this.start.copy();
        UriType uriType = dst.profile = this.profile == null ? null : this.profile.copy();
        if (this.link != null) {
            dst.link = new ArrayList<GraphDefinitionLinkComponent>();
            for (GraphDefinitionLinkComponent graphDefinitionLinkComponent : this.link) {
                dst.link.add(graphDefinitionLinkComponent.copy());
            }
        }
        return dst;
    }

    protected GraphDefinition typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof GraphDefinition)) {
            return false;
        }
        GraphDefinition o = (GraphDefinition)other_;
        return GraphDefinition.compareDeep(this.purpose, o.purpose, true) && GraphDefinition.compareDeep(this.start, o.start, true) && GraphDefinition.compareDeep(this.profile, o.profile, true) && GraphDefinition.compareDeep(this.link, o.link, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof GraphDefinition)) {
            return false;
        }
        GraphDefinition o = (GraphDefinition)other_;
        return GraphDefinition.compareValues(this.purpose, o.purpose, true) && GraphDefinition.compareValues(this.start, o.start, true) && GraphDefinition.compareValues(this.profile, o.profile, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.purpose, this.start, this.profile, this.link);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.GraphDefinition;
    }

    @Block
    public static class GraphDefinitionLinkTargetCompartmentComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Identifies the compartment", formalDefinition="Identifies the compartment.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/compartment-type")
        protected Enumeration<CompartmentCode> code;
        @Child(name="rule", type={CodeType.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="identical | matching | different | custom", formalDefinition="identical | matching | different | no-rule | custom.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/graph-compartment-rule")
        protected Enumeration<GraphCompartmentRule> rule;
        @Child(name="expression", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Custom rule, as a FHIRPath expression", formalDefinition="Custom rule, as a FHIRPath expression.")
        protected StringType expression;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Documentation for FHIRPath expression", formalDefinition="Documentation for FHIRPath expression.")
        protected StringType description;
        private static final long serialVersionUID = -1046660576L;

        public GraphDefinitionLinkTargetCompartmentComponent() {
        }

        public GraphDefinitionLinkTargetCompartmentComponent(Enumeration<CompartmentCode> code, Enumeration<GraphCompartmentRule> rule) {
            this.code = code;
            this.rule = rule;
        }

        public Enumeration<CompartmentCode> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkTargetCompartmentComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<CompartmentCode>(new CompartmentCodeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public GraphDefinitionLinkTargetCompartmentComponent setCodeElement(Enumeration<CompartmentCode> value) {
            this.code = value;
            return this;
        }

        public CompartmentCode getCode() {
            return this.code == null ? null : (CompartmentCode)((Object)this.code.getValue());
        }

        public GraphDefinitionLinkTargetCompartmentComponent setCode(CompartmentCode value) {
            if (this.code == null) {
                this.code = new Enumeration<CompartmentCode>(new CompartmentCodeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public Enumeration<GraphCompartmentRule> getRuleElement() {
            if (this.rule == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkTargetCompartmentComponent.rule");
                }
                if (Configuration.doAutoCreate()) {
                    this.rule = new Enumeration<GraphCompartmentRule>(new GraphCompartmentRuleEnumFactory());
                }
            }
            return this.rule;
        }

        public boolean hasRuleElement() {
            return this.rule != null && !this.rule.isEmpty();
        }

        public boolean hasRule() {
            return this.rule != null && !this.rule.isEmpty();
        }

        public GraphDefinitionLinkTargetCompartmentComponent setRuleElement(Enumeration<GraphCompartmentRule> value) {
            this.rule = value;
            return this;
        }

        public GraphCompartmentRule getRule() {
            return this.rule == null ? null : (GraphCompartmentRule)((Object)this.rule.getValue());
        }

        public GraphDefinitionLinkTargetCompartmentComponent setRule(GraphCompartmentRule value) {
            if (this.rule == null) {
                this.rule = new Enumeration<GraphCompartmentRule>(new GraphCompartmentRuleEnumFactory());
            }
            this.rule.setValue((Object)value);
            return this;
        }

        public StringType getExpressionElement() {
            if (this.expression == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkTargetCompartmentComponent.expression");
                }
                if (Configuration.doAutoCreate()) {
                    this.expression = new StringType();
                }
            }
            return this.expression;
        }

        public boolean hasExpressionElement() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public boolean hasExpression() {
            return this.expression != null && !this.expression.isEmpty();
        }

        public GraphDefinitionLinkTargetCompartmentComponent setExpressionElement(StringType value) {
            this.expression = value;
            return this;
        }

        public String getExpression() {
            return this.expression == null ? null : (String)this.expression.getValue();
        }

        public GraphDefinitionLinkTargetCompartmentComponent setExpression(String value) {
            if (Utilities.noString(value)) {
                this.expression = null;
            } else {
                if (this.expression == null) {
                    this.expression = new StringType();
                }
                this.expression.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkTargetCompartmentComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public GraphDefinitionLinkTargetCompartmentComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public GraphDefinitionLinkTargetCompartmentComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "code", "Identifies the compartment.", 0, 1, this.code));
            children.add(new Property("rule", "code", "identical | matching | different | no-rule | custom.", 0, 1, this.rule));
            children.add(new Property("expression", "string", "Custom rule, as a FHIRPath expression.", 0, 1, this.expression));
            children.add(new Property(GraphDefinition.SP_DESCRIPTION, "string", "Documentation for FHIRPath expression.", 0, 1, this.description));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "code", "Identifies the compartment.", 0, 1, this.code);
                }
                case 3512060: {
                    return new Property("rule", "code", "identical | matching | different | no-rule | custom.", 0, 1, this.rule);
                }
                case -1795452264: {
                    return new Property("expression", "string", "Custom rule, as a FHIRPath expression.", 0, 1, this.expression);
                }
                case -1724546052: {
                    return new Property(GraphDefinition.SP_DESCRIPTION, "string", "Documentation for FHIRPath expression.", 0, 1, this.description);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case 3512060: {
                    Base[] baseArray;
                    if (this.rule == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.rule;
                    }
                    return baseArray;
                }
                case -1795452264: {
                    Base[] baseArray;
                    if (this.expression == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.expression;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    value = new CompartmentCodeEnumFactory().fromType(this.castToCode(value));
                    this.code = value;
                    return value;
                }
                case 3512060: {
                    value = new GraphCompartmentRuleEnumFactory().fromType(this.castToCode(value));
                    this.rule = value;
                    return value;
                }
                case -1795452264: {
                    this.expression = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                value = new CompartmentCodeEnumFactory().fromType(this.castToCode(value));
                this.code = value;
            } else if (name.equals("rule")) {
                value = new GraphCompartmentRuleEnumFactory().fromType(this.castToCode(value));
                this.rule = value;
            } else if (name.equals("expression")) {
                this.expression = this.castToString(value);
            } else if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCodeElement();
                }
                case 3512060: {
                    return this.getRuleElement();
                }
                case -1795452264: {
                    return this.getExpressionElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"code"};
                }
                case 3512060: {
                    return new String[]{"code"};
                }
                case -1795452264: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.code");
            }
            if (name.equals("rule")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.rule");
            }
            if (name.equals("expression")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.expression");
            }
            if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.description");
            }
            return super.addChild(name);
        }

        @Override
        public GraphDefinitionLinkTargetCompartmentComponent copy() {
            GraphDefinitionLinkTargetCompartmentComponent dst = new GraphDefinitionLinkTargetCompartmentComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.rule = this.rule == null ? null : this.rule.copy();
            dst.expression = this.expression == null ? null : this.expression.copy();
            dst.description = this.description == null ? null : this.description.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkTargetCompartmentComponent)) {
                return false;
            }
            GraphDefinitionLinkTargetCompartmentComponent o = (GraphDefinitionLinkTargetCompartmentComponent)other_;
            return GraphDefinitionLinkTargetCompartmentComponent.compareDeep(this.code, o.code, true) && GraphDefinitionLinkTargetCompartmentComponent.compareDeep(this.rule, o.rule, true) && GraphDefinitionLinkTargetCompartmentComponent.compareDeep(this.expression, o.expression, true) && GraphDefinitionLinkTargetCompartmentComponent.compareDeep(this.description, o.description, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkTargetCompartmentComponent)) {
                return false;
            }
            GraphDefinitionLinkTargetCompartmentComponent o = (GraphDefinitionLinkTargetCompartmentComponent)other_;
            return GraphDefinitionLinkTargetCompartmentComponent.compareValues(this.code, o.code, true) && GraphDefinitionLinkTargetCompartmentComponent.compareValues(this.rule, o.rule, true) && GraphDefinitionLinkTargetCompartmentComponent.compareValues(this.expression, o.expression, true) && GraphDefinitionLinkTargetCompartmentComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.code, this.rule, this.expression, this.description);
        }

        @Override
        public String fhirType() {
            return "GraphDefinition.link.target.compartment";
        }
    }

    @Block
    public static class GraphDefinitionLinkTargetComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Type of resource this link refers to", formalDefinition="Type of resource this link refers to.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/resource-types")
        protected CodeType type;
        @Child(name="profile", type={UriType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Profile for the target resource", formalDefinition="Profile for the target resource.")
        protected UriType profile;
        @Child(name="compartment", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Compartment Consistency Rules", formalDefinition="Compartment Consistency Rules.")
        protected List<GraphDefinitionLinkTargetCompartmentComponent> compartment;
        @Child(name="link", type={GraphDefinitionLinkComponent.class}, order=4, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Additional links from target resource", formalDefinition="Additional links from target resource.")
        protected List<GraphDefinitionLinkComponent> link;
        private static final long serialVersionUID = -1862411341L;

        public GraphDefinitionLinkTargetComponent() {
        }

        public GraphDefinitionLinkTargetComponent(CodeType type) {
            this.type = type;
        }

        public CodeType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkTargetComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public GraphDefinitionLinkTargetComponent setTypeElement(CodeType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public GraphDefinitionLinkTargetComponent setType(String value) {
            if (this.type == null) {
                this.type = new CodeType();
            }
            this.type.setValue(value);
            return this;
        }

        public UriType getProfileElement() {
            if (this.profile == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkTargetComponent.profile");
                }
                if (Configuration.doAutoCreate()) {
                    this.profile = new UriType();
                }
            }
            return this.profile;
        }

        public boolean hasProfileElement() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public boolean hasProfile() {
            return this.profile != null && !this.profile.isEmpty();
        }

        public GraphDefinitionLinkTargetComponent setProfileElement(UriType value) {
            this.profile = value;
            return this;
        }

        public String getProfile() {
            return this.profile == null ? null : (String)this.profile.getValue();
        }

        public GraphDefinitionLinkTargetComponent setProfile(String value) {
            if (Utilities.noString(value)) {
                this.profile = null;
            } else {
                if (this.profile == null) {
                    this.profile = new UriType();
                }
                this.profile.setValue(value);
            }
            return this;
        }

        public List<GraphDefinitionLinkTargetCompartmentComponent> getCompartment() {
            if (this.compartment == null) {
                this.compartment = new ArrayList<GraphDefinitionLinkTargetCompartmentComponent>();
            }
            return this.compartment;
        }

        public GraphDefinitionLinkTargetComponent setCompartment(List<GraphDefinitionLinkTargetCompartmentComponent> theCompartment) {
            this.compartment = theCompartment;
            return this;
        }

        public boolean hasCompartment() {
            if (this.compartment == null) {
                return false;
            }
            for (GraphDefinitionLinkTargetCompartmentComponent item : this.compartment) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GraphDefinitionLinkTargetCompartmentComponent addCompartment() {
            GraphDefinitionLinkTargetCompartmentComponent t = new GraphDefinitionLinkTargetCompartmentComponent();
            if (this.compartment == null) {
                this.compartment = new ArrayList<GraphDefinitionLinkTargetCompartmentComponent>();
            }
            this.compartment.add(t);
            return t;
        }

        public GraphDefinitionLinkTargetComponent addCompartment(GraphDefinitionLinkTargetCompartmentComponent t) {
            if (t == null) {
                return this;
            }
            if (this.compartment == null) {
                this.compartment = new ArrayList<GraphDefinitionLinkTargetCompartmentComponent>();
            }
            this.compartment.add(t);
            return this;
        }

        public GraphDefinitionLinkTargetCompartmentComponent getCompartmentFirstRep() {
            if (this.getCompartment().isEmpty()) {
                this.addCompartment();
            }
            return this.getCompartment().get(0);
        }

        public List<GraphDefinitionLinkComponent> getLink() {
            if (this.link == null) {
                this.link = new ArrayList<GraphDefinitionLinkComponent>();
            }
            return this.link;
        }

        public GraphDefinitionLinkTargetComponent setLink(List<GraphDefinitionLinkComponent> theLink) {
            this.link = theLink;
            return this;
        }

        public boolean hasLink() {
            if (this.link == null) {
                return false;
            }
            for (GraphDefinitionLinkComponent item : this.link) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GraphDefinitionLinkComponent addLink() {
            GraphDefinitionLinkComponent t = new GraphDefinitionLinkComponent();
            if (this.link == null) {
                this.link = new ArrayList<GraphDefinitionLinkComponent>();
            }
            this.link.add(t);
            return t;
        }

        public GraphDefinitionLinkTargetComponent addLink(GraphDefinitionLinkComponent t) {
            if (t == null) {
                return this;
            }
            if (this.link == null) {
                this.link = new ArrayList<GraphDefinitionLinkComponent>();
            }
            this.link.add(t);
            return this;
        }

        public GraphDefinitionLinkComponent getLinkFirstRep() {
            if (this.getLink().isEmpty()) {
                this.addLink();
            }
            return this.getLink().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("type", "code", "Type of resource this link refers to.", 0, 1, this.type));
            children.add(new Property("profile", "uri", "Profile for the target resource.", 0, 1, this.profile));
            children.add(new Property("compartment", "", "Compartment Consistency Rules.", 0, Integer.MAX_VALUE, this.compartment));
            children.add(new Property("link", "@GraphDefinition.link", "Additional links from target resource.", 0, Integer.MAX_VALUE, this.link));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property("type", "code", "Type of resource this link refers to.", 0, 1, this.type);
                }
                case -309425751: {
                    return new Property("profile", "uri", "Profile for the target resource.", 0, 1, this.profile);
                }
                case -397756334: {
                    return new Property("compartment", "", "Compartment Consistency Rules.", 0, Integer.MAX_VALUE, this.compartment);
                }
                case 3321850: {
                    return new Property("link", "@GraphDefinition.link", "Additional links from target resource.", 0, Integer.MAX_VALUE, this.link);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.type;
                    }
                    return baseArray;
                }
                case -309425751: {
                    Base[] baseArray;
                    if (this.profile == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.profile;
                    }
                    return baseArray;
                }
                case -397756334: {
                    return this.compartment == null ? new Base[]{} : this.compartment.toArray(new Base[this.compartment.size()]);
                }
                case 3321850: {
                    return this.link == null ? new Base[]{} : this.link.toArray(new Base[this.link.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.type = this.castToCode(value);
                    return value;
                }
                case -309425751: {
                    this.profile = this.castToUri(value);
                    return value;
                }
                case -397756334: {
                    this.getCompartment().add((GraphDefinitionLinkTargetCompartmentComponent)value);
                    return value;
                }
                case 3321850: {
                    this.getLink().add((GraphDefinitionLinkComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCode(value);
            } else if (name.equals("profile")) {
                this.profile = this.castToUri(value);
            } else if (name.equals("compartment")) {
                this.getCompartment().add((GraphDefinitionLinkTargetCompartmentComponent)value);
            } else if (name.equals("link")) {
                this.getLink().add((GraphDefinitionLinkComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.getTypeElement();
                }
                case -309425751: {
                    return this.getProfileElement();
                }
                case -397756334: {
                    return this.addCompartment();
                }
                case 3321850: {
                    return this.addLink();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"code"};
                }
                case -309425751: {
                    return new String[]{"uri"};
                }
                case -397756334: {
                    return new String[0];
                }
                case 3321850: {
                    return new String[]{"@GraphDefinition.link"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.type");
            }
            if (name.equals("profile")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.profile");
            }
            if (name.equals("compartment")) {
                return this.addCompartment();
            }
            if (name.equals("link")) {
                return this.addLink();
            }
            return super.addChild(name);
        }

        @Override
        public GraphDefinitionLinkTargetComponent copy() {
            GraphDefinitionLinkTargetComponent dst = new GraphDefinitionLinkTargetComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            UriType uriType = dst.profile = this.profile == null ? null : this.profile.copy();
            if (this.compartment != null) {
                dst.compartment = new ArrayList<GraphDefinitionLinkTargetCompartmentComponent>();
                for (GraphDefinitionLinkTargetCompartmentComponent graphDefinitionLinkTargetCompartmentComponent : this.compartment) {
                    dst.compartment.add(graphDefinitionLinkTargetCompartmentComponent.copy());
                }
            }
            if (this.link != null) {
                dst.link = new ArrayList<GraphDefinitionLinkComponent>();
                for (GraphDefinitionLinkComponent graphDefinitionLinkComponent : this.link) {
                    dst.link.add(graphDefinitionLinkComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkTargetComponent)) {
                return false;
            }
            GraphDefinitionLinkTargetComponent o = (GraphDefinitionLinkTargetComponent)other_;
            return GraphDefinitionLinkTargetComponent.compareDeep(this.type, o.type, true) && GraphDefinitionLinkTargetComponent.compareDeep(this.profile, o.profile, true) && GraphDefinitionLinkTargetComponent.compareDeep(this.compartment, o.compartment, true) && GraphDefinitionLinkTargetComponent.compareDeep(this.link, o.link, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkTargetComponent)) {
                return false;
            }
            GraphDefinitionLinkTargetComponent o = (GraphDefinitionLinkTargetComponent)other_;
            return GraphDefinitionLinkTargetComponent.compareValues(this.type, o.type, true) && GraphDefinitionLinkTargetComponent.compareValues(this.profile, o.profile, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.profile, this.compartment, this.link);
        }

        @Override
        public String fhirType() {
            return "GraphDefinition.link.target";
        }
    }

    @Block
    public static class GraphDefinitionLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="path", type={StringType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Path in the resource that contains the link", formalDefinition="Path in the resource that contains the link.")
        protected StringType path;
        @Child(name="sliceName", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Which slice (if profiled)", formalDefinition="Which slice (if profiled).")
        protected StringType sliceName;
        @Child(name="min", type={IntegerType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Minimum occurrences for this link", formalDefinition="Minimum occurrences for this link.")
        protected IntegerType min;
        @Child(name="max", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Maximum occurrences for this link", formalDefinition="Maximum occurrences for this link.")
        protected StringType max;
        @Child(name="description", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Why this link is specified", formalDefinition="Information about why this link is of interest in this graph definition.")
        protected StringType description;
        @Child(name="target", type={}, order=6, min=1, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Potential target for the link", formalDefinition="Potential target for the link.")
        protected List<GraphDefinitionLinkTargetComponent> target;
        private static final long serialVersionUID = -593733346L;

        public GraphDefinitionLinkComponent() {
        }

        public GraphDefinitionLinkComponent(StringType path) {
            this.path = path;
        }

        public StringType getPathElement() {
            if (this.path == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.path");
                }
                if (Configuration.doAutoCreate()) {
                    this.path = new StringType();
                }
            }
            return this.path;
        }

        public boolean hasPathElement() {
            return this.path != null && !this.path.isEmpty();
        }

        public boolean hasPath() {
            return this.path != null && !this.path.isEmpty();
        }

        public GraphDefinitionLinkComponent setPathElement(StringType value) {
            this.path = value;
            return this;
        }

        public String getPath() {
            return this.path == null ? null : (String)this.path.getValue();
        }

        public GraphDefinitionLinkComponent setPath(String value) {
            if (this.path == null) {
                this.path = new StringType();
            }
            this.path.setValue(value);
            return this;
        }

        public StringType getSliceNameElement() {
            if (this.sliceName == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.sliceName");
                }
                if (Configuration.doAutoCreate()) {
                    this.sliceName = new StringType();
                }
            }
            return this.sliceName;
        }

        public boolean hasSliceNameElement() {
            return this.sliceName != null && !this.sliceName.isEmpty();
        }

        public boolean hasSliceName() {
            return this.sliceName != null && !this.sliceName.isEmpty();
        }

        public GraphDefinitionLinkComponent setSliceNameElement(StringType value) {
            this.sliceName = value;
            return this;
        }

        public String getSliceName() {
            return this.sliceName == null ? null : (String)this.sliceName.getValue();
        }

        public GraphDefinitionLinkComponent setSliceName(String value) {
            if (Utilities.noString(value)) {
                this.sliceName = null;
            } else {
                if (this.sliceName == null) {
                    this.sliceName = new StringType();
                }
                this.sliceName.setValue(value);
            }
            return this;
        }

        public IntegerType getMinElement() {
            if (this.min == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.min");
                }
                if (Configuration.doAutoCreate()) {
                    this.min = new IntegerType();
                }
            }
            return this.min;
        }

        public boolean hasMinElement() {
            return this.min != null && !this.min.isEmpty();
        }

        public boolean hasMin() {
            return this.min != null && !this.min.isEmpty();
        }

        public GraphDefinitionLinkComponent setMinElement(IntegerType value) {
            this.min = value;
            return this;
        }

        public int getMin() {
            return this.min == null || this.min.isEmpty() ? 0 : (Integer)this.min.getValue();
        }

        public GraphDefinitionLinkComponent setMin(int value) {
            if (this.min == null) {
                this.min = new IntegerType();
            }
            this.min.setValue((Object)value);
            return this;
        }

        public StringType getMaxElement() {
            if (this.max == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.max");
                }
                if (Configuration.doAutoCreate()) {
                    this.max = new StringType();
                }
            }
            return this.max;
        }

        public boolean hasMaxElement() {
            return this.max != null && !this.max.isEmpty();
        }

        public boolean hasMax() {
            return this.max != null && !this.max.isEmpty();
        }

        public GraphDefinitionLinkComponent setMaxElement(StringType value) {
            this.max = value;
            return this;
        }

        public String getMax() {
            return this.max == null ? null : (String)this.max.getValue();
        }

        public GraphDefinitionLinkComponent setMax(String value) {
            if (Utilities.noString(value)) {
                this.max = null;
            } else {
                if (this.max == null) {
                    this.max = new StringType();
                }
                this.max.setValue(value);
            }
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GraphDefinitionLinkComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public GraphDefinitionLinkComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public GraphDefinitionLinkComponent setDescription(String value) {
            if (Utilities.noString(value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public List<GraphDefinitionLinkTargetComponent> getTarget() {
            if (this.target == null) {
                this.target = new ArrayList<GraphDefinitionLinkTargetComponent>();
            }
            return this.target;
        }

        public GraphDefinitionLinkComponent setTarget(List<GraphDefinitionLinkTargetComponent> theTarget) {
            this.target = theTarget;
            return this;
        }

        public boolean hasTarget() {
            if (this.target == null) {
                return false;
            }
            for (GraphDefinitionLinkTargetComponent item : this.target) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GraphDefinitionLinkTargetComponent addTarget() {
            GraphDefinitionLinkTargetComponent t = new GraphDefinitionLinkTargetComponent();
            if (this.target == null) {
                this.target = new ArrayList<GraphDefinitionLinkTargetComponent>();
            }
            this.target.add(t);
            return t;
        }

        public GraphDefinitionLinkComponent addTarget(GraphDefinitionLinkTargetComponent t) {
            if (t == null) {
                return this;
            }
            if (this.target == null) {
                this.target = new ArrayList<GraphDefinitionLinkTargetComponent>();
            }
            this.target.add(t);
            return this;
        }

        public GraphDefinitionLinkTargetComponent getTargetFirstRep() {
            if (this.getTarget().isEmpty()) {
                this.addTarget();
            }
            return this.getTarget().get(0);
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("path", "string", "Path in the resource that contains the link.", 0, 1, this.path));
            children.add(new Property("sliceName", "string", "Which slice (if profiled).", 0, 1, this.sliceName));
            children.add(new Property("min", "integer", "Minimum occurrences for this link.", 0, 1, this.min));
            children.add(new Property("max", "string", "Maximum occurrences for this link.", 0, 1, this.max));
            children.add(new Property(GraphDefinition.SP_DESCRIPTION, "string", "Information about why this link is of interest in this graph definition.", 0, 1, this.description));
            children.add(new Property("target", "", "Potential target for the link.", 0, Integer.MAX_VALUE, this.target));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3433509: {
                    return new Property("path", "string", "Path in the resource that contains the link.", 0, 1, this.path);
                }
                case -825289923: {
                    return new Property("sliceName", "string", "Which slice (if profiled).", 0, 1, this.sliceName);
                }
                case 108114: {
                    return new Property("min", "integer", "Minimum occurrences for this link.", 0, 1, this.min);
                }
                case 107876: {
                    return new Property("max", "string", "Maximum occurrences for this link.", 0, 1, this.max);
                }
                case -1724546052: {
                    return new Property(GraphDefinition.SP_DESCRIPTION, "string", "Information about why this link is of interest in this graph definition.", 0, 1, this.description);
                }
                case -880905839: {
                    return new Property("target", "", "Potential target for the link.", 0, Integer.MAX_VALUE, this.target);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    Base[] baseArray;
                    if (this.path == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.path;
                    }
                    return baseArray;
                }
                case -825289923: {
                    Base[] baseArray;
                    if (this.sliceName == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.sliceName;
                    }
                    return baseArray;
                }
                case 108114: {
                    Base[] baseArray;
                    if (this.min == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.min;
                    }
                    return baseArray;
                }
                case 107876: {
                    Base[] baseArray;
                    if (this.max == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.max;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.description;
                    }
                    return baseArray;
                }
                case -880905839: {
                    return this.target == null ? new Base[]{} : this.target.toArray(new Base[this.target.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    this.path = this.castToString(value);
                    return value;
                }
                case -825289923: {
                    this.sliceName = this.castToString(value);
                    return value;
                }
                case 108114: {
                    this.min = this.castToInteger(value);
                    return value;
                }
                case 107876: {
                    this.max = this.castToString(value);
                    return value;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    return value;
                }
                case -880905839: {
                    this.getTarget().add((GraphDefinitionLinkTargetComponent)value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("path")) {
                this.path = this.castToString(value);
            } else if (name.equals("sliceName")) {
                this.sliceName = this.castToString(value);
            } else if (name.equals("min")) {
                this.min = this.castToInteger(value);
            } else if (name.equals("max")) {
                this.max = this.castToString(value);
            } else if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                this.description = this.castToString(value);
            } else if (name.equals("target")) {
                this.getTarget().add((GraphDefinitionLinkTargetComponent)value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return this.getPathElement();
                }
                case -825289923: {
                    return this.getSliceNameElement();
                }
                case 108114: {
                    return this.getMinElement();
                }
                case 107876: {
                    return this.getMaxElement();
                }
                case -1724546052: {
                    return this.getDescriptionElement();
                }
                case -880905839: {
                    return this.addTarget();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3433509: {
                    return new String[]{"string"};
                }
                case -825289923: {
                    return new String[]{"string"};
                }
                case 108114: {
                    return new String[]{"integer"};
                }
                case 107876: {
                    return new String[]{"string"};
                }
                case -1724546052: {
                    return new String[]{"string"};
                }
                case -880905839: {
                    return new String[0];
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("path")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.path");
            }
            if (name.equals("sliceName")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.sliceName");
            }
            if (name.equals("min")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.min");
            }
            if (name.equals("max")) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.max");
            }
            if (name.equals(GraphDefinition.SP_DESCRIPTION)) {
                throw new FHIRException("Cannot call addChild on a primitive type GraphDefinition.description");
            }
            if (name.equals("target")) {
                return this.addTarget();
            }
            return super.addChild(name);
        }

        @Override
        public GraphDefinitionLinkComponent copy() {
            GraphDefinitionLinkComponent dst = new GraphDefinitionLinkComponent();
            this.copyValues(dst);
            dst.path = this.path == null ? null : this.path.copy();
            dst.sliceName = this.sliceName == null ? null : this.sliceName.copy();
            dst.min = this.min == null ? null : this.min.copy();
            dst.max = this.max == null ? null : this.max.copy();
            StringType stringType = dst.description = this.description == null ? null : this.description.copy();
            if (this.target != null) {
                dst.target = new ArrayList<GraphDefinitionLinkTargetComponent>();
                for (GraphDefinitionLinkTargetComponent i2 : this.target) {
                    dst.target.add(i2.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkComponent)) {
                return false;
            }
            GraphDefinitionLinkComponent o = (GraphDefinitionLinkComponent)other_;
            return GraphDefinitionLinkComponent.compareDeep(this.path, o.path, true) && GraphDefinitionLinkComponent.compareDeep(this.sliceName, o.sliceName, true) && GraphDefinitionLinkComponent.compareDeep(this.min, o.min, true) && GraphDefinitionLinkComponent.compareDeep(this.max, o.max, true) && GraphDefinitionLinkComponent.compareDeep(this.description, o.description, true) && GraphDefinitionLinkComponent.compareDeep(this.target, o.target, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof GraphDefinitionLinkComponent)) {
                return false;
            }
            GraphDefinitionLinkComponent o = (GraphDefinitionLinkComponent)other_;
            return GraphDefinitionLinkComponent.compareValues(this.path, o.path, true) && GraphDefinitionLinkComponent.compareValues(this.sliceName, o.sliceName, true) && GraphDefinitionLinkComponent.compareValues(this.min, o.min, true) && GraphDefinitionLinkComponent.compareValues(this.max, o.max, true) && GraphDefinitionLinkComponent.compareValues(this.description, o.description, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.path, this.sliceName, this.min, this.max, this.description, this.target);
        }

        @Override
        public String fhirType() {
            return "GraphDefinition.link";
        }
    }

    public static class GraphCompartmentRuleEnumFactory
    implements EnumFactory<GraphCompartmentRule> {
        @Override
        public GraphCompartmentRule fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("identical".equals(codeString)) {
                return GraphCompartmentRule.IDENTICAL;
            }
            if ("matching".equals(codeString)) {
                return GraphCompartmentRule.MATCHING;
            }
            if ("different".equals(codeString)) {
                return GraphCompartmentRule.DIFFERENT;
            }
            if ("custom".equals(codeString)) {
                return GraphCompartmentRule.CUSTOM;
            }
            throw new IllegalArgumentException("Unknown GraphCompartmentRule code '" + codeString + "'");
        }

        public Enumeration<GraphCompartmentRule> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<GraphCompartmentRule>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("identical".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.IDENTICAL);
            }
            if ("matching".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.MATCHING);
            }
            if ("different".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.DIFFERENT);
            }
            if ("custom".equals(codeString)) {
                return new Enumeration<GraphCompartmentRule>(this, GraphCompartmentRule.CUSTOM);
            }
            throw new FHIRException("Unknown GraphCompartmentRule code '" + codeString + "'");
        }

        @Override
        public String toCode(GraphCompartmentRule code) {
            if (code == GraphCompartmentRule.IDENTICAL) {
                return "identical";
            }
            if (code == GraphCompartmentRule.MATCHING) {
                return "matching";
            }
            if (code == GraphCompartmentRule.DIFFERENT) {
                return "different";
            }
            if (code == GraphCompartmentRule.CUSTOM) {
                return "custom";
            }
            return "?";
        }

        @Override
        public String toSystem(GraphCompartmentRule code) {
            return code.getSystem();
        }
    }

    public static enum GraphCompartmentRule {
        IDENTICAL,
        MATCHING,
        DIFFERENT,
        CUSTOM,
        NULL;


        public static GraphCompartmentRule fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("identical".equals(codeString)) {
                return IDENTICAL;
            }
            if ("matching".equals(codeString)) {
                return MATCHING;
            }
            if ("different".equals(codeString)) {
                return DIFFERENT;
            }
            if ("custom".equals(codeString)) {
                return CUSTOM;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown GraphCompartmentRule code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case IDENTICAL: {
                    return "identical";
                }
                case MATCHING: {
                    return "matching";
                }
                case DIFFERENT: {
                    return "different";
                }
                case CUSTOM: {
                    return "custom";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case IDENTICAL: {
                    return "http://hl7.org/fhir/graph-compartment-rule";
                }
                case MATCHING: {
                    return "http://hl7.org/fhir/graph-compartment-rule";
                }
                case DIFFERENT: {
                    return "http://hl7.org/fhir/graph-compartment-rule";
                }
                case CUSTOM: {
                    return "http://hl7.org/fhir/graph-compartment-rule";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case IDENTICAL: {
                    return "The compartment must be identical (the same literal reference)";
                }
                case MATCHING: {
                    return "The compartment must be the same - the record must be about the same patient, but the reference may be different";
                }
                case DIFFERENT: {
                    return "The compartment must be different";
                }
                case CUSTOM: {
                    return "The compartment rule is defined in the accompanying FHIRPath expression";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case IDENTICAL: {
                    return "Identical";
                }
                case MATCHING: {
                    return "Matching";
                }
                case DIFFERENT: {
                    return "Different";
                }
                case CUSTOM: {
                    return "Custom";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class CompartmentCodeEnumFactory
    implements EnumFactory<CompartmentCode> {
        @Override
        public CompartmentCode fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("Patient".equals(codeString)) {
                return CompartmentCode.PATIENT;
            }
            if ("Encounter".equals(codeString)) {
                return CompartmentCode.ENCOUNTER;
            }
            if ("RelatedPerson".equals(codeString)) {
                return CompartmentCode.RELATEDPERSON;
            }
            if ("Practitioner".equals(codeString)) {
                return CompartmentCode.PRACTITIONER;
            }
            if ("Device".equals(codeString)) {
                return CompartmentCode.DEVICE;
            }
            throw new IllegalArgumentException("Unknown CompartmentCode code '" + codeString + "'");
        }

        public Enumeration<CompartmentCode> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<CompartmentCode>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Patient".equals(codeString)) {
                return new Enumeration<CompartmentCode>(this, CompartmentCode.PATIENT);
            }
            if ("Encounter".equals(codeString)) {
                return new Enumeration<CompartmentCode>(this, CompartmentCode.ENCOUNTER);
            }
            if ("RelatedPerson".equals(codeString)) {
                return new Enumeration<CompartmentCode>(this, CompartmentCode.RELATEDPERSON);
            }
            if ("Practitioner".equals(codeString)) {
                return new Enumeration<CompartmentCode>(this, CompartmentCode.PRACTITIONER);
            }
            if ("Device".equals(codeString)) {
                return new Enumeration<CompartmentCode>(this, CompartmentCode.DEVICE);
            }
            throw new FHIRException("Unknown CompartmentCode code '" + codeString + "'");
        }

        @Override
        public String toCode(CompartmentCode code) {
            if (code == CompartmentCode.PATIENT) {
                return "Patient";
            }
            if (code == CompartmentCode.ENCOUNTER) {
                return "Encounter";
            }
            if (code == CompartmentCode.RELATEDPERSON) {
                return "RelatedPerson";
            }
            if (code == CompartmentCode.PRACTITIONER) {
                return "Practitioner";
            }
            if (code == CompartmentCode.DEVICE) {
                return "Device";
            }
            return "?";
        }

        @Override
        public String toSystem(CompartmentCode code) {
            return code.getSystem();
        }
    }

    public static enum CompartmentCode {
        PATIENT,
        ENCOUNTER,
        RELATEDPERSON,
        PRACTITIONER,
        DEVICE,
        NULL;


        public static CompartmentCode fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("Patient".equals(codeString)) {
                return PATIENT;
            }
            if ("Encounter".equals(codeString)) {
                return ENCOUNTER;
            }
            if ("RelatedPerson".equals(codeString)) {
                return RELATEDPERSON;
            }
            if ("Practitioner".equals(codeString)) {
                return PRACTITIONER;
            }
            if ("Device".equals(codeString)) {
                return DEVICE;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown CompartmentCode code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PATIENT: {
                    return "Patient";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case DEVICE: {
                    return "Device";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PATIENT: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case ENCOUNTER: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case RELATEDPERSON: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case PRACTITIONER: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case DEVICE: {
                    return "http://hl7.org/fhir/compartment-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PATIENT: {
                    return "The compartment definition is for the patient compartment";
                }
                case ENCOUNTER: {
                    return "The compartment definition is for the encounter compartment";
                }
                case RELATEDPERSON: {
                    return "The compartment definition is for the related-person compartment";
                }
                case PRACTITIONER: {
                    return "The compartment definition is for the practitioner compartment";
                }
                case DEVICE: {
                    return "The compartment definition is for the device compartment";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PATIENT: {
                    return "Patient";
                }
                case ENCOUNTER: {
                    return "Encounter";
                }
                case RELATEDPERSON: {
                    return "RelatedPerson";
                }
                case PRACTITIONER: {
                    return "Practitioner";
                }
                case DEVICE: {
                    return "Device";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

