/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.model.Account;
import org.hl7.fhir.dstu3.model.Appointment;
import org.hl7.fhir.dstu3.model.BackboneElement;
import org.hl7.fhir.dstu3.model.Base;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Coding;
import org.hl7.fhir.dstu3.model.Condition;
import org.hl7.fhir.dstu3.model.Configuration;
import org.hl7.fhir.dstu3.model.DomainResource;
import org.hl7.fhir.dstu3.model.Duration;
import org.hl7.fhir.dstu3.model.EnumFactory;
import org.hl7.fhir.dstu3.model.Enumeration;
import org.hl7.fhir.dstu3.model.EpisodeOfCare;
import org.hl7.fhir.dstu3.model.Group;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Location;
import org.hl7.fhir.dstu3.model.Organization;
import org.hl7.fhir.dstu3.model.Patient;
import org.hl7.fhir.dstu3.model.Period;
import org.hl7.fhir.dstu3.model.PositiveIntType;
import org.hl7.fhir.dstu3.model.Practitioner;
import org.hl7.fhir.dstu3.model.PrimitiveType;
import org.hl7.fhir.dstu3.model.Procedure;
import org.hl7.fhir.dstu3.model.Property;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.dstu3.model.ReferralRequest;
import org.hl7.fhir.dstu3.model.RelatedPerson;
import org.hl7.fhir.dstu3.model.Resource;
import org.hl7.fhir.dstu3.model.ResourceType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Encounter", profile="http://hl7.org/fhir/Profile/Encounter")
public class Encounter
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Identifier(s) by which this encounter is known", formalDefinition="Identifier(s) by which this encounter is known.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="planned | arrived | triaged | in-progress | onleave | finished | cancelled +", formalDefinition="planned | arrived | triaged | in-progress | onleave | finished | cancelled +.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-status")
    protected Enumeration<EncounterStatus> status;
    @Child(name="statusHistory", type={}, order=2, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of past encounter statuses", formalDefinition="The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.")
    protected List<StatusHistoryComponent> statusHistory;
    @Child(name="class", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="inpatient | outpatient | ambulatory | emergency +", formalDefinition="inpatient | outpatient | ambulatory | emergency +.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActEncounterCode")
    protected Coding class_;
    @Child(name="classHistory", type={}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of past encounter classes", formalDefinition="The class history permits the tracking of the encounters transitions without needing to go  through the resource history.\n\nThis would be used for a case where an admission starts of as an emergency encounter, then transisions into an inpatient scenario. Doing this and not restarting a new encounter ensures that any lab/diagnostic results can more easily follow the patient and not require re-processing and not get lost or cancelled during a kindof discharge from emergency to inpatient.")
    protected List<ClassHistoryComponent> classHistory;
    @Child(name="type", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Specific type of encounter", formalDefinition="Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-type")
    protected List<CodeableConcept> type;
    @Child(name="priority", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Indicates the urgency of the encounter", formalDefinition="Indicates the urgency of the encounter.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActPriority")
    protected CodeableConcept priority;
    @Child(name="subject", type={Patient.class, Group.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient ro group present at the encounter", formalDefinition="The patient ro group present at the encounter.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="episodeOfCare", type={EpisodeOfCare.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Episode(s) of care that this encounter should be recorded against", formalDefinition="Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care, and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).")
    protected List<Reference> episodeOfCare;
    protected List<EpisodeOfCare> episodeOfCareTarget;
    @Child(name="incomingReferral", type={ReferralRequest.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The ReferralRequest that initiated this encounter", formalDefinition="The referral request this encounter satisfies (incoming referral).")
    protected List<Reference> incomingReferral;
    protected List<ReferralRequest> incomingReferralTarget;
    @Child(name="participant", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="List of participants involved in the encounter", formalDefinition="The\u00a0list of\u00a0people\u00a0responsible for providing the service.")
    protected List<EncounterParticipantComponent> participant;
    @Child(name="appointment", type={Appointment.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The appointment that scheduled this encounter", formalDefinition="The appointment that scheduled this encounter.")
    protected Reference appointment;
    protected Appointment appointmentTarget;
    @Child(name="period", type={Period.class}, order=12, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The start and end time of the encounter", formalDefinition="The start and end time of the encounter.")
    protected Period period;
    @Child(name="length", type={Duration.class}, order=13, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Quantity of time the encounter lasted (less time absent)", formalDefinition="Quantity of time the encounter lasted. This excludes the time during leaves of absence.")
    protected Duration length;
    @Child(name="reason", type={CodeableConcept.class}, order=14, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason the encounter takes place (code)", formalDefinition="Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-reason")
    protected List<CodeableConcept> reason;
    @Child(name="diagnosis", type={}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The list of diagnosis relevant to this encounter", formalDefinition="The list of diagnosis relevant to this encounter.")
    protected List<DiagnosisComponent> diagnosis;
    @Child(name="account", type={Account.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The set of accounts that may be used for billing for this Encounter", formalDefinition="The set of accounts that may be used for billing for this Encounter.")
    protected List<Reference> account;
    protected List<Account> accountTarget;
    @Child(name="hospitalization", type={}, order=17, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Details about the admission to a healthcare service", formalDefinition="Details about the admission to a healthcare service.")
    protected EncounterHospitalizationComponent hospitalization;
    @Child(name="location", type={}, order=18, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="List of locations where the patient has been", formalDefinition="List of locations where  the patient has been during this encounter.")
    protected List<EncounterLocationComponent> location;
    @Child(name="serviceProvider", type={Organization.class}, order=19, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="The custodian organization of this Encounter record", formalDefinition="An organization that is in charge of maintaining the information of this Encounter (e.g. who maintains the report or the master service catalog item, etc.). This MAY be the same as the organization on the Patient record, however it could be different. This MAY not be not the Service Delivery Location's Organization.")
    protected Reference serviceProvider;
    protected Organization serviceProviderTarget;
    @Child(name="partOf", type={Encounter.class}, order=20, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Another Encounter this encounter is part of", formalDefinition="Another Encounter of which this encounter is a part of (administratively or in time).")
    protected Reference partOf;
    protected Encounter partOfTarget;
    private static final long serialVersionUID = 2124102382L;
    @SearchParamDefinition(name="date", path="Encounter.period", description="A date within the period the Encounter lasted", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="identifier", path="Encounter.identifier", description="Identifier(s) by which this encounter is known", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="reason", path="Encounter.reason", description="Reason the encounter takes place (code)", type="token")
    public static final String SP_REASON = "reason";
    public static final TokenClientParam REASON = new TokenClientParam("reason");
    @SearchParamDefinition(name="episodeofcare", path="Encounter.episodeOfCare", description="Episode(s) of care that this encounter should be recorded against", type="reference", target={EpisodeOfCare.class})
    public static final String SP_EPISODEOFCARE = "episodeofcare";
    public static final ReferenceClientParam EPISODEOFCARE = new ReferenceClientParam("episodeofcare");
    public static final Include INCLUDE_EPISODEOFCARE = new Include("Encounter:episodeofcare").toLocked();
    @SearchParamDefinition(name="participant-type", path="Encounter.participant.type", description="Role of participant in encounter", type="token")
    public static final String SP_PARTICIPANT_TYPE = "participant-type";
    public static final TokenClientParam PARTICIPANT_TYPE = new TokenClientParam("participant-type");
    @SearchParamDefinition(name="incomingreferral", path="Encounter.incomingReferral", description="The ReferralRequest that initiated this encounter", type="reference", target={ReferralRequest.class})
    public static final String SP_INCOMINGREFERRAL = "incomingreferral";
    public static final ReferenceClientParam INCOMINGREFERRAL = new ReferenceClientParam("incomingreferral");
    public static final Include INCLUDE_INCOMINGREFERRAL = new Include("Encounter:incomingreferral").toLocked();
    @SearchParamDefinition(name="practitioner", path="Encounter.participant.individual", description="Persons involved in the encounter other than the patient", type="reference", providesMembershipIn={@Compartment(name="Practitioner")}, target={Practitioner.class})
    public static final String SP_PRACTITIONER = "practitioner";
    public static final ReferenceClientParam PRACTITIONER = new ReferenceClientParam("practitioner");
    public static final Include INCLUDE_PRACTITIONER = new Include("Encounter:practitioner").toLocked();
    @SearchParamDefinition(name="subject", path="Encounter.subject", description="The patient ro group present at the encounter", type="reference", target={Group.class, Patient.class})
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Encounter:subject").toLocked();
    @SearchParamDefinition(name="length", path="Encounter.length", description="Length of encounter in days", type="number")
    public static final String SP_LENGTH = "length";
    public static final NumberClientParam LENGTH = new NumberClientParam("length");
    @SearchParamDefinition(name="diagnosis", path="Encounter.diagnosis.condition", description="Reason the encounter takes place (resource)", type="reference", target={Condition.class, Procedure.class})
    public static final String SP_DIAGNOSIS = "diagnosis";
    public static final ReferenceClientParam DIAGNOSIS = new ReferenceClientParam("diagnosis");
    public static final Include INCLUDE_DIAGNOSIS = new Include("Encounter:diagnosis").toLocked();
    @SearchParamDefinition(name="appointment", path="Encounter.appointment", description="The appointment that scheduled this encounter", type="reference", target={Appointment.class})
    public static final String SP_APPOINTMENT = "appointment";
    public static final ReferenceClientParam APPOINTMENT = new ReferenceClientParam("appointment");
    public static final Include INCLUDE_APPOINTMENT = new Include("Encounter:appointment").toLocked();
    @SearchParamDefinition(name="part-of", path="Encounter.partOf", description="Another Encounter this encounter is part of", type="reference", target={Encounter.class})
    public static final String SP_PART_OF = "part-of";
    public static final ReferenceClientParam PART_OF = new ReferenceClientParam("part-of");
    public static final Include INCLUDE_PART_OF = new Include("Encounter:part-of").toLocked();
    @SearchParamDefinition(name="type", path="Encounter.type", description="Specific type of encounter", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="participant", path="Encounter.participant.individual", description="Persons involved in the encounter other than the patient", type="reference", providesMembershipIn={@Compartment(name="Practitioner"), @Compartment(name="RelatedPerson")}, target={Practitioner.class, RelatedPerson.class})
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT = new Include("Encounter:participant").toLocked();
    @SearchParamDefinition(name="patient", path="Encounter.subject", description="The patient ro group present at the encounter", type="reference", providesMembershipIn={@Compartment(name="Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("Encounter:patient").toLocked();
    @SearchParamDefinition(name="location-period", path="Encounter.location.period", description="Time period during which the patient was present at the location", type="date")
    public static final String SP_LOCATION_PERIOD = "location-period";
    public static final DateClientParam LOCATION_PERIOD = new DateClientParam("location-period");
    @SearchParamDefinition(name="location", path="Encounter.location.location", description="Location the encounter takes place", type="reference", target={Location.class})
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Encounter:location").toLocked();
    @SearchParamDefinition(name="service-provider", path="Encounter.serviceProvider", description="The custodian organization of this Encounter record", type="reference", target={Organization.class})
    public static final String SP_SERVICE_PROVIDER = "service-provider";
    public static final ReferenceClientParam SERVICE_PROVIDER = new ReferenceClientParam("service-provider");
    public static final Include INCLUDE_SERVICE_PROVIDER = new Include("Encounter:service-provider").toLocked();
    @SearchParamDefinition(name="special-arrangement", path="Encounter.hospitalization.specialArrangement", description="Wheelchair, translator, stretcher, etc.", type="token")
    public static final String SP_SPECIAL_ARRANGEMENT = "special-arrangement";
    public static final TokenClientParam SPECIAL_ARRANGEMENT = new TokenClientParam("special-arrangement");
    @SearchParamDefinition(name="class", path="Encounter.class", description="inpatient | outpatient | ambulatory | emergency +", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="status", path="Encounter.status", description="planned | arrived | triaged | in-progress | onleave | finished | cancelled +", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");

    public Encounter() {
    }

    public Encounter(Enumeration<EncounterStatus> status) {
        this.status = status;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public Encounter setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Encounter addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Enumeration<EncounterStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<EncounterStatus>(new EncounterStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Encounter setStatusElement(Enumeration<EncounterStatus> value) {
        this.status = value;
        return this;
    }

    public EncounterStatus getStatus() {
        return this.status == null ? null : (EncounterStatus)((Object)this.status.getValue());
    }

    public Encounter setStatus(EncounterStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<EncounterStatus>(new EncounterStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public List<StatusHistoryComponent> getStatusHistory() {
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<StatusHistoryComponent>();
        }
        return this.statusHistory;
    }

    public Encounter setStatusHistory(List<StatusHistoryComponent> theStatusHistory) {
        this.statusHistory = theStatusHistory;
        return this;
    }

    public boolean hasStatusHistory() {
        if (this.statusHistory == null) {
            return false;
        }
        for (StatusHistoryComponent item : this.statusHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StatusHistoryComponent addStatusHistory() {
        StatusHistoryComponent t = new StatusHistoryComponent();
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<StatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return t;
    }

    public Encounter addStatusHistory(StatusHistoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.statusHistory == null) {
            this.statusHistory = new ArrayList<StatusHistoryComponent>();
        }
        this.statusHistory.add(t);
        return this;
    }

    public StatusHistoryComponent getStatusHistoryFirstRep() {
        if (this.getStatusHistory().isEmpty()) {
            this.addStatusHistory();
        }
        return this.getStatusHistory().get(0);
    }

    public Coding getClass_() {
        if (this.class_ == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.class_");
            }
            if (Configuration.doAutoCreate()) {
                this.class_ = new Coding();
            }
        }
        return this.class_;
    }

    public boolean hasClass_() {
        return this.class_ != null && !this.class_.isEmpty();
    }

    public Encounter setClass_(Coding value) {
        this.class_ = value;
        return this;
    }

    public List<ClassHistoryComponent> getClassHistory() {
        if (this.classHistory == null) {
            this.classHistory = new ArrayList<ClassHistoryComponent>();
        }
        return this.classHistory;
    }

    public Encounter setClassHistory(List<ClassHistoryComponent> theClassHistory) {
        this.classHistory = theClassHistory;
        return this;
    }

    public boolean hasClassHistory() {
        if (this.classHistory == null) {
            return false;
        }
        for (ClassHistoryComponent item : this.classHistory) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ClassHistoryComponent addClassHistory() {
        ClassHistoryComponent t = new ClassHistoryComponent();
        if (this.classHistory == null) {
            this.classHistory = new ArrayList<ClassHistoryComponent>();
        }
        this.classHistory.add(t);
        return t;
    }

    public Encounter addClassHistory(ClassHistoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.classHistory == null) {
            this.classHistory = new ArrayList<ClassHistoryComponent>();
        }
        this.classHistory.add(t);
        return this;
    }

    public ClassHistoryComponent getClassHistoryFirstRep() {
        if (this.getClassHistory().isEmpty()) {
            this.addClassHistory();
        }
        return this.getClassHistory().get(0);
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public Encounter setType(List<CodeableConcept> theType) {
        this.type = theType;
        return this;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Encounter addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public CodeableConcept getTypeFirstRep() {
        if (this.getType().isEmpty()) {
            this.addType();
        }
        return this.getType().get(0);
    }

    public CodeableConcept getPriority() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new CodeableConcept();
            }
        }
        return this.priority;
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public Encounter setPriority(CodeableConcept value) {
        this.priority = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Encounter setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Encounter setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public List<Reference> getEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        return this.episodeOfCare;
    }

    public Encounter setEpisodeOfCare(List<Reference> theEpisodeOfCare) {
        this.episodeOfCare = theEpisodeOfCare;
        return this;
    }

    public boolean hasEpisodeOfCare() {
        if (this.episodeOfCare == null) {
            return false;
        }
        for (Reference item : this.episodeOfCare) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addEpisodeOfCare() {
        Reference t = new Reference();
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        this.episodeOfCare.add(t);
        return t;
    }

    public Encounter addEpisodeOfCare(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.episodeOfCare == null) {
            this.episodeOfCare = new ArrayList<Reference>();
        }
        this.episodeOfCare.add(t);
        return this;
    }

    public Reference getEpisodeOfCareFirstRep() {
        if (this.getEpisodeOfCare().isEmpty()) {
            this.addEpisodeOfCare();
        }
        return this.getEpisodeOfCare().get(0);
    }

    @Deprecated
    public List<EpisodeOfCare> getEpisodeOfCareTarget() {
        if (this.episodeOfCareTarget == null) {
            this.episodeOfCareTarget = new ArrayList<EpisodeOfCare>();
        }
        return this.episodeOfCareTarget;
    }

    @Deprecated
    public EpisodeOfCare addEpisodeOfCareTarget() {
        EpisodeOfCare r = new EpisodeOfCare();
        if (this.episodeOfCareTarget == null) {
            this.episodeOfCareTarget = new ArrayList<EpisodeOfCare>();
        }
        this.episodeOfCareTarget.add(r);
        return r;
    }

    public List<Reference> getIncomingReferral() {
        if (this.incomingReferral == null) {
            this.incomingReferral = new ArrayList<Reference>();
        }
        return this.incomingReferral;
    }

    public Encounter setIncomingReferral(List<Reference> theIncomingReferral) {
        this.incomingReferral = theIncomingReferral;
        return this;
    }

    public boolean hasIncomingReferral() {
        if (this.incomingReferral == null) {
            return false;
        }
        for (Reference item : this.incomingReferral) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIncomingReferral() {
        Reference t = new Reference();
        if (this.incomingReferral == null) {
            this.incomingReferral = new ArrayList<Reference>();
        }
        this.incomingReferral.add(t);
        return t;
    }

    public Encounter addIncomingReferral(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.incomingReferral == null) {
            this.incomingReferral = new ArrayList<Reference>();
        }
        this.incomingReferral.add(t);
        return this;
    }

    public Reference getIncomingReferralFirstRep() {
        if (this.getIncomingReferral().isEmpty()) {
            this.addIncomingReferral();
        }
        return this.getIncomingReferral().get(0);
    }

    @Deprecated
    public List<ReferralRequest> getIncomingReferralTarget() {
        if (this.incomingReferralTarget == null) {
            this.incomingReferralTarget = new ArrayList<ReferralRequest>();
        }
        return this.incomingReferralTarget;
    }

    @Deprecated
    public ReferralRequest addIncomingReferralTarget() {
        ReferralRequest r = new ReferralRequest();
        if (this.incomingReferralTarget == null) {
            this.incomingReferralTarget = new ArrayList<ReferralRequest>();
        }
        this.incomingReferralTarget.add(r);
        return r;
    }

    public List<EncounterParticipantComponent> getParticipant() {
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        return this.participant;
    }

    public Encounter setParticipant(List<EncounterParticipantComponent> theParticipant) {
        this.participant = theParticipant;
        return this;
    }

    public boolean hasParticipant() {
        if (this.participant == null) {
            return false;
        }
        for (EncounterParticipantComponent item : this.participant) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterParticipantComponent addParticipant() {
        EncounterParticipantComponent t = new EncounterParticipantComponent();
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        this.participant.add(t);
        return t;
    }

    public Encounter addParticipant(EncounterParticipantComponent t) {
        if (t == null) {
            return this;
        }
        if (this.participant == null) {
            this.participant = new ArrayList<EncounterParticipantComponent>();
        }
        this.participant.add(t);
        return this;
    }

    public EncounterParticipantComponent getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public Reference getAppointment() {
        if (this.appointment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointment = new Reference();
            }
        }
        return this.appointment;
    }

    public boolean hasAppointment() {
        return this.appointment != null && !this.appointment.isEmpty();
    }

    public Encounter setAppointment(Reference value) {
        this.appointment = value;
        return this;
    }

    public Appointment getAppointmentTarget() {
        if (this.appointmentTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.appointment");
            }
            if (Configuration.doAutoCreate()) {
                this.appointmentTarget = new Appointment();
            }
        }
        return this.appointmentTarget;
    }

    public Encounter setAppointmentTarget(Appointment value) {
        this.appointmentTarget = value;
        return this;
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public Encounter setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public Duration getLength() {
        if (this.length == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.length");
            }
            if (Configuration.doAutoCreate()) {
                this.length = new Duration();
            }
        }
        return this.length;
    }

    public boolean hasLength() {
        return this.length != null && !this.length.isEmpty();
    }

    public Encounter setLength(Duration value) {
        this.length = value;
        return this;
    }

    public List<CodeableConcept> getReason() {
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        return this.reason;
    }

    public Encounter setReason(List<CodeableConcept> theReason) {
        this.reason = theReason;
        return this;
    }

    public boolean hasReason() {
        if (this.reason == null) {
            return false;
        }
        for (CodeableConcept item : this.reason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return t;
    }

    public Encounter addReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.reason == null) {
            this.reason = new ArrayList<CodeableConcept>();
        }
        this.reason.add(t);
        return this;
    }

    public CodeableConcept getReasonFirstRep() {
        if (this.getReason().isEmpty()) {
            this.addReason();
        }
        return this.getReason().get(0);
    }

    public List<DiagnosisComponent> getDiagnosis() {
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        return this.diagnosis;
    }

    public Encounter setDiagnosis(List<DiagnosisComponent> theDiagnosis) {
        this.diagnosis = theDiagnosis;
        return this;
    }

    public boolean hasDiagnosis() {
        if (this.diagnosis == null) {
            return false;
        }
        for (DiagnosisComponent item : this.diagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosisComponent addDiagnosis() {
        DiagnosisComponent t = new DiagnosisComponent();
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return t;
    }

    public Encounter addDiagnosis(DiagnosisComponent t) {
        if (t == null) {
            return this;
        }
        if (this.diagnosis == null) {
            this.diagnosis = new ArrayList<DiagnosisComponent>();
        }
        this.diagnosis.add(t);
        return this;
    }

    public DiagnosisComponent getDiagnosisFirstRep() {
        if (this.getDiagnosis().isEmpty()) {
            this.addDiagnosis();
        }
        return this.getDiagnosis().get(0);
    }

    public List<Reference> getAccount() {
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        return this.account;
    }

    public Encounter setAccount(List<Reference> theAccount) {
        this.account = theAccount;
        return this;
    }

    public boolean hasAccount() {
        if (this.account == null) {
            return false;
        }
        for (Reference item : this.account) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAccount() {
        Reference t = new Reference();
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return t;
    }

    public Encounter addAccount(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.account == null) {
            this.account = new ArrayList<Reference>();
        }
        this.account.add(t);
        return this;
    }

    public Reference getAccountFirstRep() {
        if (this.getAccount().isEmpty()) {
            this.addAccount();
        }
        return this.getAccount().get(0);
    }

    @Deprecated
    public List<Account> getAccountTarget() {
        if (this.accountTarget == null) {
            this.accountTarget = new ArrayList<Account>();
        }
        return this.accountTarget;
    }

    @Deprecated
    public Account addAccountTarget() {
        Account r = new Account();
        if (this.accountTarget == null) {
            this.accountTarget = new ArrayList<Account>();
        }
        this.accountTarget.add(r);
        return r;
    }

    public EncounterHospitalizationComponent getHospitalization() {
        if (this.hospitalization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.hospitalization");
            }
            if (Configuration.doAutoCreate()) {
                this.hospitalization = new EncounterHospitalizationComponent();
            }
        }
        return this.hospitalization;
    }

    public boolean hasHospitalization() {
        return this.hospitalization != null && !this.hospitalization.isEmpty();
    }

    public Encounter setHospitalization(EncounterHospitalizationComponent value) {
        this.hospitalization = value;
        return this;
    }

    public List<EncounterLocationComponent> getLocation() {
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        return this.location;
    }

    public Encounter setLocation(List<EncounterLocationComponent> theLocation) {
        this.location = theLocation;
        return this;
    }

    public boolean hasLocation() {
        if (this.location == null) {
            return false;
        }
        for (EncounterLocationComponent item : this.location) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public EncounterLocationComponent addLocation() {
        EncounterLocationComponent t = new EncounterLocationComponent();
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        this.location.add(t);
        return t;
    }

    public Encounter addLocation(EncounterLocationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.location == null) {
            this.location = new ArrayList<EncounterLocationComponent>();
        }
        this.location.add(t);
        return this;
    }

    public EncounterLocationComponent getLocationFirstRep() {
        if (this.getLocation().isEmpty()) {
            this.addLocation();
        }
        return this.getLocation().get(0);
    }

    public Reference getServiceProvider() {
        if (this.serviceProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.serviceProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceProvider = new Reference();
            }
        }
        return this.serviceProvider;
    }

    public boolean hasServiceProvider() {
        return this.serviceProvider != null && !this.serviceProvider.isEmpty();
    }

    public Encounter setServiceProvider(Reference value) {
        this.serviceProvider = value;
        return this;
    }

    public Organization getServiceProviderTarget() {
        if (this.serviceProviderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.serviceProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceProviderTarget = new Organization();
            }
        }
        return this.serviceProviderTarget;
    }

    public Encounter setServiceProviderTarget(Organization value) {
        this.serviceProviderTarget = value;
        return this;
    }

    public Reference getPartOf() {
        if (this.partOf == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOf = new Reference();
            }
        }
        return this.partOf;
    }

    public boolean hasPartOf() {
        return this.partOf != null && !this.partOf.isEmpty();
    }

    public Encounter setPartOf(Reference value) {
        this.partOf = value;
        return this;
    }

    public Encounter getPartOfTarget() {
        if (this.partOfTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Encounter.partOf");
            }
            if (Configuration.doAutoCreate()) {
                this.partOfTarget = new Encounter();
            }
        }
        return this.partOfTarget;
    }

    public Encounter setPartOfTarget(Encounter value) {
        this.partOfTarget = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_STATUS, "code", "planned | arrived | triaged | in-progress | onleave | finished | cancelled +.", 0, 1, this.status));
        children.add(new Property("statusHistory", "", "The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.", 0, Integer.MAX_VALUE, this.statusHistory));
        children.add(new Property(SP_CLASS, "Coding", "inpatient | outpatient | ambulatory | emergency +.", 0, 1, this.class_));
        children.add(new Property("classHistory", "", "The class history permits the tracking of the encounters transitions without needing to go  through the resource history.\n\nThis would be used for a case where an admission starts of as an emergency encounter, then transisions into an inpatient scenario. Doing this and not restarting a new encounter ensures that any lab/diagnostic results can more easily follow the patient and not require re-processing and not get lost or cancelled during a kindof discharge from emergency to inpatient.", 0, Integer.MAX_VALUE, this.classHistory));
        children.add(new Property(SP_TYPE, "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type));
        children.add(new Property("priority", "CodeableConcept", "Indicates the urgency of the encounter.", 0, 1, this.priority));
        children.add(new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient ro group present at the encounter.", 0, 1, this.subject));
        children.add(new Property("episodeOfCare", "Reference(EpisodeOfCare)", "Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care, and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).", 0, Integer.MAX_VALUE, this.episodeOfCare));
        children.add(new Property("incomingReferral", "Reference(ReferralRequest)", "The referral request this encounter satisfies (incoming referral).", 0, Integer.MAX_VALUE, this.incomingReferral));
        children.add(new Property(SP_PARTICIPANT, "", "The\u00a0list of\u00a0people\u00a0responsible for providing the service.", 0, Integer.MAX_VALUE, this.participant));
        children.add(new Property(SP_APPOINTMENT, "Reference(Appointment)", "The appointment that scheduled this encounter.", 0, 1, this.appointment));
        children.add(new Property("period", "Period", "The start and end time of the encounter.", 0, 1, this.period));
        children.add(new Property(SP_LENGTH, "Duration", "Quantity of time the encounter lasted. This excludes the time during leaves of absence.", 0, 1, this.length));
        children.add(new Property(SP_REASON, "CodeableConcept", "Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.", 0, Integer.MAX_VALUE, this.reason));
        children.add(new Property(SP_DIAGNOSIS, "", "The list of diagnosis relevant to this encounter.", 0, Integer.MAX_VALUE, this.diagnosis));
        children.add(new Property("account", "Reference(Account)", "The set of accounts that may be used for billing for this Encounter.", 0, Integer.MAX_VALUE, this.account));
        children.add(new Property("hospitalization", "", "Details about the admission to a healthcare service.", 0, 1, this.hospitalization));
        children.add(new Property(SP_LOCATION, "", "List of locations where  the patient has been during this encounter.", 0, Integer.MAX_VALUE, this.location));
        children.add(new Property("serviceProvider", "Reference(Organization)", "An organization that is in charge of maintaining the information of this Encounter (e.g. who maintains the report or the master service catalog item, etc.). This MAY be the same as the organization on the Patient record, however it could be different. This MAY not be not the Service Delivery Location's Organization.", 0, 1, this.serviceProvider));
        children.add(new Property("partOf", "Reference(Encounter)", "Another Encounter of which this encounter is a part of (administratively or in time).", 0, 1, this.partOf));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier(s) by which this encounter is known.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -892481550: {
                return new Property(SP_STATUS, "code", "planned | arrived | triaged | in-progress | onleave | finished | cancelled +.", 0, 1, this.status);
            }
            case -986695614: {
                return new Property("statusHistory", "", "The status history permits the encounter resource to contain the status history without needing to read through the historical versions of the resource, or even have the server store them.", 0, Integer.MAX_VALUE, this.statusHistory);
            }
            case 94742904: {
                return new Property(SP_CLASS, "Coding", "inpatient | outpatient | ambulatory | emergency +.", 0, 1, this.class_);
            }
            case 962575356: {
                return new Property("classHistory", "", "The class history permits the tracking of the encounters transitions without needing to go  through the resource history.\n\nThis would be used for a case where an admission starts of as an emergency encounter, then transisions into an inpatient scenario. Doing this and not restarting a new encounter ensures that any lab/diagnostic results can more easily follow the patient and not require re-processing and not get lost or cancelled during a kindof discharge from emergency to inpatient.", 0, Integer.MAX_VALUE, this.classHistory);
            }
            case 3575610: {
                return new Property(SP_TYPE, "CodeableConcept", "Specific type of encounter (e.g. e-mail consultation, surgical day-care, skilled nursing, rehabilitation).", 0, Integer.MAX_VALUE, this.type);
            }
            case -1165461084: {
                return new Property("priority", "CodeableConcept", "Indicates the urgency of the encounter.", 0, 1, this.priority);
            }
            case -1867885268: {
                return new Property(SP_SUBJECT, "Reference(Patient|Group)", "The patient ro group present at the encounter.", 0, 1, this.subject);
            }
            case -1892140189: {
                return new Property("episodeOfCare", "Reference(EpisodeOfCare)", "Where a specific encounter should be classified as a part of a specific episode(s) of care this field should be used. This association can facilitate grouping of related encounters together for a specific purpose, such as government reporting, issue tracking, association via a common problem.  The association is recorded on the encounter as these are typically created after the episode of care, and grouped on entry rather than editing the episode of care to append another encounter to it (the episode of care could span years).", 0, Integer.MAX_VALUE, this.episodeOfCare);
            }
            case -1258204701: {
                return new Property("incomingReferral", "Reference(ReferralRequest)", "The referral request this encounter satisfies (incoming referral).", 0, Integer.MAX_VALUE, this.incomingReferral);
            }
            case 767422259: {
                return new Property(SP_PARTICIPANT, "", "The\u00a0list of\u00a0people\u00a0responsible for providing the service.", 0, Integer.MAX_VALUE, this.participant);
            }
            case -1474995297: {
                return new Property(SP_APPOINTMENT, "Reference(Appointment)", "The appointment that scheduled this encounter.", 0, 1, this.appointment);
            }
            case -991726143: {
                return new Property("period", "Period", "The start and end time of the encounter.", 0, 1, this.period);
            }
            case -1106363674: {
                return new Property(SP_LENGTH, "Duration", "Quantity of time the encounter lasted. This excludes the time during leaves of absence.", 0, 1, this.length);
            }
            case -934964668: {
                return new Property(SP_REASON, "CodeableConcept", "Reason the encounter takes place, expressed as a code. For admissions, this can be used for a coded admission diagnosis.", 0, Integer.MAX_VALUE, this.reason);
            }
            case 1196993265: {
                return new Property(SP_DIAGNOSIS, "", "The list of diagnosis relevant to this encounter.", 0, Integer.MAX_VALUE, this.diagnosis);
            }
            case -1177318867: {
                return new Property("account", "Reference(Account)", "The set of accounts that may be used for billing for this Encounter.", 0, Integer.MAX_VALUE, this.account);
            }
            case 1057894634: {
                return new Property("hospitalization", "", "Details about the admission to a healthcare service.", 0, 1, this.hospitalization);
            }
            case 1901043637: {
                return new Property(SP_LOCATION, "", "List of locations where  the patient has been during this encounter.", 0, Integer.MAX_VALUE, this.location);
            }
            case 243182534: {
                return new Property("serviceProvider", "Reference(Organization)", "An organization that is in charge of maintaining the information of this Encounter (e.g. who maintains the report or the master service catalog item, etc.). This MAY be the same as the organization on the Patient record, however it could be different. This MAY not be not the Service Delivery Location's Organization.", 0, 1, this.serviceProvider);
            }
            case -995410646: {
                return new Property("partOf", "Reference(Encounter)", "Another Encounter of which this encounter is a part of (administratively or in time).", 0, 1, this.partOf);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -892481550: {
                Base[] baseArray;
                if (this.status == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.status;
                }
                return baseArray;
            }
            case -986695614: {
                return this.statusHistory == null ? new Base[]{} : this.statusHistory.toArray(new Base[this.statusHistory.size()]);
            }
            case 94742904: {
                Base[] baseArray;
                if (this.class_ == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.class_;
                }
                return baseArray;
            }
            case 962575356: {
                return this.classHistory == null ? new Base[]{} : this.classHistory.toArray(new Base[this.classHistory.size()]);
            }
            case 3575610: {
                return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
            }
            case -1165461084: {
                Base[] baseArray;
                if (this.priority == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.priority;
                }
                return baseArray;
            }
            case -1867885268: {
                Base[] baseArray;
                if (this.subject == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.subject;
                }
                return baseArray;
            }
            case -1892140189: {
                return this.episodeOfCare == null ? new Base[]{} : this.episodeOfCare.toArray(new Base[this.episodeOfCare.size()]);
            }
            case -1258204701: {
                return this.incomingReferral == null ? new Base[]{} : this.incomingReferral.toArray(new Base[this.incomingReferral.size()]);
            }
            case 767422259: {
                return this.participant == null ? new Base[]{} : this.participant.toArray(new Base[this.participant.size()]);
            }
            case -1474995297: {
                Base[] baseArray;
                if (this.appointment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.appointment;
                }
                return baseArray;
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.period;
                }
                return baseArray;
            }
            case -1106363674: {
                Base[] baseArray;
                if (this.length == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.length;
                }
                return baseArray;
            }
            case -934964668: {
                return this.reason == null ? new Base[]{} : this.reason.toArray(new Base[this.reason.size()]);
            }
            case 1196993265: {
                return this.diagnosis == null ? new Base[]{} : this.diagnosis.toArray(new Base[this.diagnosis.size()]);
            }
            case -1177318867: {
                return this.account == null ? new Base[]{} : this.account.toArray(new Base[this.account.size()]);
            }
            case 1057894634: {
                Base[] baseArray;
                if (this.hospitalization == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.hospitalization;
                }
                return baseArray;
            }
            case 1901043637: {
                return this.location == null ? new Base[]{} : this.location.toArray(new Base[this.location.size()]);
            }
            case 243182534: {
                Base[] baseArray;
                if (this.serviceProvider == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.serviceProvider;
                }
                return baseArray;
            }
            case -995410646: {
                Base[] baseArray;
                if (this.partOf == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.partOf;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case -892481550: {
                value = new EncounterStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
                return value;
            }
            case -986695614: {
                this.getStatusHistory().add((StatusHistoryComponent)((Object)value));
                return value;
            }
            case 94742904: {
                this.class_ = this.castToCoding(value);
                return value;
            }
            case 962575356: {
                this.getClassHistory().add((ClassHistoryComponent)((Object)value));
                return value;
            }
            case 3575610: {
                this.getType().add(this.castToCodeableConcept(value));
                return value;
            }
            case -1165461084: {
                this.priority = this.castToCodeableConcept(value);
                return value;
            }
            case -1867885268: {
                this.subject = this.castToReference(value);
                return value;
            }
            case -1892140189: {
                this.getEpisodeOfCare().add(this.castToReference(value));
                return value;
            }
            case -1258204701: {
                this.getIncomingReferral().add(this.castToReference(value));
                return value;
            }
            case 767422259: {
                this.getParticipant().add((EncounterParticipantComponent)((Object)value));
                return value;
            }
            case -1474995297: {
                this.appointment = this.castToReference(value);
                return value;
            }
            case -991726143: {
                this.period = this.castToPeriod(value);
                return value;
            }
            case -1106363674: {
                this.length = this.castToDuration(value);
                return value;
            }
            case -934964668: {
                this.getReason().add(this.castToCodeableConcept(value));
                return value;
            }
            case 1196993265: {
                this.getDiagnosis().add((DiagnosisComponent)((Object)value));
                return value;
            }
            case -1177318867: {
                this.getAccount().add(this.castToReference(value));
                return value;
            }
            case 1057894634: {
                this.hospitalization = (EncounterHospitalizationComponent)((Object)value);
                return value;
            }
            case 1901043637: {
                this.getLocation().add((EncounterLocationComponent)((Object)value));
                return value;
            }
            case 243182534: {
                this.serviceProvider = this.castToReference(value);
                return value;
            }
            case -995410646: {
                this.partOf = this.castToReference(value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            value = new EncounterStatusEnumFactory().fromType(this.castToCode(value));
            this.status = value;
        } else if (name.equals("statusHistory")) {
            this.getStatusHistory().add((StatusHistoryComponent)((Object)value));
        } else if (name.equals(SP_CLASS)) {
            this.class_ = this.castToCoding(value);
        } else if (name.equals("classHistory")) {
            this.getClassHistory().add((ClassHistoryComponent)((Object)value));
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals("priority")) {
            this.priority = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("episodeOfCare")) {
            this.getEpisodeOfCare().add(this.castToReference(value));
        } else if (name.equals("incomingReferral")) {
            this.getIncomingReferral().add(this.castToReference(value));
        } else if (name.equals(SP_PARTICIPANT)) {
            this.getParticipant().add((EncounterParticipantComponent)((Object)value));
        } else if (name.equals(SP_APPOINTMENT)) {
            this.appointment = this.castToReference(value);
        } else if (name.equals("period")) {
            this.period = this.castToPeriod(value);
        } else if (name.equals(SP_LENGTH)) {
            this.length = this.castToDuration(value);
        } else if (name.equals(SP_REASON)) {
            this.getReason().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_DIAGNOSIS)) {
            this.getDiagnosis().add((DiagnosisComponent)((Object)value));
        } else if (name.equals("account")) {
            this.getAccount().add(this.castToReference(value));
        } else if (name.equals("hospitalization")) {
            this.hospitalization = (EncounterHospitalizationComponent)((Object)value);
        } else if (name.equals(SP_LOCATION)) {
            this.getLocation().add((EncounterLocationComponent)((Object)value));
        } else if (name.equals("serviceProvider")) {
            this.serviceProvider = this.castToReference(value);
        } else if (name.equals("partOf")) {
            this.partOf = this.castToReference(value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -892481550: {
                return this.getStatusElement();
            }
            case -986695614: {
                return this.addStatusHistory();
            }
            case 94742904: {
                return this.getClass_();
            }
            case 962575356: {
                return this.addClassHistory();
            }
            case 3575610: {
                return this.addType();
            }
            case -1165461084: {
                return this.getPriority();
            }
            case -1867885268: {
                return this.getSubject();
            }
            case -1892140189: {
                return this.addEpisodeOfCare();
            }
            case -1258204701: {
                return this.addIncomingReferral();
            }
            case 767422259: {
                return this.addParticipant();
            }
            case -1474995297: {
                return this.getAppointment();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1106363674: {
                return this.getLength();
            }
            case -934964668: {
                return this.addReason();
            }
            case 1196993265: {
                return this.addDiagnosis();
            }
            case -1177318867: {
                return this.addAccount();
            }
            case 1057894634: {
                return this.getHospitalization();
            }
            case 1901043637: {
                return this.addLocation();
            }
            case 243182534: {
                return this.getServiceProvider();
            }
            case -995410646: {
                return this.getPartOf();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -892481550: {
                return new String[]{"code"};
            }
            case -986695614: {
                return new String[0];
            }
            case 94742904: {
                return new String[]{"Coding"};
            }
            case 962575356: {
                return new String[0];
            }
            case 3575610: {
                return new String[]{"CodeableConcept"};
            }
            case -1165461084: {
                return new String[]{"CodeableConcept"};
            }
            case -1867885268: {
                return new String[]{"Reference"};
            }
            case -1892140189: {
                return new String[]{"Reference"};
            }
            case -1258204701: {
                return new String[]{"Reference"};
            }
            case 767422259: {
                return new String[0];
            }
            case -1474995297: {
                return new String[]{"Reference"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -1106363674: {
                return new String[]{"Duration"};
            }
            case -934964668: {
                return new String[]{"CodeableConcept"};
            }
            case 1196993265: {
                return new String[0];
            }
            case -1177318867: {
                return new String[]{"Reference"};
            }
            case 1057894634: {
                return new String[0];
            }
            case 1901043637: {
                return new String[0];
            }
            case 243182534: {
                return new String[]{"Reference"};
            }
            case -995410646: {
                return new String[]{"Reference"};
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a primitive type Encounter.status");
        }
        if (name.equals("statusHistory")) {
            return this.addStatusHistory();
        }
        if (name.equals(SP_CLASS)) {
            this.class_ = new Coding();
            return this.class_;
        }
        if (name.equals("classHistory")) {
            return this.addClassHistory();
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals("priority")) {
            this.priority = new CodeableConcept();
            return this.priority;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("episodeOfCare")) {
            return this.addEpisodeOfCare();
        }
        if (name.equals("incomingReferral")) {
            return this.addIncomingReferral();
        }
        if (name.equals(SP_PARTICIPANT)) {
            return this.addParticipant();
        }
        if (name.equals(SP_APPOINTMENT)) {
            this.appointment = new Reference();
            return this.appointment;
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals(SP_LENGTH)) {
            this.length = new Duration();
            return this.length;
        }
        if (name.equals(SP_REASON)) {
            return this.addReason();
        }
        if (name.equals(SP_DIAGNOSIS)) {
            return this.addDiagnosis();
        }
        if (name.equals("account")) {
            return this.addAccount();
        }
        if (name.equals("hospitalization")) {
            this.hospitalization = new EncounterHospitalizationComponent();
            return this.hospitalization;
        }
        if (name.equals(SP_LOCATION)) {
            return this.addLocation();
        }
        if (name.equals("serviceProvider")) {
            this.serviceProvider = new Reference();
            return this.serviceProvider;
        }
        if (name.equals("partOf")) {
            this.partOf = new Reference();
            return this.partOf;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Encounter";
    }

    @Override
    public Encounter copy() {
        Encounter dst = new Encounter();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        Enumeration<EncounterStatus> enumeration = dst.status = this.status == null ? null : this.status.copy();
        if (this.statusHistory != null) {
            dst.statusHistory = new ArrayList<StatusHistoryComponent>();
            for (StatusHistoryComponent statusHistoryComponent : this.statusHistory) {
                dst.statusHistory.add(statusHistoryComponent.copy());
            }
        }
        Coding coding = dst.class_ = this.class_ == null ? null : this.class_.copy();
        if (this.classHistory != null) {
            dst.classHistory = new ArrayList<ClassHistoryComponent>();
            for (ClassHistoryComponent classHistoryComponent : this.classHistory) {
                dst.classHistory.add(classHistoryComponent.copy());
            }
        }
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        dst.priority = this.priority == null ? null : this.priority.copy();
        Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
        if (this.episodeOfCare != null) {
            dst.episodeOfCare = new ArrayList<Reference>();
            for (Reference reference2 : this.episodeOfCare) {
                dst.episodeOfCare.add(reference2.copy());
            }
        }
        if (this.incomingReferral != null) {
            dst.incomingReferral = new ArrayList<Reference>();
            for (Reference reference3 : this.incomingReferral) {
                dst.incomingReferral.add(reference3.copy());
            }
        }
        if (this.participant != null) {
            dst.participant = new ArrayList<EncounterParticipantComponent>();
            for (EncounterParticipantComponent encounterParticipantComponent : this.participant) {
                dst.participant.add(encounterParticipantComponent.copy());
            }
        }
        dst.appointment = this.appointment == null ? null : this.appointment.copy();
        dst.period = this.period == null ? null : this.period.copy();
        Duration duration = dst.length = this.length == null ? null : this.length.copy();
        if (this.reason != null) {
            dst.reason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.reason) {
                dst.reason.add(codeableConcept.copy());
            }
        }
        if (this.diagnosis != null) {
            dst.diagnosis = new ArrayList<DiagnosisComponent>();
            for (DiagnosisComponent diagnosisComponent : this.diagnosis) {
                dst.diagnosis.add(diagnosisComponent.copy());
            }
        }
        if (this.account != null) {
            dst.account = new ArrayList<Reference>();
            for (Reference reference4 : this.account) {
                dst.account.add(reference4.copy());
            }
        }
        EncounterHospitalizationComponent encounterHospitalizationComponent = dst.hospitalization = this.hospitalization == null ? null : this.hospitalization.copy();
        if (this.location != null) {
            dst.location = new ArrayList<EncounterLocationComponent>();
            for (EncounterLocationComponent encounterLocationComponent : this.location) {
                dst.location.add(encounterLocationComponent.copy());
            }
        }
        dst.serviceProvider = this.serviceProvider == null ? null : this.serviceProvider.copy();
        dst.partOf = this.partOf == null ? null : this.partOf.copy();
        return dst;
    }

    protected Encounter typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof Encounter)) {
            return false;
        }
        Encounter o = (Encounter)other_;
        return Encounter.compareDeep(this.identifier, o.identifier, true) && Encounter.compareDeep(this.status, o.status, true) && Encounter.compareDeep(this.statusHistory, o.statusHistory, true) && Encounter.compareDeep(this.class_, o.class_, true) && Encounter.compareDeep(this.classHistory, o.classHistory, true) && Encounter.compareDeep(this.type, o.type, true) && Encounter.compareDeep(this.priority, o.priority, true) && Encounter.compareDeep(this.subject, o.subject, true) && Encounter.compareDeep(this.episodeOfCare, o.episodeOfCare, true) && Encounter.compareDeep(this.incomingReferral, o.incomingReferral, true) && Encounter.compareDeep(this.participant, o.participant, true) && Encounter.compareDeep(this.appointment, o.appointment, true) && Encounter.compareDeep(this.period, o.period, true) && Encounter.compareDeep(this.length, o.length, true) && Encounter.compareDeep(this.reason, o.reason, true) && Encounter.compareDeep(this.diagnosis, o.diagnosis, true) && Encounter.compareDeep(this.account, o.account, true) && Encounter.compareDeep(this.hospitalization, o.hospitalization, true) && Encounter.compareDeep(this.location, o.location, true) && Encounter.compareDeep(this.serviceProvider, o.serviceProvider, true) && Encounter.compareDeep(this.partOf, o.partOf, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof Encounter)) {
            return false;
        }
        Encounter o = (Encounter)other_;
        return Encounter.compareValues(this.status, o.status, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty(this.identifier, this.status, this.statusHistory, this.class_, this.classHistory, this.type, this.priority, this.subject, this.episodeOfCare, this.incomingReferral, this.participant, this.appointment, this.period, this.length, this.reason, this.diagnosis, this.account, this.hospitalization, this.location, this.serviceProvider, this.partOf);
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Encounter;
    }

    @Block
    public static class EncounterLocationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="location", type={Location.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location the encounter takes place", formalDefinition="The location where the encounter takes place.")
        protected Reference location;
        protected Location locationTarget;
        @Child(name="status", type={CodeType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | active | reserved | completed", formalDefinition="The status of the participants' presence at the specified location during the period specified. If the participant is is no longer at the location, then the period will have an end date/time.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-location-status")
        protected Enumeration<EncounterLocationStatus> status;
        @Child(name="period", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Time period during which the patient was present at the location", formalDefinition="Time period during which the patient was present at the location.")
        protected Period period;
        private static final long serialVersionUID = -322984880L;

        public EncounterLocationComponent() {
        }

        public EncounterLocationComponent(Reference location) {
            this.location = location;
        }

        public Reference getLocation() {
            if (this.location == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.location = new Reference();
                }
            }
            return this.location;
        }

        public boolean hasLocation() {
            return this.location != null && !this.location.isEmpty();
        }

        public EncounterLocationComponent setLocation(Reference value) {
            this.location = value;
            return this;
        }

        public Location getLocationTarget() {
            if (this.locationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.location");
                }
                if (Configuration.doAutoCreate()) {
                    this.locationTarget = new Location();
                }
            }
            return this.locationTarget;
        }

        public EncounterLocationComponent setLocationTarget(Location value) {
            this.locationTarget = value;
            return this;
        }

        public Enumeration<EncounterLocationStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EncounterLocationStatus>(new EncounterLocationStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public EncounterLocationComponent setStatusElement(Enumeration<EncounterLocationStatus> value) {
            this.status = value;
            return this;
        }

        public EncounterLocationStatus getStatus() {
            return this.status == null ? null : (EncounterLocationStatus)((Object)this.status.getValue());
        }

        public EncounterLocationComponent setStatus(EncounterLocationStatus value) {
            if (value == null) {
                this.status = null;
            } else {
                if (this.status == null) {
                    this.status = new Enumeration<EncounterLocationStatus>(new EncounterLocationStatusEnumFactory());
                }
                this.status.setValue((Object)value);
            }
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterLocationComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterLocationComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_LOCATION, "Reference(Location)", "The location where the encounter takes place.", 0, 1, this.location));
            children.add(new Property(Encounter.SP_STATUS, "code", "The status of the participants' presence at the specified location during the period specified. If the participant is is no longer at the location, then the period will have an end date/time.", 0, 1, this.status));
            children.add(new Property("period", "Period", "Time period during which the patient was present at the location.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 1901043637: {
                    return new Property(Encounter.SP_LOCATION, "Reference(Location)", "The location where the encounter takes place.", 0, 1, this.location);
                }
                case -892481550: {
                    return new Property(Encounter.SP_STATUS, "code", "The status of the participants' presence at the specified location during the period specified. If the participant is is no longer at the location, then the period will have an end date/time.", 0, 1, this.status);
                }
                case -991726143: {
                    return new Property("period", "Period", "Time period during which the patient was present at the location.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    Base[] baseArray;
                    if (this.location == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.location;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    this.location = this.castToReference(value);
                    return value;
                }
                case -892481550: {
                    value = new EncounterLocationStatusEnumFactory().fromType(this.castToCode(value));
                    this.status = value;
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = this.castToReference(value);
            } else if (name.equals(Encounter.SP_STATUS)) {
                value = new EncounterLocationStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return this.getLocation();
                }
                case -892481550: {
                    return this.getStatusElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 1901043637: {
                    return new String[]{"Reference"};
                }
                case -892481550: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_LOCATION)) {
                this.location = new Reference();
                return this.location;
            }
            if (name.equals(Encounter.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type Encounter.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterLocationComponent copy() {
            EncounterLocationComponent dst = new EncounterLocationComponent();
            this.copyValues(dst);
            dst.location = this.location == null ? null : this.location.copy();
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterLocationComponent)) {
                return false;
            }
            EncounterLocationComponent o = (EncounterLocationComponent)other_;
            return EncounterLocationComponent.compareDeep(this.location, o.location, true) && EncounterLocationComponent.compareDeep(this.status, o.status, true) && EncounterLocationComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterLocationComponent)) {
                return false;
            }
            EncounterLocationComponent o = (EncounterLocationComponent)other_;
            return EncounterLocationComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.location, this.status, this.period);
        }

        @Override
        public String fhirType() {
            return "Encounter.location";
        }
    }

    @Block
    public static class EncounterHospitalizationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="preAdmissionIdentifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Pre-admission identifier", formalDefinition="Pre-admission identifier.")
        protected Identifier preAdmissionIdentifier;
        @Child(name="origin", type={Location.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The location from which the patient came before admission", formalDefinition="The location from which the patient came before admission.")
        protected Reference origin;
        protected Location originTarget;
        @Child(name="admitSource", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="From where patient was admitted (physician referral, transfer)", formalDefinition="From where patient was admitted (physician referral, transfer).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-admit-source")
        protected CodeableConcept admitSource;
        @Child(name="reAdmission", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The type of hospital re-admission that has occurred (if any). If the value is absent, then this is not identified as a readmission", formalDefinition="Whether this hospitalization is a readmission and why if known.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v2-0092")
        protected CodeableConcept reAdmission;
        @Child(name="dietPreference", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Diet preferences reported by the patient", formalDefinition="Diet preferences reported by the patient.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-diet")
        protected List<CodeableConcept> dietPreference;
        @Child(name="specialCourtesy", type={CodeableConcept.class}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Special courtesies (VIP, board member)", formalDefinition="Special courtesies (VIP, board member).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-special-courtesy")
        protected List<CodeableConcept> specialCourtesy;
        @Child(name="specialArrangement", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Wheelchair, translator, stretcher, etc.", formalDefinition="Any special requests that have been made for this hospitalization encounter, such as the provision of specific equipment or other things.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-special-arrangements")
        protected List<CodeableConcept> specialArrangement;
        @Child(name="destination", type={Location.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Location to which the patient is discharged", formalDefinition="Location to which the patient is discharged.")
        protected Reference destination;
        protected Location destinationTarget;
        @Child(name="dischargeDisposition", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Category or kind of location after discharge", formalDefinition="Category or kind of location after discharge.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-discharge-disposition")
        protected CodeableConcept dischargeDisposition;
        private static final long serialVersionUID = -1165804076L;

        public Identifier getPreAdmissionIdentifier() {
            if (this.preAdmissionIdentifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.preAdmissionIdentifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.preAdmissionIdentifier = new Identifier();
                }
            }
            return this.preAdmissionIdentifier;
        }

        public boolean hasPreAdmissionIdentifier() {
            return this.preAdmissionIdentifier != null && !this.preAdmissionIdentifier.isEmpty();
        }

        public EncounterHospitalizationComponent setPreAdmissionIdentifier(Identifier value) {
            this.preAdmissionIdentifier = value;
            return this;
        }

        public Reference getOrigin() {
            if (this.origin == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.origin");
                }
                if (Configuration.doAutoCreate()) {
                    this.origin = new Reference();
                }
            }
            return this.origin;
        }

        public boolean hasOrigin() {
            return this.origin != null && !this.origin.isEmpty();
        }

        public EncounterHospitalizationComponent setOrigin(Reference value) {
            this.origin = value;
            return this;
        }

        public Location getOriginTarget() {
            if (this.originTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.origin");
                }
                if (Configuration.doAutoCreate()) {
                    this.originTarget = new Location();
                }
            }
            return this.originTarget;
        }

        public EncounterHospitalizationComponent setOriginTarget(Location value) {
            this.originTarget = value;
            return this;
        }

        public CodeableConcept getAdmitSource() {
            if (this.admitSource == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.admitSource");
                }
                if (Configuration.doAutoCreate()) {
                    this.admitSource = new CodeableConcept();
                }
            }
            return this.admitSource;
        }

        public boolean hasAdmitSource() {
            return this.admitSource != null && !this.admitSource.isEmpty();
        }

        public EncounterHospitalizationComponent setAdmitSource(CodeableConcept value) {
            this.admitSource = value;
            return this;
        }

        public CodeableConcept getReAdmission() {
            if (this.reAdmission == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.reAdmission");
                }
                if (Configuration.doAutoCreate()) {
                    this.reAdmission = new CodeableConcept();
                }
            }
            return this.reAdmission;
        }

        public boolean hasReAdmission() {
            return this.reAdmission != null && !this.reAdmission.isEmpty();
        }

        public EncounterHospitalizationComponent setReAdmission(CodeableConcept value) {
            this.reAdmission = value;
            return this;
        }

        public List<CodeableConcept> getDietPreference() {
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            return this.dietPreference;
        }

        public EncounterHospitalizationComponent setDietPreference(List<CodeableConcept> theDietPreference) {
            this.dietPreference = theDietPreference;
            return this;
        }

        public boolean hasDietPreference() {
            if (this.dietPreference == null) {
                return false;
            }
            for (CodeableConcept item : this.dietPreference) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addDietPreference() {
            CodeableConcept t = new CodeableConcept();
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            this.dietPreference.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addDietPreference(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.dietPreference == null) {
                this.dietPreference = new ArrayList<CodeableConcept>();
            }
            this.dietPreference.add(t);
            return this;
        }

        public CodeableConcept getDietPreferenceFirstRep() {
            if (this.getDietPreference().isEmpty()) {
                this.addDietPreference();
            }
            return this.getDietPreference().get(0);
        }

        public List<CodeableConcept> getSpecialCourtesy() {
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            return this.specialCourtesy;
        }

        public EncounterHospitalizationComponent setSpecialCourtesy(List<CodeableConcept> theSpecialCourtesy) {
            this.specialCourtesy = theSpecialCourtesy;
            return this;
        }

        public boolean hasSpecialCourtesy() {
            if (this.specialCourtesy == null) {
                return false;
            }
            for (CodeableConcept item : this.specialCourtesy) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSpecialCourtesy() {
            CodeableConcept t = new CodeableConcept();
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            this.specialCourtesy.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addSpecialCourtesy(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.specialCourtesy == null) {
                this.specialCourtesy = new ArrayList<CodeableConcept>();
            }
            this.specialCourtesy.add(t);
            return this;
        }

        public CodeableConcept getSpecialCourtesyFirstRep() {
            if (this.getSpecialCourtesy().isEmpty()) {
                this.addSpecialCourtesy();
            }
            return this.getSpecialCourtesy().get(0);
        }

        public List<CodeableConcept> getSpecialArrangement() {
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            return this.specialArrangement;
        }

        public EncounterHospitalizationComponent setSpecialArrangement(List<CodeableConcept> theSpecialArrangement) {
            this.specialArrangement = theSpecialArrangement;
            return this;
        }

        public boolean hasSpecialArrangement() {
            if (this.specialArrangement == null) {
                return false;
            }
            for (CodeableConcept item : this.specialArrangement) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addSpecialArrangement() {
            CodeableConcept t = new CodeableConcept();
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            this.specialArrangement.add(t);
            return t;
        }

        public EncounterHospitalizationComponent addSpecialArrangement(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.specialArrangement == null) {
                this.specialArrangement = new ArrayList<CodeableConcept>();
            }
            this.specialArrangement.add(t);
            return this;
        }

        public CodeableConcept getSpecialArrangementFirstRep() {
            if (this.getSpecialArrangement().isEmpty()) {
                this.addSpecialArrangement();
            }
            return this.getSpecialArrangement().get(0);
        }

        public Reference getDestination() {
            if (this.destination == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destination = new Reference();
                }
            }
            return this.destination;
        }

        public boolean hasDestination() {
            return this.destination != null && !this.destination.isEmpty();
        }

        public EncounterHospitalizationComponent setDestination(Reference value) {
            this.destination = value;
            return this;
        }

        public Location getDestinationTarget() {
            if (this.destinationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.destination");
                }
                if (Configuration.doAutoCreate()) {
                    this.destinationTarget = new Location();
                }
            }
            return this.destinationTarget;
        }

        public EncounterHospitalizationComponent setDestinationTarget(Location value) {
            this.destinationTarget = value;
            return this;
        }

        public CodeableConcept getDischargeDisposition() {
            if (this.dischargeDisposition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterHospitalizationComponent.dischargeDisposition");
                }
                if (Configuration.doAutoCreate()) {
                    this.dischargeDisposition = new CodeableConcept();
                }
            }
            return this.dischargeDisposition;
        }

        public boolean hasDischargeDisposition() {
            return this.dischargeDisposition != null && !this.dischargeDisposition.isEmpty();
        }

        public EncounterHospitalizationComponent setDischargeDisposition(CodeableConcept value) {
            this.dischargeDisposition = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("preAdmissionIdentifier", "Identifier", "Pre-admission identifier.", 0, 1, this.preAdmissionIdentifier));
            children.add(new Property("origin", "Reference(Location)", "The location from which the patient came before admission.", 0, 1, this.origin));
            children.add(new Property("admitSource", "CodeableConcept", "From where patient was admitted (physician referral, transfer).", 0, 1, this.admitSource));
            children.add(new Property("reAdmission", "CodeableConcept", "Whether this hospitalization is a readmission and why if known.", 0, 1, this.reAdmission));
            children.add(new Property("dietPreference", "CodeableConcept", "Diet preferences reported by the patient.", 0, Integer.MAX_VALUE, this.dietPreference));
            children.add(new Property("specialCourtesy", "CodeableConcept", "Special courtesies (VIP, board member).", 0, Integer.MAX_VALUE, this.specialCourtesy));
            children.add(new Property("specialArrangement", "CodeableConcept", "Any special requests that have been made for this hospitalization encounter, such as the provision of specific equipment or other things.", 0, Integer.MAX_VALUE, this.specialArrangement));
            children.add(new Property("destination", "Reference(Location)", "Location to which the patient is discharged.", 0, 1, this.destination));
            children.add(new Property("dischargeDisposition", "CodeableConcept", "Category or kind of location after discharge.", 0, 1, this.dischargeDisposition));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -965394961: {
                    return new Property("preAdmissionIdentifier", "Identifier", "Pre-admission identifier.", 0, 1, this.preAdmissionIdentifier);
                }
                case -1008619738: {
                    return new Property("origin", "Reference(Location)", "The location from which the patient came before admission.", 0, 1, this.origin);
                }
                case 538887120: {
                    return new Property("admitSource", "CodeableConcept", "From where patient was admitted (physician referral, transfer).", 0, 1, this.admitSource);
                }
                case 669348630: {
                    return new Property("reAdmission", "CodeableConcept", "Whether this hospitalization is a readmission and why if known.", 0, 1, this.reAdmission);
                }
                case -1360641041: {
                    return new Property("dietPreference", "CodeableConcept", "Diet preferences reported by the patient.", 0, Integer.MAX_VALUE, this.dietPreference);
                }
                case 1583588345: {
                    return new Property("specialCourtesy", "CodeableConcept", "Special courtesies (VIP, board member).", 0, Integer.MAX_VALUE, this.specialCourtesy);
                }
                case 47410321: {
                    return new Property("specialArrangement", "CodeableConcept", "Any special requests that have been made for this hospitalization encounter, such as the provision of specific equipment or other things.", 0, Integer.MAX_VALUE, this.specialArrangement);
                }
                case -1429847026: {
                    return new Property("destination", "Reference(Location)", "Location to which the patient is discharged.", 0, 1, this.destination);
                }
                case 528065941: {
                    return new Property("dischargeDisposition", "CodeableConcept", "Category or kind of location after discharge.", 0, 1, this.dischargeDisposition);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    Base[] baseArray;
                    if (this.preAdmissionIdentifier == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.preAdmissionIdentifier;
                    }
                    return baseArray;
                }
                case -1008619738: {
                    Base[] baseArray;
                    if (this.origin == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.origin;
                    }
                    return baseArray;
                }
                case 538887120: {
                    Base[] baseArray;
                    if (this.admitSource == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.admitSource;
                    }
                    return baseArray;
                }
                case 669348630: {
                    Base[] baseArray;
                    if (this.reAdmission == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.reAdmission;
                    }
                    return baseArray;
                }
                case -1360641041: {
                    return this.dietPreference == null ? new Base[]{} : this.dietPreference.toArray(new Base[this.dietPreference.size()]);
                }
                case 1583588345: {
                    return this.specialCourtesy == null ? new Base[]{} : this.specialCourtesy.toArray(new Base[this.specialCourtesy.size()]);
                }
                case 47410321: {
                    return this.specialArrangement == null ? new Base[]{} : this.specialArrangement.toArray(new Base[this.specialArrangement.size()]);
                }
                case -1429847026: {
                    Base[] baseArray;
                    if (this.destination == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.destination;
                    }
                    return baseArray;
                }
                case 528065941: {
                    Base[] baseArray;
                    if (this.dischargeDisposition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.dischargeDisposition;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    this.preAdmissionIdentifier = this.castToIdentifier(value);
                    return value;
                }
                case -1008619738: {
                    this.origin = this.castToReference(value);
                    return value;
                }
                case 538887120: {
                    this.admitSource = this.castToCodeableConcept(value);
                    return value;
                }
                case 669348630: {
                    this.reAdmission = this.castToCodeableConcept(value);
                    return value;
                }
                case -1360641041: {
                    this.getDietPreference().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 1583588345: {
                    this.getSpecialCourtesy().add(this.castToCodeableConcept(value));
                    return value;
                }
                case 47410321: {
                    this.getSpecialArrangement().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -1429847026: {
                    this.destination = this.castToReference(value);
                    return value;
                }
                case 528065941: {
                    this.dischargeDisposition = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = this.castToIdentifier(value);
            } else if (name.equals("origin")) {
                this.origin = this.castToReference(value);
            } else if (name.equals("admitSource")) {
                this.admitSource = this.castToCodeableConcept(value);
            } else if (name.equals("reAdmission")) {
                this.reAdmission = this.castToCodeableConcept(value);
            } else if (name.equals("dietPreference")) {
                this.getDietPreference().add(this.castToCodeableConcept(value));
            } else if (name.equals("specialCourtesy")) {
                this.getSpecialCourtesy().add(this.castToCodeableConcept(value));
            } else if (name.equals("specialArrangement")) {
                this.getSpecialArrangement().add(this.castToCodeableConcept(value));
            } else if (name.equals("destination")) {
                this.destination = this.castToReference(value);
            } else if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    return this.getPreAdmissionIdentifier();
                }
                case -1008619738: {
                    return this.getOrigin();
                }
                case 538887120: {
                    return this.getAdmitSource();
                }
                case 669348630: {
                    return this.getReAdmission();
                }
                case -1360641041: {
                    return this.addDietPreference();
                }
                case 1583588345: {
                    return this.addSpecialCourtesy();
                }
                case 47410321: {
                    return this.addSpecialArrangement();
                }
                case -1429847026: {
                    return this.getDestination();
                }
                case 528065941: {
                    return this.getDischargeDisposition();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -965394961: {
                    return new String[]{"Identifier"};
                }
                case -1008619738: {
                    return new String[]{"Reference"};
                }
                case 538887120: {
                    return new String[]{"CodeableConcept"};
                }
                case 669348630: {
                    return new String[]{"CodeableConcept"};
                }
                case -1360641041: {
                    return new String[]{"CodeableConcept"};
                }
                case 1583588345: {
                    return new String[]{"CodeableConcept"};
                }
                case 47410321: {
                    return new String[]{"CodeableConcept"};
                }
                case -1429847026: {
                    return new String[]{"Reference"};
                }
                case 528065941: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("preAdmissionIdentifier")) {
                this.preAdmissionIdentifier = new Identifier();
                return this.preAdmissionIdentifier;
            }
            if (name.equals("origin")) {
                this.origin = new Reference();
                return this.origin;
            }
            if (name.equals("admitSource")) {
                this.admitSource = new CodeableConcept();
                return this.admitSource;
            }
            if (name.equals("reAdmission")) {
                this.reAdmission = new CodeableConcept();
                return this.reAdmission;
            }
            if (name.equals("dietPreference")) {
                return this.addDietPreference();
            }
            if (name.equals("specialCourtesy")) {
                return this.addSpecialCourtesy();
            }
            if (name.equals("specialArrangement")) {
                return this.addSpecialArrangement();
            }
            if (name.equals("destination")) {
                this.destination = new Reference();
                return this.destination;
            }
            if (name.equals("dischargeDisposition")) {
                this.dischargeDisposition = new CodeableConcept();
                return this.dischargeDisposition;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterHospitalizationComponent copy() {
            EncounterHospitalizationComponent dst = new EncounterHospitalizationComponent();
            this.copyValues(dst);
            dst.preAdmissionIdentifier = this.preAdmissionIdentifier == null ? null : this.preAdmissionIdentifier.copy();
            dst.origin = this.origin == null ? null : this.origin.copy();
            dst.admitSource = this.admitSource == null ? null : this.admitSource.copy();
            CodeableConcept codeableConcept = dst.reAdmission = this.reAdmission == null ? null : this.reAdmission.copy();
            if (this.dietPreference != null) {
                dst.dietPreference = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.dietPreference) {
                    dst.dietPreference.add(i2.copy());
                }
            }
            if (this.specialCourtesy != null) {
                dst.specialCourtesy = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.specialCourtesy) {
                    dst.specialCourtesy.add(i2.copy());
                }
            }
            if (this.specialArrangement != null) {
                dst.specialArrangement = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.specialArrangement) {
                    dst.specialArrangement.add(i2.copy());
                }
            }
            dst.destination = this.destination == null ? null : this.destination.copy();
            dst.dischargeDisposition = this.dischargeDisposition == null ? null : this.dischargeDisposition.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterHospitalizationComponent)) {
                return false;
            }
            EncounterHospitalizationComponent o = (EncounterHospitalizationComponent)other_;
            return EncounterHospitalizationComponent.compareDeep(this.preAdmissionIdentifier, o.preAdmissionIdentifier, true) && EncounterHospitalizationComponent.compareDeep(this.origin, o.origin, true) && EncounterHospitalizationComponent.compareDeep(this.admitSource, o.admitSource, true) && EncounterHospitalizationComponent.compareDeep(this.reAdmission, o.reAdmission, true) && EncounterHospitalizationComponent.compareDeep(this.dietPreference, o.dietPreference, true) && EncounterHospitalizationComponent.compareDeep(this.specialCourtesy, o.specialCourtesy, true) && EncounterHospitalizationComponent.compareDeep(this.specialArrangement, o.specialArrangement, true) && EncounterHospitalizationComponent.compareDeep(this.destination, o.destination, true) && EncounterHospitalizationComponent.compareDeep(this.dischargeDisposition, o.dischargeDisposition, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterHospitalizationComponent)) {
                return false;
            }
            EncounterHospitalizationComponent o = (EncounterHospitalizationComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.preAdmissionIdentifier, this.origin, this.admitSource, this.reAdmission, this.dietPreference, this.specialCourtesy, this.specialArrangement, this.destination, this.dischargeDisposition);
        }

        @Override
        public String fhirType() {
            return "Encounter.hospitalization";
        }
    }

    @Block
    public static class DiagnosisComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="condition", type={Condition.class, Procedure.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Reason the encounter takes place (resource)", formalDefinition="Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.")
        protected Reference condition;
        protected Resource conditionTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026)", formalDefinition="Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/diagnosis-role")
        protected CodeableConcept role;
        @Child(name="rank", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Ranking of the diagnosis (for each role type)", formalDefinition="Ranking of the diagnosis (for each role type).")
        protected PositiveIntType rank;
        private static final long serialVersionUID = 1005913665L;

        public DiagnosisComponent() {
        }

        public DiagnosisComponent(Reference condition) {
            this.condition = condition;
        }

        public Reference getCondition() {
            if (this.condition == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.condition");
                }
                if (Configuration.doAutoCreate()) {
                    this.condition = new Reference();
                }
            }
            return this.condition;
        }

        public boolean hasCondition() {
            return this.condition != null && !this.condition.isEmpty();
        }

        public DiagnosisComponent setCondition(Reference value) {
            this.condition = value;
            return this;
        }

        public Resource getConditionTarget() {
            return this.conditionTarget;
        }

        public DiagnosisComponent setConditionTarget(Resource value) {
            this.conditionTarget = value;
            return this;
        }

        public CodeableConcept getRole() {
            if (this.role == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.role");
                }
                if (Configuration.doAutoCreate()) {
                    this.role = new CodeableConcept();
                }
            }
            return this.role;
        }

        public boolean hasRole() {
            return this.role != null && !this.role.isEmpty();
        }

        public DiagnosisComponent setRole(CodeableConcept value) {
            this.role = value;
            return this;
        }

        public PositiveIntType getRankElement() {
            if (this.rank == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosisComponent.rank");
                }
                if (Configuration.doAutoCreate()) {
                    this.rank = new PositiveIntType();
                }
            }
            return this.rank;
        }

        public boolean hasRankElement() {
            return this.rank != null && !this.rank.isEmpty();
        }

        public boolean hasRank() {
            return this.rank != null && !this.rank.isEmpty();
        }

        public DiagnosisComponent setRankElement(PositiveIntType value) {
            this.rank = value;
            return this;
        }

        public int getRank() {
            return this.rank == null || this.rank.isEmpty() ? 0 : (Integer)this.rank.getValue();
        }

        public DiagnosisComponent setRank(int value) {
            if (this.rank == null) {
                this.rank = new PositiveIntType();
            }
            this.rank.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("condition", "Reference(Condition|Procedure)", "Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, 1, this.condition));
            children.add(new Property("role", "CodeableConcept", "Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).", 0, 1, this.role));
            children.add(new Property("rank", "positiveInt", "Ranking of the diagnosis (for each role type).", 0, 1, this.rank));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -861311717: {
                    return new Property("condition", "Reference(Condition|Procedure)", "Reason the encounter takes place, as specified using information from another resource. For admissions, this is the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.", 0, 1, this.condition);
                }
                case 3506294: {
                    return new Property("role", "CodeableConcept", "Role that this diagnosis has within the encounter (e.g. admission, billing, discharge \u2026).", 0, 1, this.role);
                }
                case 3492908: {
                    return new Property("rank", "positiveInt", "Ranking of the diagnosis (for each role type).", 0, 1, this.rank);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    Base[] baseArray;
                    if (this.condition == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.condition;
                    }
                    return baseArray;
                }
                case 3506294: {
                    Base[] baseArray;
                    if (this.role == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.role;
                    }
                    return baseArray;
                }
                case 3492908: {
                    Base[] baseArray;
                    if (this.rank == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.rank;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    this.condition = this.castToReference(value);
                    return value;
                }
                case 3506294: {
                    this.role = this.castToCodeableConcept(value);
                    return value;
                }
                case 3492908: {
                    this.rank = this.castToPositiveInt(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("condition")) {
                this.condition = this.castToReference(value);
            } else if (name.equals("role")) {
                this.role = this.castToCodeableConcept(value);
            } else if (name.equals("rank")) {
                this.rank = this.castToPositiveInt(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return this.getCondition();
                }
                case 3506294: {
                    return this.getRole();
                }
                case 3492908: {
                    return this.getRankElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -861311717: {
                    return new String[]{"Reference"};
                }
                case 3506294: {
                    return new String[]{"CodeableConcept"};
                }
                case 3492908: {
                    return new String[]{"positiveInt"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("condition")) {
                this.condition = new Reference();
                return this.condition;
            }
            if (name.equals("role")) {
                this.role = new CodeableConcept();
                return this.role;
            }
            if (name.equals("rank")) {
                throw new FHIRException("Cannot call addChild on a primitive type Encounter.rank");
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosisComponent copy() {
            DiagnosisComponent dst = new DiagnosisComponent();
            this.copyValues(dst);
            dst.condition = this.condition == null ? null : this.condition.copy();
            dst.role = this.role == null ? null : this.role.copy();
            dst.rank = this.rank == null ? null : this.rank.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareDeep(this.condition, o.condition, true) && DiagnosisComponent.compareDeep(this.role, o.role, true) && DiagnosisComponent.compareDeep(this.rank, o.rank, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof DiagnosisComponent)) {
                return false;
            }
            DiagnosisComponent o = (DiagnosisComponent)other_;
            return DiagnosisComponent.compareValues(this.rank, o.rank, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.condition, this.role, this.rank);
        }

        @Override
        public String fhirType() {
            return "Encounter.diagnosis";
        }
    }

    @Block
    public static class EncounterParticipantComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Role of participant in encounter", formalDefinition="Role of participant in encounter.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-participant-type")
        protected List<CodeableConcept> type;
        @Child(name="period", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Period of time during the encounter that the participant participated", formalDefinition="The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.")
        protected Period period;
        @Child(name="individual", type={Practitioner.class, RelatedPerson.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Persons involved in the encounter other than the patient", formalDefinition="Persons involved in the encounter other than the patient.")
        protected Reference individual;
        protected Resource individualTarget;
        private static final long serialVersionUID = 317095765L;

        public List<CodeableConcept> getType() {
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            return this.type;
        }

        public EncounterParticipantComponent setType(List<CodeableConcept> theType) {
            this.type = theType;
            return this;
        }

        public boolean hasType() {
            if (this.type == null) {
                return false;
            }
            for (CodeableConcept item : this.type) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addType() {
            CodeableConcept t = new CodeableConcept();
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return t;
        }

        public EncounterParticipantComponent addType(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.type == null) {
                this.type = new ArrayList<CodeableConcept>();
            }
            this.type.add(t);
            return this;
        }

        public CodeableConcept getTypeFirstRep() {
            if (this.getType().isEmpty()) {
                this.addType();
            }
            return this.getType().get(0);
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterParticipantComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public EncounterParticipantComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        public Reference getIndividual() {
            if (this.individual == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create EncounterParticipantComponent.individual");
                }
                if (Configuration.doAutoCreate()) {
                    this.individual = new Reference();
                }
            }
            return this.individual;
        }

        public boolean hasIndividual() {
            return this.individual != null && !this.individual.isEmpty();
        }

        public EncounterParticipantComponent setIndividual(Reference value) {
            this.individual = value;
            return this;
        }

        public Resource getIndividualTarget() {
            return this.individualTarget;
        }

        public EncounterParticipantComponent setIndividualTarget(Resource value) {
            this.individualTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_TYPE, "CodeableConcept", "Role of participant in encounter.", 0, Integer.MAX_VALUE, this.type));
            children.add(new Property("period", "Period", "The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.", 0, 1, this.period));
            children.add(new Property("individual", "Reference(Practitioner|RelatedPerson)", "Persons involved in the encounter other than the patient.", 0, 1, this.individual));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3575610: {
                    return new Property(Encounter.SP_TYPE, "CodeableConcept", "Role of participant in encounter.", 0, Integer.MAX_VALUE, this.type);
                }
                case -991726143: {
                    return new Property("period", "Period", "The period of time that the specified participant participated in the encounter. These can overlap or be sub-sets of the overall encounter's period.", 0, 1, this.period);
                }
                case -46292327: {
                    return new Property("individual", "Reference(Practitioner|RelatedPerson)", "Persons involved in the encounter other than the patient.", 0, 1, this.individual);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.type == null ? new Base[]{} : this.type.toArray(new Base[this.type.size()]);
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.period;
                    }
                    return baseArray;
                }
                case -46292327: {
                    Base[] baseArray;
                    if (this.individual == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.individual;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    this.getType().add(this.castToCodeableConcept(value));
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
                case -46292327: {
                    this.individual = this.castToReference(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                this.getType().add(this.castToCodeableConcept(value));
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else if (name.equals("individual")) {
                this.individual = this.castToReference(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return this.addType();
                }
                case -991726143: {
                    return this.getPeriod();
                }
                case -46292327: {
                    return this.getIndividual();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3575610: {
                    return new String[]{"CodeableConcept"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
                case -46292327: {
                    return new String[]{"Reference"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_TYPE)) {
                return this.addType();
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            if (name.equals("individual")) {
                this.individual = new Reference();
                return this.individual;
            }
            return super.addChild(name);
        }

        @Override
        public EncounterParticipantComponent copy() {
            EncounterParticipantComponent dst = new EncounterParticipantComponent();
            this.copyValues(dst);
            if (this.type != null) {
                dst.type = new ArrayList<CodeableConcept>();
                for (CodeableConcept i2 : this.type) {
                    dst.type.add(i2.copy());
                }
            }
            dst.period = this.period == null ? null : this.period.copy();
            dst.individual = this.individual == null ? null : this.individual.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterParticipantComponent)) {
                return false;
            }
            EncounterParticipantComponent o = (EncounterParticipantComponent)other_;
            return EncounterParticipantComponent.compareDeep(this.type, o.type, true) && EncounterParticipantComponent.compareDeep(this.period, o.period, true) && EncounterParticipantComponent.compareDeep(this.individual, o.individual, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof EncounterParticipantComponent)) {
                return false;
            }
            EncounterParticipantComponent o = (EncounterParticipantComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.type, this.period, this.individual);
        }

        @Override
        public String fhirType() {
            return "Encounter.participant";
        }
    }

    @Block
    public static class ClassHistoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="class", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="inpatient | outpatient | ambulatory | emergency +", formalDefinition="inpatient | outpatient | ambulatory | emergency +.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/v3-ActEncounterCode")
        protected Coding class_;
        @Child(name="period", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The time that the episode was in the specified class", formalDefinition="The time that the episode was in the specified class.")
        protected Period period;
        private static final long serialVersionUID = 1331020311L;

        public ClassHistoryComponent() {
        }

        public ClassHistoryComponent(Coding class_, Period period) {
            this.class_ = class_;
            this.period = period;
        }

        public Coding getClass_() {
            if (this.class_ == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassHistoryComponent.class_");
                }
                if (Configuration.doAutoCreate()) {
                    this.class_ = new Coding();
                }
            }
            return this.class_;
        }

        public boolean hasClass_() {
            return this.class_ != null && !this.class_.isEmpty();
        }

        public ClassHistoryComponent setClass_(Coding value) {
            this.class_ = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ClassHistoryComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ClassHistoryComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_CLASS, "Coding", "inpatient | outpatient | ambulatory | emergency +.", 0, 1, this.class_));
            children.add(new Property("period", "Period", "The time that the episode was in the specified class.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 94742904: {
                    return new Property(Encounter.SP_CLASS, "Coding", "inpatient | outpatient | ambulatory | emergency +.", 0, 1, this.class_);
                }
                case -991726143: {
                    return new Property("period", "Period", "The time that the episode was in the specified class.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 94742904: {
                    Base[] baseArray;
                    if (this.class_ == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.class_;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 94742904: {
                    this.class_ = this.castToCoding(value);
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_CLASS)) {
                this.class_ = this.castToCoding(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742904: {
                    return this.getClass_();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 94742904: {
                    return new String[]{"Coding"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_CLASS)) {
                this.class_ = new Coding();
                return this.class_;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public ClassHistoryComponent copy() {
            ClassHistoryComponent dst = new ClassHistoryComponent();
            this.copyValues(dst);
            dst.class_ = this.class_ == null ? null : this.class_.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof ClassHistoryComponent)) {
                return false;
            }
            ClassHistoryComponent o = (ClassHistoryComponent)other_;
            return ClassHistoryComponent.compareDeep(this.class_, o.class_, true) && ClassHistoryComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof ClassHistoryComponent)) {
                return false;
            }
            ClassHistoryComponent o = (ClassHistoryComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.class_, this.period);
        }

        @Override
        public String fhirType() {
            return "Encounter.classHistory";
        }
    }

    @Block
    public static class StatusHistoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="planned | arrived | triaged | in-progress | onleave | finished | cancelled +", formalDefinition="planned | arrived | triaged | in-progress | onleave | finished | cancelled +.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/encounter-status")
        protected Enumeration<EncounterStatus> status;
        @Child(name="period", type={Period.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The time that the episode was in the specified status", formalDefinition="The time that the episode was in the specified status.")
        protected Period period;
        private static final long serialVersionUID = -1893906736L;

        public StatusHistoryComponent() {
        }

        public StatusHistoryComponent(Enumeration<EncounterStatus> status, Period period) {
            this.status = status;
            this.period = period;
        }

        public Enumeration<EncounterStatus> getStatusElement() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatusHistoryComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new Enumeration<EncounterStatus>(new EncounterStatusEnumFactory());
                }
            }
            return this.status;
        }

        public boolean hasStatusElement() {
            return this.status != null && !this.status.isEmpty();
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public StatusHistoryComponent setStatusElement(Enumeration<EncounterStatus> value) {
            this.status = value;
            return this;
        }

        public EncounterStatus getStatus() {
            return this.status == null ? null : (EncounterStatus)((Object)this.status.getValue());
        }

        public StatusHistoryComponent setStatus(EncounterStatus value) {
            if (this.status == null) {
                this.status = new Enumeration<EncounterStatus>(new EncounterStatusEnumFactory());
            }
            this.status.setValue((Object)value);
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create StatusHistoryComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public StatusHistoryComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property(Encounter.SP_STATUS, "code", "planned | arrived | triaged | in-progress | onleave | finished | cancelled +.", 0, 1, this.status));
            children.add(new Property("period", "Period", "The time that the episode was in the specified status.", 0, 1, this.period));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -892481550: {
                    return new Property(Encounter.SP_STATUS, "code", "planned | arrived | triaged | in-progress | onleave | finished | cancelled +.", 0, 1, this.status);
                }
                case -991726143: {
                    return new Property("period", "Period", "The time that the episode was in the specified status.", 0, 1, this.period);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.status;
                    }
                    return baseArray;
                }
                case -991726143: {
                    Base[] baseArray;
                    if (this.period == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.period;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    value = new EncounterStatusEnumFactory().fromType(this.castToCode(value));
                    this.status = value;
                    return value;
                }
                case -991726143: {
                    this.period = this.castToPeriod(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Encounter.SP_STATUS)) {
                value = new EncounterStatusEnumFactory().fromType(this.castToCode(value));
                this.status = value;
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return this.getStatusElement();
                }
                case -991726143: {
                    return this.getPeriod();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -892481550: {
                    return new String[]{"code"};
                }
                case -991726143: {
                    return new String[]{"Period"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Encounter.SP_STATUS)) {
                throw new FHIRException("Cannot call addChild on a primitive type Encounter.status");
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public StatusHistoryComponent copy() {
            StatusHistoryComponent dst = new StatusHistoryComponent();
            this.copyValues(dst);
            dst.status = this.status == null ? null : this.status.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof StatusHistoryComponent)) {
                return false;
            }
            StatusHistoryComponent o = (StatusHistoryComponent)other_;
            return StatusHistoryComponent.compareDeep(this.status, o.status, true) && StatusHistoryComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof StatusHistoryComponent)) {
                return false;
            }
            StatusHistoryComponent o = (StatusHistoryComponent)other_;
            return StatusHistoryComponent.compareValues(this.status, o.status, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty(this.status, this.period);
        }

        @Override
        public String fhirType() {
            return "Encounter.statusHistory";
        }
    }

    public static class EncounterLocationStatusEnumFactory
    implements EnumFactory<EncounterLocationStatus> {
        @Override
        public EncounterLocationStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EncounterLocationStatus.PLANNED;
            }
            if ("active".equals(codeString)) {
                return EncounterLocationStatus.ACTIVE;
            }
            if ("reserved".equals(codeString)) {
                return EncounterLocationStatus.RESERVED;
            }
            if ("completed".equals(codeString)) {
                return EncounterLocationStatus.COMPLETED;
            }
            throw new IllegalArgumentException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        public Enumeration<EncounterLocationStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EncounterLocationStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.PLANNED);
            }
            if ("active".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.ACTIVE);
            }
            if ("reserved".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.RESERVED);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<EncounterLocationStatus>(this, EncounterLocationStatus.COMPLETED);
            }
            throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EncounterLocationStatus code) {
            if (code == EncounterLocationStatus.PLANNED) {
                return "planned";
            }
            if (code == EncounterLocationStatus.ACTIVE) {
                return "active";
            }
            if (code == EncounterLocationStatus.RESERVED) {
                return "reserved";
            }
            if (code == EncounterLocationStatus.COMPLETED) {
                return "completed";
            }
            return "?";
        }

        @Override
        public String toSystem(EncounterLocationStatus code) {
            return code.getSystem();
        }
    }

    public static enum EncounterLocationStatus {
        PLANNED,
        ACTIVE,
        RESERVED,
        COMPLETED,
        NULL;


        public static EncounterLocationStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("reserved".equals(codeString)) {
                return RESERVED;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EncounterLocationStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case ACTIVE: {
                    return "active";
                }
                case RESERVED: {
                    return "reserved";
                }
                case COMPLETED: {
                    return "completed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case ACTIVE: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case RESERVED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/encounter-location-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The patient is planned to be moved to this location at some point in the future.";
                }
                case ACTIVE: {
                    return "The patient is currently at this location, or was between the period specified.\r\rA system may update these records when the patient leaves the location to either reserved, or completed";
                }
                case RESERVED: {
                    return "This location is held empty for this patient.";
                }
                case COMPLETED: {
                    return "The patient was at this location during the period specified.\r\rNot to be used when the patient is currently at the location";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case ACTIVE: {
                    return "Active";
                }
                case RESERVED: {
                    return "Reserved";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class EncounterStatusEnumFactory
    implements EnumFactory<EncounterStatus> {
        @Override
        public EncounterStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return EncounterStatus.PLANNED;
            }
            if ("arrived".equals(codeString)) {
                return EncounterStatus.ARRIVED;
            }
            if ("triaged".equals(codeString)) {
                return EncounterStatus.TRIAGED;
            }
            if ("in-progress".equals(codeString)) {
                return EncounterStatus.INPROGRESS;
            }
            if ("onleave".equals(codeString)) {
                return EncounterStatus.ONLEAVE;
            }
            if ("finished".equals(codeString)) {
                return EncounterStatus.FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return EncounterStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return EncounterStatus.ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return EncounterStatus.UNKNOWN;
            }
            throw new IllegalArgumentException("Unknown EncounterStatus code '" + codeString + "'");
        }

        public Enumeration<EncounterStatus> fromType(Base code) throws FHIRException {
            if (code == null) {
                return null;
            }
            if (code.isEmpty()) {
                return new Enumeration<EncounterStatus>(this);
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.PLANNED);
            }
            if ("arrived".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.ARRIVED);
            }
            if ("triaged".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.TRIAGED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.INPROGRESS);
            }
            if ("onleave".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.ONLEAVE);
            }
            if ("finished".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.FINISHED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.ENTEREDINERROR);
            }
            if ("unknown".equals(codeString)) {
                return new Enumeration<EncounterStatus>(this, EncounterStatus.UNKNOWN);
            }
            throw new FHIRException("Unknown EncounterStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(EncounterStatus code) {
            if (code == EncounterStatus.PLANNED) {
                return "planned";
            }
            if (code == EncounterStatus.ARRIVED) {
                return "arrived";
            }
            if (code == EncounterStatus.TRIAGED) {
                return "triaged";
            }
            if (code == EncounterStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == EncounterStatus.ONLEAVE) {
                return "onleave";
            }
            if (code == EncounterStatus.FINISHED) {
                return "finished";
            }
            if (code == EncounterStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == EncounterStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            if (code == EncounterStatus.UNKNOWN) {
                return "unknown";
            }
            return "?";
        }

        @Override
        public String toSystem(EncounterStatus code) {
            return code.getSystem();
        }
    }

    public static enum EncounterStatus {
        PLANNED,
        ARRIVED,
        TRIAGED,
        INPROGRESS,
        ONLEAVE,
        FINISHED,
        CANCELLED,
        ENTEREDINERROR,
        UNKNOWN,
        NULL;


        public static EncounterStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("arrived".equals(codeString)) {
                return ARRIVED;
            }
            if ("triaged".equals(codeString)) {
                return TRIAGED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("onleave".equals(codeString)) {
                return ONLEAVE;
            }
            if ("finished".equals(codeString)) {
                return FINISHED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            if ("unknown".equals(codeString)) {
                return UNKNOWN;
            }
            if (Configuration.isAcceptInvalidEnums()) {
                return null;
            }
            throw new FHIRException("Unknown EncounterStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PLANNED: {
                    return "planned";
                }
                case ARRIVED: {
                    return "arrived";
                }
                case TRIAGED: {
                    return "triaged";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case ONLEAVE: {
                    return "onleave";
                }
                case FINISHED: {
                    return "finished";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case UNKNOWN: {
                    return "unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PLANNED: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case ARRIVED: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case TRIAGED: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case ONLEAVE: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case FINISHED: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case UNKNOWN: {
                    return "http://hl7.org/fhir/encounter-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PLANNED: {
                    return "The Encounter has not yet started.";
                }
                case ARRIVED: {
                    return "The Patient is present for the encounter, however is not currently meeting with a practitioner.";
                }
                case TRIAGED: {
                    return "The patient has been assessed for the priority of their treatment based on the severity of their condition.";
                }
                case INPROGRESS: {
                    return "The Encounter has begun and the patient is present / the practitioner and the patient are meeting.";
                }
                case ONLEAVE: {
                    return "The Encounter has begun, but the patient is temporarily on leave.";
                }
                case FINISHED: {
                    return "The Encounter has ended.";
                }
                case CANCELLED: {
                    return "The Encounter has ended before it has begun.";
                }
                case ENTEREDINERROR: {
                    return "This instance should not have been part of this patient's medical record.";
                }
                case UNKNOWN: {
                    return "The encounter status is unknown. Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PLANNED: {
                    return "Planned";
                }
                case ARRIVED: {
                    return "Arrived";
                }
                case TRIAGED: {
                    return "Triaged";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case ONLEAVE: {
                    return "On Leave";
                }
                case FINISHED: {
                    return "Finished";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case UNKNOWN: {
                    return "Unknown";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

