/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.txClient;

import java.net.URISyntaxException;
import java.util.Map;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.TerminologyCapabilities40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.utils.client.FHIRToolingClient;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.TerminologyCapabilities;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.TerminologyClient;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;

public class TerminologyClientR4
implements TerminologyClient {
    private FHIRToolingClient client;

    public TerminologyClientR4(String address) throws URISyntaxException {
        this.client = new FHIRToolingClient(address);
    }

    @Override
    public TerminologyCapabilities getTerminologyCapabilities() throws FHIRException {
        return TerminologyCapabilities40_50.convertTerminologyCapabilities(this.client.getTerminologyCapabilities());
    }

    @Override
    public String getAddress() {
        return this.client.getAddress();
    }

    @Override
    public ValueSet expandValueset(ValueSet vs, org.hl7.fhir.r5.model.Parameters p, Map<String, String> params) throws FHIRException {
        org.hl7.fhir.r4.model.ValueSet vs2 = (org.hl7.fhir.r4.model.ValueSet)VersionConvertor_40_50.convertResource(vs);
        Parameters p2 = (Parameters)VersionConvertor_40_50.convertResource(p);
        vs2 = this.client.expandValueset(vs2, p2, params);
        return (ValueSet)VersionConvertor_40_50.convertResource(vs2);
    }

    @Override
    public org.hl7.fhir.r5.model.Parameters validateCS(org.hl7.fhir.r5.model.Parameters pin) throws FHIRException {
        Parameters p2 = (Parameters)VersionConvertor_40_50.convertResource(pin);
        p2 = this.client.operateType(CodeSystem.class, "validate-code", p2);
        return (org.hl7.fhir.r5.model.Parameters)VersionConvertor_40_50.convertResource(p2);
    }

    @Override
    public org.hl7.fhir.r5.model.Parameters validateVS(org.hl7.fhir.r5.model.Parameters pin) throws FHIRException {
        Parameters p2 = (Parameters)VersionConvertor_40_50.convertResource(pin);
        p2 = this.client.operateType(org.hl7.fhir.r4.model.ValueSet.class, "validate-code", p2);
        return (org.hl7.fhir.r5.model.Parameters)VersionConvertor_40_50.convertResource(p2);
    }

    @Override
    public TerminologyClient setTimeout(int i2) {
        this.client.setTimeout(i2);
        return this;
    }

    @Override
    public TerminologyClient setLogger(ToolingClientLogger txLog) {
        this.client.setLogger(txLog);
        return this;
    }

    @Override
    public TerminologyClient setRetryCount(int retryCount) throws FHIRException {
        this.client.setRetryCount(retryCount);
        return this;
    }

    @Override
    public CapabilityStatement getCapabilitiesStatementQuick() throws FHIRException {
        return (CapabilityStatement)VersionConvertor_40_50.convertResource(this.client.getCapabilitiesStatementQuick());
    }

    @Override
    public org.hl7.fhir.r5.model.Parameters lookupCode(Map<String, String> params) throws FHIRException {
        return (org.hl7.fhir.r5.model.Parameters)VersionConvertor_40_50.convertResource(this.client.lookupCode(params));
    }

    @Override
    public int getRetryCount() throws FHIRException {
        return this.client.getRetryCount();
    }

    @Override
    public org.hl7.fhir.r5.model.Bundle validateBatch(org.hl7.fhir.r5.model.Bundle batch) {
        return (org.hl7.fhir.r5.model.Bundle)VersionConvertor_40_50.convertResource(this.client.transaction((Bundle)VersionConvertor_40_50.convertResource(batch)));
    }

    @Override
    public CanonicalResource read(String type, String id) {
        Class<?> t;
        try {
            t = Class.forName("org.hl7.fhir.r4.model." + type);
        }
        catch (ClassNotFoundException e) {
            throw new FHIRException("Unable to fetch resources of type " + type + " in R2");
        }
        Object r4 = this.client.read(t, id);
        if (r4 == null) {
            throw new FHIRException("Unable to fetch resource " + Utilities.pathURL(this.getAddress(), type, id));
        }
        Resource r5 = VersionConvertor_40_50.convertResource(r4);
        if (r5 != null) {
            throw new FHIRException("Unable to convert resource " + Utilities.pathURL(this.getAddress(), type, id) + " to R5 (internal representation)");
        }
        if (!(r5 instanceof CanonicalResource)) {
            throw new FHIRException("Unable to convert resource " + Utilities.pathURL(this.getAddress(), type, id) + " to R5 canonical resource (internal representation)");
        }
        return (CanonicalResource)r5;
    }
}

