/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import org.hl7.fhir.convertors.misc.OIDBasedValueSetImporter;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.utils.client.FHIRToolingClient;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.Utilities;

public class VSACImporter
extends OIDBasedValueSetImporter {
    public static void main(String[] args2) throws FileNotFoundException, FHIRException, IOException, ParseException, URISyntaxException {
        VSACImporter self = new VSACImporter();
        self.process(args2[0], args2[1], args2[2], args2[3]);
    }

    public VSACImporter() throws FileNotFoundException, FHIRException, IOException {
        this.init();
    }

    private void process(String source, String dest, String username, String password) throws FHIRException, FileNotFoundException, IOException, URISyntaxException {
        CSVReader csv = new CSVReader(new FileInputStream(source));
        csv.readHeaders();
        FHIRToolingClient client = new FHIRToolingClient("https://cts.nlm.nih.gov/fhir", username, password);
        int i2 = 0;
        while (csv.line()) {
            String oid = csv.cell("OID");
            try {
                ValueSet vs = client.read(ValueSet.class, oid);
                new JsonParser().compose(new FileOutputStream(Utilities.path(dest, "ValueSet-" + oid + ".json")), (Resource)vs);
                if (++i2 % 100 != 0) continue;
                System.out.println(i2);
            }
            catch (Exception e) {
                System.out.println("Unable to fetch OID " + oid + ": " + e.getMessage());
            }
        }
        System.out.println("Done. " + i2 + " ValueSets");
    }
}

