/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.misc;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r4.formats.IParser;
import org.hl7.fhir.r4.formats.JsonParser;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.DateTimeType;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.utilities.CSVReader;
import org.hl7.fhir.utilities.Utilities;

public class NUCCConvertor {
    public static void main(String[] args2) throws Exception {
        new NUCCConvertor().execute();
    }

    public void execute() throws IOException, FHIRException {
        CSVReader csv = new CSVReader(new FileInputStream("c:\\temp\\nucc.csv"));
        CodeSystem cs = new CodeSystem();
        cs.setId("nucc-provider-taxonomy");
        cs.setUrl("http://nucc.org/provider-taxonomy");
        cs.setName("NUCC Provider Taxonomy");
        cs.setDateElement(new DateTimeType());
        cs.setDescription("The Health Care Provider Taxonomy code is a unique alphanumeric code, ten characters in length. The code set is structured into three distinct 'Levels' including Provider Type, Classification, and Area of Specialization");
        cs.setCopyright("Vendors must request a license to include this in a product per the following: 'Vendors interested in incorporating the Health Care Provider Taxonomy code set into their commercial products must complete the license request form found on the CSV page.' Using the form at the url listed. The preamble is reproduced below: http://www.nucc.org/index.php?option=com_content&view=article&id=111&Itemid=110");
        cs.setStatus(Enumerations.PublicationStatus.ACTIVE);
        cs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
        cs.setExperimental(false);
        cs.setValueSet("http://hl7.org/fhir/ValueSet/nucc-provider-taxonomy");
        cs.setHierarchyMeaning(CodeSystem.CodeSystemHierarchyMeaning.CLASSIFIEDWITH);
        cs.addProperty().setCode("grouping").setType(CodeSystem.PropertyType.STRING).setDescription("A major grouping of service(s) or occupation(s) of health care providers. For example: Allopathic & Osteopathic Physicians, Dental Providers, Hospitals, etc");
        cs.addProperty().setCode("classification").setType(CodeSystem.PropertyType.STRING).setDescription("A more specific service or occupation related to the Provider Grouping.e");
        cs.addProperty().setCode("specialization").setType(CodeSystem.PropertyType.STRING).setDescription("A more specialized area of the Classification in which a provider chooses to practice or make services available.");
        csv.parseLine();
        while (csv.ready()) {
            String[] values2 = csv.parseLine();
            this.processLine(cs, values2);
        }
        csv.close();
        cs.sort();
        new JsonParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(new FileOutputStream("c:\\temp\\nucc.json"), cs);
    }

    private void processLine(CodeSystem cs, String[] values2) throws FHIRFormatError {
        CodeSystem.ConceptDefinitionComponent cc = new CodeSystem.ConceptDefinitionComponent();
        cs.getConcept().add(cc);
        cc.setCode(values2[0]);
        cc.setDisplay(values2[4]);
        if (!Utilities.noString(values2[1])) {
            cc.addProperty().setCode("grouping").setValue(new StringType(values2[1]));
        }
        if (!Utilities.noString(values2[2])) {
            cc.addProperty().setCode("classification").setValue(new StringType(values2[2]));
        }
        if (!Utilities.noString(values2[3])) {
            cc.addProperty().setCode("specialization").setValue(new StringType(values2[3]));
        }
        if (values2.length > 5 && !Utilities.noString(values2[5])) {
            cc.setDefinition(values2[5]);
        }
    }
}

