/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.TestScript;

public class TestScript40_50
extends VersionConvertor_40_50 {
    public static TestScript convertTestScript(org.hl7.fhir.r4.model.TestScript src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript tgt = new TestScript();
        TestScript40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(TestScript40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(TestScript40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(TestScript40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(TestScript40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(TestScript40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(TestScript40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(TestScript40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(TestScript40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(TestScript40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(TestScript40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(TestScript40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(TestScript40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(TestScript40_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (TestScript.TestScriptOriginComponent testScriptOriginComponent : src.getOrigin()) {
            tgt.addOrigin(TestScript40_50.convertTestScriptOriginComponent(testScriptOriginComponent));
        }
        for (TestScript.TestScriptDestinationComponent testScriptDestinationComponent : src.getDestination()) {
            tgt.addDestination(TestScript40_50.convertTestScriptDestinationComponent(testScriptDestinationComponent));
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript40_50.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript40_50.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getProfile()) {
            tgt.addProfile(TestScript40_50.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript40_50.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript40_50.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript40_50.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript40_50.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.TestScript convertTestScript(TestScript src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.TestScript tgt = new org.hl7.fhir.r4.model.TestScript();
        TestScript40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(TestScript40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(TestScript40_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(TestScript40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(TestScript40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(TestScript40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(TestScript40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(TestScript40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(TestScript40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(TestScript40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(TestScript40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(TestScript40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(TestScript40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(TestScript40_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (TestScript.TestScriptOriginComponent testScriptOriginComponent : src.getOrigin()) {
            tgt.addOrigin(TestScript40_50.convertTestScriptOriginComponent(testScriptOriginComponent));
        }
        for (TestScript.TestScriptDestinationComponent testScriptDestinationComponent : src.getDestination()) {
            tgt.addDestination(TestScript40_50.convertTestScriptDestinationComponent(testScriptDestinationComponent));
        }
        if (src.hasMetadata()) {
            tgt.setMetadata(TestScript40_50.convertTestScriptMetadataComponent(src.getMetadata()));
        }
        for (TestScript.TestScriptFixtureComponent testScriptFixtureComponent : src.getFixture()) {
            tgt.addFixture(TestScript40_50.convertTestScriptFixtureComponent(testScriptFixtureComponent));
        }
        for (Reference reference : src.getProfile()) {
            tgt.addProfile(TestScript40_50.convertReference(reference));
        }
        for (TestScript.TestScriptVariableComponent testScriptVariableComponent : src.getVariable()) {
            tgt.addVariable(TestScript40_50.convertTestScriptVariableComponent(testScriptVariableComponent));
        }
        if (src.hasSetup()) {
            tgt.setSetup(TestScript40_50.convertTestScriptSetupComponent(src.getSetup()));
        }
        for (TestScript.TestScriptTestComponent testScriptTestComponent : src.getTest()) {
            tgt.addTest(TestScript40_50.convertTestScriptTestComponent(testScriptTestComponent));
        }
        if (src.hasTeardown()) {
            tgt.setTeardown(TestScript40_50.convertTestScriptTeardownComponent(src.getTeardown()));
        }
        return tgt;
    }

    public static TestScript.TestScriptOriginComponent convertTestScriptOriginComponent(TestScript.TestScriptOriginComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptOriginComponent tgt = new TestScript.TestScriptOriginComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIndex()) {
            tgt.setIndexElement(TestScript40_50.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(TestScript40_50.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptOriginComponent convertTestScriptOriginComponent(TestScript.TestScriptOriginComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptOriginComponent tgt = new TestScript.TestScriptOriginComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIndex()) {
            tgt.setIndexElement(TestScript40_50.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(TestScript40_50.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptDestinationComponent convertTestScriptDestinationComponent(TestScript.TestScriptDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptDestinationComponent tgt = new TestScript.TestScriptDestinationComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIndex()) {
            tgt.setIndexElement(TestScript40_50.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(TestScript40_50.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptDestinationComponent convertTestScriptDestinationComponent(TestScript.TestScriptDestinationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptDestinationComponent tgt = new TestScript.TestScriptDestinationComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasIndex()) {
            tgt.setIndexElement(TestScript40_50.convertInteger(src.getIndexElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfile(TestScript40_50.convertCoding(src.getProfile()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript40_50.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript40_50.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        for (TestScript.TestScriptMetadataLinkComponent testScriptMetadataLinkComponent : src.getLink()) {
            tgt.addLink(TestScript40_50.convertTestScriptMetadataLinkComponent(testScriptMetadataLinkComponent));
        }
        for (TestScript.TestScriptMetadataCapabilityComponent testScriptMetadataCapabilityComponent : src.getCapability()) {
            tgt.addCapability(TestScript40_50.convertTestScriptMetadataCapabilityComponent(testScriptMetadataCapabilityComponent));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(TestScript40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(TestScript40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRequired()) {
            tgt.setRequiredElement(TestScript40_50.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidated()) {
            tgt.setValidatedElement(TestScript40_50.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r4.model.IntegerType integerType : src.getOrigin()) {
            tgt.getOrigin().add(TestScript40_50.convertInteger(integerType));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(TestScript40_50.convertInteger(src.getDestinationElement()));
        }
        for (UriType uriType : src.getLink()) {
            tgt.getLink().add(TestScript40_50.convertUri(uriType));
        }
        if (src.hasCapabilities()) {
            tgt.setCapabilitiesElement(TestScript40_50.convertCanonical(src.getCapabilitiesElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasRequired()) {
            tgt.setRequiredElement(TestScript40_50.convertBoolean(src.getRequiredElement()));
        }
        if (src.hasValidated()) {
            tgt.setValidatedElement(TestScript40_50.convertBoolean(src.getValidatedElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        for (IntegerType integerType : src.getOrigin()) {
            tgt.getOrigin().add(TestScript40_50.convertInteger(integerType));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(TestScript40_50.convertInteger(src.getDestinationElement()));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getLink()) {
            tgt.getLink().add(TestScript40_50.convertUri(uriType));
        }
        if (src.hasCapabilities()) {
            tgt.setCapabilitiesElement(TestScript40_50.convertCanonical(src.getCapabilitiesElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAutocreate()) {
            tgt.setAutocreateElement(TestScript40_50.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodelete()) {
            tgt.setAutodeleteElement(TestScript40_50.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(TestScript40_50.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAutocreate()) {
            tgt.setAutocreateElement(TestScript40_50.convertBoolean(src.getAutocreateElement()));
        }
        if (src.hasAutodelete()) {
            tgt.setAutodeleteElement(TestScript40_50.convertBoolean(src.getAutodeleteElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(TestScript40_50.convertReference(src.getResource()));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TestScript40_50.convertString(src.getNameElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValueElement(TestScript40_50.convertString(src.getDefaultValueElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(TestScript40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(TestScript40_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasHint()) {
            tgt.setHintElement(TestScript40_50.convertString(src.getHintElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(TestScript40_50.convertString(src.getPathElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(TestScript40_50.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TestScript40_50.convertString(src.getNameElement()));
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValueElement(TestScript40_50.convertString(src.getDefaultValueElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(TestScript40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(TestScript40_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasHint()) {
            tgt.setHintElement(TestScript40_50.convertString(src.getHintElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(TestScript40_50.convertString(src.getPathElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(TestScript40_50.convertId(src.getSourceIdElement()));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(TestScript40_50.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(TestScript40_50.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript40_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.SetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript40_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(TestScript40_50.convertCoding(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResource(TestScript.FHIRDefinedType.fromCode(src.getResource()));
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(TestScript40_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAcceptElement(TestScript40_50.convertCode(src.getAcceptElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript40_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(TestScript40_50.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrlElement(TestScript40_50.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethodElement(TestScript40_50.convertTestScriptRequestMethodCode(src.getMethodElement()));
        }
        if (src.hasOrigin()) {
            tgt.setOriginElement(TestScript40_50.convertInteger(src.getOriginElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(TestScript40_50.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(TestScript40_50.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasRequestId()) {
            tgt.setRequestIdElement(TestScript40_50.convertId(src.getRequestIdElement()));
        }
        if (src.hasResponseId()) {
            tgt.setResponseIdElement(TestScript40_50.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(TestScript40_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetIdElement(TestScript40_50.convertId(src.getTargetIdElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(TestScript40_50.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(TestScript40_50.convertCoding(src.getType()));
        }
        if (src.hasResource()) {
            tgt.setResource(src.getResource().toCode());
        }
        if (src.hasLabel()) {
            tgt.setLabelElement(TestScript40_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasAccept()) {
            tgt.setAcceptElement(TestScript40_50.convertCode(src.getAcceptElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript40_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasDestination()) {
            tgt.setDestinationElement(TestScript40_50.convertInteger(src.getDestinationElement()));
        }
        if (src.hasEncodeRequestUrl()) {
            tgt.setEncodeRequestUrlElement(TestScript40_50.convertBoolean(src.getEncodeRequestUrlElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethodElement(TestScript40_50.convertTestScriptRequestMethodCode(src.getMethodElement()));
        }
        if (src.hasOrigin()) {
            tgt.setOriginElement(TestScript40_50.convertInteger(src.getOriginElement()));
        }
        if (src.hasParams()) {
            tgt.setParamsElement(TestScript40_50.convertString(src.getParamsElement()));
        }
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(TestScript40_50.convertSetupActionOperationRequestHeaderComponent(t));
        }
        if (src.hasRequestId()) {
            tgt.setRequestIdElement(TestScript40_50.convertId(src.getRequestIdElement()));
        }
        if (src.hasResponseId()) {
            tgt.setResponseIdElement(TestScript40_50.convertId(src.getResponseIdElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(TestScript40_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasTargetId()) {
            tgt.setTargetIdElement(TestScript40_50.convertId(src.getTargetIdElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(TestScript40_50.convertString(src.getUrlElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestScript.TestScriptRequestMethodCode> convertTestScriptRequestMethodCode(Enumeration<TestScript.TestScriptRequestMethodCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestScript.TestScriptRequestMethodCode> tgt = new org.hl7.fhir.r5.model.Enumeration<TestScript.TestScriptRequestMethodCode>(new TestScript.TestScriptRequestMethodCodeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.TestScriptRequestMethodCode)((Object)src.getValue())) {
            case DELETE: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.DELETE);
                break;
            }
            case GET: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.GET);
                break;
            }
            case OPTIONS: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.OPTIONS);
                break;
            }
            case PATCH: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PATCH);
                break;
            }
            case POST: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.POST);
                break;
            }
            case PUT: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PUT);
                break;
            }
            case HEAD: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.HEAD);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.TestScriptRequestMethodCode> convertTestScriptRequestMethodCode(org.hl7.fhir.r5.model.Enumeration<TestScript.TestScriptRequestMethodCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.TestScriptRequestMethodCode> tgt = new Enumeration<TestScript.TestScriptRequestMethodCode>(new TestScript.TestScriptRequestMethodCodeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.TestScriptRequestMethodCode)((Object)src.getValue())) {
            case DELETE: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.DELETE);
                break;
            }
            case GET: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.GET);
                break;
            }
            case OPTIONS: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.OPTIONS);
                break;
            }
            case PATCH: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PATCH);
                break;
            }
            case POST: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.POST);
                break;
            }
            case PUT: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.PUT);
                break;
            }
            case HEAD: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.HEAD);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.TestScriptRequestMethodCode.NULL);
            }
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasField()) {
            tgt.setFieldElement(TestScript40_50.convertString(src.getFieldElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(TestScript40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasField()) {
            tgt.setFieldElement(TestScript40_50.convertString(src.getFieldElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(TestScript40_50.convertString(src.getValueElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(TestScript40_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(TestScript40_50.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceIdElement(TestScript40_50.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourceExpression()) {
            tgt.setCompareToSourceExpressionElement(TestScript40_50.convertString(src.getCompareToSourceExpressionElement()));
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePathElement(TestScript40_50.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript40_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(TestScript40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(TestScript40_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumIdElement(TestScript40_50.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinksElement(TestScript40_50.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(TestScript40_50.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(TestScript40_50.convertString(src.getPathElement()));
        }
        if (src.hasRequestMethod()) {
            tgt.setRequestMethodElement(TestScript40_50.convertTestScriptRequestMethodCode(src.getRequestMethodElement()));
        }
        if (src.hasRequestURL()) {
            tgt.setRequestURLElement(TestScript40_50.convertString(src.getRequestURLElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(TestScript.FHIRDefinedType.fromCode(src.getResource()));
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(TestScript40_50.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCode()) {
            tgt.setResponseCodeElement(TestScript40_50.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(TestScript40_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileIdElement(TestScript40_50.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(TestScript40_50.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnlyElement(TestScript40_50.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLabel()) {
            tgt.setLabelElement(TestScript40_50.convertString(src.getLabelElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasDirection()) {
            tgt.setDirectionElement(TestScript40_50.convertAssertionDirectionType(src.getDirectionElement()));
        }
        if (src.hasCompareToSourceId()) {
            tgt.setCompareToSourceIdElement(TestScript40_50.convertString(src.getCompareToSourceIdElement()));
        }
        if (src.hasCompareToSourceExpression()) {
            tgt.setCompareToSourceExpressionElement(TestScript40_50.convertString(src.getCompareToSourceExpressionElement()));
        }
        if (src.hasCompareToSourcePath()) {
            tgt.setCompareToSourcePathElement(TestScript40_50.convertString(src.getCompareToSourcePathElement()));
        }
        if (src.hasContentType()) {
            tgt.setContentTypeElement(TestScript40_50.convertCode(src.getContentTypeElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(TestScript40_50.convertString(src.getExpressionElement()));
        }
        if (src.hasHeaderField()) {
            tgt.setHeaderFieldElement(TestScript40_50.convertString(src.getHeaderFieldElement()));
        }
        if (src.hasMinimumId()) {
            tgt.setMinimumIdElement(TestScript40_50.convertString(src.getMinimumIdElement()));
        }
        if (src.hasNavigationLinks()) {
            tgt.setNavigationLinksElement(TestScript40_50.convertBoolean(src.getNavigationLinksElement()));
        }
        if (src.hasOperator()) {
            tgt.setOperatorElement(TestScript40_50.convertAssertionOperatorType(src.getOperatorElement()));
        }
        if (src.hasPath()) {
            tgt.setPathElement(TestScript40_50.convertString(src.getPathElement()));
        }
        if (src.hasRequestMethod()) {
            tgt.setRequestMethodElement(TestScript40_50.convertTestScriptRequestMethodCode(src.getRequestMethodElement()));
        }
        if (src.hasRequestURL()) {
            tgt.setRequestURLElement(TestScript40_50.convertString(src.getRequestURLElement()));
        }
        if (src.hasResource()) {
            tgt.setResource(src.getResource().toCode());
        }
        if (src.hasResponse()) {
            tgt.setResponseElement(TestScript40_50.convertAssertionResponseTypes(src.getResponseElement()));
        }
        if (src.hasResponseCode()) {
            tgt.setResponseCodeElement(TestScript40_50.convertString(src.getResponseCodeElement()));
        }
        if (src.hasSourceId()) {
            tgt.setSourceIdElement(TestScript40_50.convertId(src.getSourceIdElement()));
        }
        if (src.hasValidateProfileId()) {
            tgt.setValidateProfileIdElement(TestScript40_50.convertId(src.getValidateProfileIdElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(TestScript40_50.convertString(src.getValueElement()));
        }
        if (src.hasWarningOnly()) {
            tgt.setWarningOnlyElement(TestScript40_50.convertBoolean(src.getWarningOnlyElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionDirectionType> tgt = new org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionDirectionType> convertAssertionDirectionType(org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionDirectionType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionDirectionType> tgt = new Enumeration<TestScript.AssertionDirectionType>(new TestScript.AssertionDirectionTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionDirectionType)((Object)src.getValue())) {
            case RESPONSE: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.RESPONSE);
                break;
            }
            case REQUEST: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.REQUEST);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionDirectionType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionOperatorType> tgt = new org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            case EVAL: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EVAL);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionOperatorType> convertAssertionOperatorType(org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionOperatorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionOperatorType> tgt = new Enumeration<TestScript.AssertionOperatorType>(new TestScript.AssertionOperatorTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionOperatorType)((Object)src.getValue())) {
            case EQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EQUALS);
                break;
            }
            case NOTEQUALS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEQUALS);
                break;
            }
            case IN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTIN);
                break;
            }
            case GREATERTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.GREATERTHAN);
                break;
            }
            case LESSTHAN: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.LESSTHAN);
                break;
            }
            case EMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EMPTY);
                break;
            }
            case NOTEMPTY: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTEMPTY);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.CONTAINS);
                break;
            }
            case NOTCONTAINS: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NOTCONTAINS);
                break;
            }
            case EVAL: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.EVAL);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionOperatorType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionResponseTypes> tgt = new org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<TestScript.AssertionResponseTypes> convertAssertionResponseTypes(org.hl7.fhir.r5.model.Enumeration<TestScript.AssertionResponseTypes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<TestScript.AssertionResponseTypes> tgt = new Enumeration<TestScript.AssertionResponseTypes>(new TestScript.AssertionResponseTypesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((TestScript.AssertionResponseTypes)((Object)src.getValue())) {
            case OKAY: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.OKAY);
                break;
            }
            case CREATED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CREATED);
                break;
            }
            case NOCONTENT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOCONTENT);
                break;
            }
            case NOTMODIFIED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTMODIFIED);
                break;
            }
            case BAD: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.BAD);
                break;
            }
            case FORBIDDEN: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.FORBIDDEN);
                break;
            }
            case NOTFOUND: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NOTFOUND);
                break;
            }
            case METHODNOTALLOWED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.METHODNOTALLOWED);
                break;
            }
            case CONFLICT: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.CONFLICT);
                break;
            }
            case GONE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.GONE);
                break;
            }
            case PRECONDITIONFAILED: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.PRECONDITIONFAILED);
                break;
            }
            case UNPROCESSABLE: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.UNPROCESSABLE);
                break;
            }
            default: {
                tgt.setValue((Object)TestScript.AssertionResponseTypes.NULL);
            }
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TestScript40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(TestScript40_50.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(TestScript40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(TestScript40_50.convertString(src.getDescriptionElement()));
        }
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(TestScript40_50.convertTestActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript40_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        if (src.hasAssert()) {
            tgt.setAssert(TestScript40_50.convertSetupActionAssertComponent(src.getAssert()));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestScript40_50.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(TestScript40_50.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }

    public static TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        TestScript40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOperation()) {
            tgt.setOperation(TestScript40_50.convertSetupActionOperationComponent(src.getOperation()));
        }
        return tgt;
    }
}

