/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r5.model.Slot;

public class Slot40_50
extends VersionConvertor_40_50 {
    public static Slot convertSlot(org.hl7.fhir.r4.model.Slot src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Slot tgt = new Slot();
        Slot40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Slot40_50.convertIdentifier(identifier));
        }
        for (CodeableConcept codeableConcept : src.getServiceCategory()) {
            tgt.addServiceCategory(Slot40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(Slot40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(Slot40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(Slot40_50.convertCodeableConcept(src.getAppointmentType()));
        }
        if (src.hasSchedule()) {
            tgt.setSchedule(Slot40_50.convertReference(src.getSchedule()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Slot40_50.convertSlotStatus(src.getStatusElement()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(Slot40_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(Slot40_50.convertInstant(src.getEndElement()));
        }
        if (src.hasOverbooked()) {
            tgt.setOverbookedElement(Slot40_50.convertBoolean(src.getOverbookedElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(Slot40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Slot convertSlot(Slot src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Slot tgt = new org.hl7.fhir.r4.model.Slot();
        Slot40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Slot40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getServiceCategory()) {
            tgt.addServiceCategory(Slot40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getServiceType()) {
            tgt.addServiceType(Slot40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getSpecialty()) {
            tgt.addSpecialty(Slot40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasAppointmentType()) {
            tgt.setAppointmentType(Slot40_50.convertCodeableConcept(src.getAppointmentType()));
        }
        if (src.hasSchedule()) {
            tgt.setSchedule(Slot40_50.convertReference(src.getSchedule()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Slot40_50.convertSlotStatus(src.getStatusElement()));
        }
        if (src.hasStart()) {
            tgt.setStartElement(Slot40_50.convertInstant(src.getStartElement()));
        }
        if (src.hasEnd()) {
            tgt.setEndElement(Slot40_50.convertInstant(src.getEndElement()));
        }
        if (src.hasOverbooked()) {
            tgt.setOverbookedElement(Slot40_50.convertBoolean(src.getOverbookedElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(Slot40_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Slot.SlotStatus> convertSlotStatus(Enumeration<Slot.SlotStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Slot.SlotStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Slot.SlotStatus>(new Slot.SlotStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Slot.SlotStatus)((Object)src.getValue())) {
            case BUSY: {
                tgt.setValue((Object)Slot.SlotStatus.BUSY);
                break;
            }
            case FREE: {
                tgt.setValue((Object)Slot.SlotStatus.FREE);
                break;
            }
            case BUSYUNAVAILABLE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYUNAVAILABLE);
                break;
            }
            case BUSYTENTATIVE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYTENTATIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Slot.SlotStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Slot.SlotStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Slot.SlotStatus> convertSlotStatus(org.hl7.fhir.r5.model.Enumeration<Slot.SlotStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Slot.SlotStatus> tgt = new Enumeration<Slot.SlotStatus>(new Slot.SlotStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Slot.SlotStatus)((Object)src.getValue())) {
            case BUSY: {
                tgt.setValue((Object)Slot.SlotStatus.BUSY);
                break;
            }
            case FREE: {
                tgt.setValue((Object)Slot.SlotStatus.FREE);
                break;
            }
            case BUSYUNAVAILABLE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYUNAVAILABLE);
                break;
            }
            case BUSYTENTATIVE: {
                tgt.setValue((Object)Slot.SlotStatus.BUSYTENTATIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Slot.SlotStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Slot.SlotStatus.NULL);
            }
        }
        return tgt;
    }
}

