/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.RiskAssessment;

public class RiskAssessment40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.RiskAssessment convertRiskAssessment(RiskAssessment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.RiskAssessment tgt = new org.hl7.fhir.r5.model.RiskAssessment();
        RiskAssessment40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(RiskAssessment40_50.convertIdentifier(identifier));
        }
        if (src.hasBasedOn()) {
            tgt.setBasedOn(RiskAssessment40_50.convertReference(src.getBasedOn()));
        }
        if (src.hasParent()) {
            tgt.setParent(RiskAssessment40_50.convertReference(src.getParent()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(RiskAssessment40_50.convertRiskAssessmentStatus(src.getStatusElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(RiskAssessment40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasCode()) {
            tgt.setCode(RiskAssessment40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(RiskAssessment40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(RiskAssessment40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(RiskAssessment40_50.convertType(src.getOccurrence()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(RiskAssessment40_50.convertReference(src.getCondition()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(RiskAssessment40_50.convertReference(src.getPerformer()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(RiskAssessment40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(RiskAssessment40_50.convertReferenceToCodeableReference(reference));
        }
        for (Reference reference : src.getBasis()) {
            tgt.addBasis(RiskAssessment40_50.convertReference(reference));
        }
        for (RiskAssessment.RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : src.getPrediction()) {
            tgt.addPrediction(RiskAssessment40_50.convertRiskAssessmentPredictionComponent(riskAssessmentPredictionComponent));
        }
        if (src.hasMitigation()) {
            tgt.setMitigationElement(RiskAssessment40_50.convertString(src.getMitigationElement()));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(RiskAssessment40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static RiskAssessment convertRiskAssessment(org.hl7.fhir.r5.model.RiskAssessment src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment tgt = new RiskAssessment();
        RiskAssessment40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(RiskAssessment40_50.convertIdentifier(identifier));
        }
        if (src.hasBasedOn()) {
            tgt.setBasedOn(RiskAssessment40_50.convertReference(src.getBasedOn()));
        }
        if (src.hasParent()) {
            tgt.setParent(RiskAssessment40_50.convertReference(src.getParent()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(RiskAssessment40_50.convertRiskAssessmentStatus(src.getStatusElement()));
        }
        if (src.hasMethod()) {
            tgt.setMethod(RiskAssessment40_50.convertCodeableConcept(src.getMethod()));
        }
        if (src.hasCode()) {
            tgt.setCode(RiskAssessment40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(RiskAssessment40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(RiskAssessment40_50.convertReference(src.getEncounter()));
        }
        if (src.hasOccurrence()) {
            tgt.setOccurrence(RiskAssessment40_50.convertType(src.getOccurrence()));
        }
        if (src.hasCondition()) {
            tgt.setCondition(RiskAssessment40_50.convertReference(src.getCondition()));
        }
        if (src.hasPerformer()) {
            tgt.setPerformer(RiskAssessment40_50.convertReference(src.getPerformer()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(RiskAssessment40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(RiskAssessment40_50.convertReference(codeableReference.getReference()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasis()) {
            tgt.addBasis(RiskAssessment40_50.convertReference(reference));
        }
        for (RiskAssessment.RiskAssessmentPredictionComponent riskAssessmentPredictionComponent : src.getPrediction()) {
            tgt.addPrediction(RiskAssessment40_50.convertRiskAssessmentPredictionComponent(riskAssessmentPredictionComponent));
        }
        if (src.hasMitigation()) {
            tgt.setMitigationElement(RiskAssessment40_50.convertString(src.getMitigationElement()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(RiskAssessment40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> convertRiskAssessmentStatus(Enumeration<RiskAssessment.RiskAssessmentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus>(new Enumerations.ObservationStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((RiskAssessment.RiskAssessmentStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.ObservationStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.ObservationStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Enumerations.ObservationStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.ObservationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Enumerations.ObservationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ObservationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<RiskAssessment.RiskAssessmentStatus> convertRiskAssessmentStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.ObservationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<RiskAssessment.RiskAssessmentStatus> tgt = new Enumeration<RiskAssessment.RiskAssessmentStatus>(new RiskAssessment.RiskAssessmentStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ObservationStatus)((Object)src.getValue())) {
            case REGISTERED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.REGISTERED);
                break;
            }
            case PRELIMINARY: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.AMENDED);
                break;
            }
            case CORRECTED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.CORRECTED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)RiskAssessment.RiskAssessmentStatus.NULL);
            }
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        RiskAssessment40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOutcome()) {
            tgt.setOutcome(RiskAssessment40_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(RiskAssessment40_50.convertType(src.getProbability()));
        }
        if (src.hasQualitativeRisk()) {
            tgt.setQualitativeRisk(RiskAssessment40_50.convertCodeableConcept(src.getQualitativeRisk()));
        }
        if (src.hasRelativeRisk()) {
            tgt.setRelativeRiskElement(RiskAssessment40_50.convertDecimal(src.getRelativeRiskElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(RiskAssessment40_50.convertType(src.getWhen()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(RiskAssessment40_50.convertString(src.getRationaleElement()));
        }
        return tgt;
    }

    public static RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        RiskAssessment40_50.copyElement(src, tgt, new String[0]);
        if (src.hasOutcome()) {
            tgt.setOutcome(RiskAssessment40_50.convertCodeableConcept(src.getOutcome()));
        }
        if (src.hasProbability()) {
            tgt.setProbability(RiskAssessment40_50.convertType(src.getProbability()));
        }
        if (src.hasQualitativeRisk()) {
            tgt.setQualitativeRisk(RiskAssessment40_50.convertCodeableConcept(src.getQualitativeRisk()));
        }
        if (src.hasRelativeRisk()) {
            tgt.setRelativeRiskElement(RiskAssessment40_50.convertDecimal(src.getRelativeRiskElement()));
        }
        if (src.hasWhen()) {
            tgt.setWhen(RiskAssessment40_50.convertType(src.getWhen()));
        }
        if (src.hasRationale()) {
            tgt.setRationaleElement(RiskAssessment40_50.convertString(src.getRationaleElement()));
        }
        return tgt;
    }
}

