/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.RelatedPerson;

public class RelatedPerson40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.RelatedPerson convertRelatedPerson(RelatedPerson src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.RelatedPerson tgt = new org.hl7.fhir.r5.model.RelatedPerson();
        RelatedPerson40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(RelatedPerson40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(RelatedPerson40_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(RelatedPerson40_50.convertReference(src.getPatient()));
        }
        for (CodeableConcept codeableConcept : src.getRelationship()) {
            tgt.addRelationship(RelatedPerson40_50.convertCodeableConcept(codeableConcept));
        }
        for (HumanName humanName : src.getName()) {
            tgt.addName(RelatedPerson40_50.convertHumanName(humanName));
        }
        for (ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(RelatedPerson40_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(RelatedPerson40_50.convertDate(src.getBirthDateElement()));
        }
        for (org.hl7.fhir.r4.model.Address address : src.getAddress()) {
            tgt.addAddress(RelatedPerson40_50.convertAddress(address));
        }
        for (org.hl7.fhir.r4.model.Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(RelatedPerson40_50.convertAttachment(attachment));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(RelatedPerson40_50.convertPeriod(src.getPeriod()));
        }
        for (RelatedPerson.RelatedPersonCommunicationComponent relatedPersonCommunicationComponent : src.getCommunication()) {
            tgt.addCommunication(RelatedPerson40_50.convertRelatedPersonCommunicationComponent(relatedPersonCommunicationComponent));
        }
        return tgt;
    }

    public static RelatedPerson convertRelatedPerson(org.hl7.fhir.r5.model.RelatedPerson src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RelatedPerson tgt = new RelatedPerson();
        RelatedPerson40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(RelatedPerson40_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(RelatedPerson40_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(RelatedPerson40_50.convertReference(src.getPatient()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getRelationship()) {
            tgt.addRelationship(RelatedPerson40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.HumanName humanName : src.getName()) {
            tgt.addName(RelatedPerson40_50.convertHumanName(humanName));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getTelecom()) {
            tgt.addTelecom(RelatedPerson40_50.convertContactPoint(contactPoint));
        }
        if (src.hasGender()) {
            tgt.setGenderElement(Enumerations40_50.convertAdministrativeGender(src.getGenderElement()));
        }
        if (src.hasBirthDate()) {
            tgt.setBirthDateElement(RelatedPerson40_50.convertDate(src.getBirthDateElement()));
        }
        for (Address address : src.getAddress()) {
            tgt.addAddress(RelatedPerson40_50.convertAddress(address));
        }
        for (Attachment attachment : src.getPhoto()) {
            tgt.addPhoto(RelatedPerson40_50.convertAttachment(attachment));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(RelatedPerson40_50.convertPeriod(src.getPeriod()));
        }
        for (RelatedPerson.RelatedPersonCommunicationComponent relatedPersonCommunicationComponent : src.getCommunication()) {
            tgt.addCommunication(RelatedPerson40_50.convertRelatedPersonCommunicationComponent(relatedPersonCommunicationComponent));
        }
        return tgt;
    }

    public static RelatedPerson.RelatedPersonCommunicationComponent convertRelatedPersonCommunicationComponent(RelatedPerson.RelatedPersonCommunicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RelatedPerson.RelatedPersonCommunicationComponent tgt = new RelatedPerson.RelatedPersonCommunicationComponent();
        RelatedPerson40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguage(RelatedPerson40_50.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(RelatedPerson40_50.convertBoolean(src.getPreferredElement()));
        }
        return tgt;
    }

    public static RelatedPerson.RelatedPersonCommunicationComponent convertRelatedPersonCommunicationComponent(RelatedPerson.RelatedPersonCommunicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        RelatedPerson.RelatedPersonCommunicationComponent tgt = new RelatedPerson.RelatedPersonCommunicationComponent();
        RelatedPerson40_50.copyElement(src, tgt, new String[0]);
        if (src.hasLanguage()) {
            tgt.setLanguage(RelatedPerson40_50.convertCodeableConcept(src.getLanguage()));
        }
        if (src.hasPreferred()) {
            tgt.setPreferredElement(RelatedPerson40_50.convertBoolean(src.getPreferredElement()));
        }
        return tgt;
    }
}

