/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Dosage;
import org.hl7.fhir.r5.model.MedicationUsage;

public class MedicationStatement40_50
extends VersionConvertor_40_50 {
    public static MedicationUsage convertMedicationStatement(MedicationStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationUsage tgt = new MedicationUsage();
        MedicationStatement40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicationStatement40_50.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(MedicationStatement40_50.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(MedicationStatement40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement40_50.convertMedicationStatementStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getStatusReason()) {
            tgt.addStatusReason(MedicationStatement40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCategory()) {
            tgt.addCategory(MedicationStatement40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedicationCodeableConcept()) {
            tgt.getMedication().setConcept(MedicationStatement40_50.convertCodeableConcept(src.getMedicationCodeableConcept()));
        }
        if (src.hasMedicationReference()) {
            tgt.getMedication().setReference(MedicationStatement40_50.convertReference(src.getMedicationReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MedicationStatement40_50.convertReference(src.getSubject()));
        }
        if (src.hasContext()) {
            tgt.setEncounter(MedicationStatement40_50.convertReference(src.getContext()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(MedicationStatement40_50.convertType(src.getEffective()));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(MedicationStatement40_50.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(MedicationStatement40_50.convertReference(src.getInformationSource()));
        }
        for (Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(MedicationStatement40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(MedicationStatement40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(MedicationStatement40_50.convertReferenceToCodeableReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(MedicationStatement40_50.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.r4.model.Dosage dosage : src.getDosage()) {
            tgt.addDosage(MedicationStatement40_50.convertDosage(dosage));
        }
        return tgt;
    }

    public static MedicationStatement convertMedicationStatement(MedicationUsage src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationStatement tgt = new MedicationStatement();
        MedicationStatement40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(MedicationStatement40_50.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(MedicationStatement40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(MedicationStatement40_50.convertReference(reference));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement40_50.convertMedicationStatementStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getStatusReason()) {
            tgt.addStatusReason(MedicationStatement40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCategory()) {
            tgt.setCategory(MedicationStatement40_50.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        if (src.getMedication().hasConcept()) {
            tgt.setMedication(MedicationStatement40_50.convertType(src.getMedication().getConcept()));
        }
        if (src.getMedication().hasReference()) {
            tgt.setMedication(MedicationStatement40_50.convertType(src.getMedication().getReference()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(MedicationStatement40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setContext(MedicationStatement40_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(MedicationStatement40_50.convertType(src.getEffective()));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(MedicationStatement40_50.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(MedicationStatement40_50.convertReference(src.getInformationSource()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(MedicationStatement40_50.convertReference(reference));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(MedicationStatement40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(MedicationStatement40_50.convertReference(codeableReference.getReference()));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(MedicationStatement40_50.convertAnnotation(annotation));
        }
        for (Dosage dosage : src.getDosage()) {
            tgt.addDosage(MedicationStatement40_50.convertDosage(dosage));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> convertMedicationStatementStatus(Enumeration<MedicationStatement.MedicationStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes>(new MedicationUsage.MedicationUsageStatusCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationStatement.MedicationStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.COMPLETED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.UNKNOWN);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.UNKNOWN);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.UNKNOWN);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.UNKNOWN);
                break;
            }
            case NOTTAKEN: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.COMPLETED);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationUsage.MedicationUsageStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationStatement.MedicationStatementStatus> convertMedicationStatementStatus(org.hl7.fhir.r5.model.Enumeration<MedicationUsage.MedicationUsageStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationStatement.MedicationStatementStatus> tgt = new Enumeration<MedicationStatement.MedicationStatementStatus>(new MedicationStatement.MedicationStatementStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((MedicationUsage.MedicationUsageStatusCodes)((Object)src.getValue())) {
            case COMPLETED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NULL);
            }
        }
        return tgt;
    }
}

