/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Goal;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Goal;

public class Goal40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Goal convertGoal(Goal src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Goal tgt = new org.hl7.fhir.r5.model.Goal();
        Goal40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Goal40_50.convertIdentifier(identifier));
        }
        if (src.hasLifecycleStatus()) {
            tgt.setLifecycleStatusElement(Goal40_50.convertGoalLifecycleStatus(src.getLifecycleStatusElement()));
        }
        if (src.hasAchievementStatus()) {
            tgt.setAchievementStatus(Goal40_50.convertCodeableConcept(src.getAchievementStatus()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Goal40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriority(Goal40_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(Goal40_50.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Goal40_50.convertReference(src.getSubject()));
        }
        if (src.hasStart()) {
            tgt.setStart(Goal40_50.convertType(src.getStart()));
        }
        for (Goal.GoalTargetComponent goalTargetComponent : src.getTarget()) {
            tgt.addTarget(Goal40_50.convertGoalTargetComponent(goalTargetComponent));
        }
        if (src.hasStatusDate()) {
            tgt.setStatusDateElement(Goal40_50.convertDate(src.getStatusDateElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReasonElement(Goal40_50.convertString(src.getStatusReasonElement()));
        }
        for (Reference reference : src.getAddresses()) {
            tgt.addAddresses(Goal40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(Goal40_50.convertAnnotation(annotation));
        }
        for (CodeableConcept codeableConcept : src.getOutcomeCode()) {
            tgt.addOutcome(Goal40_50.convertCodeableConceptToCodeableReference(codeableConcept));
        }
        for (Reference reference : src.getOutcomeReference()) {
            tgt.addOutcome(Goal40_50.convertReferenceToCodeableReference(reference));
        }
        return tgt;
    }

    public static Goal convertGoal(org.hl7.fhir.r5.model.Goal src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal tgt = new Goal();
        Goal40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Goal40_50.convertIdentifier(identifier));
        }
        if (src.hasLifecycleStatus()) {
            tgt.setLifecycleStatusElement(Goal40_50.convertGoalLifecycleStatus(src.getLifecycleStatusElement()));
        }
        if (src.hasAchievementStatus()) {
            tgt.setAchievementStatus(Goal40_50.convertCodeableConcept(src.getAchievementStatus()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(Goal40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPriority()) {
            tgt.setPriority(Goal40_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(Goal40_50.convertCodeableConcept(src.getDescription()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(Goal40_50.convertReference(src.getSubject()));
        }
        if (src.hasStart()) {
            tgt.setStart(Goal40_50.convertType(src.getStart()));
        }
        for (Goal.GoalTargetComponent goalTargetComponent : src.getTarget()) {
            tgt.addTarget(Goal40_50.convertGoalTargetComponent(goalTargetComponent));
        }
        if (src.hasStatusDate()) {
            tgt.setStatusDateElement(Goal40_50.convertDate(src.getStatusDateElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReasonElement(Goal40_50.convertString(src.getStatusReasonElement()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getAddresses()) {
            tgt.addAddresses(Goal40_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(Goal40_50.convertAnnotation(annotation));
        }
        for (CodeableReference codeableReference : src.getOutcome()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addOutcomeCode(Goal40_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getOutcome()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addOutcomeReference(Goal40_50.convertReference(codeableReference.getReference()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Goal.GoalLifecycleStatus> convertGoalLifecycleStatus(Enumeration<Goal.GoalLifecycleStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Goal.GoalLifecycleStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Goal.GoalLifecycleStatus>(new Goal.GoalLifecycleStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Goal.GoalLifecycleStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.PROPOSED);
                break;
            }
            case PLANNED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.PLANNED);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACCEPTED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ENTEREDINERROR);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.REJECTED);
                break;
            }
            default: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Goal.GoalLifecycleStatus> convertGoalLifecycleStatus(org.hl7.fhir.r5.model.Enumeration<Goal.GoalLifecycleStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Goal.GoalLifecycleStatus> tgt = new Enumeration<Goal.GoalLifecycleStatus>(new Goal.GoalLifecycleStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Goal.GoalLifecycleStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.PROPOSED);
                break;
            }
            case PLANNED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.PLANNED);
                break;
            }
            case ACCEPTED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACCEPTED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ACTIVE);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ONHOLD);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.COMPLETED);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.CANCELLED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.ENTEREDINERROR);
                break;
            }
            case REJECTED: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.REJECTED);
                break;
            }
            default: {
                tgt.setValue((Object)Goal.GoalLifecycleStatus.NULL);
            }
        }
        return tgt;
    }

    public static Goal.GoalTargetComponent convertGoalTargetComponent(Goal.GoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal.GoalTargetComponent tgt = new Goal.GoalTargetComponent();
        Goal40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMeasure()) {
            tgt.setMeasure(Goal40_50.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(Goal40_50.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(Goal40_50.convertType(src.getDue()));
        }
        return tgt;
    }

    public static Goal.GoalTargetComponent convertGoalTargetComponent(Goal.GoalTargetComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Goal.GoalTargetComponent tgt = new Goal.GoalTargetComponent();
        Goal40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMeasure()) {
            tgt.setMeasure(Goal40_50.convertCodeableConcept(src.getMeasure()));
        }
        if (src.hasDetail()) {
            tgt.setDetail(Goal40_50.convertType(src.getDetail()));
        }
        if (src.hasDue()) {
            tgt.setDue(Goal40_50.convertType(src.getDue()));
        }
        return tgt;
    }
}

