/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.ExplanationOfBenefit;
import org.hl7.fhir.r4.model.Period;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ExplanationOfBenefit;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.StringType;

public class ExplanationOfBenefit40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ExplanationOfBenefit convertExplanationOfBenefit(ExplanationOfBenefit src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ExplanationOfBenefit tgt = new org.hl7.fhir.r5.model.ExplanationOfBenefit();
        ExplanationOfBenefit40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ExplanationOfBenefit40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ExplanationOfBenefit40_50.convertExplanationOfBenefitStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(ExplanationOfBenefit40_50.convertUse(src.getUseElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(ExplanationOfBenefit40_50.convertReference(src.getPatient()));
        }
        if (src.hasBillablePeriod()) {
            tgt.setBillablePeriod(ExplanationOfBenefit40_50.convertPeriod(src.getBillablePeriod()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(ExplanationOfBenefit40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(ExplanationOfBenefit40_50.convertReference(src.getEnterer()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(ExplanationOfBenefit40_50.convertReference(src.getInsurer()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(ExplanationOfBenefit40_50.convertReference(src.getProvider()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(ExplanationOfBenefit40_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasFundsReserveRequested()) {
            tgt.setFundsReserveRequested(ExplanationOfBenefit40_50.convertCodeableConcept(src.getFundsReserveRequested()));
        }
        if (src.hasFundsReserve()) {
            tgt.setFundsReserve(ExplanationOfBenefit40_50.convertCodeableConcept(src.getFundsReserve()));
        }
        for (ExplanationOfBenefit.RelatedClaimComponent relatedClaimComponent : src.getRelated()) {
            tgt.addRelated(ExplanationOfBenefit40_50.convertRelatedClaimComponent(relatedClaimComponent));
        }
        if (src.hasPrescription()) {
            tgt.setPrescription(ExplanationOfBenefit40_50.convertReference(src.getPrescription()));
        }
        if (src.hasOriginalPrescription()) {
            tgt.setOriginalPrescription(ExplanationOfBenefit40_50.convertReference(src.getOriginalPrescription()));
        }
        if (src.hasPayee()) {
            tgt.setPayee(ExplanationOfBenefit40_50.convertPayeeComponent(src.getPayee()));
        }
        if (src.hasReferral()) {
            tgt.setReferral(ExplanationOfBenefit40_50.convertReference(src.getReferral()));
        }
        if (src.hasFacility()) {
            tgt.setFacility(ExplanationOfBenefit40_50.convertReference(src.getFacility()));
        }
        if (src.hasClaim()) {
            tgt.setClaim(ExplanationOfBenefit40_50.convertReference(src.getClaim()));
        }
        if (src.hasClaimResponse()) {
            tgt.setClaimResponse(ExplanationOfBenefit40_50.convertReference(src.getClaimResponse()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(ExplanationOfBenefit40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(ExplanationOfBenefit40_50.convertString(src.getDispositionElement()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getPreAuthRef()) {
            tgt.getPreAuthRef().add(ExplanationOfBenefit40_50.convertString(stringType));
        }
        for (Period period : src.getPreAuthRefPeriod()) {
            tgt.addPreAuthRefPeriod(ExplanationOfBenefit40_50.convertPeriod(period));
        }
        for (ExplanationOfBenefit.CareTeamComponent careTeamComponent : src.getCareTeam()) {
            tgt.addCareTeam(ExplanationOfBenefit40_50.convertCareTeamComponent(careTeamComponent));
        }
        for (ExplanationOfBenefit.SupportingInformationComponent supportingInformationComponent : src.getSupportingInfo()) {
            tgt.addSupportingInfo(ExplanationOfBenefit40_50.convertSupportingInformationComponent(supportingInformationComponent));
        }
        for (ExplanationOfBenefit.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(ExplanationOfBenefit40_50.convertDiagnosisComponent(diagnosisComponent));
        }
        for (ExplanationOfBenefit.ProcedureComponent procedureComponent : src.getProcedure()) {
            tgt.addProcedure(ExplanationOfBenefit40_50.convertProcedureComponent(procedureComponent));
        }
        if (src.hasPrecedence()) {
            tgt.setPrecedenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getPrecedenceElement()));
        }
        for (ExplanationOfBenefit.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(ExplanationOfBenefit40_50.convertInsuranceComponent(insuranceComponent));
        }
        if (src.hasAccident()) {
            tgt.setAccident(ExplanationOfBenefit40_50.convertAccidentComponent(src.getAccident()));
        }
        for (ExplanationOfBenefit.ItemComponent itemComponent : src.getItem()) {
            tgt.addItem(ExplanationOfBenefit40_50.convertItemComponent(itemComponent));
        }
        for (ExplanationOfBenefit.AddedItemComponent addedItemComponent : src.getAddItem()) {
            tgt.addAddItem(ExplanationOfBenefit40_50.convertAddedItemComponent(addedItemComponent));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.TotalComponent totalComponent : src.getTotal()) {
            tgt.addTotal(ExplanationOfBenefit40_50.convertTotalComponent(totalComponent));
        }
        if (src.hasPayment()) {
            tgt.setPayment(ExplanationOfBenefit40_50.convertPaymentComponent(src.getPayment()));
        }
        if (src.hasFormCode()) {
            tgt.setFormCode(ExplanationOfBenefit40_50.convertCodeableConcept(src.getFormCode()));
        }
        if (src.hasForm()) {
            tgt.setForm(ExplanationOfBenefit40_50.convertAttachment(src.getForm()));
        }
        for (ExplanationOfBenefit.NoteComponent noteComponent : src.getProcessNote()) {
            tgt.addProcessNote(ExplanationOfBenefit40_50.convertNoteComponent(noteComponent));
        }
        if (src.hasBenefitPeriod()) {
            tgt.setBenefitPeriod(ExplanationOfBenefit40_50.convertPeriod(src.getBenefitPeriod()));
        }
        for (ExplanationOfBenefit.BenefitBalanceComponent benefitBalanceComponent : src.getBenefitBalance()) {
            tgt.addBenefitBalance(ExplanationOfBenefit40_50.convertBenefitBalanceComponent(benefitBalanceComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit convertExplanationOfBenefit(org.hl7.fhir.r5.model.ExplanationOfBenefit src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit tgt = new ExplanationOfBenefit();
        ExplanationOfBenefit40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ExplanationOfBenefit40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ExplanationOfBenefit40_50.convertExplanationOfBenefitStatus(src.getStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasSubType()) {
            tgt.setSubType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getSubType()));
        }
        if (src.hasUse()) {
            tgt.setUseElement(ExplanationOfBenefit40_50.convertUse(src.getUseElement()));
        }
        if (src.hasPatient()) {
            tgt.setPatient(ExplanationOfBenefit40_50.convertReference(src.getPatient()));
        }
        if (src.hasBillablePeriod()) {
            tgt.setBillablePeriod(ExplanationOfBenefit40_50.convertPeriod(src.getBillablePeriod()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(ExplanationOfBenefit40_50.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasEnterer()) {
            tgt.setEnterer(ExplanationOfBenefit40_50.convertReference(src.getEnterer()));
        }
        if (src.hasInsurer()) {
            tgt.setInsurer(ExplanationOfBenefit40_50.convertReference(src.getInsurer()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(ExplanationOfBenefit40_50.convertReference(src.getProvider()));
        }
        if (src.hasPriority()) {
            tgt.setPriority(ExplanationOfBenefit40_50.convertCodeableConcept(src.getPriority()));
        }
        if (src.hasFundsReserveRequested()) {
            tgt.setFundsReserveRequested(ExplanationOfBenefit40_50.convertCodeableConcept(src.getFundsReserveRequested()));
        }
        if (src.hasFundsReserve()) {
            tgt.setFundsReserve(ExplanationOfBenefit40_50.convertCodeableConcept(src.getFundsReserve()));
        }
        for (ExplanationOfBenefit.RelatedClaimComponent relatedClaimComponent : src.getRelated()) {
            tgt.addRelated(ExplanationOfBenefit40_50.convertRelatedClaimComponent(relatedClaimComponent));
        }
        if (src.hasPrescription()) {
            tgt.setPrescription(ExplanationOfBenefit40_50.convertReference(src.getPrescription()));
        }
        if (src.hasOriginalPrescription()) {
            tgt.setOriginalPrescription(ExplanationOfBenefit40_50.convertReference(src.getOriginalPrescription()));
        }
        if (src.hasPayee()) {
            tgt.setPayee(ExplanationOfBenefit40_50.convertPayeeComponent(src.getPayee()));
        }
        if (src.hasReferral()) {
            tgt.setReferral(ExplanationOfBenefit40_50.convertReference(src.getReferral()));
        }
        if (src.hasFacility()) {
            tgt.setFacility(ExplanationOfBenefit40_50.convertReference(src.getFacility()));
        }
        if (src.hasClaim()) {
            tgt.setClaim(ExplanationOfBenefit40_50.convertReference(src.getClaim()));
        }
        if (src.hasClaimResponse()) {
            tgt.setClaimResponse(ExplanationOfBenefit40_50.convertReference(src.getClaimResponse()));
        }
        if (src.hasOutcome()) {
            tgt.setOutcomeElement(ExplanationOfBenefit40_50.convertRemittanceOutcome(src.getOutcomeElement()));
        }
        if (src.hasDisposition()) {
            tgt.setDispositionElement(ExplanationOfBenefit40_50.convertString(src.getDispositionElement()));
        }
        for (StringType stringType : src.getPreAuthRef()) {
            tgt.getPreAuthRef().add(ExplanationOfBenefit40_50.convertString(stringType));
        }
        for (org.hl7.fhir.r5.model.Period period : src.getPreAuthRefPeriod()) {
            tgt.addPreAuthRefPeriod(ExplanationOfBenefit40_50.convertPeriod(period));
        }
        for (ExplanationOfBenefit.CareTeamComponent careTeamComponent : src.getCareTeam()) {
            tgt.addCareTeam(ExplanationOfBenefit40_50.convertCareTeamComponent(careTeamComponent));
        }
        for (ExplanationOfBenefit.SupportingInformationComponent supportingInformationComponent : src.getSupportingInfo()) {
            tgt.addSupportingInfo(ExplanationOfBenefit40_50.convertSupportingInformationComponent(supportingInformationComponent));
        }
        for (ExplanationOfBenefit.DiagnosisComponent diagnosisComponent : src.getDiagnosis()) {
            tgt.addDiagnosis(ExplanationOfBenefit40_50.convertDiagnosisComponent(diagnosisComponent));
        }
        for (ExplanationOfBenefit.ProcedureComponent procedureComponent : src.getProcedure()) {
            tgt.addProcedure(ExplanationOfBenefit40_50.convertProcedureComponent(procedureComponent));
        }
        if (src.hasPrecedence()) {
            tgt.setPrecedenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getPrecedenceElement()));
        }
        for (ExplanationOfBenefit.InsuranceComponent insuranceComponent : src.getInsurance()) {
            tgt.addInsurance(ExplanationOfBenefit40_50.convertInsuranceComponent(insuranceComponent));
        }
        if (src.hasAccident()) {
            tgt.setAccident(ExplanationOfBenefit40_50.convertAccidentComponent(src.getAccident()));
        }
        for (ExplanationOfBenefit.ItemComponent itemComponent : src.getItem()) {
            tgt.addItem(ExplanationOfBenefit40_50.convertItemComponent(itemComponent));
        }
        for (ExplanationOfBenefit.AddedItemComponent addedItemComponent : src.getAddItem()) {
            tgt.addAddItem(ExplanationOfBenefit40_50.convertAddedItemComponent(addedItemComponent));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.TotalComponent totalComponent : src.getTotal()) {
            tgt.addTotal(ExplanationOfBenefit40_50.convertTotalComponent(totalComponent));
        }
        if (src.hasPayment()) {
            tgt.setPayment(ExplanationOfBenefit40_50.convertPaymentComponent(src.getPayment()));
        }
        if (src.hasFormCode()) {
            tgt.setFormCode(ExplanationOfBenefit40_50.convertCodeableConcept(src.getFormCode()));
        }
        if (src.hasForm()) {
            tgt.setForm(ExplanationOfBenefit40_50.convertAttachment(src.getForm()));
        }
        for (ExplanationOfBenefit.NoteComponent noteComponent : src.getProcessNote()) {
            tgt.addProcessNote(ExplanationOfBenefit40_50.convertNoteComponent(noteComponent));
        }
        if (src.hasBenefitPeriod()) {
            tgt.setBenefitPeriod(ExplanationOfBenefit40_50.convertPeriod(src.getBenefitPeriod()));
        }
        for (ExplanationOfBenefit.BenefitBalanceComponent benefitBalanceComponent : src.getBenefitBalance()) {
            tgt.addBenefitBalance(ExplanationOfBenefit40_50.convertBenefitBalanceComponent(benefitBalanceComponent));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ExplanationOfBenefit.ExplanationOfBenefitStatus> convertExplanationOfBenefitStatus(Enumeration<ExplanationOfBenefit.ExplanationOfBenefitStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ExplanationOfBenefit.ExplanationOfBenefitStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<ExplanationOfBenefit.ExplanationOfBenefitStatus>(new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ExplanationOfBenefit.ExplanationOfBenefitStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ExplanationOfBenefit.ExplanationOfBenefitStatus> convertExplanationOfBenefitStatus(org.hl7.fhir.r5.model.Enumeration<ExplanationOfBenefit.ExplanationOfBenefitStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ExplanationOfBenefit.ExplanationOfBenefitStatus> tgt = new Enumeration<ExplanationOfBenefit.ExplanationOfBenefitStatus>(new ExplanationOfBenefit.ExplanationOfBenefitStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ExplanationOfBenefit.ExplanationOfBenefitStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ExplanationOfBenefit.ExplanationOfBenefitStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> convertUse(Enumeration<ExplanationOfBenefit.Use> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.Use>(new Enumerations.UseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ExplanationOfBenefit.Use)((Object)src.getValue())) {
            case CLAIM: {
                tgt.setValue((Object)Enumerations.Use.CLAIM);
                break;
            }
            case PREAUTHORIZATION: {
                tgt.setValue((Object)Enumerations.Use.PREAUTHORIZATION);
                break;
            }
            case PREDETERMINATION: {
                tgt.setValue((Object)Enumerations.Use.PREDETERMINATION);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.Use.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ExplanationOfBenefit.Use> convertUse(org.hl7.fhir.r5.model.Enumeration<Enumerations.Use> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ExplanationOfBenefit.Use> tgt = new Enumeration<ExplanationOfBenefit.Use>(new ExplanationOfBenefit.UseEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.Use)((Object)src.getValue())) {
            case CLAIM: {
                tgt.setValue((Object)ExplanationOfBenefit.Use.CLAIM);
                break;
            }
            case PREAUTHORIZATION: {
                tgt.setValue((Object)ExplanationOfBenefit.Use.PREAUTHORIZATION);
                break;
            }
            case PREDETERMINATION: {
                tgt.setValue((Object)ExplanationOfBenefit.Use.PREDETERMINATION);
                break;
            }
            default: {
                tgt.setValue((Object)ExplanationOfBenefit.Use.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> convertRemittanceOutcome(Enumeration<ExplanationOfBenefit.RemittanceOutcome> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes>(new Enumerations.ClaimProcessingCodesEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ExplanationOfBenefit.RemittanceOutcome)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ClaimProcessingCodes.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ExplanationOfBenefit.RemittanceOutcome> convertRemittanceOutcome(org.hl7.fhir.r5.model.Enumeration<Enumerations.ClaimProcessingCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ExplanationOfBenefit.RemittanceOutcome> tgt = new Enumeration<ExplanationOfBenefit.RemittanceOutcome>(new ExplanationOfBenefit.RemittanceOutcomeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.ClaimProcessingCodes)((Object)src.getValue())) {
            case QUEUED: {
                tgt.setValue((Object)ExplanationOfBenefit.RemittanceOutcome.QUEUED);
                break;
            }
            case COMPLETE: {
                tgt.setValue((Object)ExplanationOfBenefit.RemittanceOutcome.COMPLETE);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)ExplanationOfBenefit.RemittanceOutcome.ERROR);
                break;
            }
            case PARTIAL: {
                tgt.setValue((Object)ExplanationOfBenefit.RemittanceOutcome.PARTIAL);
                break;
            }
            default: {
                tgt.setValue((Object)ExplanationOfBenefit.RemittanceOutcome.NULL);
            }
        }
        return tgt;
    }

    public static ExplanationOfBenefit.RelatedClaimComponent convertRelatedClaimComponent(ExplanationOfBenefit.RelatedClaimComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.RelatedClaimComponent tgt = new ExplanationOfBenefit.RelatedClaimComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasClaim()) {
            tgt.setClaim(ExplanationOfBenefit40_50.convertReference(src.getClaim()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasReference()) {
            tgt.setReference(ExplanationOfBenefit40_50.convertIdentifier(src.getReference()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.RelatedClaimComponent convertRelatedClaimComponent(ExplanationOfBenefit.RelatedClaimComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.RelatedClaimComponent tgt = new ExplanationOfBenefit.RelatedClaimComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasClaim()) {
            tgt.setClaim(ExplanationOfBenefit40_50.convertReference(src.getClaim()));
        }
        if (src.hasRelationship()) {
            tgt.setRelationship(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRelationship()));
        }
        if (src.hasReference()) {
            tgt.setReference(ExplanationOfBenefit40_50.convertIdentifier(src.getReference()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.PayeeComponent convertPayeeComponent(ExplanationOfBenefit.PayeeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.PayeeComponent tgt = new ExplanationOfBenefit.PayeeComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasParty()) {
            tgt.setParty(ExplanationOfBenefit40_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.PayeeComponent convertPayeeComponent(ExplanationOfBenefit.PayeeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.PayeeComponent tgt = new ExplanationOfBenefit.PayeeComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasParty()) {
            tgt.setParty(ExplanationOfBenefit40_50.convertReference(src.getParty()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.CareTeamComponent convertCareTeamComponent(ExplanationOfBenefit.CareTeamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.CareTeamComponent tgt = new ExplanationOfBenefit.CareTeamComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(ExplanationOfBenefit40_50.convertReference(src.getProvider()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(ExplanationOfBenefit40_50.convertBoolean(src.getResponsibleElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasQualification()) {
            tgt.setQualification(ExplanationOfBenefit40_50.convertCodeableConcept(src.getQualification()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.CareTeamComponent convertCareTeamComponent(ExplanationOfBenefit.CareTeamComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.CareTeamComponent tgt = new ExplanationOfBenefit.CareTeamComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(ExplanationOfBenefit40_50.convertReference(src.getProvider()));
        }
        if (src.hasResponsible()) {
            tgt.setResponsibleElement(ExplanationOfBenefit40_50.convertBoolean(src.getResponsibleElement()));
        }
        if (src.hasRole()) {
            tgt.setRole(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasQualification()) {
            tgt.setQualification(ExplanationOfBenefit40_50.convertCodeableConcept(src.getQualification()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.SupportingInformationComponent convertSupportingInformationComponent(ExplanationOfBenefit.SupportingInformationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.SupportingInformationComponent tgt = new ExplanationOfBenefit.SupportingInformationComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(ExplanationOfBenefit40_50.convertType(src.getTiming()));
        }
        if (src.hasValue()) {
            tgt.setValue(ExplanationOfBenefit40_50.convertType(src.getValue()));
        }
        if (src.hasReason()) {
            tgt.setReason(ExplanationOfBenefit40_50.convertCoding(src.getReason()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.SupportingInformationComponent convertSupportingInformationComponent(ExplanationOfBenefit.SupportingInformationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.SupportingInformationComponent tgt = new ExplanationOfBenefit.SupportingInformationComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasCode()) {
            tgt.setCode(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasTiming()) {
            tgt.setTiming(ExplanationOfBenefit40_50.convertType(src.getTiming()));
        }
        if (src.hasValue()) {
            tgt.setValue(ExplanationOfBenefit40_50.convertType(src.getValue()));
        }
        if (src.hasReason()) {
            tgt.setReason(ExplanationOfBenefit40_50.convertCoding(src.getReason()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.DiagnosisComponent convertDiagnosisComponent(ExplanationOfBenefit.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.DiagnosisComponent tgt = new ExplanationOfBenefit.DiagnosisComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasDiagnosis()) {
            tgt.setDiagnosis(ExplanationOfBenefit40_50.convertType(src.getDiagnosis()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getType()) {
            tgt.addType(ExplanationOfBenefit40_50.convertCodeableConcept(t));
        }
        if (src.hasOnAdmission()) {
            tgt.setOnAdmission(ExplanationOfBenefit40_50.convertCodeableConcept(src.getOnAdmission()));
        }
        if (src.hasPackageCode()) {
            tgt.setPackageCode(ExplanationOfBenefit40_50.convertCodeableConcept(src.getPackageCode()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.DiagnosisComponent convertDiagnosisComponent(ExplanationOfBenefit.DiagnosisComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.DiagnosisComponent tgt = new ExplanationOfBenefit.DiagnosisComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasDiagnosis()) {
            tgt.setDiagnosis(ExplanationOfBenefit40_50.convertType(src.getDiagnosis()));
        }
        for (CodeableConcept t : src.getType()) {
            tgt.addType(ExplanationOfBenefit40_50.convertCodeableConcept(t));
        }
        if (src.hasOnAdmission()) {
            tgt.setOnAdmission(ExplanationOfBenefit40_50.convertCodeableConcept(src.getOnAdmission()));
        }
        if (src.hasPackageCode()) {
            tgt.setPackageCode(ExplanationOfBenefit40_50.convertCodeableConcept(src.getPackageCode()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.ProcedureComponent convertProcedureComponent(ExplanationOfBenefit.ProcedureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.ProcedureComponent tgt = new ExplanationOfBenefit.ProcedureComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ExplanationOfBenefit40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(ExplanationOfBenefit40_50.convertType(src.getProcedure()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUdi()) {
            tgt.addUdi(ExplanationOfBenefit40_50.convertReference(reference));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.ProcedureComponent convertProcedureComponent(ExplanationOfBenefit.ProcedureComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.ProcedureComponent tgt = new ExplanationOfBenefit.ProcedureComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        for (CodeableConcept codeableConcept : src.getType()) {
            tgt.addType(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ExplanationOfBenefit40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasProcedure()) {
            tgt.setProcedure(ExplanationOfBenefit40_50.convertType(src.getProcedure()));
        }
        for (Reference reference : src.getUdi()) {
            tgt.addUdi(ExplanationOfBenefit40_50.convertReference(reference));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.InsuranceComponent convertInsuranceComponent(ExplanationOfBenefit.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.InsuranceComponent tgt = new ExplanationOfBenefit.InsuranceComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFocal()) {
            tgt.setFocalElement(ExplanationOfBenefit40_50.convertBoolean(src.getFocalElement()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(ExplanationOfBenefit40_50.convertReference(src.getCoverage()));
        }
        for (org.hl7.fhir.r4.model.StringType t : src.getPreAuthRef()) {
            tgt.getPreAuthRef().add(ExplanationOfBenefit40_50.convertString(t));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.InsuranceComponent convertInsuranceComponent(ExplanationOfBenefit.InsuranceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.InsuranceComponent tgt = new ExplanationOfBenefit.InsuranceComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasFocal()) {
            tgt.setFocalElement(ExplanationOfBenefit40_50.convertBoolean(src.getFocalElement()));
        }
        if (src.hasCoverage()) {
            tgt.setCoverage(ExplanationOfBenefit40_50.convertReference(src.getCoverage()));
        }
        for (StringType t : src.getPreAuthRef()) {
            tgt.getPreAuthRef().add(ExplanationOfBenefit40_50.convertString(t));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AccidentComponent convertAccidentComponent(ExplanationOfBenefit.AccidentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AccidentComponent tgt = new ExplanationOfBenefit.AccidentComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDate()) {
            tgt.setDateElement(ExplanationOfBenefit40_50.convertDate(src.getDateElement()));
        }
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ExplanationOfBenefit40_50.convertType(src.getLocation()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AccidentComponent convertAccidentComponent(ExplanationOfBenefit.AccidentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AccidentComponent tgt = new ExplanationOfBenefit.AccidentComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasDate()) {
            tgt.setDateElement(ExplanationOfBenefit40_50.convertDate(src.getDateElement()));
        }
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ExplanationOfBenefit40_50.convertType(src.getLocation()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.ItemComponent convertItemComponent(ExplanationOfBenefit.ItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.ItemComponent tgt = new ExplanationOfBenefit.ItemComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        for (PositiveIntType positiveIntType : src.getCareTeamSequence()) {
            tgt.getCareTeamSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getDiagnosisSequence()) {
            tgt.getDiagnosisSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getProcedureSequence()) {
            tgt.getProcedureSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getInformationSequence()) {
            tgt.getInformationSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasServiced()) {
            tgt.setServiced(ExplanationOfBenefit40_50.convertType(src.getServiced()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ExplanationOfBenefit40_50.convertType(src.getLocation()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUdi()) {
            tgt.addUdi(ExplanationOfBenefit40_50.convertReference(reference));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(ExplanationOfBenefit40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSubSite()) {
            tgt.addSubSite(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getEncounter()) {
            tgt.addEncounter(ExplanationOfBenefit40_50.convertReference(reference));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.DetailComponent detailComponent : src.getDetail()) {
            tgt.addDetail(ExplanationOfBenefit40_50.convertDetailComponent(detailComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.ItemComponent convertItemComponent(ExplanationOfBenefit.ItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.ItemComponent tgt = new ExplanationOfBenefit.ItemComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getCareTeamSequence()) {
            tgt.getCareTeamSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getDiagnosisSequence()) {
            tgt.getDiagnosisSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getProcedureSequence()) {
            tgt.getProcedureSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getInformationSequence()) {
            tgt.getInformationSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasServiced()) {
            tgt.setServiced(ExplanationOfBenefit40_50.convertType(src.getServiced()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ExplanationOfBenefit40_50.convertType(src.getLocation()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (Reference reference : src.getUdi()) {
            tgt.addUdi(ExplanationOfBenefit40_50.convertReference(reference));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(ExplanationOfBenefit40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (CodeableConcept codeableConcept : src.getSubSite()) {
            tgt.addSubSite(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getEncounter()) {
            tgt.addEncounter(ExplanationOfBenefit40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.DetailComponent detailComponent : src.getDetail()) {
            tgt.addDetail(ExplanationOfBenefit40_50.convertDetailComponent(detailComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AdjudicationComponent convertAdjudicationComponent(ExplanationOfBenefit.AdjudicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AdjudicationComponent tgt = new ExplanationOfBenefit.AdjudicationComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasReason()) {
            tgt.setReason(ExplanationOfBenefit40_50.convertCodeableConcept(src.getReason()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ExplanationOfBenefit40_50.convertMoney(src.getAmount()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ExplanationOfBenefit40_50.convertDecimal(src.getValueElement()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AdjudicationComponent convertAdjudicationComponent(ExplanationOfBenefit.AdjudicationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AdjudicationComponent tgt = new ExplanationOfBenefit.AdjudicationComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasReason()) {
            tgt.setReason(ExplanationOfBenefit40_50.convertCodeableConcept(src.getReason()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ExplanationOfBenefit40_50.convertMoney(src.getAmount()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ExplanationOfBenefit40_50.convertDecimal(src.getValueElement()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.DetailComponent convertDetailComponent(ExplanationOfBenefit.DetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.DetailComponent tgt = new ExplanationOfBenefit.DetailComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUdi()) {
            tgt.addUdi(ExplanationOfBenefit40_50.convertReference(reference));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.SubDetailComponent subDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(ExplanationOfBenefit40_50.convertSubDetailComponent(subDetailComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.DetailComponent convertDetailComponent(ExplanationOfBenefit.DetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.DetailComponent tgt = new ExplanationOfBenefit.DetailComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (Reference reference : src.getUdi()) {
            tgt.addUdi(ExplanationOfBenefit40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.SubDetailComponent subDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(ExplanationOfBenefit40_50.convertSubDetailComponent(subDetailComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.SubDetailComponent convertSubDetailComponent(ExplanationOfBenefit.SubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.SubDetailComponent tgt = new ExplanationOfBenefit.SubDetailComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getUdi()) {
            tgt.addUdi(ExplanationOfBenefit40_50.convertReference(reference));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.SubDetailComponent convertSubDetailComponent(ExplanationOfBenefit.SubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.SubDetailComponent tgt = new ExplanationOfBenefit.SubDetailComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSequence()) {
            tgt.setSequenceElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getSequenceElement()));
        }
        if (src.hasRevenue()) {
            tgt.setRevenue(ExplanationOfBenefit40_50.convertCodeableConcept(src.getRevenue()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (Reference reference : src.getUdi()) {
            tgt.addUdi(ExplanationOfBenefit40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AddedItemComponent convertAddedItemComponent(ExplanationOfBenefit.AddedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AddedItemComponent tgt = new ExplanationOfBenefit.AddedItemComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        for (PositiveIntType positiveIntType : src.getItemSequence()) {
            tgt.getItemSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getDetailSequence()) {
            tgt.getDetailSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (PositiveIntType positiveIntType : src.getSubDetailSequence()) {
            tgt.getSubDetailSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getProvider()) {
            tgt.addProvider(ExplanationOfBenefit40_50.convertReference(reference));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasServiced()) {
            tgt.setServiced(ExplanationOfBenefit40_50.convertType(src.getServiced()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ExplanationOfBenefit40_50.convertType(src.getLocation()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(ExplanationOfBenefit40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSubSite()) {
            tgt.addSubSite(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.AddedItemDetailComponent addedItemDetailComponent : src.getDetail()) {
            tgt.addDetail(ExplanationOfBenefit40_50.convertAddedItemDetailComponent(addedItemDetailComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AddedItemComponent convertAddedItemComponent(ExplanationOfBenefit.AddedItemComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AddedItemComponent tgt = new ExplanationOfBenefit.AddedItemComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getItemSequence()) {
            tgt.getItemSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getDetailSequence()) {
            tgt.getDetailSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getSubDetailSequence()) {
            tgt.getSubDetailSequence().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (Reference reference : src.getProvider()) {
            tgt.addProvider(ExplanationOfBenefit40_50.convertReference(reference));
        }
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getProgramCode()) {
            tgt.addProgramCode(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasServiced()) {
            tgt.setServiced(ExplanationOfBenefit40_50.convertType(src.getServiced()));
        }
        if (src.hasLocation()) {
            tgt.setLocation(ExplanationOfBenefit40_50.convertType(src.getLocation()));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        if (src.hasBodySite()) {
            tgt.setBodySite(ExplanationOfBenefit40_50.convertCodeableConcept(src.getBodySite()));
        }
        for (CodeableConcept codeableConcept : src.getSubSite()) {
            tgt.addSubSite(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.AddedItemDetailComponent addedItemDetailComponent : src.getDetail()) {
            tgt.addDetail(ExplanationOfBenefit40_50.convertAddedItemDetailComponent(addedItemDetailComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AddedItemDetailComponent convertAddedItemDetailComponent(ExplanationOfBenefit.AddedItemDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AddedItemDetailComponent tgt = new ExplanationOfBenefit.AddedItemDetailComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.AddedItemDetailSubDetailComponent addedItemDetailSubDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(ExplanationOfBenefit40_50.convertAddedItemDetailSubDetailComponent(addedItemDetailSubDetailComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AddedItemDetailComponent convertAddedItemDetailComponent(ExplanationOfBenefit.AddedItemDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AddedItemDetailComponent tgt = new ExplanationOfBenefit.AddedItemDetailComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        for (ExplanationOfBenefit.AddedItemDetailSubDetailComponent addedItemDetailSubDetailComponent : src.getSubDetail()) {
            tgt.addSubDetail(ExplanationOfBenefit40_50.convertAddedItemDetailSubDetailComponent(addedItemDetailSubDetailComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AddedItemDetailSubDetailComponent convertAddedItemDetailSubDetailComponent(ExplanationOfBenefit.AddedItemDetailSubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AddedItemDetailSubDetailComponent tgt = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.AddedItemDetailSubDetailComponent convertAddedItemDetailSubDetailComponent(ExplanationOfBenefit.AddedItemDetailSubDetailComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.AddedItemDetailSubDetailComponent tgt = new ExplanationOfBenefit.AddedItemDetailSubDetailComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProductOrService()) {
            tgt.setProductOrService(ExplanationOfBenefit40_50.convertCodeableConcept(src.getProductOrService()));
        }
        for (CodeableConcept codeableConcept : src.getModifier()) {
            tgt.addModifier(ExplanationOfBenefit40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasQuantity()) {
            tgt.setQuantity(ExplanationOfBenefit40_50.convertSimpleQuantity(src.getQuantity()));
        }
        if (src.hasUnitPrice()) {
            tgt.setUnitPrice(ExplanationOfBenefit40_50.convertMoney(src.getUnitPrice()));
        }
        if (src.hasFactor()) {
            tgt.setFactorElement(ExplanationOfBenefit40_50.convertDecimal(src.getFactorElement()));
        }
        if (src.hasNet()) {
            tgt.setNet(ExplanationOfBenefit40_50.convertMoney(src.getNet()));
        }
        for (org.hl7.fhir.r5.model.PositiveIntType positiveIntType : src.getNoteNumber()) {
            tgt.getNoteNumber().add(ExplanationOfBenefit40_50.convertPositiveInt(positiveIntType));
        }
        for (ExplanationOfBenefit.AdjudicationComponent adjudicationComponent : src.getAdjudication()) {
            tgt.addAdjudication(ExplanationOfBenefit40_50.convertAdjudicationComponent(adjudicationComponent));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.TotalComponent convertTotalComponent(ExplanationOfBenefit.TotalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.TotalComponent tgt = new ExplanationOfBenefit.TotalComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ExplanationOfBenefit40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.TotalComponent convertTotalComponent(ExplanationOfBenefit.TotalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.TotalComponent tgt = new ExplanationOfBenefit.TotalComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ExplanationOfBenefit40_50.convertMoney(src.getAmount()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.PaymentComponent convertPaymentComponent(ExplanationOfBenefit.PaymentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.PaymentComponent tgt = new ExplanationOfBenefit.PaymentComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAdjustment()) {
            tgt.setAdjustment(ExplanationOfBenefit40_50.convertMoney(src.getAdjustment()));
        }
        if (src.hasAdjustmentReason()) {
            tgt.setAdjustmentReason(ExplanationOfBenefit40_50.convertCodeableConcept(src.getAdjustmentReason()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ExplanationOfBenefit40_50.convertDate(src.getDateElement()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ExplanationOfBenefit40_50.convertMoney(src.getAmount()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(ExplanationOfBenefit40_50.convertIdentifier(src.getIdentifier()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.PaymentComponent convertPaymentComponent(ExplanationOfBenefit.PaymentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.PaymentComponent tgt = new ExplanationOfBenefit.PaymentComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAdjustment()) {
            tgt.setAdjustment(ExplanationOfBenefit40_50.convertMoney(src.getAdjustment()));
        }
        if (src.hasAdjustmentReason()) {
            tgt.setAdjustmentReason(ExplanationOfBenefit40_50.convertCodeableConcept(src.getAdjustmentReason()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ExplanationOfBenefit40_50.convertDate(src.getDateElement()));
        }
        if (src.hasAmount()) {
            tgt.setAmount(ExplanationOfBenefit40_50.convertMoney(src.getAmount()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(ExplanationOfBenefit40_50.convertIdentifier(src.getIdentifier()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.NoteComponent convertNoteComponent(ExplanationOfBenefit.NoteComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.NoteComponent tgt = new ExplanationOfBenefit.NoteComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumber()) {
            tgt.setNumberElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getNumberElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Enumerations40_50.convertNoteType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(ExplanationOfBenefit40_50.convertString(src.getTextElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(ExplanationOfBenefit40_50.convertCodeableConcept(src.getLanguage()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.NoteComponent convertNoteComponent(ExplanationOfBenefit.NoteComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.NoteComponent tgt = new ExplanationOfBenefit.NoteComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumber()) {
            tgt.setNumberElement(ExplanationOfBenefit40_50.convertPositiveInt(src.getNumberElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(Enumerations40_50.convertNoteType(src.getTypeElement()));
        }
        if (src.hasText()) {
            tgt.setTextElement(ExplanationOfBenefit40_50.convertString(src.getTextElement()));
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(ExplanationOfBenefit40_50.convertCodeableConcept(src.getLanguage()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.BenefitBalanceComponent convertBenefitBalanceComponent(ExplanationOfBenefit.BenefitBalanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.BenefitBalanceComponent tgt = new ExplanationOfBenefit.BenefitBalanceComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasExcluded()) {
            tgt.setExcludedElement(ExplanationOfBenefit40_50.convertBoolean(src.getExcludedElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExplanationOfBenefit40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExplanationOfBenefit40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(ExplanationOfBenefit40_50.convertCodeableConcept(src.getNetwork()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(ExplanationOfBenefit40_50.convertCodeableConcept(src.getUnit()));
        }
        if (src.hasTerm()) {
            tgt.setTerm(ExplanationOfBenefit40_50.convertCodeableConcept(src.getTerm()));
        }
        for (ExplanationOfBenefit.BenefitComponent t : src.getFinancial()) {
            tgt.addFinancial(ExplanationOfBenefit40_50.convertBenefitComponent(t));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.BenefitBalanceComponent convertBenefitBalanceComponent(ExplanationOfBenefit.BenefitBalanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.BenefitBalanceComponent tgt = new ExplanationOfBenefit.BenefitBalanceComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCategory()) {
            tgt.setCategory(ExplanationOfBenefit40_50.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasExcluded()) {
            tgt.setExcludedElement(ExplanationOfBenefit40_50.convertBoolean(src.getExcludedElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExplanationOfBenefit40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExplanationOfBenefit40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasNetwork()) {
            tgt.setNetwork(ExplanationOfBenefit40_50.convertCodeableConcept(src.getNetwork()));
        }
        if (src.hasUnit()) {
            tgt.setUnit(ExplanationOfBenefit40_50.convertCodeableConcept(src.getUnit()));
        }
        if (src.hasTerm()) {
            tgt.setTerm(ExplanationOfBenefit40_50.convertCodeableConcept(src.getTerm()));
        }
        for (ExplanationOfBenefit.BenefitComponent t : src.getFinancial()) {
            tgt.addFinancial(ExplanationOfBenefit40_50.convertBenefitComponent(t));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.BenefitComponent convertBenefitComponent(ExplanationOfBenefit.BenefitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.BenefitComponent tgt = new ExplanationOfBenefit.BenefitComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAllowed()) {
            tgt.setAllowed(ExplanationOfBenefit40_50.convertType(src.getAllowed()));
        }
        if (src.hasUsed()) {
            tgt.setUsed(ExplanationOfBenefit40_50.convertType(src.getUsed()));
        }
        return tgt;
    }

    public static ExplanationOfBenefit.BenefitComponent convertBenefitComponent(ExplanationOfBenefit.BenefitComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExplanationOfBenefit.BenefitComponent tgt = new ExplanationOfBenefit.BenefitComponent();
        ExplanationOfBenefit40_50.copyElement(src, tgt, new String[0]);
        if (src.hasType()) {
            tgt.setType(ExplanationOfBenefit40_50.convertCodeableConcept(src.getType()));
        }
        if (src.hasAllowed()) {
            tgt.setAllowed(ExplanationOfBenefit40_50.convertType(src.getAllowed()));
        }
        if (src.hasUsed()) {
            tgt.setUsed(ExplanationOfBenefit40_50.convertType(src.getUsed()));
        }
        return tgt;
    }
}

