/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.ExampleScenario;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ExampleScenario;

public class ExampleScenario40_50
extends VersionConvertor_40_50 {
    public static ExampleScenario convertExampleScenario(org.hl7.fhir.r4.model.ExampleScenario src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario tgt = new ExampleScenario();
        ExampleScenario40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ExampleScenario40_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ExampleScenario40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ExampleScenario40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExampleScenario40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ExampleScenario40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ExampleScenario40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ExampleScenario40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ExampleScenario40_50.convertContactDetail(contactDetail));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ExampleScenario40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ExampleScenario40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ExampleScenario40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(ExampleScenario40_50.convertMarkdown(src.getPurposeElement()));
        }
        for (ExampleScenario.ExampleScenarioActorComponent exampleScenarioActorComponent : src.getActor()) {
            tgt.addActor(ExampleScenario40_50.convertExampleScenarioActorComponent(exampleScenarioActorComponent));
        }
        for (ExampleScenario.ExampleScenarioInstanceComponent exampleScenarioInstanceComponent : src.getInstance()) {
            tgt.addInstance(ExampleScenario40_50.convertExampleScenarioInstanceComponent(exampleScenarioInstanceComponent));
        }
        for (ExampleScenario.ExampleScenarioProcessComponent exampleScenarioProcessComponent : src.getProcess()) {
            tgt.addProcess(ExampleScenario40_50.convertExampleScenarioProcessComponent(exampleScenarioProcessComponent));
        }
        for (CanonicalType canonicalType : src.getWorkflow()) {
            tgt.getWorkflow().add(ExampleScenario40_50.convertCanonical(canonicalType));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.ExampleScenario convertExampleScenario(ExampleScenario src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.ExampleScenario tgt = new org.hl7.fhir.r4.model.ExampleScenario();
        ExampleScenario40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ExampleScenario40_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ExampleScenario40_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ExampleScenario40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExampleScenario40_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ExampleScenario40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ExampleScenario40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ExampleScenario40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ExampleScenario40_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ExampleScenario40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ExampleScenario40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ExampleScenario40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(ExampleScenario40_50.convertMarkdown(src.getPurposeElement()));
        }
        for (ExampleScenario.ExampleScenarioActorComponent exampleScenarioActorComponent : src.getActor()) {
            tgt.addActor(ExampleScenario40_50.convertExampleScenarioActorComponent(exampleScenarioActorComponent));
        }
        for (ExampleScenario.ExampleScenarioInstanceComponent exampleScenarioInstanceComponent : src.getInstance()) {
            tgt.addInstance(ExampleScenario40_50.convertExampleScenarioInstanceComponent(exampleScenarioInstanceComponent));
        }
        for (ExampleScenario.ExampleScenarioProcessComponent exampleScenarioProcessComponent : src.getProcess()) {
            tgt.addProcess(ExampleScenario40_50.convertExampleScenarioProcessComponent(exampleScenarioProcessComponent));
        }
        for (org.hl7.fhir.r5.model.CanonicalType canonicalType : src.getWorkflow()) {
            tgt.getWorkflow().add(ExampleScenario40_50.convertCanonical(canonicalType));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioActorComponent convertExampleScenarioActorComponent(ExampleScenario.ExampleScenarioActorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioActorComponent tgt = new ExampleScenario.ExampleScenarioActorComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasActorId()) {
            tgt.setActorIdElement(ExampleScenario40_50.convertString(src.getActorIdElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(ExampleScenario40_50.convertExampleScenarioActorType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExampleScenario40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioActorComponent convertExampleScenarioActorComponent(ExampleScenario.ExampleScenarioActorComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioActorComponent tgt = new ExampleScenario.ExampleScenarioActorComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasActorId()) {
            tgt.setActorIdElement(ExampleScenario40_50.convertString(src.getActorIdElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(ExampleScenario40_50.convertExampleScenarioActorType(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExampleScenario40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ExampleScenario.ExampleScenarioActorType> convertExampleScenarioActorType(Enumeration<ExampleScenario.ExampleScenarioActorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ExampleScenario.ExampleScenarioActorType> tgt = new org.hl7.fhir.r5.model.Enumeration<ExampleScenario.ExampleScenarioActorType>(new ExampleScenario.ExampleScenarioActorTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ExampleScenario.ExampleScenarioActorType)((Object)src.getValue())) {
            case PERSON: {
                tgt.setValue((Object)ExampleScenario.ExampleScenarioActorType.PERSON);
                break;
            }
            case ENTITY: {
                tgt.setValue((Object)ExampleScenario.ExampleScenarioActorType.ENTITY);
                break;
            }
            default: {
                tgt.setValue((Object)ExampleScenario.ExampleScenarioActorType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ExampleScenario.ExampleScenarioActorType> convertExampleScenarioActorType(org.hl7.fhir.r5.model.Enumeration<ExampleScenario.ExampleScenarioActorType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ExampleScenario.ExampleScenarioActorType> tgt = new Enumeration<ExampleScenario.ExampleScenarioActorType>(new ExampleScenario.ExampleScenarioActorTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ExampleScenario.ExampleScenarioActorType)((Object)src.getValue())) {
            case PERSON: {
                tgt.setValue((Object)ExampleScenario.ExampleScenarioActorType.PERSON);
                break;
            }
            case ENTITY: {
                tgt.setValue((Object)ExampleScenario.ExampleScenarioActorType.ENTITY);
                break;
            }
            default: {
                tgt.setValue((Object)ExampleScenario.ExampleScenarioActorType.NULL);
            }
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioInstanceComponent convertExampleScenarioInstanceComponent(ExampleScenario.ExampleScenarioInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioInstanceComponent tgt = new ExampleScenario.ExampleScenarioInstanceComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasResourceId()) {
            tgt.setResourceIdElement(ExampleScenario40_50.convertString(src.getResourceIdElement()));
        }
        if (src.hasResourceType()) {
            tgt.setResourceTypeElement(ExampleScenario40_50.convertFHIRResourceType(src.getResourceTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExampleScenario40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (ExampleScenario.ExampleScenarioInstanceVersionComponent exampleScenarioInstanceVersionComponent : src.getVersion()) {
            tgt.addVersion(ExampleScenario40_50.convertExampleScenarioInstanceVersionComponent(exampleScenarioInstanceVersionComponent));
        }
        for (ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent exampleScenarioInstanceContainedInstanceComponent : src.getContainedInstance()) {
            tgt.addContainedInstance(ExampleScenario40_50.convertExampleScenarioInstanceContainedInstanceComponent(exampleScenarioInstanceContainedInstanceComponent));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioInstanceComponent convertExampleScenarioInstanceComponent(ExampleScenario.ExampleScenarioInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioInstanceComponent tgt = new ExampleScenario.ExampleScenarioInstanceComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasResourceId()) {
            tgt.setResourceIdElement(ExampleScenario40_50.convertString(src.getResourceIdElement()));
        }
        if (src.hasResourceType()) {
            tgt.setResourceTypeElement(ExampleScenario40_50.convertFHIRResourceType(src.getResourceTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExampleScenario40_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (ExampleScenario.ExampleScenarioInstanceVersionComponent exampleScenarioInstanceVersionComponent : src.getVersion()) {
            tgt.addVersion(ExampleScenario40_50.convertExampleScenarioInstanceVersionComponent(exampleScenarioInstanceVersionComponent));
        }
        for (ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent exampleScenarioInstanceContainedInstanceComponent : src.getContainedInstance()) {
            tgt.addContainedInstance(ExampleScenario40_50.convertExampleScenarioInstanceContainedInstanceComponent(exampleScenarioInstanceContainedInstanceComponent));
        }
        return tgt;
    }

    public static CodeType convertFHIRResourceType(Enumeration<ExampleScenario.FHIRResourceType> src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CodeType tgt = new CodeType(src.asStringValue());
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static Enumeration<ExampleScenario.FHIRResourceType> convertFHIRResourceType(CodeType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Enumeration<String> tgt = new Enumeration<String>((EnumFactory<String>)new ExampleScenario.FHIRResourceTypeEnumFactory(), src.getCode());
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioInstanceVersionComponent convertExampleScenarioInstanceVersionComponent(ExampleScenario.ExampleScenarioInstanceVersionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioInstanceVersionComponent tgt = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(ExampleScenario40_50.convertString(src.getVersionIdElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioInstanceVersionComponent convertExampleScenarioInstanceVersionComponent(ExampleScenario.ExampleScenarioInstanceVersionComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioInstanceVersionComponent tgt = new ExampleScenario.ExampleScenarioInstanceVersionComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(ExampleScenario40_50.convertString(src.getVersionIdElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent convertExampleScenarioInstanceContainedInstanceComponent(ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent tgt = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasResourceId()) {
            tgt.setResourceIdElement(ExampleScenario40_50.convertString(src.getResourceIdElement()));
        }
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(ExampleScenario40_50.convertString(src.getVersionIdElement()));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent convertExampleScenarioInstanceContainedInstanceComponent(ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent tgt = new ExampleScenario.ExampleScenarioInstanceContainedInstanceComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasResourceId()) {
            tgt.setResourceIdElement(ExampleScenario40_50.convertString(src.getResourceIdElement()));
        }
        if (src.hasVersionId()) {
            tgt.setVersionIdElement(ExampleScenario40_50.convertString(src.getVersionIdElement()));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioProcessComponent convertExampleScenarioProcessComponent(ExampleScenario.ExampleScenarioProcessComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioProcessComponent tgt = new ExampleScenario.ExampleScenarioProcessComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTitle()) {
            tgt.setTitleElement(ExampleScenario40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPreConditions()) {
            tgt.setPreConditionsElement(ExampleScenario40_50.convertMarkdown(src.getPreConditionsElement()));
        }
        if (src.hasPostConditions()) {
            tgt.setPostConditionsElement(ExampleScenario40_50.convertMarkdown(src.getPostConditionsElement()));
        }
        for (ExampleScenario.ExampleScenarioProcessStepComponent t : src.getStep()) {
            tgt.addStep(ExampleScenario40_50.convertExampleScenarioProcessStepComponent(t));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioProcessComponent convertExampleScenarioProcessComponent(ExampleScenario.ExampleScenarioProcessComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioProcessComponent tgt = new ExampleScenario.ExampleScenarioProcessComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTitle()) {
            tgt.setTitleElement(ExampleScenario40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasPreConditions()) {
            tgt.setPreConditionsElement(ExampleScenario40_50.convertMarkdown(src.getPreConditionsElement()));
        }
        if (src.hasPostConditions()) {
            tgt.setPostConditionsElement(ExampleScenario40_50.convertMarkdown(src.getPostConditionsElement()));
        }
        for (ExampleScenario.ExampleScenarioProcessStepComponent t : src.getStep()) {
            tgt.addStep(ExampleScenario40_50.convertExampleScenarioProcessStepComponent(t));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioProcessStepComponent convertExampleScenarioProcessStepComponent(ExampleScenario.ExampleScenarioProcessStepComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioProcessStepComponent tgt = new ExampleScenario.ExampleScenarioProcessStepComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        for (ExampleScenario.ExampleScenarioProcessComponent exampleScenarioProcessComponent : src.getProcess()) {
            tgt.addProcess(ExampleScenario40_50.convertExampleScenarioProcessComponent(exampleScenarioProcessComponent));
        }
        if (src.hasPause()) {
            tgt.setPauseElement(ExampleScenario40_50.convertBoolean(src.getPauseElement()));
        }
        if (src.hasOperation()) {
            tgt.setOperation(ExampleScenario40_50.convertExampleScenarioProcessStepOperationComponent(src.getOperation()));
        }
        for (ExampleScenario.ExampleScenarioProcessStepAlternativeComponent exampleScenarioProcessStepAlternativeComponent : src.getAlternative()) {
            tgt.addAlternative(ExampleScenario40_50.convertExampleScenarioProcessStepAlternativeComponent(exampleScenarioProcessStepAlternativeComponent));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioProcessStepComponent convertExampleScenarioProcessStepComponent(ExampleScenario.ExampleScenarioProcessStepComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioProcessStepComponent tgt = new ExampleScenario.ExampleScenarioProcessStepComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        for (ExampleScenario.ExampleScenarioProcessComponent exampleScenarioProcessComponent : src.getProcess()) {
            tgt.addProcess(ExampleScenario40_50.convertExampleScenarioProcessComponent(exampleScenarioProcessComponent));
        }
        if (src.hasPause()) {
            tgt.setPauseElement(ExampleScenario40_50.convertBoolean(src.getPauseElement()));
        }
        if (src.hasOperation()) {
            tgt.setOperation(ExampleScenario40_50.convertExampleScenarioProcessStepOperationComponent(src.getOperation()));
        }
        for (ExampleScenario.ExampleScenarioProcessStepAlternativeComponent exampleScenarioProcessStepAlternativeComponent : src.getAlternative()) {
            tgt.addAlternative(ExampleScenario40_50.convertExampleScenarioProcessStepAlternativeComponent(exampleScenarioProcessStepAlternativeComponent));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioProcessStepOperationComponent convertExampleScenarioProcessStepOperationComponent(ExampleScenario.ExampleScenarioProcessStepOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioProcessStepOperationComponent tgt = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumber()) {
            tgt.setNumberElement(ExampleScenario40_50.convertString(src.getNumberElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(ExampleScenario40_50.convertString(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExampleScenario40_50.convertString(src.getNameElement()));
        }
        if (src.hasInitiator()) {
            tgt.setInitiatorElement(ExampleScenario40_50.convertString(src.getInitiatorElement()));
        }
        if (src.hasReceiver()) {
            tgt.setReceiverElement(ExampleScenario40_50.convertString(src.getReceiverElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasInitiatorActive()) {
            tgt.setInitiatorActiveElement(ExampleScenario40_50.convertBoolean(src.getInitiatorActiveElement()));
        }
        if (src.hasReceiverActive()) {
            tgt.setReceiverActiveElement(ExampleScenario40_50.convertBoolean(src.getReceiverActiveElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(ExampleScenario40_50.convertExampleScenarioInstanceContainedInstanceComponent(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(ExampleScenario40_50.convertExampleScenarioInstanceContainedInstanceComponent(src.getResponse()));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioProcessStepOperationComponent convertExampleScenarioProcessStepOperationComponent(ExampleScenario.ExampleScenarioProcessStepOperationComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioProcessStepOperationComponent tgt = new ExampleScenario.ExampleScenarioProcessStepOperationComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasNumber()) {
            tgt.setNumberElement(ExampleScenario40_50.convertString(src.getNumberElement()));
        }
        if (src.hasType()) {
            tgt.setTypeElement(ExampleScenario40_50.convertString(src.getTypeElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ExampleScenario40_50.convertString(src.getNameElement()));
        }
        if (src.hasInitiator()) {
            tgt.setInitiatorElement(ExampleScenario40_50.convertString(src.getInitiatorElement()));
        }
        if (src.hasReceiver()) {
            tgt.setReceiverElement(ExampleScenario40_50.convertString(src.getReceiverElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasInitiatorActive()) {
            tgt.setInitiatorActiveElement(ExampleScenario40_50.convertBoolean(src.getInitiatorActiveElement()));
        }
        if (src.hasReceiverActive()) {
            tgt.setReceiverActiveElement(ExampleScenario40_50.convertBoolean(src.getReceiverActiveElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(ExampleScenario40_50.convertExampleScenarioInstanceContainedInstanceComponent(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(ExampleScenario40_50.convertExampleScenarioInstanceContainedInstanceComponent(src.getResponse()));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioProcessStepAlternativeComponent convertExampleScenarioProcessStepAlternativeComponent(ExampleScenario.ExampleScenarioProcessStepAlternativeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioProcessStepAlternativeComponent tgt = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTitle()) {
            tgt.setTitleElement(ExampleScenario40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (ExampleScenario.ExampleScenarioProcessStepComponent t : src.getStep()) {
            tgt.addStep(ExampleScenario40_50.convertExampleScenarioProcessStepComponent(t));
        }
        return tgt;
    }

    public static ExampleScenario.ExampleScenarioProcessStepAlternativeComponent convertExampleScenarioProcessStepAlternativeComponent(ExampleScenario.ExampleScenarioProcessStepAlternativeComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ExampleScenario.ExampleScenarioProcessStepAlternativeComponent tgt = new ExampleScenario.ExampleScenarioProcessStepAlternativeComponent();
        ExampleScenario40_50.copyElement(src, tgt, new String[0]);
        if (src.hasTitle()) {
            tgt.setTitleElement(ExampleScenario40_50.convertString(src.getTitleElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ExampleScenario40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (ExampleScenario.ExampleScenarioProcessStepComponent t : src.getStep()) {
            tgt.addStep(ExampleScenario40_50.convertExampleScenarioProcessStepComponent(t));
        }
        return tgt;
    }
}

