/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.Endpoint;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.Endpoint;
import org.hl7.fhir.r5.model.StringType;

public class Endpoint40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.Endpoint convertEndpoint(Endpoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.Endpoint tgt = new org.hl7.fhir.r5.model.Endpoint();
        Endpoint40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Endpoint40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Endpoint40_50.convertEndpointStatus(src.getStatusElement()));
        }
        if (src.hasConnectionType()) {
            tgt.setConnectionType(Endpoint40_50.convertCoding(src.getConnectionType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Endpoint40_50.convertString(src.getNameElement()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(Endpoint40_50.convertReference(src.getManagingOrganization()));
        }
        for (ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(Endpoint40_50.convertContactPoint(contactPoint));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Endpoint40_50.convertPeriod(src.getPeriod()));
        }
        for (CodeableConcept codeableConcept : src.getPayloadType()) {
            tgt.addPayloadType(Endpoint40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.CodeType codeType : src.getPayloadMimeType()) {
            tgt.getPayloadMimeType().add(Endpoint40_50.convertCode(codeType));
        }
        if (src.hasAddress()) {
            tgt.setAddressElement(Endpoint40_50.convertUrl(src.getAddressElement()));
        }
        for (org.hl7.fhir.r4.model.StringType stringType : src.getHeader()) {
            tgt.getHeader().add(Endpoint40_50.convertString(stringType));
        }
        return tgt;
    }

    public static Endpoint convertEndpoint(org.hl7.fhir.r5.model.Endpoint src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Endpoint tgt = new Endpoint();
        Endpoint40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(Endpoint40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Endpoint40_50.convertEndpointStatus(src.getStatusElement()));
        }
        if (src.hasConnectionType()) {
            tgt.setConnectionType(Endpoint40_50.convertCoding(src.getConnectionType()));
        }
        if (src.hasName()) {
            tgt.setNameElement(Endpoint40_50.convertString(src.getNameElement()));
        }
        if (src.hasManagingOrganization()) {
            tgt.setManagingOrganization(Endpoint40_50.convertReference(src.getManagingOrganization()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint contactPoint : src.getContact()) {
            tgt.addContact(Endpoint40_50.convertContactPoint(contactPoint));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(Endpoint40_50.convertPeriod(src.getPeriod()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getPayloadType()) {
            tgt.addPayloadType(Endpoint40_50.convertCodeableConcept(codeableConcept));
        }
        for (CodeType codeType : src.getPayloadMimeType()) {
            tgt.getPayloadMimeType().add(Endpoint40_50.convertCode(codeType));
        }
        if (src.hasAddress()) {
            tgt.setAddressElement(Endpoint40_50.convertUrl(src.getAddressElement()));
        }
        for (StringType stringType : src.getHeader()) {
            tgt.getHeader().add(Endpoint40_50.convertString(stringType));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Endpoint.EndpointStatus> convertEndpointStatus(Enumeration<Endpoint.EndpointStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Endpoint.EndpointStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Endpoint.EndpointStatus>(new Endpoint.EndpointStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Endpoint.EndpointStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Endpoint.EndpointStatus.SUSPENDED);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ERROR);
                break;
            }
            case OFF: {
                tgt.setValue((Object)Endpoint.EndpointStatus.OFF);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ENTEREDINERROR);
                break;
            }
            case TEST: {
                tgt.setValue((Object)Endpoint.EndpointStatus.TEST);
                break;
            }
            default: {
                tgt.setValue((Object)Endpoint.EndpointStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Endpoint.EndpointStatus> convertEndpointStatus(org.hl7.fhir.r5.model.Enumeration<Endpoint.EndpointStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Endpoint.EndpointStatus> tgt = new Enumeration<Endpoint.EndpointStatus>(new Endpoint.EndpointStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Endpoint.EndpointStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Endpoint.EndpointStatus.SUSPENDED);
                break;
            }
            case ERROR: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ERROR);
                break;
            }
            case OFF: {
                tgt.setValue((Object)Endpoint.EndpointStatus.OFF);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Endpoint.EndpointStatus.ENTEREDINERROR);
                break;
            }
            case TEST: {
                tgt.setValue((Object)Endpoint.EndpointStatus.TEST);
                break;
            }
            default: {
                tgt.setValue((Object)Endpoint.EndpointStatus.NULL);
            }
        }
        return tgt;
    }
}

