/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.DocumentReference;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class DocumentReference40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.DocumentReference convertDocumentReference(DocumentReference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.DocumentReference tgt = new org.hl7.fhir.r5.model.DocumentReference();
        DocumentReference40_50.copyDomainResource(src, tgt);
        if (src.hasMasterIdentifier()) {
            tgt.addIdentifier(DocumentReference40_50.convertIdentifier(src.getMasterIdentifier()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DocumentReference40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Enumerations40_50.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatusElement(DocumentReference40_50.convertReferredDocumentStatus(src.getDocStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(DocumentReference40_50.convertCodeableConcept(src.getType()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(DocumentReference40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(DocumentReference40_50.convertReference(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(DocumentReference40_50.convertInstant(src.getDateElement()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getAuthor()) {
            tgt.addAuthor(DocumentReference40_50.convertReference(reference));
        }
        if (src.hasAuthenticator()) {
            tgt.addAttester().setMode(DocumentReference.DocumentAttestationMode.OFFICIAL).setParty(VersionConvertor_40_50.convertReference(src.getAuthenticator()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(DocumentReference40_50.convertReference(src.getCustodian()));
        }
        for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference40_50.convertDocumentReferenceRelatesToComponent(documentReferenceRelatesToComponent));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(DocumentReference40_50.convertStringToMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getSecurityLabel()) {
            tgt.addSecurityLabel(DocumentReference40_50.convertCodeableConcept(codeableConcept));
        }
        for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : src.getContent()) {
            tgt.addContent(DocumentReference40_50.convertDocumentReferenceContentComponent(documentReferenceContentComponent));
        }
        if (src.hasContext()) {
            DocumentReference40_50.convertDocumentReferenceContextComponent(src.getContext(), tgt);
        }
        return tgt;
    }

    public static DocumentReference convertDocumentReference(org.hl7.fhir.r5.model.DocumentReference src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference tgt = new DocumentReference();
        DocumentReference40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(DocumentReference40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Enumerations40_50.convertDocumentReferenceStatus(src.getStatusElement()));
        }
        if (src.hasDocStatus()) {
            tgt.setDocStatusElement(DocumentReference40_50.convertReferredDocumentStatus(src.getDocStatusElement()));
        }
        if (src.hasType()) {
            tgt.setType(DocumentReference40_50.convertCodeableConcept(src.getType()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(DocumentReference40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(DocumentReference40_50.convertReference(src.getSubject()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(DocumentReference40_50.convertInstant(src.getDateElement()));
        }
        for (Reference reference : src.getAuthor()) {
            tgt.addAuthor(DocumentReference40_50.convertReference(reference));
        }
        for (DocumentReference.DocumentReferenceAttesterComponent documentReferenceAttesterComponent : src.getAttester()) {
            if (documentReferenceAttesterComponent.getMode() != DocumentReference.DocumentAttestationMode.OFFICIAL) continue;
            tgt.setAuthenticator(VersionConvertor_40_50.convertReference(documentReferenceAttesterComponent.getParty()));
        }
        if (src.hasCustodian()) {
            tgt.setCustodian(DocumentReference40_50.convertReference(src.getCustodian()));
        }
        for (DocumentReference.DocumentReferenceRelatesToComponent documentReferenceRelatesToComponent : src.getRelatesTo()) {
            tgt.addRelatesTo(DocumentReference40_50.convertDocumentReferenceRelatesToComponent(documentReferenceRelatesToComponent));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(DocumentReference40_50.convertString(src.getDescriptionElement()));
        }
        for (CodeableConcept codeableConcept : src.getSecurityLabel()) {
            tgt.addSecurityLabel(DocumentReference40_50.convertCodeableConcept(codeableConcept));
        }
        for (DocumentReference.DocumentReferenceContentComponent documentReferenceContentComponent : src.getContent()) {
            tgt.addContent(DocumentReference40_50.convertDocumentReferenceContentComponent(documentReferenceContentComponent));
        }
        DocumentReference40_50.convertDocumentReferenceContextComponent(src, tgt.getContext());
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> convertReferredDocumentStatus(Enumeration<DocumentReference.ReferredDocumentStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus>(new Enumerations.CompositionStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DocumentReference.ReferredDocumentStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)Enumerations.CompositionStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)Enumerations.CompositionStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)Enumerations.CompositionStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.CompositionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.CompositionStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DocumentReference.ReferredDocumentStatus> convertReferredDocumentStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.CompositionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DocumentReference.ReferredDocumentStatus> tgt = new Enumeration<DocumentReference.ReferredDocumentStatus>(new DocumentReference.ReferredDocumentStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.CompositionStatus)((Object)src.getValue())) {
            case PRELIMINARY: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.PRELIMINARY);
                break;
            }
            case FINAL: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.FINAL);
                break;
            }
            case AMENDED: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.AMENDED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.ReferredDocumentStatus.NULL);
            }
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        DocumentReference40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(DocumentReference40_50.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(DocumentReference40_50.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        DocumentReference40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(DocumentReference40_50.convertDocumentRelationshipType(src.getCodeElement()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(DocumentReference40_50.convertReference(src.getTarget()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> convertDocumentRelationshipType(Enumeration<DocumentReference.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType>(new Enumerations.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((DocumentReference.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<DocumentReference.DocumentRelationshipType> convertDocumentRelationshipType(org.hl7.fhir.r5.model.Enumeration<Enumerations.DocumentRelationshipType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<DocumentReference.DocumentRelationshipType> tgt = new Enumeration<DocumentReference.DocumentRelationshipType>(new DocumentReference.DocumentRelationshipTypeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.DocumentRelationshipType)((Object)src.getValue())) {
            case REPLACES: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.REPLACES);
                break;
            }
            case TRANSFORMS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.TRANSFORMS);
                break;
            }
            case SIGNS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.SIGNS);
                break;
            }
            case APPENDS: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.APPENDS);
                break;
            }
            default: {
                tgt.setValue((Object)DocumentReference.DocumentRelationshipType.NULL);
            }
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        DocumentReference40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAttachment()) {
            tgt.setAttachment(DocumentReference40_50.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.setFormat(DocumentReference40_50.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        DocumentReference40_50.copyElement(src, tgt, new String[0]);
        if (src.hasAttachment()) {
            tgt.setAttachment(DocumentReference40_50.convertAttachment(src.getAttachment()));
        }
        if (src.hasFormat()) {
            tgt.setFormat(DocumentReference40_50.convertCoding(src.getFormat()));
        }
        return tgt;
    }

    public static void convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src, org.hl7.fhir.r5.model.DocumentReference tgt) throws FHIRException {
        for (org.hl7.fhir.r4.model.Reference reference : src.getEncounter()) {
            tgt.addEncounter(DocumentReference40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getEvent()) {
            tgt.addEvent(DocumentReference40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(DocumentReference40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(DocumentReference40_50.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(DocumentReference40_50.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(DocumentReference40_50.convertReference(src.getSourcePatientInfo()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getRelated()) {
            tgt.addRelated(DocumentReference40_50.convertReference(reference));
        }
    }

    public static void convertDocumentReferenceContextComponent(org.hl7.fhir.r5.model.DocumentReference src, DocumentReference.DocumentReferenceContextComponent tgt) throws FHIRException {
        for (Reference reference : src.getEncounter()) {
            tgt.addEncounter(DocumentReference40_50.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getEvent()) {
            tgt.addEvent(DocumentReference40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(DocumentReference40_50.convertPeriod(src.getPeriod()));
        }
        if (src.hasFacilityType()) {
            tgt.setFacilityType(DocumentReference40_50.convertCodeableConcept(src.getFacilityType()));
        }
        if (src.hasPracticeSetting()) {
            tgt.setPracticeSetting(DocumentReference40_50.convertCodeableConcept(src.getPracticeSetting()));
        }
        if (src.hasSourcePatientInfo()) {
            tgt.setSourcePatientInfo(DocumentReference40_50.convertReference(src.getSourcePatientInfo()));
        }
        for (Reference reference : src.getRelated()) {
            tgt.addRelated(DocumentReference40_50.convertReference(reference));
        }
    }
}

