/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.convertors.conv40_50.Enumerations40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CanonicalPair;

public class ConceptMap40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ConceptMap tgt = new org.hl7.fhir.r5.model.ConceptMap();
        ConceptMap40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ConceptMap40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(ConceptMap40_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ConceptMap40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ConceptMap40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ConceptMap40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ConceptMap40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ConceptMap40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ConceptMap40_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.r4.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ConceptMap40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ConceptMap40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ConceptMap40_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ConceptMap40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(ConceptMap40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ConceptMap40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(ConceptMap40_50.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(ConceptMap40_50.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            tgt.addGroup(ConceptMap40_50.convertConceptMapGroupComponent(conceptMapGroupComponent));
        }
        return tgt;
    }

    public static ConceptMap convertConceptMap(org.hl7.fhir.r5.model.ConceptMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        ConceptMap40_50.copyDomainResource(src, tgt);
        if (src.hasUrl()) {
            tgt.setUrlElement(ConceptMap40_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(ConceptMap40_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(ConceptMap40_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(ConceptMap40_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(ConceptMap40_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)Enumerations40_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(ConceptMap40_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ConceptMap40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(ConceptMap40_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ConceptMap40_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ConceptMap40_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(ConceptMap40_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(ConceptMap40_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(ConceptMap40_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(ConceptMap40_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(ConceptMap40_50.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(ConceptMap40_50.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            tgt.addGroup(ConceptMap40_50.convertConceptMapGroupComponent(conceptMapGroupComponent));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent convertConceptMapGroupComponent(ConceptMap.ConceptMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupComponent tgt = new ConceptMap.ConceptMapGroupComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSource() || src.hasSourceVersion()) {
            tgt.setSourceElement(ConceptMap40_50.convertUriAndVersionToCanonical(src.getSourceElement(), src.getSourceVersionElement()));
        }
        if (src.hasTarget() || src.hasTargetVersion()) {
            tgt.setTargetElement(ConceptMap40_50.convertUriAndVersionToCanonical(src.getTargetElement(), src.getTargetVersionElement()));
        }
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            tgt.addElement(ConceptMap40_50.convertSourceElementComponent(t));
        }
        if (src.hasUnmapped()) {
            tgt.setUnmapped(ConceptMap40_50.convertConceptMapGroupUnmappedComponent(src.getUnmapped()));
        }
        return tgt;
    }

    private static CanonicalType convertUriAndVersionToCanonical(UriType srcUri, StringType srcVersion) {
        if (srcUri == null && srcVersion == null) {
            return null;
        }
        CanonicalType tgt = new CanonicalType();
        ConceptMap40_50.copyElement(srcUri == null ? srcVersion : srcUri, tgt, new String[0]);
        if (srcUri.hasValue()) {
            if (srcVersion.hasValue()) {
                tgt.setValue((String)srcUri.getValue() + "|" + (String)srcVersion.getValue());
            } else {
                tgt.setValue(srcUri.getValue());
            }
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent convertConceptMapGroupComponent(ConceptMap.ConceptMapGroupComponent src) throws FHIRException {
        CanonicalPair cp;
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupComponent tgt = new ConceptMap.ConceptMapGroupComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasSource()) {
            cp = new CanonicalPair(src.getSource());
            tgt.setSource(cp.getUrl());
            tgt.setSourceVersion(cp.getVersion());
        }
        if (src.hasTarget()) {
            cp = new CanonicalPair(src.getTarget());
            tgt.setTarget(cp.getUrl());
            tgt.setTargetVersion(cp.getVersion());
        }
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            tgt.addElement(ConceptMap40_50.convertSourceElementComponent(t));
        }
        if (src.hasUnmapped()) {
            tgt.setUnmapped(ConceptMap40_50.convertConceptMapGroupUnmappedComponent(src.getUnmapped()));
        }
        return tgt;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ConceptMap40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ConceptMap40_50.convertString(src.getDisplayElement()));
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            if (t.getEquivalence() == Enumerations.ConceptMapEquivalence.UNMATCHED) {
                tgt.setNoMap(true);
                continue;
            }
            tgt.addTarget(ConceptMap40_50.convertTargetElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ConceptMap40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ConceptMap40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasNoMap() && src.getNoMap()) {
            tgt.addTarget(new ConceptMap.TargetElementComponent().setEquivalence(Enumerations.ConceptMapEquivalence.UNMATCHED));
        } else {
            for (ConceptMap.TargetElementComponent t : src.getTarget()) {
                tgt.addTarget(ConceptMap40_50.convertTargetElementComponent(t));
            }
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ConceptMap40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ConceptMap40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setRelationshipElement(ConceptMap40_50.convertConceptMapRelationship(src.getEquivalenceElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(ConceptMap40_50.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap40_50.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap40_50.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(ConceptMap40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ConceptMap40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasRelationship()) {
            tgt.setEquivalenceElement(ConceptMap40_50.convertConceptMapEquivalence(src.getRelationshipElement()));
        } else {
            tgt.setEquivalence(Enumerations.ConceptMapEquivalence.RELATEDTO);
        }
        if (src.hasComment()) {
            tgt.setCommentElement(ConceptMap40_50.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap40_50.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap40_50.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(org.hl7.fhir.r5.model.Enumeration<Enumerations.ConceptMapRelationship> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ConceptMapEquivalence> tgt = new Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence");
        if (src.hasExtension("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence")) {
            tgt.setValueAsString(src.getExtensionString("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence"));
        } else {
            switch ((Enumerations.ConceptMapRelationship)((Object)src.getValue())) {
                case RELATEDTO: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.RELATEDTO);
                    break;
                }
                case EQUIVALENT: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                    break;
                }
                case SOURCEISNARROWERTHANTARGET: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                    break;
                }
                case SOURCEISBROADERTHANTARGET: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                    break;
                }
                case NOTRELATEDTO: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
                }
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.ConceptMapRelationship> convertConceptMapRelationship(Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.ConceptMapRelationship> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        ToolingExtensions.setCodeExtension(tgt, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence", src.getValueAsString());
        switch ((Enumerations.ConceptMapEquivalence)((Object)src.getValue())) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.EQUIVALENT);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET);
                break;
            }
            case RELATEDTO: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.RELATEDTO);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.RELATEDTO);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NULL);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NOTRELATEDTO);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NULL);
            }
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProperty()) {
            tgt.setPropertyElement(ConceptMap40_50.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(ConceptMap40_50.convertCanonical(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ConceptMap40_50.convertString(src.getValueElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ConceptMap40_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasProperty()) {
            tgt.setPropertyElement(ConceptMap40_50.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystemElement(ConceptMap40_50.convertCanonical(src.getSystemElement()));
        }
        if (src.hasValue()) {
            tgt.setValueElement(ConceptMap40_50.convertString(src.getValueElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ConceptMap40_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupUnmappedComponent convertConceptMapGroupUnmappedComponent(ConceptMap.ConceptMapGroupUnmappedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupUnmappedComponent tgt = new ConceptMap.ConceptMapGroupUnmappedComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(ConceptMap40_50.convertConceptMapGroupUnmappedMode(src.getModeElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(ConceptMap40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ConceptMap40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(ConceptMap40_50.convertCanonical(src.getUrlElement()));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupUnmappedComponent convertConceptMapGroupUnmappedComponent(ConceptMap.ConceptMapGroupUnmappedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupUnmappedComponent tgt = new ConceptMap.ConceptMapGroupUnmappedComponent();
        ConceptMap40_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(ConceptMap40_50.convertConceptMapGroupUnmappedMode(src.getModeElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(ConceptMap40_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(ConceptMap40_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrlElement(ConceptMap40_50.convertCanonical(src.getUrlElement()));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> convertConceptMapGroupUnmappedMode(Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> tgt = new org.hl7.fhir.r5.model.Enumeration<ConceptMap.ConceptMapGroupUnmappedMode>(new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ConceptMap.ConceptMapGroupUnmappedMode)((Object)src.getValue())) {
            case PROVIDED: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.PROVIDED);
                break;
            }
            case FIXED: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.FIXED);
                break;
            }
            case OTHERMAP: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.OTHERMAP);
                break;
            }
            default: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> convertConceptMapGroupUnmappedMode(org.hl7.fhir.r5.model.Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> tgt = new Enumeration<ConceptMap.ConceptMapGroupUnmappedMode>(new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ConceptMap.ConceptMapGroupUnmappedMode)((Object)src.getValue())) {
            case PROVIDED: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.PROVIDED);
                break;
            }
            case FIXED: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.FIXED);
                break;
            }
            case OTHERMAP: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.OTHERMAP);
                break;
            }
            default: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.NULL);
            }
        }
        return tgt;
    }
}

