/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv40_50;

import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.ClinicalImpression;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.UriType;
import org.hl7.fhir.r5.model.Annotation;
import org.hl7.fhir.r5.model.ClinicalImpression;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;

public class ClinicalImpression40_50
extends VersionConvertor_40_50 {
    public static org.hl7.fhir.r5.model.ClinicalImpression convertClinicalImpression(ClinicalImpression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.ClinicalImpression tgt = new org.hl7.fhir.r5.model.ClinicalImpression();
        ClinicalImpression40_50.copyDomainResource(src, tgt);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ClinicalImpression40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClinicalImpression40_50.convertClinicalImpressionStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(ClinicalImpression40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ClinicalImpression40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ClinicalImpression40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(ClinicalImpression40_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(ClinicalImpression40_50.convertType(src.getEffective()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ClinicalImpression40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasAssessor()) {
            tgt.setPerformer(ClinicalImpression40_50.convertReference(src.getAssessor()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(ClinicalImpression40_50.convertReference(src.getPrevious()));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getProblem()) {
            tgt.addProblem(ClinicalImpression40_50.convertReference(reference));
        }
        for (UriType uriType : src.getProtocol()) {
            tgt.getProtocol().add(ClinicalImpression40_50.convertUri(uriType));
        }
        if (src.hasSummary()) {
            tgt.setSummaryElement(ClinicalImpression40_50.convertString(src.getSummaryElement()));
        }
        for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : src.getFinding()) {
            tgt.addFinding(ClinicalImpression40_50.convertClinicalImpressionFindingComponent(clinicalImpressionFindingComponent));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept codeableConcept : src.getPrognosisCodeableConcept()) {
            tgt.addPrognosisCodeableConcept(ClinicalImpression40_50.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getPrognosisReference()) {
            tgt.addPrognosisReference(ClinicalImpression40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(ClinicalImpression40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(ClinicalImpression40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static ClinicalImpression convertClinicalImpression(org.hl7.fhir.r5.model.ClinicalImpression src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression tgt = new ClinicalImpression();
        ClinicalImpression40_50.copyDomainResource(src, tgt);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(ClinicalImpression40_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(ClinicalImpression40_50.convertClinicalImpressionStatus(src.getStatusElement()));
        }
        if (src.hasStatusReason()) {
            tgt.setStatusReason(ClinicalImpression40_50.convertCodeableConcept(src.getStatusReason()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(ClinicalImpression40_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(ClinicalImpression40_50.convertReference(src.getSubject()));
        }
        if (src.hasEncounter()) {
            tgt.setEncounter(ClinicalImpression40_50.convertReference(src.getEncounter()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(ClinicalImpression40_50.convertType(src.getEffective()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(ClinicalImpression40_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPerformer()) {
            tgt.setAssessor(ClinicalImpression40_50.convertReference(src.getPerformer()));
        }
        if (src.hasPrevious()) {
            tgt.setPrevious(ClinicalImpression40_50.convertReference(src.getPrevious()));
        }
        for (Reference reference : src.getProblem()) {
            tgt.addProblem(ClinicalImpression40_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.UriType uriType : src.getProtocol()) {
            tgt.getProtocol().add(ClinicalImpression40_50.convertUri(uriType));
        }
        if (src.hasSummary()) {
            tgt.setSummaryElement(ClinicalImpression40_50.convertString(src.getSummaryElement()));
        }
        for (ClinicalImpression.ClinicalImpressionFindingComponent clinicalImpressionFindingComponent : src.getFinding()) {
            tgt.addFinding(ClinicalImpression40_50.convertClinicalImpressionFindingComponent(clinicalImpressionFindingComponent));
        }
        for (CodeableConcept codeableConcept : src.getPrognosisCodeableConcept()) {
            tgt.addPrognosisCodeableConcept(ClinicalImpression40_50.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getPrognosisReference()) {
            tgt.addPrognosisReference(ClinicalImpression40_50.convertReference(reference));
        }
        for (Reference reference : src.getSupportingInfo()) {
            tgt.addSupportingInfo(ClinicalImpression40_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(ClinicalImpression40_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> convertClinicalImpressionStatus(Enumeration<ClinicalImpression.ClinicalImpressionStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> tgt = new org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus>(new Enumerations.EventStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((ClinicalImpression.ClinicalImpressionStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)Enumerations.EventStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Enumerations.EventStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Enumerations.EventStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.EventStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<ClinicalImpression.ClinicalImpressionStatus> convertClinicalImpressionStatus(org.hl7.fhir.r5.model.Enumeration<Enumerations.EventStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ClinicalImpression.ClinicalImpressionStatus> tgt = new Enumeration<ClinicalImpression.ClinicalImpressionStatus>(new ClinicalImpression.ClinicalImpressionStatusEnumFactory());
        VersionConvertor_40_50.copyElement(src, tgt, new String[0]);
        switch ((Enumerations.EventStatus)((Object)src.getValue())) {
            case INPROGRESS: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.INPROGRESS);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)ClinicalImpression.ClinicalImpressionStatus.NULL);
            }
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        ClinicalImpression40_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemCodeableConcept()) {
            tgt.setItem(ClinicalImpression40_50.convertCodeableConceptToCodeableReference(src.getItemCodeableConcept()));
        }
        if (src.hasItemReference()) {
            tgt.setItem(ClinicalImpression40_50.convertReferenceToCodeableReference(src.getItemReference()));
        }
        if (src.hasBasis()) {
            tgt.setBasisElement(ClinicalImpression40_50.convertString(src.getBasisElement()));
        }
        return tgt;
    }

    public static ClinicalImpression.ClinicalImpressionFindingComponent convertClinicalImpressionFindingComponent(ClinicalImpression.ClinicalImpressionFindingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ClinicalImpression.ClinicalImpressionFindingComponent tgt = new ClinicalImpression.ClinicalImpressionFindingComponent();
        ClinicalImpression40_50.copyElement(src, tgt, new String[0]);
        if (src.hasItem() && src.getItem().hasConcept()) {
            tgt.setItemCodeableConcept(ClinicalImpression40_50.convertCodeableConcept(src.getItem().getConcept()));
        }
        if (src.hasItem() && src.getItem().hasReference()) {
            tgt.setItemReference(ClinicalImpression40_50.convertReference(src.getItem().getReference()));
        }
        if (src.hasBasis()) {
            tgt.setBasisElement(ClinicalImpression40_50.convertString(src.getBasisElement()));
        }
        return tgt;
    }
}

