/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;

public class StructureDefinition30_50 {
    public static Enumeration<StructureDefinition.ExtensionContextType> convertExtensionContext(org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.ExtensionContext> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.ExtensionContextType> tgt = new Enumeration<StructureDefinition.ExtensionContextType>(new StructureDefinition.ExtensionContextTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.ExtensionContext)((Object)src.getValue())) {
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.ELEMENT);
                break;
            }
            case DATATYPE: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.ELEMENT);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContextType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.ExtensionContext> convertExtensionContext(Enumeration<StructureDefinition.ExtensionContextType> src, String expression) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.ExtensionContext> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.ExtensionContext>(new StructureDefinition.ExtensionContextEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.ExtensionContextType)((Object)src.getValue())) {
            case FHIRPATH: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                break;
            }
            case ELEMENT: {
                String tn;
                String string = tn = expression.contains(".") ? expression.substring(0, expression.indexOf(".")) : expression;
                if (StructureDefinition30_50.isResource300(tn)) {
                    tgt.setValue((Object)StructureDefinition.ExtensionContext.RESOURCE);
                    break;
                }
                tgt.setValue((Object)StructureDefinition.ExtensionContext.DATATYPE);
                break;
            }
            case EXTENSION: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.EXTENSION);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.ExtensionContext.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.StructureDefinition tgt = new org.hl7.fhir.r5.model.StructureDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (org.hl7.fhir.dstu3.model.Coding coding : src.getKeyword()) {
            tgt.addKeyword(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode(src.getFhirVersion()));
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition30_50.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition30_50.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(VersionConvertor_30_50.convertBoolean(src.getAbstractElement()));
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getContext()) {
            StructureDefinition.StructureDefinitionContextComponent ec = tgt.addContext();
            ec.setTypeElement(StructureDefinition30_50.convertExtensionContext(src.getContextTypeElement()));
            ec.setExpression("*".equals(stringType.getValue()) ? "Element" : (String)stringType.getValue());
        }
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getContextInvariant()) {
            tgt.addContextInvariant((String)stringType.getValue());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinition(src.getBaseDefinition());
        }
        if (src.hasDerivation()) {
            tgt.setDerivationElement(StructureDefinition30_50.convertTypeDerivationRule(src.getDerivationElement()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition30_50.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition30_50.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        if (tgt.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            for (org.hl7.fhir.r5.model.ElementDefinition elementDefinition : tgt.getSnapshot().getElement()) {
                if (elementDefinition.hasBase()) continue;
                elementDefinition.getBase().setPath(elementDefinition.getPath()).setMin(elementDefinition.getMin()).setMax(elementDefinition.getMax());
            }
        }
        return tgt;
    }

    public static StructureDefinition convertStructureDefinition(org.hl7.fhir.r5.model.StructureDefinition src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        for (Coding coding : src.getKeyword()) {
            tgt.addKeyword(VersionConvertor_30_50.convertCoding(coding));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion().toCode());
        }
        for (StructureDefinition.StructureDefinitionMappingComponent structureDefinitionMappingComponent : src.getMapping()) {
            tgt.addMapping(StructureDefinition30_50.convertStructureDefinitionMappingComponent(structureDefinitionMappingComponent));
        }
        if (src.hasKind()) {
            tgt.setKindElement(StructureDefinition30_50.convertStructureDefinitionKind(src.getKindElement()));
        }
        if (src.hasAbstract()) {
            tgt.setAbstractElement(VersionConvertor_30_50.convertBoolean(src.getAbstractElement()));
        }
        for (StructureDefinition.StructureDefinitionContextComponent structureDefinitionContextComponent : src.getContext()) {
            if (!tgt.hasContextType()) {
                tgt.setContextTypeElement(StructureDefinition30_50.convertExtensionContext(structureDefinitionContextComponent.getTypeElement(), structureDefinitionContextComponent.getExpression()));
            }
            tgt.addContext("Element".equals(structureDefinitionContextComponent.getExpression()) ? "*" : structureDefinitionContextComponent.getExpression());
        }
        for (StringType stringType : src.getContextInvariant()) {
            tgt.addContextInvariant((String)stringType.getValue());
        }
        if (src.hasType()) {
            tgt.setType(src.getType());
        }
        if (src.hasBaseDefinition()) {
            tgt.setBaseDefinition(src.getBaseDefinition());
        }
        if (src.hasDerivation()) {
            tgt.setDerivationElement(StructureDefinition30_50.convertTypeDerivationRule(src.getDerivationElement()));
        }
        if (src.hasSnapshot()) {
            tgt.setSnapshot(StructureDefinition30_50.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        }
        if (src.hasDifferential()) {
            tgt.setDifferential(StructureDefinition30_50.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_50.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_50.convertElementDefinition(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case PRIMITIVETYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE);
                break;
            }
            case COMPLEXTYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.StructureDefinitionKind> convertStructureDefinitionKind(org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.StructureDefinitionKind> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.StructureDefinitionKind> tgt = new Enumeration<StructureDefinition.StructureDefinitionKind>(new StructureDefinition.StructureDefinitionKindEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.StructureDefinitionKind)((Object)src.getValue())) {
            case PRIMITIVETYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE);
                break;
            }
            case COMPLEXTYPE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
                break;
            }
            case RESOURCE: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.RESOURCE);
                break;
            }
            case LOGICAL: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.LOGICAL);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.StructureDefinitionKind.NULL);
            }
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(VersionConvertor_30_50.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_50.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasIdentity()) {
            tgt.setIdentityElement(VersionConvertor_30_50.convertId(src.getIdentityElement()));
        }
        if (src.hasUri()) {
            tgt.setUriElement(VersionConvertor_30_50.convertUri(src.getUriElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_50.convertElementDefinition(t));
        }
        return tgt;
    }

    public static StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(VersionConvertor_30_50.convertElementDefinition(t));
        }
        return tgt;
    }

    public static Enumeration<StructureDefinition.TypeDerivationRule> convertTypeDerivationRule(org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.TypeDerivationRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<StructureDefinition.TypeDerivationRule> tgt = new Enumeration<StructureDefinition.TypeDerivationRule>(new StructureDefinition.TypeDerivationRuleEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.TypeDerivationRule)((Object)src.getValue())) {
            case SPECIALIZATION: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.SPECIALIZATION);
                break;
            }
            case CONSTRAINT: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.TypeDerivationRule> convertTypeDerivationRule(Enumeration<StructureDefinition.TypeDerivationRule> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.TypeDerivationRule> tgt = new org.hl7.fhir.dstu3.model.Enumeration<StructureDefinition.TypeDerivationRule>(new StructureDefinition.TypeDerivationRuleEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((StructureDefinition.TypeDerivationRule)((Object)src.getValue())) {
            case SPECIALIZATION: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.SPECIALIZATION);
                break;
            }
            case CONSTRAINT: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.CONSTRAINT);
                break;
            }
            default: {
                tgt.setValue((Object)StructureDefinition.TypeDerivationRule.NULL);
            }
        }
        return tgt;
    }

    public static boolean isResource300(String tn) {
        return Utilities.existsInList(tn, "Account", "ActivityDefinition", "AllergyIntolerance", "AdverseEvent", "Appointment", "AppointmentResponse", "AuditEvent", "Basic", "Binary", "BodySite", "Bundle", "CapabilityStatement", "CarePlan", "CareTeam", "ChargeItem", "Claim", "ClaimResponse", "ClinicalImpression", "CodeSystem", "Communication", "CommunicationRequest", "CompartmentDefinition", "Composition", "ConceptMap", "Condition", "Consent", "Contract", "Coverage", "DataElement", "DetectedIssue", "Device", "DeviceComponent", "DeviceMetric", "DeviceRequest", "DeviceUseStatement", "DiagnosticReport", "DocumentManifest", "DocumentReference", "EligibilityRequest", "EligibilityResponse", "Encounter", "Endpoint", "EnrollmentRequest", "EnrollmentResponse", "EpisodeOfCare", "ExpansionProfile", "ExplanationOfBenefit", "FamilyMemberHistory", "Flag", "Goal", "GraphDefinition", "Group", "GuidanceResponse", "HealthcareService", "ImagingManifest", "ImagingStudy", "Immunization", "ImmunizationRecommendation", "ImplementationGuide", "Library", "Linkage", "List", "Location", "Measure", "MeasureReport", "Media", "Medication", "MedicationAdministration", "MedicationDispense", "MedicationRequest", "MedicationStatement", "MessageDefinition", "MessageHeader", "NamingSystem", "NutritionOrder", "Observation", "OperationDefinition", "OperationOutcome", "Organization", "Parameters", "Patient", "PaymentNotice", "PaymentReconciliation", "Person", "PlanDefinition", "Practitioner", "PractitionerRole", "Procedure", "ProcedureRequest", "ProcessRequest", "ProcessResponse", "Provenance", "Questionnaire", "QuestionnaireResponse", "ReferralRequest", "RelatedPerson", "RequestGroup", "ResearchStudy", "ResearchSubject", "RiskAssessment", "Schedule", "SearchParameter", "Sequence", "ServiceDefinition", "Slot", "Specimen", "StructureDefinition", "StructureMap", "Subscription", "Substance", "SupplyDelivery", "SupplyRequest", "Task", "TestScript", "TestReport", "ValueSet", "VisionPrescription");
    }
}

