/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import java.util.stream.Collectors;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.CodeType;
import org.hl7.fhir.dstu3.model.SearchParameter;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;

public class SearchParameter30_50 {
    public static Enumeration<SearchParameter.SearchComparator> convertSearchComparator(org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.SearchComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SearchParameter.SearchComparator> tgt = new Enumeration<SearchParameter.SearchComparator>(new SearchParameter.SearchComparatorEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.SearchComparator)((Object)src.getValue())) {
            case EQ: {
                tgt.setValue((Object)SearchParameter.SearchComparator.EQ);
                break;
            }
            case NE: {
                tgt.setValue((Object)SearchParameter.SearchComparator.NE);
                break;
            }
            case GT: {
                tgt.setValue((Object)SearchParameter.SearchComparator.GT);
                break;
            }
            case LT: {
                tgt.setValue((Object)SearchParameter.SearchComparator.LT);
                break;
            }
            case GE: {
                tgt.setValue((Object)SearchParameter.SearchComparator.GE);
                break;
            }
            case LE: {
                tgt.setValue((Object)SearchParameter.SearchComparator.LE);
                break;
            }
            case SA: {
                tgt.setValue((Object)SearchParameter.SearchComparator.SA);
                break;
            }
            case EB: {
                tgt.setValue((Object)SearchParameter.SearchComparator.EB);
                break;
            }
            case AP: {
                tgt.setValue((Object)SearchParameter.SearchComparator.AP);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.SearchComparator.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.SearchComparator> convertSearchComparator(Enumeration<SearchParameter.SearchComparator> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.SearchComparator> tgt = new org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.SearchComparator>(new SearchParameter.SearchComparatorEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.SearchComparator)((Object)src.getValue())) {
            case EQ: {
                tgt.setValue((Object)SearchParameter.SearchComparator.EQ);
                break;
            }
            case NE: {
                tgt.setValue((Object)SearchParameter.SearchComparator.NE);
                break;
            }
            case GT: {
                tgt.setValue((Object)SearchParameter.SearchComparator.GT);
                break;
            }
            case LT: {
                tgt.setValue((Object)SearchParameter.SearchComparator.LT);
                break;
            }
            case GE: {
                tgt.setValue((Object)SearchParameter.SearchComparator.GE);
                break;
            }
            case LE: {
                tgt.setValue((Object)SearchParameter.SearchComparator.LE);
                break;
            }
            case SA: {
                tgt.setValue((Object)SearchParameter.SearchComparator.SA);
                break;
            }
            case EB: {
                tgt.setValue((Object)SearchParameter.SearchComparator.EB);
                break;
            }
            case AP: {
                tgt.setValue((Object)SearchParameter.SearchComparator.AP);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.SearchComparator.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<SearchParameter.SearchModifierCode> convertSearchModifierCode(org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.SearchModifierCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SearchParameter.SearchModifierCode> tgt = new Enumeration<SearchParameter.SearchModifierCode>(new SearchParameter.SearchModifierCodeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.SearchModifierCode)((Object)src.getValue())) {
            case MISSING: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.MISSING);
                break;
            }
            case EXACT: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.EXACT);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.CONTAINS);
                break;
            }
            case NOT: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.NOT);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.TEXT);
                break;
            }
            case IN: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.NOTIN);
                break;
            }
            case BELOW: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.BELOW);
                break;
            }
            case ABOVE: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.ABOVE);
                break;
            }
            case TYPE: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.TYPE);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.SearchModifierCode> convertSearchModifierCode(Enumeration<SearchParameter.SearchModifierCode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.SearchModifierCode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.SearchModifierCode>(new SearchParameter.SearchModifierCodeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.SearchModifierCode)((Object)src.getValue())) {
            case MISSING: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.MISSING);
                break;
            }
            case EXACT: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.EXACT);
                break;
            }
            case CONTAINS: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.CONTAINS);
                break;
            }
            case NOT: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.NOT);
                break;
            }
            case TEXT: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.TEXT);
                break;
            }
            case IN: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.IN);
                break;
            }
            case NOTIN: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.NOTIN);
                break;
            }
            case BELOW: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.BELOW);
                break;
            }
            case ABOVE: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.ABOVE);
                break;
            }
            case TYPE: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.TYPE);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.SearchModifierCode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.SearchParameter convertSearchParameter(SearchParameter src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r5.model.SearchParameter tgt = new org.hl7.fhir.r5.model.SearchParameter();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        for (CodeType codeType : src.getBase()) {
            tgt.addBase((String)codeType.getValue());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDerivedFrom()) {
            tgt.setDerivedFrom(src.getDerivedFrom());
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_50.convertString(src.getExpressionElement()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_30_50.convertString(src.getXpathElement()));
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsageElement(SearchParameter30_50.convertXPathUsageType(src.getXpathUsageElement()));
        }
        for (CodeType codeType : src.getTarget()) {
            tgt.addTarget((String)codeType.getValue());
        }
        tgt.setComparator(src.getComparator().stream().map(SearchParameter30_50::convertSearchComparator).collect(Collectors.toList()));
        tgt.setModifier(src.getModifier().stream().map(SearchParameter30_50::convertSearchModifierCode).collect(Collectors.toList()));
        for (org.hl7.fhir.dstu3.model.StringType stringType : src.getChain()) {
            tgt.addChain((String)stringType.getValue());
        }
        for (SearchParameter.SearchParameterComponentComponent searchParameterComponentComponent : src.getComponent()) {
            tgt.addComponent(SearchParameter30_50.convertSearchParameterComponentComponent(searchParameterComponentComponent));
        }
        return tgt;
    }

    public static SearchParameter convertSearchParameter(org.hl7.fhir.r5.model.SearchParameter src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SearchParameter tgt = new SearchParameter();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getBase()) {
            tgt.addBase((String)codeType.getValue());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_30_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDerivedFrom()) {
            tgt.setDerivedFrom(src.getDerivedFrom());
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_50.convertString(src.getExpressionElement()));
        }
        if (src.hasXpath()) {
            tgt.setXpathElement(VersionConvertor_30_50.convertString(src.getXpathElement()));
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsageElement(SearchParameter30_50.convertXPathUsageType(src.getXpathUsageElement()));
        }
        for (org.hl7.fhir.r5.model.CodeType codeType : src.getTarget()) {
            tgt.addTarget((String)codeType.getValue());
        }
        tgt.setComparator(src.getComparator().stream().map(SearchParameter30_50::convertSearchComparator).collect(Collectors.toList()));
        tgt.setModifier(src.getModifier().stream().map(SearchParameter30_50::convertSearchModifierCode).collect(Collectors.toList()));
        for (StringType stringType : src.getChain()) {
            tgt.addChain((String)stringType.getValue());
        }
        for (SearchParameter.SearchParameterComponentComponent searchParameterComponentComponent : src.getComponent()) {
            tgt.addComponent(SearchParameter30_50.convertSearchParameterComponentComponent(searchParameterComponentComponent));
        }
        return tgt;
    }

    public static SearchParameter.SearchParameterComponentComponent convertSearchParameterComponentComponent(SearchParameter.SearchParameterComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SearchParameter.SearchParameterComponentComponent tgt = new SearchParameter.SearchParameterComponentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasDefinition()) {
            tgt.setDefinitionElement(VersionConvertor_30_50.convertReferenceToCanonical(src.getDefinition()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_50.convertString(src.getExpressionElement()));
        }
        return tgt;
    }

    public static SearchParameter.SearchParameterComponentComponent convertSearchParameterComponentComponent(SearchParameter.SearchParameterComponentComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        SearchParameter.SearchParameterComponentComponent tgt = new SearchParameter.SearchParameterComponentComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasDefinition()) {
            tgt.setDefinition(VersionConvertor_30_50.convertCanonicalToReference(src.getDefinitionElement()));
        }
        if (src.hasExpression()) {
            tgt.setExpressionElement(VersionConvertor_30_50.convertString(src.getExpressionElement()));
        }
        return tgt;
    }

    public static Enumeration<SearchParameter.XPathUsageType> convertXPathUsageType(org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.XPathUsageType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<SearchParameter.XPathUsageType> tgt = new Enumeration<SearchParameter.XPathUsageType>(new SearchParameter.XPathUsageTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.XPathUsageType)((Object)src.getValue())) {
            case NORMAL: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NORMAL);
                break;
            }
            case PHONETIC: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.PHONETIC);
                break;
            }
            case NEARBY: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NEARBY);
                break;
            }
            case DISTANCE: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.DISTANCE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.XPathUsageType> convertXPathUsageType(Enumeration<SearchParameter.XPathUsageType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.XPathUsageType> tgt = new org.hl7.fhir.dstu3.model.Enumeration<SearchParameter.XPathUsageType>(new SearchParameter.XPathUsageTypeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.XPathUsageType)((Object)src.getValue())) {
            case NORMAL: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NORMAL);
                break;
            }
            case PHONETIC: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.PHONETIC);
                break;
            }
            case NEARBY: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NEARBY);
                break;
            }
            case DISTANCE: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.DISTANCE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NULL);
            }
        }
        return tgt;
    }
}

