/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Medication;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Medication;

public class Medication30_50 {
    public static Medication convertMedication(org.hl7.fhir.dstu3.model.Medication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication tgt = new Medication();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Medication30_50.convertMedicationStatus(src.getStatusElement()));
        }
        if (src.hasManufacturer()) {
            tgt.setSponsor(VersionConvertor_30_50.convertReference(src.getManufacturer()));
        }
        if (src.hasForm()) {
            tgt.setDoseForm(VersionConvertor_30_50.convertCodeableConcept(src.getForm()));
        }
        for (Medication.MedicationIngredientComponent t : src.getIngredient()) {
            tgt.addIngredient(Medication30_50.convertMedicationIngredientComponent(t));
        }
        if (src.hasPackage()) {
            tgt.setBatch(Medication30_50.convertMedicationPackageBatchComponent(src.getPackage().getBatchFirstRep()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Medication convertMedication(Medication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Medication tgt = new org.hl7.fhir.dstu3.model.Medication();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCode(VersionConvertor_30_50.convertCodeableConcept(src.getCode()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(Medication30_50.convertMedicationStatus(src.getStatusElement()));
        }
        if (src.hasSponsor()) {
            tgt.setManufacturer(VersionConvertor_30_50.convertReference(src.getSponsor()));
        }
        if (src.hasDoseForm()) {
            tgt.setForm(VersionConvertor_30_50.convertCodeableConcept(src.getDoseForm()));
        }
        for (Medication.MedicationIngredientComponent t : src.getIngredient()) {
            tgt.addIngredient(Medication30_50.convertMedicationIngredientComponent(t));
        }
        if (src.hasBatch()) {
            tgt.getPackage().addBatch(Medication30_50.convertMedicationPackageBatchComponent(src.getBatch()));
        }
        return tgt;
    }

    public static Medication.MedicationIngredientComponent convertMedicationIngredientComponent(Medication.MedicationIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.getItem().hasConcept()) {
            tgt.setItem(VersionConvertor_30_50.convertType(src.getItem().getConcept()));
        }
        if (src.getItem().hasReference()) {
            tgt.setItem(VersionConvertor_30_50.convertType(src.getItem().getReference()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActiveElement(VersionConvertor_30_50.convertBoolean(src.getIsActiveElement()));
        }
        if (src.hasStrengthRatio()) {
            tgt.setAmount(VersionConvertor_30_50.convertRatio(src.getStrengthRatio()));
        }
        return tgt;
    }

    public static Medication.MedicationIngredientComponent convertMedicationIngredientComponent(Medication.MedicationIngredientComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationIngredientComponent tgt = new Medication.MedicationIngredientComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasItemCodeableConcept()) {
            tgt.getItem().setConcept(VersionConvertor_30_50.convertCodeableConcept(src.getItemCodeableConcept()));
        }
        if (src.hasItemReference()) {
            tgt.getItem().setReference(VersionConvertor_30_50.convertReference(src.getItemReference()));
        }
        if (src.hasIsActive()) {
            tgt.setIsActiveElement(VersionConvertor_30_50.convertBoolean(src.getIsActiveElement()));
        }
        if (src.hasAmount()) {
            tgt.setStrength(VersionConvertor_30_50.convertRatio(src.getAmount()));
        }
        return tgt;
    }

    public static Medication.MedicationPackageBatchComponent convertMedicationPackageBatchComponent(Medication.MedicationBatchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationPackageBatchComponent tgt = new Medication.MedicationPackageBatchComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(VersionConvertor_30_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(VersionConvertor_30_50.convertDateTime(src.getExpirationDateElement()));
        }
        return tgt;
    }

    public static Medication.MedicationBatchComponent convertMedicationPackageBatchComponent(Medication.MedicationPackageBatchComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Medication.MedicationBatchComponent tgt = new Medication.MedicationBatchComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasLotNumber()) {
            tgt.setLotNumberElement(VersionConvertor_30_50.convertString(src.getLotNumberElement()));
        }
        if (src.hasExpirationDate()) {
            tgt.setExpirationDateElement(VersionConvertor_30_50.convertDateTime(src.getExpirationDateElement()));
        }
        return tgt;
    }

    public static Enumeration<Medication.MedicationStatusCodes> convertMedicationStatus(org.hl7.fhir.dstu3.model.Enumeration<Medication.MedicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Medication.MedicationStatusCodes> tgt = new Enumeration<Medication.MedicationStatusCodes>(new Medication.MedicationStatusCodesEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Medication.MedicationStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatusCodes.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatusCodes.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Medication.MedicationStatusCodes.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Medication.MedicationStatusCodes.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Medication.MedicationStatus> convertMedicationStatus(Enumeration<Medication.MedicationStatusCodes> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Medication.MedicationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Medication.MedicationStatus>(new Medication.MedicationStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((Medication.MedicationStatusCodes)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatus.ACTIVE);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)Medication.MedicationStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Medication.MedicationStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)Medication.MedicationStatus.NULL);
            }
        }
        return tgt;
    }
}

