/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.ConceptMap;
import org.hl7.fhir.dstu3.model.Enumerations;
import org.hl7.fhir.dstu3.model.StringType;
import org.hl7.fhir.dstu3.model.UriType;
import org.hl7.fhir.dstu3.model.UsageContext;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.CanonicalPair;

public class ConceptMap30_50 {
    public static org.hl7.fhir.dstu3.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.ConceptMap tgt = new org.hl7.fhir.dstu3.model.ConceptMap();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.setIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifierFirstRep()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.dstu3.model.Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.r5.model.UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasSource()) {
            tgt.setSource(VersionConvertor_30_50.convertType(src.getSource()));
        }
        if (src.hasTarget()) {
            tgt.setTarget(VersionConvertor_30_50.convertType(src.getTarget()));
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            tgt.addGroup(ConceptMap30_50.convertConceptMapGroupComponent(conceptMapGroupComponent));
        }
        return tgt;
    }

    public static ConceptMap convertConceptMap(org.hl7.fhir.dstu3.model.ConceptMap src) throws FHIRException {
        DataType t;
        if (src == null) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        if (src.hasUrl()) {
            tgt.setUrlElement(VersionConvertor_30_50.convertUri(src.getUrlElement()));
        }
        if (src.hasIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_30_50.convertString(src.getVersionElement()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasTitle()) {
            tgt.setTitleElement(VersionConvertor_30_50.convertString(src.getTitleElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_30_50.convertPublicationStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_30_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_30_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_30_50.convertString(src.getPublisherElement()));
        }
        for (org.hl7.fhir.dstu3.model.ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(VersionConvertor_30_50.convertContactDetail(contactDetail));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertMarkdown(src.getDescriptionElement()));
        }
        for (UsageContext usageContext : src.getUseContext()) {
            tgt.addUseContext(VersionConvertor_30_50.convertUsageContext(usageContext));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addJurisdiction(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasPurpose()) {
            tgt.setPurposeElement(VersionConvertor_30_50.convertMarkdown(src.getPurposeElement()));
        }
        if (src.hasCopyright()) {
            tgt.setCopyrightElement(VersionConvertor_30_50.convertMarkdown(src.getCopyrightElement()));
        }
        if (src.hasSource()) {
            t = VersionConvertor_30_50.convertType(src.getSource());
            tgt.setSource(t instanceof Reference ? new CanonicalType(((Reference)t).getReference()) : t);
        }
        if (src.hasTarget()) {
            t = VersionConvertor_30_50.convertType(src.getTarget());
            tgt.setTarget(t instanceof Reference ? new CanonicalType(((Reference)t).getReference()) : t);
        }
        for (ConceptMap.ConceptMapGroupComponent conceptMapGroupComponent : src.getGroup()) {
            tgt.addGroup(ConceptMap30_50.convertConceptMapGroupComponent(conceptMapGroupComponent));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent convertConceptMapGroupComponent(ConceptMap.ConceptMapGroupComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupComponent tgt = new ConceptMap.ConceptMapGroupComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSource() || src.hasSourceVersion()) {
            tgt.setSourceElement(ConceptMap30_50.convertUriAndVersionToCanonical(src.getSourceElement(), src.getSourceVersionElement()));
        }
        if (src.hasTarget() || src.hasTargetVersion()) {
            tgt.setSourceElement(ConceptMap30_50.convertUriAndVersionToCanonical(src.getTargetElement(), src.getTargetVersionElement()));
        }
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            tgt.addElement(ConceptMap30_50.convertSourceElementComponent(t));
        }
        if (src.hasUnmapped()) {
            tgt.setUnmapped(ConceptMap30_50.convertConceptMapGroupUnmappedComponent(src.getUnmapped()));
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupComponent convertConceptMapGroupComponent(ConceptMap.ConceptMapGroupComponent src) throws FHIRException {
        CanonicalPair cp;
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupComponent tgt = new ConceptMap.ConceptMapGroupComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasSource()) {
            cp = new CanonicalPair(src.getSource());
            tgt.setSource(cp.getUrl());
            tgt.setSourceVersion(cp.getVersion());
        }
        if (src.hasTarget()) {
            cp = new CanonicalPair(src.getTarget());
            tgt.setTarget(cp.getUrl());
            tgt.setTargetVersion(cp.getVersion());
        }
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            tgt.addElement(ConceptMap30_50.convertSourceElementComponent(t));
        }
        if (src.hasUnmapped()) {
            tgt.setUnmapped(ConceptMap30_50.convertConceptMapGroupUnmappedComponent(src.getUnmapped()));
        }
        return tgt;
    }

    private static CanonicalType convertUriAndVersionToCanonical(UriType srcUri, StringType srcVersion) {
        if (srcUri == null && srcVersion == null) {
            return null;
        }
        CanonicalType tgt = new CanonicalType();
        VersionConvertor_30_50.copyElement(srcUri == null ? srcVersion : srcUri, tgt, new String[0]);
        if (srcUri.hasValue()) {
            if (srcVersion.hasValue()) {
                tgt.setValue((String)srcUri.getValue() + "|" + (String)srcVersion.getValue());
            } else {
                tgt.setValue(srcUri.getValue());
            }
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupUnmappedComponent convertConceptMapGroupUnmappedComponent(ConceptMap.ConceptMapGroupUnmappedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupUnmappedComponent tgt = new ConceptMap.ConceptMapGroupUnmappedComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(ConceptMap30_50.convertConceptMapGroupUnmappedMode(src.getModeElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static ConceptMap.ConceptMapGroupUnmappedComponent convertConceptMapGroupUnmappedComponent(ConceptMap.ConceptMapGroupUnmappedComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.ConceptMapGroupUnmappedComponent tgt = new ConceptMap.ConceptMapGroupUnmappedComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasMode()) {
            tgt.setModeElement(ConceptMap30_50.convertConceptMapGroupUnmappedMode(src.getModeElement()));
        }
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl());
        }
        return tgt;
    }

    public static Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> convertConceptMapGroupUnmappedMode(org.hl7.fhir.dstu3.model.Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> tgt = new Enumeration<ConceptMap.ConceptMapGroupUnmappedMode>(new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ConceptMap.ConceptMapGroupUnmappedMode)((Object)src.getValue())) {
            case PROVIDED: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.PROVIDED);
                break;
            }
            case FIXED: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.FIXED);
                break;
            }
            case OTHERMAP: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.OTHERMAP);
                break;
            }
            default: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> convertConceptMapGroupUnmappedMode(Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<ConceptMap.ConceptMapGroupUnmappedMode> tgt = new org.hl7.fhir.dstu3.model.Enumeration<ConceptMap.ConceptMapGroupUnmappedMode>(new ConceptMap.ConceptMapGroupUnmappedModeEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((ConceptMap.ConceptMapGroupUnmappedMode)((Object)src.getValue())) {
            case PROVIDED: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.PROVIDED);
                break;
            }
            case FIXED: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.FIXED);
                break;
            }
            case OTHERMAP: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.OTHERMAP);
                break;
            }
            default: {
                tgt.setValue((Object)ConceptMap.ConceptMapGroupUnmappedMode.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Enumerations.ConceptMapEquivalence> convertConceptMapEquivalence(Enumeration<Enumerations.ConceptMapRelationship> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Enumerations.ConceptMapEquivalence> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Enumerations.ConceptMapEquivalence>(new Enumerations.ConceptMapEquivalenceEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence");
        if (src.hasExtension("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence")) {
            tgt.setValueAsString(src.getExtensionString("http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence"));
        } else {
            switch ((Enumerations.ConceptMapRelationship)((Object)src.getValue())) {
                case EQUIVALENT: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.EQUIVALENT);
                    break;
                }
                case SOURCEISNARROWERTHANTARGET: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.WIDER);
                    break;
                }
                case SOURCEISBROADERTHANTARGET: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NARROWER);
                    break;
                }
                case NOTRELATEDTO: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.DISJOINT);
                    break;
                }
                default: {
                    tgt.setValue((Object)Enumerations.ConceptMapEquivalence.NULL);
                }
            }
        }
        return tgt;
    }

    public static Enumeration<Enumerations.ConceptMapRelationship> convertConceptMapRelationship(org.hl7.fhir.dstu3.model.Enumeration<Enumerations.ConceptMapEquivalence> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Enumerations.ConceptMapRelationship> tgt = new Enumeration<Enumerations.ConceptMapRelationship>(new Enumerations.ConceptMapRelationshipEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        ToolingExtensions.setCodeExtension(tgt, "http://hl7.org/fhir/1.0/StructureDefinition/extension-ConceptMap.element.target.equivalence", src.getValueAsString());
        switch ((Enumerations.ConceptMapEquivalence)((Object)src.getValue())) {
            case EQUIVALENT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.EQUIVALENT);
                break;
            }
            case EQUAL: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.EQUIVALENT);
                break;
            }
            case WIDER: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET);
                break;
            }
            case SUBSUMES: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISNARROWERTHANTARGET);
                break;
            }
            case NARROWER: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET);
                break;
            }
            case SPECIALIZES: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.SOURCEISBROADERTHANTARGET);
                break;
            }
            case INEXACT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.RELATEDTO);
                break;
            }
            case UNMATCHED: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NULL);
                break;
            }
            case DISJOINT: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NOTRELATEDTO);
                break;
            }
            default: {
                tgt.setValue((Object)Enumerations.ConceptMapRelationship.NULL);
            }
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasProperty()) {
            tgt.setPropertyElement(VersionConvertor_30_50.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasCode()) {
            tgt.setValueElement(VersionConvertor_30_50.convertString(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasProperty()) {
            tgt.setPropertyElement(VersionConvertor_30_50.convertUri(src.getPropertyElement()));
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasValue()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertString(src.getValueElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        return tgt;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasNoMap() && src.getNoMap()) {
            tgt.addTarget(new ConceptMap.TargetElementComponent().setEquivalence(Enumerations.ConceptMapEquivalence.UNMATCHED));
        } else {
            for (ConceptMap.TargetElementComponent t : src.getTarget()) {
                tgt.addTarget(ConceptMap30_50.convertTargetElementComponent(t));
            }
        }
        return tgt;
    }

    public static ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            if (t.getEquivalence() == Enumerations.ConceptMapEquivalence.UNMATCHED) {
                tgt.setNoMap(true);
                continue;
            }
            tgt.addTarget(ConceptMap30_50.convertTargetElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasEquivalence()) {
            tgt.setRelationshipElement(ConceptMap30_50.convertConceptMapRelationship(src.getEquivalenceElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap30_50.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap30_50.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public static ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasCode()) {
            tgt.setCodeElement(VersionConvertor_30_50.convertCode(src.getCodeElement()));
        }
        if (src.hasDisplay()) {
            tgt.setDisplayElement(VersionConvertor_30_50.convertString(src.getDisplayElement()));
        }
        if (src.hasRelationship()) {
            tgt.setEquivalenceElement(ConceptMap30_50.convertConceptMapEquivalence(src.getRelationshipElement()));
        }
        if (src.hasComment()) {
            tgt.setCommentElement(VersionConvertor_30_50.convertString(src.getCommentElement()));
        }
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(ConceptMap30_50.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(ConceptMap30_50.convertOtherElementComponent(t));
        }
        return tgt;
    }
}

