/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.CareTeam;
import org.hl7.fhir.dstu3.model.CodeableConcept;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.Reference;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CareTeam;
import org.hl7.fhir.r5.model.CodeableReference;
import org.hl7.fhir.r5.model.Enumeration;

public class CareTeam30_50 {
    public static CareTeam convertCareTeam(org.hl7.fhir.dstu3.model.CareTeam src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam tgt = new CareTeam();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CareTeam30_50.convertCareTeamStatus(src.getStatusElement()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        for (CareTeam.CareTeamParticipantComponent careTeamParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(CareTeam30_50.convertCareTeamParticipantComponent(careTeamParticipantComponent));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReason(VersionConvertor_30_50.convertCodeableConceptToCodableReference(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReason(VersionConvertor_30_50.convertReferenceToCodableReference(reference));
        }
        for (Reference reference : src.getManagingOrganization()) {
            tgt.addManagingOrganization(VersionConvertor_30_50.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.CareTeam convertCareTeam(CareTeam src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.CareTeam tgt = new org.hl7.fhir.dstu3.model.CareTeam();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(CareTeam30_50.convertCareTeamStatus(src.getStatusElement()));
        }
        for (org.hl7.fhir.r5.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_30_50.convertString(src.getNameElement()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_50.convertReference(src.getSubject()));
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        for (CareTeam.CareTeamParticipantComponent careTeamParticipantComponent : src.getParticipant()) {
            tgt.addParticipant(CareTeam30_50.convertCareTeamParticipantComponent(careTeamParticipantComponent));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasConcept()) continue;
            tgt.addReasonCode(VersionConvertor_30_50.convertCodeableConcept(codeableReference.getConcept()));
        }
        for (CodeableReference codeableReference : src.getReason()) {
            if (!codeableReference.hasReference()) continue;
            tgt.addReasonReference(VersionConvertor_30_50.convertReference(codeableReference.getReference()));
        }
        for (org.hl7.fhir.r5.model.Reference reference : src.getManagingOrganization()) {
            tgt.addManagingOrganization(VersionConvertor_30_50.convertReference(reference));
        }
        for (org.hl7.fhir.r5.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_50.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static CareTeam.CareTeamParticipantComponent convertCareTeamParticipantComponent(CareTeam.CareTeamParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam.CareTeamParticipantComponent tgt = new CareTeam.CareTeamParticipantComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasMember()) {
            tgt.setMember(VersionConvertor_30_50.convertReference(src.getMember()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_50.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasCoveragePeriod()) {
            tgt.setPeriod(VersionConvertor_30_50.convertPeriod(src.getCoveragePeriod()));
        }
        return tgt;
    }

    public static CareTeam.CareTeamParticipantComponent convertCareTeamParticipantComponent(CareTeam.CareTeamParticipantComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        CareTeam.CareTeamParticipantComponent tgt = new CareTeam.CareTeamParticipantComponent();
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        if (src.hasRole()) {
            tgt.setRole(VersionConvertor_30_50.convertCodeableConcept(src.getRole()));
        }
        if (src.hasMember()) {
            tgt.setMember(VersionConvertor_30_50.convertReference(src.getMember()));
        }
        if (src.hasOnBehalfOf()) {
            tgt.setOnBehalfOf(VersionConvertor_30_50.convertReference(src.getOnBehalfOf()));
        }
        if (src.hasPeriod()) {
            tgt.setCoverage(VersionConvertor_30_50.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<CareTeam.CareTeamStatus> convertCareTeamStatus(Enumeration<CareTeam.CareTeamStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<CareTeam.CareTeamStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<CareTeam.CareTeamStatus>(new CareTeam.CareTeamStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CareTeam.CareTeamStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.PROPOSED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.SUSPENDED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<CareTeam.CareTeamStatus> convertCareTeamStatus(org.hl7.fhir.dstu3.model.Enumeration<CareTeam.CareTeamStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<CareTeam.CareTeamStatus> tgt = new Enumeration<CareTeam.CareTeamStatus>(new CareTeam.CareTeamStatusEnumFactory());
        VersionConvertor_30_50.copyElement(src, tgt, new String[0]);
        switch ((CareTeam.CareTeamStatus)((Object)src.getValue())) {
            case PROPOSED: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.PROPOSED);
                break;
            }
            case ACTIVE: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.ACTIVE);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.SUSPENDED);
                break;
            }
            case INACTIVE: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.INACTIVE);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)CareTeam.CareTeamStatus.NULL);
            }
        }
        return tgt;
    }
}

