/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_50;

import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.dstu3.model.BodySite;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BodyStructure;

public class BodySite30_50 {
    public static BodyStructure convertBodySite(BodySite src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BodyStructure tgt = new BodyStructure();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        for (org.hl7.fhir.dstu3.model.Attachment attachment : src.getImage()) {
            tgt.addImage(VersionConvertor_30_50.convertAttachment(attachment));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        return tgt;
    }

    public static BodySite convertBodySite(BodyStructure src) throws FHIRException {
        if (src == null) {
            return null;
        }
        BodySite tgt = new BodySite();
        VersionConvertor_30_50.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r5.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_50.convertIdentifier(identifier));
        }
        if (src.hasActive()) {
            tgt.setActiveElement(VersionConvertor_30_50.convertBoolean(src.getActiveElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_30_50.convertString(src.getDescriptionElement()));
        }
        for (Attachment attachment : src.getImage()) {
            tgt.addImage(VersionConvertor_30_50.convertAttachment(attachment));
        }
        if (src.hasPatient()) {
            tgt.setPatient(VersionConvertor_30_50.convertReference(src.getPatient()));
        }
        return tgt;
    }
}

