/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.PaymentNotice;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.PaymentNotice;

public class PaymentNotice30_40 {
    public static PaymentNotice convertPaymentNotice(org.hl7.fhir.dstu3.model.PaymentNotice src) throws FHIRException {
        if (src == null) {
            return null;
        }
        PaymentNotice tgt = new PaymentNotice();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(PaymentNotice30_40.convertPaymentNoticeStatus(src.getStatusElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(VersionConvertor_30_40.convertReference(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_30_40.convertReference(src.getResponse()));
        }
        if (src.hasStatusDate()) {
            tgt.setPaymentDateElement(VersionConvertor_30_40.convertDate(src.getStatusDateElement()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(VersionConvertor_30_40.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasTarget()) {
            tgt.setRecipient(VersionConvertor_30_40.convertReference(src.getTarget()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(VersionConvertor_30_40.convertReference(src.getProvider()));
        }
        if (src.hasPaymentStatus()) {
            tgt.setPaymentStatus(VersionConvertor_30_40.convertCodeableConcept(src.getPaymentStatus()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.PaymentNotice convertPaymentNotice(PaymentNotice src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.PaymentNotice tgt = new org.hl7.fhir.dstu3.model.PaymentNotice();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(t));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(PaymentNotice30_40.convertPaymentNoticeStatus(src.getStatusElement()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(VersionConvertor_30_40.convertReference(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(VersionConvertor_30_40.convertReference(src.getResponse()));
        }
        if (src.hasPaymentDate()) {
            tgt.setStatusDateElement(VersionConvertor_30_40.convertDate(src.getPaymentDateElement()));
        }
        if (src.hasCreated()) {
            tgt.setCreatedElement(VersionConvertor_30_40.convertDateTime(src.getCreatedElement()));
        }
        if (src.hasRecipient()) {
            tgt.setTarget(VersionConvertor_30_40.convertReference(src.getRecipient()));
        }
        if (src.hasProvider()) {
            tgt.setProvider(VersionConvertor_30_40.convertReference(src.getProvider()));
        }
        if (src.hasPaymentStatus()) {
            tgt.setPaymentStatus(VersionConvertor_30_40.convertCodeableConcept(src.getPaymentStatus()));
        }
        return tgt;
    }

    public static Enumeration<PaymentNotice.PaymentNoticeStatus> convertPaymentNoticeStatus(org.hl7.fhir.dstu3.model.Enumeration<PaymentNotice.PaymentNoticeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<PaymentNotice.PaymentNoticeStatus> tgt = new Enumeration<PaymentNotice.PaymentNoticeStatus>(new PaymentNotice.PaymentNoticeStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PaymentNotice.PaymentNoticeStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.NULL);
            }
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<PaymentNotice.PaymentNoticeStatus> convertPaymentNoticeStatus(Enumeration<PaymentNotice.PaymentNoticeStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<PaymentNotice.PaymentNoticeStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<PaymentNotice.PaymentNoticeStatus>(new PaymentNotice.PaymentNoticeStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((PaymentNotice.PaymentNoticeStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.ACTIVE);
                break;
            }
            case CANCELLED: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.CANCELLED);
                break;
            }
            case DRAFT: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.DRAFT);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.ENTEREDINERROR);
                break;
            }
            default: {
                tgt.setValue((Object)PaymentNotice.PaymentNoticeStatus.NULL);
            }
        }
        return tgt;
    }
}

