/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.dstu3.model.MedicationStatement;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Reference;

public class MedicationStatement30_40 {
    public static org.hl7.fhir.dstu3.model.MedicationStatement convertMedicationStatement(MedicationStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.dstu3.model.MedicationStatement tgt = new org.hl7.fhir.dstu3.model.MedicationStatement();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement30_40.convertMedicationStatementStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(VersionConvertor_30_40.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_30_40.convertReference(src.getInformationSource()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(VersionConvertor_30_40.convertReference(reference));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (Dosage dosage : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_40.convertDosage(dosage));
        }
        return tgt;
    }

    public static MedicationStatement convertMedicationStatement(org.hl7.fhir.dstu3.model.MedicationStatement src) throws FHIRException {
        if (src == null) {
            return null;
        }
        MedicationStatement tgt = new MedicationStatement();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasContext()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(MedicationStatement30_40.convertMedicationStatementStatus(src.getStatusElement()));
        }
        if (src.hasCategory()) {
            tgt.setCategory(VersionConvertor_30_40.convertCodeableConcept(src.getCategory()));
        }
        if (src.hasMedication()) {
            tgt.setMedication(VersionConvertor_30_40.convertType(src.getMedication()));
        }
        if (src.hasEffective()) {
            tgt.setEffective(VersionConvertor_30_40.convertType(src.getEffective()));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAssertedElement(VersionConvertor_30_40.convertDateTime(src.getDateAssertedElement()));
        }
        if (src.hasInformationSource()) {
            tgt.setInformationSource(VersionConvertor_30_40.convertReference(src.getInformationSource()));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getDerivedFrom()) {
            tgt.addDerivedFrom(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        for (org.hl7.fhir.dstu3.model.Dosage dosage : src.getDosage()) {
            tgt.addDosage(VersionConvertor_30_40.convertDosage(dosage));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> convertMedicationStatementStatus(Enumeration<MedicationStatement.MedicationStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus>(new MedicationStatement.MedicationStatementStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationStatement.MedicationStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.INTENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.STOPPED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ONHOLD);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<MedicationStatement.MedicationStatementStatus> convertMedicationStatementStatus(org.hl7.fhir.dstu3.model.Enumeration<MedicationStatement.MedicationStatementStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<MedicationStatement.MedicationStatementStatus> tgt = new Enumeration<MedicationStatement.MedicationStatementStatus>(new MedicationStatement.MedicationStatementStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((MedicationStatement.MedicationStatementStatus)((Object)src.getValue())) {
            case ACTIVE: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ACTIVE);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ENTEREDINERROR);
                break;
            }
            case INTENDED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.INTENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.STOPPED);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.ONHOLD);
                break;
            }
            default: {
                tgt.setValue((Object)MedicationStatement.MedicationStatementStatus.NULL);
            }
        }
        return tgt;
    }
}

