/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv30_40;

import org.hl7.fhir.convertors.VersionConvertor_30_40;
import org.hl7.fhir.dstu3.model.Annotation;
import org.hl7.fhir.dstu3.model.Communication;
import org.hl7.fhir.dstu3.model.Identifier;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.Enumeration;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.UriType;

public class Communication30_40 {
    public static Communication convertCommunication(org.hl7.fhir.r4.model.Communication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication tgt = new Communication();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (org.hl7.fhir.r4.model.Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (UriType uriType : src.getInstantiatesCanonical()) {
            tgt.addDefinition(new org.hl7.fhir.dstu3.model.Reference((String)uriType.getValue()));
        }
        for (Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasStatus()) {
            if (src.getStatus() == Communication.CommunicationStatus.NOTDONE) {
                tgt.setNotDone(true);
            } else {
                tgt.setStatusElement(Communication30_40.convertCommunicationStatus(src.getStatusElement()));
            }
        }
        if (src.hasStatusReason()) {
            tgt.setNotDoneReason(VersionConvertor_30_40.convertCodeableConcept(src.getStatusReason()));
        }
        for (CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasEncounter()) {
            tgt.setContext(VersionConvertor_30_40.convertReference(src.getEncounter()));
        }
        if (src.hasSent()) {
            tgt.setSentElement(VersionConvertor_30_40.convertDateTime(src.getSentElement()));
        }
        if (src.hasReceived()) {
            tgt.setReceivedElement(VersionConvertor_30_40.convertDateTime(src.getReceivedElement()));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_30_40.convertReference(src.getSender()));
        }
        for (CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (Communication.CommunicationPayloadComponent communicationPayloadComponent : src.getPayload()) {
            tgt.addPayload(Communication30_40.convertCommunicationPayloadComponent(communicationPayloadComponent));
        }
        for (org.hl7.fhir.r4.model.Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static org.hl7.fhir.r4.model.Communication convertCommunication(Communication src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.Communication tgt = new org.hl7.fhir.r4.model.Communication();
        VersionConvertor_30_40.copyDomainResource(src, tgt, new String[0]);
        for (Identifier identifier : src.getIdentifier()) {
            tgt.addIdentifier(VersionConvertor_30_40.convertIdentifier(identifier));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getDefinition()) {
            tgt.addInstantiatesCanonical(reference.getReference());
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getBasedOn()) {
            tgt.addBasedOn(VersionConvertor_30_40.convertReference(reference));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getPartOf()) {
            tgt.addPartOf(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasNotDone()) {
            tgt.setStatus(Communication.CommunicationStatus.NOTDONE);
        } else if (src.hasStatus()) {
            tgt.setStatusElement(Communication30_40.convertCommunicationStatus(src.getStatusElement()));
        }
        if (src.hasNotDoneReason()) {
            tgt.setStatusReason(VersionConvertor_30_40.convertCodeableConcept(src.getNotDoneReason()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getCategory()) {
            tgt.addCategory(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getMedium()) {
            tgt.addMedium(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        if (src.hasSubject()) {
            tgt.setSubject(VersionConvertor_30_40.convertReference(src.getSubject()));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getRecipient()) {
            tgt.addRecipient(VersionConvertor_30_40.convertReference(reference));
        }
        if (src.hasContext()) {
            tgt.setEncounter(VersionConvertor_30_40.convertReference(src.getContext()));
        }
        if (src.hasSent()) {
            tgt.setSentElement(VersionConvertor_30_40.convertDateTime(src.getSentElement()));
        }
        if (src.hasReceived()) {
            tgt.setReceivedElement(VersionConvertor_30_40.convertDateTime(src.getReceivedElement()));
        }
        if (src.hasSender()) {
            tgt.setSender(VersionConvertor_30_40.convertReference(src.getSender()));
        }
        for (org.hl7.fhir.dstu3.model.CodeableConcept codeableConcept : src.getReasonCode()) {
            tgt.addReasonCode(VersionConvertor_30_40.convertCodeableConcept(codeableConcept));
        }
        for (org.hl7.fhir.dstu3.model.Reference reference : src.getReasonReference()) {
            tgt.addReasonReference(VersionConvertor_30_40.convertReference(reference));
        }
        for (Communication.CommunicationPayloadComponent communicationPayloadComponent : src.getPayload()) {
            tgt.addPayload(Communication30_40.convertCommunicationPayloadComponent(communicationPayloadComponent));
        }
        for (Annotation annotation : src.getNote()) {
            tgt.addNote(VersionConvertor_30_40.convertAnnotation(annotation));
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_30_40.convertType(src.getContent()));
        }
        return tgt;
    }

    public static Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        if (src.hasContent()) {
            tgt.setContent(VersionConvertor_30_40.convertType(src.getContent()));
        }
        return tgt;
    }

    public static org.hl7.fhir.dstu3.model.Enumeration<Communication.CommunicationStatus> convertCommunicationStatus(Enumeration<Communication.CommunicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.dstu3.model.Enumeration<Communication.CommunicationStatus> tgt = new org.hl7.fhir.dstu3.model.Enumeration<Communication.CommunicationStatus>(new Communication.CommunicationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Communication.CommunicationStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)Communication.CommunicationStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Communication.CommunicationStatus.INPROGRESS);
                break;
            }
            case ONHOLD: {
                tgt.setValue((Object)Communication.CommunicationStatus.SUSPENDED);
                break;
            }
            case STOPPED: {
                tgt.setValue((Object)Communication.CommunicationStatus.ABORTED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Communication.CommunicationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Communication.CommunicationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Communication.CommunicationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Communication.CommunicationStatus.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<Communication.CommunicationStatus> convertCommunicationStatus(org.hl7.fhir.dstu3.model.Enumeration<Communication.CommunicationStatus> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration<Communication.CommunicationStatus> tgt = new Enumeration<Communication.CommunicationStatus>(new Communication.CommunicationStatusEnumFactory());
        VersionConvertor_30_40.copyElement(src, tgt, new String[0]);
        switch ((Communication.CommunicationStatus)((Object)src.getValue())) {
            case PREPARATION: {
                tgt.setValue((Object)Communication.CommunicationStatus.PREPARATION);
                break;
            }
            case INPROGRESS: {
                tgt.setValue((Object)Communication.CommunicationStatus.INPROGRESS);
                break;
            }
            case SUSPENDED: {
                tgt.setValue((Object)Communication.CommunicationStatus.ONHOLD);
                break;
            }
            case ABORTED: {
                tgt.setValue((Object)Communication.CommunicationStatus.STOPPED);
                break;
            }
            case COMPLETED: {
                tgt.setValue((Object)Communication.CommunicationStatus.COMPLETED);
                break;
            }
            case ENTEREDINERROR: {
                tgt.setValue((Object)Communication.CommunicationStatus.ENTEREDINERROR);
                break;
            }
            case UNKNOWN: {
                tgt.setValue((Object)Communication.CommunicationStatus.UNKNOWN);
                break;
            }
            default: {
                tgt.setValue((Object)Communication.CommunicationStatus.NULL);
            }
        }
        return tgt;
    }
}

