/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv14_50;

import java.util.List;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.dstu2016may.model.ContactPoint;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.Element;
import org.hl7.fhir.dstu2016may.model.Enumerations;
import org.hl7.fhir.dstu2016may.model.Extension;
import org.hl7.fhir.dstu2016may.model.IdType;
import org.hl7.fhir.dstu2016may.model.ImplementationGuide;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.Type;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.dstu2016may.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.UsageContext;

public class ImplementationGuide14_50 {
    public static ImplementationGuide convertImplementationGuide(org.hl7.fhir.r5.model.ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        VersionConvertor_14_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_14_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(ImplementationGuide14_50.convertImplementationGuideContactComponent(contactDetail));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (UsageContext usageContext : src.getUseContext()) {
            if (!usageContext.hasValueCodeableConcept()) continue;
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(usageContext.getValueCodeableConcept()));
        }
        for (CodeableConcept codeableConcept : src.getJurisdiction()) {
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConcept(codeableConcept));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion()) {
            for (Enumeration enumeration : src.getFhirVersion()) {
                tgt.setFhirVersion(enumeration.asStringValue());
            }
        }
        for (ImplementationGuide.ImplementationGuideDependsOnComponent implementationGuideDependsOnComponent : src.getDependsOn()) {
            tgt.addDependency(ImplementationGuide14_50.convertImplementationGuideDependencyComponent(implementationGuideDependsOnComponent));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionGroupingComponent implementationGuideDefinitionGroupingComponent : src.getDefinition().getGrouping()) {
            tgt.addPackage(ImplementationGuide14_50.convertImplementationGuidePackageComponent(implementationGuideDefinitionGroupingComponent));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionResourceComponent implementationGuideDefinitionResourceComponent : src.getDefinition().getResource()) {
            ImplementationGuide14_50.findPackage(tgt.getPackage(), implementationGuideDefinitionResourceComponent.getGroupingId()).addResource(ImplementationGuide14_50.convertImplementationGuidePackageResourceComponent(implementationGuideDefinitionResourceComponent));
        }
        for (ImplementationGuide.ImplementationGuideGlobalComponent implementationGuideGlobalComponent : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide14_50.convertImplementationGuideGlobalComponent(implementationGuideGlobalComponent));
        }
        tgt.setPage(ImplementationGuide14_50.convertImplementationGuidePageComponent(src.getDefinition().getPage()));
        return tgt;
    }

    public static org.hl7.fhir.r5.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.ImplementationGuide tgt = new org.hl7.fhir.r5.model.ImplementationGuide();
        VersionConvertor_14_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_14_50.convertUri(src.getUrlElement()));
        }
        if (src.hasVersion()) {
            tgt.setVersionElement(VersionConvertor_14_50.convertString(src.getVersionElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((Enumeration)VersionConvertor_14_50.convertConformanceResourceStatus((org.hl7.fhir.dstu2016may.model.Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_14_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasPublisher()) {
            tgt.setPublisherElement(VersionConvertor_14_50.convertString(src.getPublisherElement()));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getContact()) {
            tgt.addContact(ImplementationGuide14_50.convertImplementationGuideContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_14_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getUseContext()) {
            if (VersionConvertor_14_50.isJurisdiction((org.hl7.fhir.dstu2016may.model.CodeableConcept)t)) {
                tgt.addJurisdiction(VersionConvertor_14_50.convertCodeableConcept((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(VersionConvertor_14_50.convertCodeableConceptToUsageContext((org.hl7.fhir.dstu2016may.model.CodeableConcept)t));
        }
        if (src.hasCopyright()) {
            tgt.setCopyright(src.getCopyright());
        }
        if (src.hasFhirVersion()) {
            tgt.addFhirVersion(Enumerations.FHIRVersion.fromCode(src.getFhirVersion()));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getDependency()) {
            tgt.addDependsOn(ImplementationGuide14_50.convertImplementationGuideDependencyComponent((ImplementationGuide.ImplementationGuideDependencyComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getPackage()) {
            tgt.getDefinition().addGrouping(ImplementationGuide14_50.convertImplementationGuidePackageComponent(tgt.getDefinition(), (ImplementationGuide.ImplementationGuidePackageComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getGlobal()) {
            tgt.addGlobal(ImplementationGuide14_50.convertImplementationGuideGlobalComponent((ImplementationGuide.ImplementationGuideGlobalComponent)t));
        }
        tgt.getDefinition().setPage(ImplementationGuide14_50.convertImplementationGuidePageComponent(src.getPage()));
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideContactComponent convertImplementationGuideContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideContactComponent tgt = new ImplementationGuide.ImplementationGuideContactComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertImplementationGuideContactComponent(ImplementationGuide.ImplementationGuideContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_14_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependsOnComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependsOnComponent tgt = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (ToolingExtensions.hasExtension((Element)src, (String)"http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.packageId")) {
            tgt.setPackageId(ToolingExtensions.readStringExtension((Element)src, (String)"http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.packageId"));
        }
        if (ToolingExtensions.hasExtension((Element)src, (String)"http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.version")) {
            tgt.setVersion(ToolingExtensions.readStringExtension((Element)src, (String)"http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.version"));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependsOnComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        tgt.setType(ImplementationGuide.GuideDependencyType.REFERENCE);
        if (src.hasUri()) {
            tgt.setUri(src.getUri());
        }
        if (src.hasPackageId()) {
            tgt.addExtension(new Extension("http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.packageId", (IBaseDatatype)new IdType(src.getPackageId())));
        }
        if (src.hasVersion()) {
            tgt.addExtension(new Extension("http://hl7.org/fhir/4.0/StructureDefinition/extension-ImplementationGuide.dependsOn.version", (IBaseDatatype)new StringType(src.getVersion())));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (tgt.hasType() && src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertCode(src.getTypeElement()));
        }
        if (src.hasProfileElement()) {
            tgt.setProfile(VersionConvertor_14_50.convertCanonicalToReference(src.getProfileElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasTypeElement()) {
            tgt.setTypeElement(VersionConvertor_14_50.convertCode(src.getTypeElement()));
        }
        if (src.hasProfile()) {
            tgt.setProfileElement(VersionConvertor_14_50.convertReferenceToCanonical(src.getProfile()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionGroupingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        tgt.setId(src.getId());
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_50.convertString(src.getDescriptionElement()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionGroupingComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionComponent context, ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        tgt.setId("p" + (context.getGrouping().size() + 1));
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_50.convertString(src.getDescriptionElement()));
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            ImplementationGuide.ImplementationGuideDefinitionResourceComponent tn = ImplementationGuide14_50.convertImplementationGuidePackageResourceComponent(t);
            tn.setGroupingId(tgt.getId());
            context.addResource(tn);
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuideDefinitionResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasExampleCanonicalType()) {
            if (src.hasExampleCanonicalType()) {
                tgt.setExampleFor(VersionConvertor_14_50.convertCanonicalToReference(src.getExampleCanonicalType()));
            }
            tgt.setExample(true);
        } else if (src.hasExampleBooleanType()) {
            tgt.setExample(((Boolean)src.getExampleBooleanType().getValue()).booleanValue());
        } else {
            tgt.setExample(false);
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasReference()) {
            tgt.setSource((Type)VersionConvertor_14_50.convertReference(src.getReference()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasExampleFor()) {
            DataType t = VersionConvertor_14_50.convertType((Type)src.getExampleFor());
            tgt.setExample(t instanceof Reference ? new CanonicalType(((Reference)t).getReference()) : t);
        } else if (src.hasExample()) {
            tgt.setExample(new BooleanType(src.getExample()));
        }
        if (src.hasName()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescriptionElement(VersionConvertor_14_50.convertString(src.getDescriptionElement()));
        }
        if (src.hasSourceReference()) {
            tgt.setReference(VersionConvertor_14_50.convertReference(src.getSourceReference()));
        } else if (src.hasSourceUriType()) {
            tgt.setReference(new Reference((String)src.getSourceUriType().getValue()));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuideDefinitionPageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        VersionConvertor_14_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameUrlType()) {
            tgt.setSource((String)src.getNameUrlType().getValue());
        }
        if (src.hasTitleElement()) {
            tgt.setNameElement(VersionConvertor_14_50.convertString(src.getTitleElement()));
        }
        if (src.hasGeneration()) {
            tgt.setKind(ImplementationGuide14_50.convertPageGeneration(src.getGeneration()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionPageComponent t : src.getPage()) {
            tgt.addPage(ImplementationGuide14_50.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuideDefinitionPageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasSource()) {
            tgt.setName(ImplementationGuide14_50.convertUriToUrl(src.getSourceElement()));
        }
        if (src.hasNameElement()) {
            tgt.setTitleElement(VersionConvertor_14_50.convertString(src.getNameElement()));
        }
        if (src.hasKind()) {
            tgt.setGeneration(ImplementationGuide14_50.convertPageGeneration(src.getKind()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent t : src.getPage()) {
            tgt.addPage(ImplementationGuide14_50.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public static ImplementationGuide.GuidePageKind convertPageGeneration(ImplementationGuide.GuidePageGeneration generation) {
        switch (generation) {
            case HTML: {
                return ImplementationGuide.GuidePageKind.PAGE;
            }
        }
        return ImplementationGuide.GuidePageKind.RESOURCE;
    }

    public static ImplementationGuide.GuidePageGeneration convertPageGeneration(ImplementationGuide.GuidePageKind kind) {
        switch (kind) {
            case PAGE: {
                return ImplementationGuide.GuidePageGeneration.HTML;
            }
        }
        return ImplementationGuide.GuidePageGeneration.GENERATED;
    }

    public static UrlType convertUriToUrl(UriType src) throws FHIRException {
        UrlType tgt = new UrlType();
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        VersionConvertor_14_50.copyElement((Element)src, tgt, new String[0]);
        return tgt;
    }

    public static ImplementationGuide.ImplementationGuidePackageComponent findPackage(List<ImplementationGuide.ImplementationGuidePackageComponent> definition, String id) {
        for (ImplementationGuide.ImplementationGuidePackageComponent t : definition) {
            if (!t.getId().equals(id)) continue;
            return t;
        }
        ImplementationGuide.ImplementationGuidePackageComponent t = new ImplementationGuide.ImplementationGuidePackageComponent();
        t.setName("Default Package");
        t.setId(id);
        return t;
    }
}

