/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors.conv10_50;

import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Element;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.SearchParameter;
import org.hl7.fhir.dstu2.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.SearchParameter;

public class SearchParameter10_50 {
    public static SearchParameter convertSearchParameter(org.hl7.fhir.r5.model.SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter tgt = new SearchParameter();
        VersionConvertor_10_50.copyDomainResource(src, (DomainResource)tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement(VersionConvertor_10_50.convertConformanceResourceStatus(src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (ContactDetail contactDetail : src.getContact()) {
            tgt.addContact(SearchParameter10_50.convertSearchParameterContactComponent(contactDetail));
        }
        if (src.hasPurpose()) {
            tgt.setRequirements(src.getPurpose());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        for (CodeType codeType : src.getBase()) {
            tgt.setBase(codeType.asStringValue());
        }
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_10_50.convertSearchParamType(src.getTypeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        ToolingExtensions.setStringExtension((DomainResource)tgt, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression", (String)src.getExpression());
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_10_50.convertString(src.getXpathElement()));
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsageElement(SearchParameter10_50.convertXPathUsageType(src.getXpathUsageElement()));
        }
        for (CodeType codeType : src.getTarget()) {
            tgt.addTarget((String)codeType.getValue());
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.SearchParameter convertSearchParameter(SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.SearchParameter tgt = new org.hl7.fhir.r5.model.SearchParameter();
        VersionConvertor_10_50.copyDomainResource((DomainResource)src, tgt, new String[0]);
        if (src.hasUrlElement()) {
            tgt.setUrlElement(VersionConvertor_10_50.convertUri(src.getUrlElement()));
        }
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        if (src.hasStatus()) {
            tgt.setStatusElement((org.hl7.fhir.r5.model.Enumeration)VersionConvertor_10_50.convertConformanceResourceStatus((Enumeration<Enumerations.ConformanceResourceStatus>)src.getStatusElement()));
        }
        if (src.hasExperimental()) {
            tgt.setExperimentalElement(VersionConvertor_10_50.convertBoolean(src.getExperimentalElement()));
        }
        if (src.hasDate()) {
            tgt.setDateElement(VersionConvertor_10_50.convertDateTime(src.getDateElement()));
        }
        if (src.hasPublisherElement()) {
            tgt.setPublisherElement(VersionConvertor_10_50.convertString(src.getPublisherElement()));
        }
        for (SearchParameter.SearchParameterContactComponent t : src.getContact()) {
            tgt.addContact(SearchParameter10_50.convertSearchParameterContactComponent(t));
        }
        if (src.hasRequirements()) {
            tgt.setPurpose(src.getRequirements());
        }
        if (src.hasCodeElement()) {
            tgt.setCodeElement(VersionConvertor_10_50.convertCode(src.getCodeElement()));
        }
        tgt.addBase(src.getBase());
        if (src.hasType()) {
            tgt.setTypeElement(VersionConvertor_10_50.convertSearchParamType((Enumeration<Enumerations.SearchParamType>)src.getTypeElement()));
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        tgt.setExpression(ToolingExtensions.readStringExtension((DomainResource)src, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression"));
        if (src.hasXpathElement()) {
            tgt.setXpathElement(VersionConvertor_10_50.convertString(src.getXpathElement()));
        }
        if (src.hasXpathUsage()) {
            tgt.setXpathUsageElement(SearchParameter10_50.convertXPathUsageType((Enumeration<SearchParameter.XPathUsageType>)src.getXpathUsageElement()));
        }
        for (SearchParameter.SearchParameterContactComponent t : src.getTarget()) {
            tgt.addTarget((String)t.getValue());
        }
        return tgt;
    }

    public static SearchParameter.SearchParameterContactComponent convertSearchParameterContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter.SearchParameterContactComponent tgt = new SearchParameter.SearchParameterContactComponent();
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (org.hl7.fhir.r5.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static ContactDetail convertSearchParameterContactComponent(SearchParameter.SearchParameterContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        VersionConvertor_10_50.copyElement((Element)src, tgt, new String[0]);
        if (src.hasNameElement()) {
            tgt.setNameElement(VersionConvertor_10_50.convertString(src.getNameElement()));
        }
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(VersionConvertor_10_50.convertContactPoint(t));
        }
        return tgt;
    }

    public static org.hl7.fhir.r5.model.Enumeration<SearchParameter.XPathUsageType> convertXPathUsageType(Enumeration<SearchParameter.XPathUsageType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r5.model.Enumeration<SearchParameter.XPathUsageType> tgt = new org.hl7.fhir.r5.model.Enumeration<SearchParameter.XPathUsageType>(new SearchParameter.XPathUsageTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, tgt, new String[0]);
        switch ((SearchParameter.XPathUsageType)src.getValue()) {
            case NORMAL: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NORMAL);
                break;
            }
            case PHONETIC: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.PHONETIC);
                break;
            }
            case NEARBY: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NEARBY);
                break;
            }
            case DISTANCE: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.DISTANCE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NULL);
            }
        }
        return tgt;
    }

    public static Enumeration<SearchParameter.XPathUsageType> convertXPathUsageType(org.hl7.fhir.r5.model.Enumeration<SearchParameter.XPathUsageType> src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Enumeration tgt = new Enumeration((EnumFactory)new SearchParameter.XPathUsageTypeEnumFactory());
        VersionConvertor_10_50.copyElement(src, (Element)tgt, new String[0]);
        switch ((SearchParameter.XPathUsageType)((Object)src.getValue())) {
            case NORMAL: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NORMAL);
                break;
            }
            case PHONETIC: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.PHONETIC);
                break;
            }
            case NEARBY: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NEARBY);
                break;
            }
            case DISTANCE: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.DISTANCE);
                break;
            }
            case OTHER: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.OTHER);
                break;
            }
            default: {
                tgt.setValue((Object)SearchParameter.XPathUsageType.NULL);
            }
        }
        return tgt;
    }
}

